/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.benchmarks.agent.temperature;

import at.jku.ssw.mevss.benchmarks.agent.temperature.TemperatureReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class LinuxTemperatureReader
extends TemperatureReader {
    private static final File DIR = new File("/sys/class/hwmon/");
    private static final String CPU_SENSOR_NAME = "coretemp";
    private final Map<File, Map<String, File>> cpu_temperatures;

    public LinuxTemperatureReader() throws IOException {
        Object object;
        Object object2;
        if (!DIR.exists()) {
            throw new IOException("Reading hardware temperatures not supported! (install lm-sensors)");
        }
        ArrayList<File> arrayList = new ArrayList<File>(1);
        for (File file : DIR.listFiles()) {
            object2 = new File(file + "/name");
            if (!((File)object2).exists() || !((String)(object = new String(this.readAllBytes((File)object2)).trim())).equals(CPU_SENSOR_NAME)) continue;
            arrayList.add(file);
        }
        this.cpu_temperatures = new HashMap<File, Map<String, File>>();
        for (File file : arrayList) {
            HashMap<String, File> hashMap = new HashMap<String, File>();
            int n = 1;
            while (true) {
                object2 = "temp" + n;
                object = new File(file + "/" + (String)object2 + "_label");
                if (!((File)object).exists()) break;
                String string = new String(this.readAllBytes((File)object)).trim();
                File file2 = new File(file + "/" + (String)object2 + "_input");
                if (!file2.exists()) {
                    throw new IOException("internal");
                }
                hashMap.put(string, file2);
                ++n;
            }
            this.cpu_temperatures.put(file, hashMap);
        }
    }

    @Override
    public int readCPUTemperature() throws IOException {
        int n = 0;
        int n2 = 0;
        for (Map<String, File> map : this.cpu_temperatures.values()) {
            for (File file : map.values()) {
                int n3 = this.readTemperature(file);
                n += n3;
                ++n2;
            }
        }
        return n / n2;
    }

    private int readTemperature(File file) throws IOException {
        return this.parseInt(this.readAllBytes(file)) / 1000;
    }

    private int parseInt(byte[] byArray) throws IOException {
        int n = 0;
        for (byte by : byArray) {
            char c = (char)by;
            if (Character.isDigit(c)) {
                int n2 = c - 48;
                n = n * 10 + n2;
                continue;
            }
            if (Character.isWhitespace(c)) continue;
            throw new IOException();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readAllBytes(File file) throws IOException {
        try (FileInputStream fileInputStream = null;){
            byte[] byArray;
            fileInputStream = new FileInputStream(file);
            byte[] byArray2 = new byte[1024];
            int n = 0;
            int n2 = ((InputStream)fileInputStream).read(byArray2);
            while (n2 > 0) {
                if ((n += n2) == byArray2.length) {
                    byArray = new byte[byArray2.length * 2];
                    System.arraycopy(byArray2, 0, byArray, 0, n);
                }
                n2 = ((InputStream)fileInputStream).read(byArray2, n, byArray2.length - n);
            }
            byte[] byArray3 = new byte[n];
            System.arraycopy(byArray2, 0, byArray3, 0, n);
            byArray = byArray3;
            return byArray;
        }
    }
}

