/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.benchmarks.agent.suites;

import at.jku.ssw.mevss.benchmarks.agent.BenchmarkManagedAgent;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collections;

public final class SPECjbbManagedAgent {
    private final BenchmarkManagedAgent agent = new BenchmarkManagedAgent(BenchmarkManagedAgent.Goal.MAX);
    private int state = 0;
    private int level = 0;
    private long time = 0L;

    private OutputStreamBuffer createOutBuffer(PrintStream printStream) {
        return new OutputStreamBuffer(printStream);
    }

    private void process(String string) {
        string = string.trim();
        try {
            if (string.startsWith("INVALID")) {
                this.agent.invalidate();
            }
            switch (this.state) {
                case 0: {
                    if (string.startsWith("Loading Warehouse ")) {
                        this.level = Integer.parseInt(string.substring("Loading Warehouse ".length(), string.indexOf(46, "Loading Warehouse ".length() + 1)));
                        assert (this.level > 0);
                        this.state = 1;
                    }
                    break;
                }
                case 1: {
                    if (string.startsWith("Timing Measurement began ") && string.endsWith(" minutes")) {
                        int n = string.indexOf("for ") + "for ".length();
                        assert (n > "Timing Measurement began ".length());
                        double d = Double.parseDouble(string.substring(n, string.indexOf(32, n + 1)).replace(',', '.'));
                        assert (d > 0.0);
                        this.time = (long)(d * 60.0 * 1000.0);
                        this.start();
                        this.state = 2;
                    }
                    break;
                }
                case 2: {
                    if (string.startsWith("throughput")) {
                        int n = string.indexOf(61);
                        assert (n > "throughput".length());
                        String string2 = string.substring(n + 1, string.length()).trim();
                        string2 = string2.substring(0, string2.indexOf(32)).trim();
                        double d = Double.parseDouble(string2);
                        assert (d > 0.0);
                        this.stop(true, d);
                        this.state = 0;
                    }
                    break;
                }
                default: {
                    assert (false);
                    this.state = 0;
                    break;
                }
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Exception occured during parsing of line \"" + string + "\" in state " + this.state + "!", exception);
        }
    }

    private void start() {
        this.agent.start();
    }

    private void stop(boolean bl, double d) {
        long l = (long)((double)this.time * 1.0 / 1000.0 * d);
        this.agent.stop(bl, this.level >= Runtime.getRuntime().availableProcessors() ? l : 0L, this.time, l, Collections.singletonMap("level", new Integer(this.level)));
    }

    static {
        System.setOut(new PrintStream(new SPECjbbManagedAgent().createOutBuffer(System.out), true));
    }

    private final class OutputStreamBuffer
    extends OutputStream {
        private final PrintStream out;
        private final StringBuilder buffer;

        public OutputStreamBuffer(PrintStream printStream) {
            this.out = printStream;
            this.buffer = new StringBuilder();
        }

        @Override
        public void write(int n) {
            this.write((char)n);
        }

        private void write(char c) {
            this.buffer.append(c);
        }

        @Override
        public void flush() throws IOException {
            super.flush();
            int n = this.buffer.indexOf("\n");
            while (n >= 0) {
                String string = this.buffer.substring(0, n);
                SPECjbbManagedAgent.this.process(string);
                this.buffer.delete(0, n + 1);
                this.out.println(string);
                n = this.buffer.indexOf("\n");
            }
        }
    }
}

