/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.benchmarks.agent.stacks;

import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;

public class StackDumper {
    public static void start(double d) {
        StackDumper.start(0.0, d);
    }

    public static void start(final double d, final double d2) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                StackDumper.run(d, d2);
            }
        }, "Stack Dumper");
        thread.setDaemon(true);
        thread.start();
    }

    private static void run(double d, double d2) {
        Thread thread = Thread.currentThread();
        try {
            Thread.sleep((long)(d * 1000.0));
            while (!thread.isInterrupted()) {
                StackDumper.dump();
                Thread.sleep((long)(d2 * 1000.0));
            }
        }
        catch (InterruptedException interruptedException) {
            thread.interrupt();
        }
    }

    private static void dump() {
        ThreadInfo[] threadInfoArray;
        StackDumper.dump("############################################################################################################");
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        for (ThreadInfo threadInfo : threadInfoArray = threadMXBean.dumpAllThreads(true, true)) {
            StackDumper.dump(threadInfo);
            StackDumper.dump("");
        }
    }

    private static void dump(ThreadInfo threadInfo) {
        StackDumper.dump(threadInfo.getThreadId() + " - \"" + threadInfo.getThreadName() + "\" (" + (Object)((Object)threadInfo.getThreadState()) + ")");
        if (threadInfo.getLockOwnerId() >= 0L) {
            StackDumper.dump(" ... waiting for lock " + threadInfo.getLockName() + " owned by " + threadInfo.getLockOwnerId() + " - \"" + threadInfo.getLockOwnerName() + "\"");
        }
        for (LockInfo monitorInfoArray : threadInfo.getLockedSynchronizers()) {
            StackDumper.dump("holding lock " + monitorInfoArray.toString());
        }
        Object[] objectArray = threadInfo.getStackTrace();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            for (MonitorInfo monitorInfo : threadInfo.getLockedMonitors()) {
                if (monitorInfo.getLockedStackDepth() != i) continue;
                StackDumper.dump(" holding monitor " + monitorInfo.toString());
            }
            StackDumper.dump((StackTraceElement)object);
        }
    }

    private static void dump(StackTraceElement stackTraceElement) {
        StackDumper.dump(stackTraceElement.getClassName() + "::" + stackTraceElement.getMethodName() + "(" + stackTraceElement.getFileName() + ":" + stackTraceElement.getLineNumber() + ")");
    }

    private static void dump(String string) {
        System.err.println("# " + string);
    }
}

