/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.benchmarks.agent.livememory;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.reflect.InvocationTargetException;

public final class LiveMemorySearcher {
    private final int maxSamplingProportion;
    private final File output;

    private LiveMemorySearcher(File file, int n) {
        this.output = file;
        this.maxSamplingProportion = n;
        this.sample(false);
        this.start();
    }

    public static void main(String[] stringArray) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ClassNotFoundException {
        int n = Math.max(0, Integer.parseInt(stringArray[0]));
        File file = new File(stringArray[1]);
        String string = stringArray[2];
        String[] stringArray2 = new String[stringArray.length - 3];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = stringArray[i + 3];
        }
        LiveMemorySearcher liveMemorySearcher = new LiveMemorySearcher(file, n);
        Class.forName(string).getMethod("main", String[].class).invoke(null, new Object[]{stringArray2});
        liveMemorySearcher.sample(true);
    }

    private void start() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                LiveMemorySearcher.this.run();
            }
        });
        thread.setName("Live Memory Sampler");
        thread.setDaemon(true);
        thread.setPriority(10);
        thread.start();
    }

    private void run() {
        Thread thread = Thread.currentThread();
        do {
            long l = this.sample(true);
            try {
                Thread.sleep((long)Math.max(10.0, (double)(l * (long)(this.maxSamplingProportion + 1)) * (Math.random() * 2.0)));
            }
            catch (InterruptedException interruptedException) {
                thread.interrupt();
            }
        } while (!thread.isInterrupted());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized long sample(boolean bl) {
        long l = System.currentTimeMillis();
        if (bl) {
            System.gc();
        }
        l = System.currentTimeMillis() - l;
        long l2 = System.currentTimeMillis();
        long l3 = 0L;
        for (MemoryPoolMXBean memoryPoolMXBean : ManagementFactory.getMemoryPoolMXBeans()) {
            if (memoryPoolMXBean.getType() != MemoryType.HEAP) continue;
            l3 += memoryPoolMXBean.getCollectionUsage().getUsed();
        }
        Object object = null;
        try {
            object = new BufferedWriter(new FileWriter(this.output, true));
            ((Writer)object).append(String.valueOf(l3));
            ((Writer)object).append('\n');
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            try {
                ((BufferedWriter)object).close();
            }
            catch (IOException iOException2) {
                iOException2.printStackTrace(System.err);
            }
            System.exit(1);
        }
        finally {
            if (object != null) {
                try {
                    ((BufferedWriter)object).close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace(System.err);
                }
            }
        }
        l2 = System.currentTimeMillis() - l2;
        return Math.max(0L, l - l2);
    }
}

