/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.benchmarks.agent.instrumentation;

import at.jku.ssw.mevss.benchmarks.agent.StaticMetricStore;
import at.jku.ssw.mevss.benchmarks.agent.instrumentation.Instrumentation;
import at.jku.ssw.mevss.benchmarks.agent.instrumentation.Instrumentee;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtMethod;

public class OperationInstrumentation
implements Instrumentation {
    public static final String[] NAMES;
    public static final Instrumentee[] OPERATIONS;

    @Override
    public Instrumentee[] getInstrumentees() {
        return (Instrumentee[])OPERATIONS.clone();
    }

    @Override
    public boolean wantsToInstrument(Instrumentee instrumentee) {
        for (Instrumentee instrumentee2 : OPERATIONS) {
            if (!instrumentee2.equals(instrumentee)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int instrument(CtMethod ctMethod) throws CannotCompileException {
        int n = OperationInstrumentation.getOperationID(ctMethod);
        String string = "$$time_" + n;
        String string2 = string + " = java.lang.System.currentTimeMillis();";
        String string3 = StaticMetricStore.class.getName() + ".reportOperation(java.lang.System.currentTimeMillis() - " + string + ", " + n + ");";
        ctMethod.addLocalVariable(string, CtClass.longType);
        ctMethod.insertBefore(string2);
        ctMethod.insertAfter(string3);
        return 1;
    }

    private static int getOperationID(CtMethod ctMethod) {
        Instrumentee instrumentee = new Instrumentee(ctMethod.getDeclaringClass().getName(), ctMethod.getName());
        for (int i = 0; i < OPERATIONS.length; ++i) {
            if (!OPERATIONS[i].equals(instrumentee)) continue;
            return i;
        }
        return -1;
    }

    static {
        String string = System.getProperty("benchmarkexecutor.agent.operationimplementation");
        if (string != null && string.length() > 0) {
            String[] stringArray = string.split(",");
            NAMES = new String[stringArray.length];
            OPERATIONS = new Instrumentee[NAMES.length];
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                String string3 = OperationInstrumentation.NAMES[i] = string2.substring(0, string2.indexOf(61));
                OperationInstrumentation.OPERATIONS[i] = Instrumentee.parse(string2.substring(string3.length() + 1));
            }
        } else {
            NAMES = new String[0];
            OPERATIONS = new Instrumentee[0];
        }
    }
}

