/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.benchmarks.agent.instrumentation;

import at.jku.ssw.mevss.benchmarks.agent.Logger;
import at.jku.ssw.mevss.benchmarks.agent.instrumentation.Instrumentation;
import at.jku.ssw.mevss.benchmarks.agent.instrumentation.Instrumentee;
import java.util.HashMap;
import java.util.Map;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;

public class LogMethodInstrumentation
implements Instrumentation {
    private static final Map<Instrumentee, String> LOGGED = new HashMap<Instrumentee, String>();

    @Override
    public Instrumentee[] getInstrumentees() {
        return LOGGED.keySet().toArray(new Instrumentee[0]);
    }

    @Override
    public boolean wantsToInstrument(Instrumentee instrumentee) {
        return LOGGED.containsKey(instrumentee);
    }

    @Override
    public int instrument(CtMethod ctMethod) throws CannotCompileException {
        try {
            Instrumentee instrumentee = new Instrumentee(ctMethod.getDeclaringClass().getName(), ctMethod.getName());
            ctMethod.insertBefore(LogMethodInstrumentation.getSource(instrumentee, LOGGED.get(instrumentee), Modifier.isStatic(ctMethod.getDeclaringClass().getModifiers()), ctMethod.getParameterTypes()));
            return 1;
        }
        catch (NotFoundException notFoundException) {
            throw new CannotCompileException(notFoundException);
        }
    }

    private static String getSource(Instrumentee instrumentee, String string, boolean bl, CtClass[] ctClassArray) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null) {
            stringBuilder.append("if(" + string + ") ");
        }
        stringBuilder.append(Logger.class.getName() + ".log(");
        stringBuilder.append("\"" + instrumentee + "\", ");
        stringBuilder.append("new java.lang.Object[] {");
        for (int i = 0; i < ctClassArray.length; ++i) {
            CtClass ctClass;
            if (i > 0) {
                stringBuilder.append(",");
            }
            if ((ctClass = ctClassArray[i]).isPrimitive()) {
                stringBuilder.append("java.lang." + LogMethodInstrumentation.getBoxedClassName(ctClass) + ".valueOf(");
            }
            int n = i + (bl ? 0 : 1);
            stringBuilder.append("$" + n);
            if (!ctClass.isPrimitive()) continue;
            stringBuilder.append(")");
        }
        stringBuilder.append("});");
        return stringBuilder.toString();
    }

    private static String getBoxedClassName(CtClass ctClass) {
        if (ctClass == CtClass.booleanType) {
            return "Boolean";
        }
        if (ctClass == CtClass.charType) {
            return "Character";
        }
        if (ctClass == CtClass.byteType) {
            return "Byte";
        }
        if (ctClass == CtClass.shortType) {
            return "Short";
        }
        if (ctClass == CtClass.intType) {
            return "Integer";
        }
        if (ctClass == CtClass.longType) {
            return "Long";
        }
        if (ctClass == CtClass.floatType) {
            return "Float";
        }
        if (ctClass == CtClass.doubleType) {
            return "Double";
        }
        assert (false);
        throw new InternalError("Unknown primitive type: " + ctClass);
    }

    static {
        LOGGED.put(new Instrumentee(System.class.getName(), "exit"), "$1 != 0");
        LOGGED.put(new Instrumentee(Runtime.class.getName(), "exit"), "$1 != 0");
    }
}

