/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.benchmarks.agent;

import at.jku.ssw.mevss.benchmarks.agent.instrumentation.Instrumentation;
import at.jku.ssw.mevss.benchmarks.agent.instrumentation.Instrumentee;
import at.jku.ssw.mevss.benchmarks.agent.instrumentation.InvalidationInstrumentation;
import at.jku.ssw.mevss.benchmarks.agent.instrumentation.IterationInstrumentation;
import at.jku.ssw.mevss.benchmarks.agent.instrumentation.LogMethodInstrumentation;
import at.jku.ssw.mevss.benchmarks.agent.instrumentation.OperationInstrumentation;
import java.io.ByteArrayInputStream;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.LoaderClassPath;

public final class BenchmarkManagedAgentNativeAccess {
    private static final Instrumentation[] INSTRUMENTATIONS = new Instrumentation[]{new IterationInstrumentation(), new OperationInstrumentation(), new InvalidationInstrumentation(), new LogMethodInstrumentation()};

    private BenchmarkManagedAgentNativeAccess() {
        throw new RuntimeException("Must not instantiate!");
    }

    private static void init() {
        String string = System.getProperty("benchmarkexecutor.agent.class");
        if (string != null) {
            try {
                Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException(classNotFoundException);
            }
        }
    }

    public static String getClassesToInstrument() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Instrumentation instrumentation : INSTRUMENTATIONS) {
            for (Instrumentee instrumentee : instrumentation.getInstrumentees()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(';');
                }
                stringBuilder.append(instrumentee.clazz.replace('.', '/'));
            }
        }
        return stringBuilder.toString();
    }

    public static byte[] instrument(byte[] byArray, ClassLoader classLoader) throws Throwable {
        ClassPool classPool = new ClassPool();
        classPool.appendSystemPath();
        classPool.appendClassPath(new LoaderClassPath(classLoader));
        CtClass ctClass = classPool.makeClass(new ByteArrayInputStream(byArray));
        if (ctClass.getName().startsWith(BenchmarkManagedAgentNativeAccess.class.getPackage().getName())) {
            return byArray;
        }
        int n = 0;
        try {
            for (CtMethod ctMethod : ctClass.getDeclaredMethods()) {
                Instrumentee instrumentee = new Instrumentee(ctClass.getName(), ctMethod.getName());
                for (Instrumentation instrumentation : INSTRUMENTATIONS) {
                    if (!instrumentation.wantsToInstrument(instrumentee)) continue;
                    int n2 = instrumentation.instrument(ctMethod);
                    n += n2;
                }
            }
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Failed to instrument class " + ctClass.getName(), throwable);
        }
        if (n > 0) {
            byArray = ctClass.toBytecode();
        }
        return byArray;
    }

    static {
        BenchmarkManagedAgentNativeAccess.init();
    }
}

