/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.benchmarks.agent;

import at.jku.ssw.mevss.benchmarks.agent.Invalidator;
import at.jku.ssw.mevss.benchmarks.agent.StaticMetricStore;
import at.jku.ssw.mevss.benchmarks.agent.Tuple;
import at.jku.ssw.mevss.benchmarks.agent.instrumentation.OperationInstrumentation;
import at.jku.ssw.mevss.benchmarks.agent.stacks.StackDumper;
import at.jku.ssw.mevss.benchmarks.agent.temperature.TemperatureReader;
import at.jku.ssw.mevss.benchmarks.agent.temperature.TemperatureReaderFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public final class BenchmarkManagedAgent {
    private static final boolean ADJUST_MEMORY_POOL_NAMES = BenchmarkManagedAgent.canAdjustMemoryPoolNames();
    private static final boolean ADJUST_GC_NAMES = BenchmarkManagedAgent.canAdjustGCNames();
    private static final TemperatureReader TEMPERATURE_READER = TemperatureReaderFactory.create();
    private final Goal goal;
    private boolean valid;
    private final List<Iteration> iterations = new ArrayList<Iteration>(25);
    private final Method reset;
    private final Method flush;
    private final Method getCustomMetrics;
    private final Map<String, GarbageCollectorInfo> garbageCollectorInfos = new HashMap<String, GarbageCollectorInfo>();
    private double compilationTime = 0.0;
    private double cpuTime = 0.0;
    private int cpuTemp = 0;
    private long classesLoaded = 0L;
    private long classesUnloaded = 0L;

    private static boolean canAdjustMemoryPoolNames() {
        HashSet<String> hashSet = new HashSet<String>();
        for (MemoryPoolMXBean memoryPoolMXBean : ManagementFactory.getMemoryPoolMXBeans()) {
            if (hashSet.add(MemoryPoolInfo.adjustName(memoryPoolMXBean.getName()))) continue;
            return false;
        }
        return true;
    }

    private static boolean canAdjustGCNames() {
        HashSet<String> hashSet = new HashSet<String>();
        for (GarbageCollectorMXBean garbageCollectorMXBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            if (hashSet.add(GarbageCollectorInfo.adjustName(garbageCollectorMXBean.getName()))) continue;
            return false;
        }
        return true;
    }

    public BenchmarkManagedAgent() {
        this(Goal.MIN);
    }

    public BenchmarkManagedAgent(Goal goal) {
        this(goal, true);
    }

    public BenchmarkManagedAgent(Goal goal, boolean bl) {
        this.goal = goal;
        this.valid = true;
        this.reset = BenchmarkManagedAgent.getMethod("reset");
        this.flush = BenchmarkManagedAgent.getMethod("flush");
        this.getCustomMetrics = BenchmarkManagedAgent.getMethod("getCustomMetrics");
        String string = System.getProperty("benchmarkexecutor.agent.dump_interval");
        if (string != null && string.length() > 0) {
            StackDumper.start(Double.parseDouble(string));
        }
        if ((string = System.getProperty("benchmarkexecutor.agent.dump_delay")) != null && string.length() > 0) {
            StackDumper.start(Double.parseDouble(string), 1.0);
        }
        if (bl) {
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    BenchmarkManagedAgent.this.report();
                }
            }));
        }
    }

    public void invalidate() {
        this.valid = false;
    }

    public void start() {
        BenchmarkManagedAgent.forceGC();
        if (this.reset != null) {
            try {
                this.reset.invoke(null, new Object[0]);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(System.err);
            }
        }
        StaticMetricStore.reset((int)OperationInstrumentation.OPERATIONS.length);
        BenchmarkManagedAgent.reset();
        this.initMemoryPoolInfos();
        this.initGarbageCollectorInfos();
        this.compilationTime = BenchmarkManagedAgent.getCompilationTime();
        this.cpuTime = BenchmarkManagedAgent.getCPUTime();
        this.cpuTemp = BenchmarkManagedAgent.getCPUTemperature();
        this.classesLoaded = BenchmarkManagedAgent.getLoadedClasses();
        this.classesUnloaded = BenchmarkManagedAgent.getUnloadedClasses();
        ManagementFactory.getThreadMXBean().resetPeakThreadCount();
        BenchmarkManagedAgent.startMonitoring();
    }

    private void initMemoryPoolInfos() {
        for (MemoryPoolMXBean memoryPoolMXBean : ManagementFactory.getMemoryPoolMXBeans()) {
            memoryPoolMXBean.resetPeakUsage();
        }
    }

    private void initGarbageCollectorInfos() {
        this.garbageCollectorInfos.clear();
        for (GarbageCollectorMXBean garbageCollectorMXBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            this.garbageCollectorInfos.put(garbageCollectorMXBean.getName(), BenchmarkManagedAgent.convertGarbageCollectorBeanToInfo(garbageCollectorMXBean));
        }
    }

    public void stop(boolean bl, long l, long l2, long l3) {
        this.stop(bl, l, l2, l3, null);
    }

    public void stop(boolean bl, long l, long l2, long l3, Map<String, Number> map) {
        if (this.flush != null) {
            try {
                this.flush.invoke(null, new Object[0]);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(System.err);
            }
        }
        BenchmarkManagedAgent.stopMonitoring();
        Iteration iteration = new Iteration(l);
        this.storeIteration(iteration, l2, l3, map);
        this.iterations.add(iteration);
        this.valid &= bl;
    }

    private void storeIteration(Iteration iteration, long l, long l2, Map<String, Number> map) {
        double d = (double)l / 1000.0;
        double d2 = BenchmarkManagedAgent.getCPUTime() - this.cpuTime;
        int n = BenchmarkManagedAgent.getCPUTemperature();
        int n2 = n - this.cpuTemp;
        double d3 = BenchmarkManagedAgent.getCompilationTime() - this.compilationTime;
        long l3 = BenchmarkManagedAgent.getLoadedClasses() - this.classesLoaded;
        long l4 = BenchmarkManagedAgent.getUnloadedClasses() - this.classesUnloaded;
        long l5 = BenchmarkManagedAgent.getPeakThreads();
        GarbageCollectorInfo[] garbageCollectorInfoArray = this.getGarbageCollectorInfos();
        MemoryPoolInfo[] memoryPoolInfoArray = this.getMemoryPoolInfos();
        Tuple[] tupleArray = BenchmarkManagedAgent.getNativeProperties();
        Double[] doubleArray = BenchmarkManagedAgent.getOperationTimes();
        Map<String, Long> map2 = this.getCustomProperties();
        BenchmarkManagedAgent.storeProperty(iteration, "iteration", this.iterations.size());
        BenchmarkManagedAgent.storeProperty(iteration, "run_time", d);
        BenchmarkManagedAgent.storeProperty(iteration, "operations", l2);
        BenchmarkManagedAgent.storeProperty(iteration, "throughput", (double)l2 / d);
        BenchmarkManagedAgent.storeProperty(iteration, "cpu_time", d2);
        BenchmarkManagedAgent.storeProperty(iteration, "cpu_usage", d2 / d);
        BenchmarkManagedAgent.storeProperty(iteration, "cpu_temperature", n);
        BenchmarkManagedAgent.storeProperty(iteration, "cpu_temperature_change", n2);
        BenchmarkManagedAgent.storeProperty(iteration, "compilation_time", d3);
        BenchmarkManagedAgent.storeProperty(iteration, "compilation_time_ratio", d3 / d2);
        BenchmarkManagedAgent.storeProperty(iteration, "classes_loaded", l3);
        BenchmarkManagedAgent.storeProperty(iteration, "classes_unloaded", l4);
        BenchmarkManagedAgent.storeProperty(iteration, "threads_peak", l5);
        this.reportGarbageCollectorInfos(iteration, garbageCollectorInfoArray);
        this.reportMemoryPoolInfos(iteration, memoryPoolInfoArray);
        if (tupleArray != null) {
            for (Tuple tuple : tupleArray) {
                BenchmarkManagedAgent.storeProperty(iteration, tuple.first.toString(), tuple.second.toString());
            }
        }
        for (int i = 0; i < doubleArray.length; ++i) {
            Double d4 = doubleArray[i];
            if (d4 == null) continue;
            String string = OperationInstrumentation.NAMES[i] + "_time";
            BenchmarkManagedAgent.storeProperty(iteration, string, d4);
        }
        if (map != null) {
            for (String string : map.keySet()) {
                BenchmarkManagedAgent.storeProperty(iteration, string, map.get(string).toString());
            }
        }
        if (map2 != null) {
            for (String string : map2.keySet()) {
                BenchmarkManagedAgent.storeProperty(iteration, string, map2.get(string));
            }
        }
        this.reportExternalCustomMetrics(iteration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportExternalCustomMetrics(Iteration iteration) {
        Map<String, String[]> map = this.getMetricCommands();
        for (String string : map.keySet()) {
            try {
                ProcessBuilder processBuilder = new ProcessBuilder(map.get(string));
                Process process = processBuilder.start();
                try (BufferedReader bufferedReader = null;){
                    bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    String string2 = bufferedReader.readLine();
                    if (string2 != null) {
                        BenchmarkManagedAgent.storeProperty(iteration, string, string2.trim());
                    }
                }
                process.waitFor();
            }
            catch (IOException iOException) {
                System.err.println("Could not write/read to/from stream; " + iOException);
            }
            catch (InterruptedException interruptedException) {
                System.err.println("Process interrupted while collecting metrics; " + interruptedException);
            }
        }
    }

    private static double getCompilationTime() {
        return 1.0 * (double)ManagementFactory.getCompilationMXBean().getTotalCompilationTime() / 1000.0;
    }

    private static double getCPUTime() {
        try {
            OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
            Method method = operatingSystemMXBean.getClass().getDeclaredMethod("getProcessCpuTime", new Class[0]);
            method.setAccessible(true);
            long l = (Long)method.invoke((Object)operatingSystemMXBean, new Object[0]);
            return 1.0 * (double)l / 1.0E9;
        }
        catch (Throwable throwable) {
            return 0.0;
        }
    }

    private static int getCPUTemperature() {
        try {
            return TEMPERATURE_READER.readCPUTemperature();
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    private static long getLoadedClasses() {
        return ManagementFactory.getClassLoadingMXBean().getTotalLoadedClassCount();
    }

    private static long getUnloadedClasses() {
        return ManagementFactory.getClassLoadingMXBean().getUnloadedClassCount();
    }

    private static long getPeakThreads() {
        return ManagementFactory.getThreadMXBean().getPeakThreadCount();
    }

    private MemoryPoolInfo[] getMemoryPoolInfos() {
        ArrayList<MemoryPoolInfo> arrayList = new ArrayList<MemoryPoolInfo>();
        for (MemoryPoolMXBean memoryPoolMXBean : ManagementFactory.getMemoryPoolMXBeans()) {
            arrayList.add(new MemoryPoolInfo(memoryPoolMXBean));
        }
        return arrayList.toArray(new MemoryPoolInfo[arrayList.size()]);
    }

    private GarbageCollectorInfo[] getGarbageCollectorInfos() {
        ArrayList<GarbageCollectorInfo> arrayList = new ArrayList<GarbageCollectorInfo>();
        for (GarbageCollectorMXBean garbageCollectorMXBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            GarbageCollectorInfo garbageCollectorInfo = this.garbageCollectorInfos.get(garbageCollectorMXBean.getName());
            GarbageCollectorInfo garbageCollectorInfo2 = BenchmarkManagedAgent.convertGarbageCollectorBeanToInfo(garbageCollectorMXBean);
            if (garbageCollectorInfo != null) {
                garbageCollectorInfo2 = new GarbageCollectorInfo(garbageCollectorMXBean, garbageCollectorInfo2.count - garbageCollectorInfo.count, garbageCollectorInfo2.time - garbageCollectorInfo.time);
            }
            arrayList.add(garbageCollectorInfo2);
        }
        return arrayList.toArray(new GarbageCollectorInfo[arrayList.size()]);
    }

    private void reportMemoryPoolInfos(Iteration iteration, MemoryPoolInfo[] memoryPoolInfoArray) {
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        block4: for (MemoryPoolInfo memoryPoolInfo : memoryPoolInfoArray) {
            String string = memoryPoolInfo.name.replace(' ', '_');
            BenchmarkManagedAgent.storeProperty(iteration, "peak_memory_usage_" + string, memoryPoolInfo.peakUsage);
            l += memoryPoolInfo.peakUsage;
            switch (memoryPoolInfo.type) {
                case HEAP: {
                    l2 += memoryPoolInfo.peakUsage;
                    continue block4;
                }
                case NON_HEAP: {
                    l3 += memoryPoolInfo.peakUsage;
                    continue block4;
                }
                default: {
                    assert (false);
                    continue block4;
                }
            }
        }
        BenchmarkManagedAgent.storeProperty(iteration, "peak_memory_usage_heap", l2);
        BenchmarkManagedAgent.storeProperty(iteration, "peak_memory_usage_non_heap", l3);
        BenchmarkManagedAgent.storeProperty(iteration, "peak_memory_usage", l);
    }

    private void reportGarbageCollectorInfos(Iteration iteration, GarbageCollectorInfo[] garbageCollectorInfoArray) {
        long l = 0L;
        long l2 = 0L;
        for (GarbageCollectorInfo garbageCollectorInfo : garbageCollectorInfoArray) {
            String string = garbageCollectorInfo.name.replace(' ', '_');
            BenchmarkManagedAgent.storeProperty(iteration, "garbage_collection_count_" + string, garbageCollectorInfo.count);
            BenchmarkManagedAgent.storeProperty(iteration, "garbage_collection_time_" + string, (double)garbageCollectorInfo.time * 1.0 / 1000.0);
            l += garbageCollectorInfo.count;
            l2 += garbageCollectorInfo.time;
        }
        BenchmarkManagedAgent.storeProperty(iteration, "garbage_collection_count", l);
        BenchmarkManagedAgent.storeProperty(iteration, "garbage_collection_time", (double)l2 * 1.0 / 1000.0);
    }

    private static GarbageCollectorInfo convertGarbageCollectorBeanToInfo(GarbageCollectorMXBean garbageCollectorMXBean) {
        return new GarbageCollectorInfo(garbageCollectorMXBean);
    }

    private static void storeProperty(Iteration iteration, String string, long l) {
        BenchmarkManagedAgent.storeProperty(iteration, string, String.valueOf(l));
    }

    private static void storeProperty(Iteration iteration, String string, double d) {
        BenchmarkManagedAgent.storeProperty(iteration, string, String.valueOf(d));
    }

    private static void storeProperty(Iteration iteration, String string, String string2) {
        iteration.metrics.put(string, string2);
    }

    private static native void reset();

    private static native void forceGC();

    private static native void startMonitoring();

    private static native void stopMonitoring();

    private static native Tuple[] getNativeProperties();

    private static Double[] getOperationTimes() {
        Double[] doubleArray = new Double[OperationInstrumentation.OPERATIONS.length];
        for (int i = 0; i < doubleArray.length; ++i) {
            doubleArray[i] = StaticMetricStore.getOperationTime((int)i);
        }
        return doubleArray;
    }

    private Map<String, Long> getCustomProperties() {
        if (this.getCustomMetrics != null) {
            try {
                return (Map)this.getCustomMetrics.invoke(null, new Object[0]);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(System.err);
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void report() {
        this.reportBestIteration();
        this.reportAllIterations();
        File file = BenchmarkManagedAgent.getResultFile();
        if (file != null) {
            BufferedWriter bufferedWriter = null;
            try {
                bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
                bufferedWriter.write(this.iterations.size() == 0 ? "crashed" : (Invalidator.VALID && this.valid ? "valid" : "invalid"));
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
            }
            finally {
                if (bufferedWriter != null) {
                    try {
                        bufferedWriter.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace(System.err);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportBestIteration() {
        Iteration iteration = this.getBestIteration();
        if (iteration != null) {
            BufferedWriter bufferedWriter = null;
            try {
                bufferedWriter = new BufferedWriter(new OutputStreamWriter(BenchmarkManagedAgent.getResultBestStream()));
                bufferedWriter.write("# best iteration");
                bufferedWriter.newLine();
                for (String string : iteration.metrics.keySet()) {
                    bufferedWriter.write(string);
                    bufferedWriter.write(61);
                    bufferedWriter.write(iteration.metrics.get(string));
                    bufferedWriter.newLine();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
            }
            finally {
                if (bufferedWriter != null) {
                    try {
                        bufferedWriter.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace(System.err);
                    }
                }
            }
        }
    }

    private Iteration getBestIteration() {
        Iteration iteration = null;
        for (Iteration iteration2 : this.iterations) {
            if (iteration != null && !BenchmarkManagedAgent.isNewBest(this.goal, iteration.result, iteration2.result)) continue;
            iteration = iteration2;
        }
        return iteration;
    }

    private static boolean isNewBest(Goal goal, long l, long l2) {
        switch (goal) {
            case MIN: {
                return l2 <= l;
            }
            case MAX: {
                return l2 >= l;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportAllIterations() {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(BenchmarkManagedAgent.getResultAllStream()));
            bufferedWriter.write("# all iterations");
            bufferedWriter.newLine();
            for (String string : this.getAllMetrics()) {
                String[] stringArray = this.getAllValues(string);
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl = true;
                for (String string2 : stringArray) {
                    if (bl) {
                        bl = false;
                    } else {
                        stringBuilder.append(";");
                    }
                    if (string2 == null) continue;
                    stringBuilder.append(string2);
                }
                bufferedWriter.write(string);
                bufferedWriter.write(61);
                bufferedWriter.write(stringBuilder.toString());
                bufferedWriter.newLine();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace(System.err);
                }
            }
        }
    }

    private String[] getAllMetrics() {
        HashSet<String> hashSet = new HashSet<String>();
        for (Iteration iteration : this.iterations) {
            for (String string : iteration.metrics.keySet()) {
                hashSet.add(string);
            }
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    private String[] getAllValues(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Iteration iteration : this.iterations) {
            arrayList.add(iteration.metrics.get(string));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private Map<String, String[]> getMetricCommands() {
        String[] stringArray;
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        String string = System.getProperty("benchmarkexecutor.agent.metric_commands");
        String[] stringArray2 = stringArray = string == null ? null : string.split(";");
        if (stringArray == null) {
            return hashMap;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            String[] stringArray3 = string2.split(",");
            hashMap.put(stringArray3[0], stringArray3[1].split(" "));
        }
        return hashMap;
    }

    private static OutputStream getResultBestStream() throws IOException {
        return BenchmarkManagedAgent.getStream("benchmarkexecutor.agent.result.best");
    }

    private static OutputStream getResultAllStream() throws IOException {
        return BenchmarkManagedAgent.getStream("benchmarkexecutor.agent.result.all");
    }

    private static OutputStream getStream(String string) throws IOException {
        String string2 = System.getProperty(string);
        if (string2 != null) {
            return new FileOutputStream(string2);
        }
        return new OutputStream(){

            @Override
            public void write(int n) {
                System.err.write(n);
            }
        };
    }

    private static Method getMethod(String string) {
        try {
            String string2 = System.getProperty("benchmarkexecutor.agent." + string);
            if (string2 == null) {
                return null;
            }
            String string3 = string2.substring(0, string2.lastIndexOf(46));
            String string4 = string2.substring(string2.lastIndexOf(46) + 1, string2.length());
            Class<?> clazz = Class.forName(string3);
            Method method = clazz.getDeclaredMethod(string4, new Class[0]);
            if (!Modifier.isStatic(method.getModifiers())) {
                throw new IllegalArgumentException("Method is not static!");
            }
            try {
                method.invoke(null, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                System.err.println(BenchmarkManagedAgent.class.getName() + ": ignoring " + string + " method (exception on test invocation: " + invocationTargetException.getCause().getClass().getName() + ": " + invocationTargetException.getCause().getMessage() + ")");
                method = null;
            }
            return method;
        }
        catch (Throwable throwable) {
            System.err.println(BenchmarkManagedAgent.class.getName() + ": error resolving method for " + string + ": " + throwable.getClass().getName() + ": " + throwable.getMessage());
            return null;
        }
    }

    private static File getResultFile() {
        String string = System.getProperty("benchmarkexecutor.agent.result");
        if (string == null) {
            return null;
        }
        return new File(string);
    }

    private static class GarbageCollectorInfo {
        private static final GarbageCollectorMXBean MINOR;
        private static final GarbageCollectorMXBean MAJOR;
        public final String name;
        public final long count;
        public final long time;

        public GarbageCollectorInfo(GarbageCollectorMXBean garbageCollectorMXBean) {
            this(garbageCollectorMXBean, garbageCollectorMXBean.getCollectionCount(), garbageCollectorMXBean.getCollectionTime());
        }

        public GarbageCollectorInfo(GarbageCollectorMXBean garbageCollectorMXBean, long l, long l2) {
            this.name = GarbageCollectorInfo.adjustName(garbageCollectorMXBean.getName());
            this.count = l;
            this.time = l2;
        }

        private static String adjustName(String string) {
            if (ADJUST_GC_NAMES) {
                if (MINOR != null && MAJOR != null) {
                    if (MINOR.getName().equals(string)) {
                        return "minor";
                    }
                    if (MAJOR.getName().equals(string)) {
                        return "major";
                    }
                } else {
                    String string2 = string.toLowerCase();
                    if (string2.contains("scavenge") || string2.contains("new") || string2.contains("young") || string2.contains("copy")) {
                        return "minor";
                    }
                    if (string2.contains("marksweep") || string2.contains("old")) {
                        return "major";
                    }
                }
            }
            return string;
        }

        static {
            if (ManagementFactory.getGarbageCollectorMXBeans().size() == 2) {
                GarbageCollectorMXBean platformManagedObject = null;
                GarbageCollectorMXBean platformManagedObject2 = null;
                long l = 0L;
                for (MemoryPoolMXBean platformManagedObject3 : ManagementFactory.getMemoryPoolMXBeans()) {
                    if (platformManagedObject3.getType() != MemoryType.HEAP) continue;
                    ++l;
                }
                for (GarbageCollectorMXBean garbageCollectorMXBean : ManagementFactory.getGarbageCollectorMXBeans()) {
                    int n = garbageCollectorMXBean.getMemoryPoolNames().length;
                    if ((long)n < l) {
                        platformManagedObject = garbageCollectorMXBean;
                        continue;
                    }
                    if ((long)n == l) {
                        platformManagedObject2 = garbageCollectorMXBean;
                        continue;
                    }
                    throw new Error("Here be dragons");
                }
                MINOR = platformManagedObject != null && platformManagedObject2 != null ? platformManagedObject : null;
                MAJOR = platformManagedObject != null && platformManagedObject2 != null ? platformManagedObject2 : null;
            } else {
                MAJOR = null;
                MINOR = null;
            }
        }
    }

    private static class MemoryPoolInfo {
        public final String name;
        public final MemoryType type;
        public final long peakUsage;

        public MemoryPoolInfo(MemoryPoolMXBean memoryPoolMXBean) {
            this(memoryPoolMXBean.getName(), memoryPoolMXBean.getType(), memoryPoolMXBean.getPeakUsage().getUsed());
        }

        private MemoryPoolInfo(String string, MemoryType memoryType, long l) {
            this.name = MemoryPoolInfo.adjustName(string);
            this.type = memoryType;
            this.peakUsage = l;
        }

        private static String adjustName(String string) {
            if (ADJUST_MEMORY_POOL_NAMES) {
                String string2 = string.toLowerCase();
                if (string2.contains("eden")) {
                    return "Eden";
                }
                if (string2.contains("survivor")) {
                    return "Survivor";
                }
                if (string2.contains("old") || string2.contains("tenured")) {
                    return "Old";
                }
            }
            return string;
        }
    }

    private static class Iteration {
        public final long result;
        public final Map<String, String> metrics;

        public Iteration(long l) {
            this.result = l;
            this.metrics = new HashMap<String, String>();
        }
    }

    public static enum Goal {
        MIN,
        MAX;

    }
}

