/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.system;

import org.sunflow.system.UserInterface;
import org.sunflow.system.ui.ConsoleInterface;
import org.sunflow.system.ui.SilentInterface;

public final class UI {
    private static UserInterface ui = new ConsoleInterface();
    private static boolean canceled = false;
    private static int verbosity = 3;

    private UI() {
    }

    public static final void set(UserInterface userInterface) {
        if (userInterface == null) {
            userInterface = new SilentInterface();
        }
        ui = userInterface;
    }

    public static final void verbosity(int n) {
        verbosity = n;
    }

    public static final String formatOutput(Module module, PrintLevel printLevel, String string) {
        return String.format("%-5s  %-6s: %s", module.name(), printLevel.name().toLowerCase(), string);
    }

    public static final synchronized void printDetailed(Module module, String string, Object ... objectArray) {
        if (verbosity > 3) {
            ui.print(module, PrintLevel.DETAIL, String.format(string, objectArray));
        }
    }

    public static final synchronized void printInfo(Module module, String string, Object ... objectArray) {
        if (verbosity > 2) {
            ui.print(module, PrintLevel.INFO, String.format(string, objectArray));
        }
    }

    public static final synchronized void printWarning(Module module, String string, Object ... objectArray) {
        if (verbosity > 1) {
            ui.print(module, PrintLevel.WARN, String.format(string, objectArray));
        }
    }

    public static final synchronized void printError(Module module, String string, Object ... objectArray) {
        if (verbosity > 0) {
            ui.print(module, PrintLevel.ERROR, String.format(string, objectArray));
        }
    }

    public static final synchronized void taskStart(String string, int n, int n2) {
        ui.taskStart(string, n, n2);
    }

    public static final synchronized void taskUpdate(int n) {
        ui.taskUpdate(n);
    }

    public static final synchronized void taskStop() {
        ui.taskStop();
        canceled = false;
    }

    public static final synchronized void taskCancel() {
        UI.printInfo(Module.GUI, "Abort requested by the user ...", new Object[0]);
        canceled = true;
    }

    public static final synchronized boolean taskCanceled() {
        if (canceled) {
            UI.printInfo(Module.GUI, "Abort request noticed by the current task", new Object[0]);
        }
        return canceled;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PrintLevel {
        ERROR,
        WARN,
        INFO,
        DETAIL;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Module {
        API,
        GEOM,
        HAIR,
        ACCEL,
        BCKT,
        IPR,
        LIGHT,
        GUI,
        SCENE,
        BENCH,
        TEX,
        IMG,
        DISP,
        QMC,
        SYS,
        USER,
        CAM;

    }
}

