/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.system;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;
import org.sunflow.core.Display;
import org.sunflow.image.Bitmap;

public class ImagePanel
extends JPanel
implements Display {
    private static final int[] BORDERS = new int[]{org.sunflow.image.Color.RED.toRGB(), org.sunflow.image.Color.GREEN.toRGB(), org.sunflow.image.Color.BLUE.toRGB(), org.sunflow.image.Color.YELLOW.toRGB(), org.sunflow.image.Color.CYAN.toRGB(), org.sunflow.image.Color.MAGENTA.toRGB()};
    private BufferedImage image;
    private float xo;
    private float yo;
    private float w;
    private float h;
    private long repaintCounter;

    public ImagePanel() {
        this.setPreferredSize(new Dimension(640, 480));
        this.image = null;
        this.yo = 0.0f;
        this.xo = 0.0f;
        this.h = 0.0f;
        this.w = 0.0f;
        ScrollZoomListener scrollZoomListener = new ScrollZoomListener();
        this.addMouseListener(scrollZoomListener);
        this.addMouseMotionListener(scrollZoomListener);
        this.addMouseWheelListener(scrollZoomListener);
    }

    public void save(String string) {
        Bitmap.save(this.image, string);
    }

    private synchronized void drag(int n, int n2) {
        this.xo += (float)n;
        this.yo += (float)n2;
        this.repaint();
    }

    private synchronized void zoom(int n, int n2) {
        int n3 = Math.max(n, n2);
        int n4 = Math.min(n, n2);
        if (Math.abs(n4) > Math.abs(n3)) {
            n3 = n4;
        }
        if (n3 == 0) {
            return;
        }
        float f = (float)this.getWidth() * 0.5f;
        float f2 = (float)this.getHeight() * 0.5f;
        float f3 = this.xo + ((float)this.getWidth() - this.w) * 0.5f;
        float f4 = this.yo + ((float)this.getHeight() - this.h) * 0.5f;
        float f5 = f - f3;
        float f6 = f2 - f4;
        if (this.w + (float)n3 > 100.0f) {
            this.h = (this.w + (float)n3) * this.h / this.w;
            f5 = (this.w + (float)n3) * f5 / this.w;
            f6 = (this.w + (float)n3) * f6 / this.w;
            this.w += (float)n3;
        }
        float f7 = f - f5;
        float f8 = f2 - f6;
        this.xo = f7 - ((float)this.getWidth() - this.w) * 0.5f;
        this.yo = f8 - ((float)this.getHeight() - this.h) * 0.5f;
        this.repaint();
    }

    public synchronized void reset() {
        this.yo = 0.0f;
        this.xo = 0.0f;
        if (this.image != null) {
            this.w = this.image.getWidth();
            this.h = this.image.getHeight();
        }
        this.repaint();
    }

    public synchronized void fit() {
        this.yo = 0.0f;
        this.xo = 0.0f;
        if (this.image != null) {
            float f = Math.max(this.getWidth() - 10, 100);
            float f2 = f * (float)this.image.getHeight() / (float)this.image.getWidth();
            float f3 = Math.max(this.getHeight() - 10, 100);
            float f4 = f3 * (float)this.image.getWidth() / (float)this.image.getHeight();
            if (f2 > f3) {
                this.w = f4;
                this.h = f3;
            } else {
                this.w = f;
                this.h = f2;
            }
            this.repaint();
        }
    }

    public synchronized void imageBegin(int n, int n2, int n3) {
        if (this.image != null && n == this.image.getWidth() && n2 == this.image.getHeight()) {
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    int n4 = this.image.getRGB(j, i);
                    this.image.setRGB(j, i, ((n4 & 0xFEFEFE) >>> 1) + ((n4 & 0xFCFCFC) >>> 2));
                }
            }
        } else {
            this.image = new BufferedImage(n, n2, 1);
            this.w = n;
            this.h = n2;
            this.yo = 0.0f;
            this.xo = 0.0f;
        }
        this.repaintCounter = System.nanoTime();
        this.repaint();
    }

    public synchronized void imagePrepare(int n, int n2, int n3, int n4, int n5) {
        int n6 = BORDERS[n5 % BORDERS.length];
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                if (j == 0 || j == n3 - 1) {
                    if (5 * i >= n4 && 5 * (n4 - i - 1) >= n4) continue;
                    this.image.setRGB(n + j, n2 + i, n6);
                    continue;
                }
                if (i != 0 && i != n4 - 1 || 5 * j >= n3 && 5 * (n3 - j - 1) >= n3) continue;
                this.image.setRGB(n + j, n2 + i, n6);
            }
        }
        this.repaint();
    }

    public synchronized void imageUpdate(int n, int n2, int n3, int n4, org.sunflow.image.Color[] colorArray) {
        if (this.image == null || colorArray == null) {
            return;
        }
        int n5 = 0;
        for (int i = 0; i < n4; ++i) {
            int n6 = 0;
            while (n6 < n3) {
                this.image.setRGB(n + n6, n2 + i, colorArray[n5].copy().toNonLinear().toRGB());
                ++n6;
                ++n5;
            }
        }
        this.repaint();
    }

    public synchronized void imageFill(int n, int n2, int n3, int n4, org.sunflow.image.Color color) {
        if (this.image == null || color == null) {
            return;
        }
        int n5 = color.copy().toNonLinear().toRGB();
        int n6 = 0;
        for (int i = 0; i < n4; ++i) {
            int n7 = 0;
            while (n7 < n3) {
                this.image.setRGB(n + n7, n2 + i, n5);
                ++n7;
                ++n6;
            }
        }
        this.fastRepaint();
    }

    public void imageEnd() {
        this.repaint();
    }

    private void fastRepaint() {
        long l = System.nanoTime();
        if (this.repaintCounter + 125000000L < l) {
            this.repaintCounter = l;
            this.repaint();
        }
    }

    public synchronized void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.image == null) {
            return;
        }
        int n = Math.round(this.xo + ((float)this.getWidth() - this.w) * 0.5f);
        int n2 = Math.round(this.yo + ((float)this.getHeight() - this.h) * 0.5f);
        int n3 = Math.round(this.w);
        int n4 = Math.round(this.h);
        int n5 = n - 1;
        int n6 = n2 - 1;
        int n7 = n + n3 + 1;
        int n8 = n2 + n4 + 1;
        graphics.setColor(Color.WHITE);
        graphics.drawLine(n5, n6, n7, n6);
        graphics.drawLine(n7, n6, n7, n8);
        graphics.drawLine(n7, n8, n5, n8);
        graphics.drawLine(n5, n8, n5, n6);
        graphics.drawImage(this.image, n, n2, n3, n4, this);
    }

    private class ScrollZoomListener
    extends MouseInputAdapter
    implements MouseWheelListener {
        int mx;
        int my;
        boolean dragging;
        boolean zooming;

        private ScrollZoomListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.mx = mouseEvent.getX();
            this.my = mouseEvent.getY();
            switch (mouseEvent.getButton()) {
                case 1: {
                    this.dragging = true;
                    this.zooming = false;
                    break;
                }
                case 2: {
                    this.zooming = false;
                    this.dragging = false;
                    if ((mouseEvent.getModifiersEx() & 0x80) == 128) {
                        ImagePanel.this.fit();
                        break;
                    }
                    ImagePanel.this.reset();
                    break;
                }
                case 3: {
                    this.zooming = true;
                    this.dragging = false;
                    break;
                }
                default: {
                    return;
                }
            }
            ImagePanel.this.repaint();
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (this.dragging) {
                ImagePanel.this.drag(n - this.mx, n2 - this.my);
            }
            if (this.zooming) {
                ImagePanel.this.zoom(n - this.mx, n2 - this.my);
            }
            this.mx = n;
            this.my = n2;
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.mouseDragged(mouseEvent);
        }

        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            ImagePanel.this.zoom(-20 * mouseWheelEvent.getWheelRotation(), 0);
        }
    }
}

