/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.system;

import org.sunflow.system.BenchmarkTest;
import org.sunflow.system.Timer;
import org.sunflow.system.UI;

public class BenchmarkFramework {
    private Timer[] timers;
    private int timeLimit;

    public BenchmarkFramework(int n, int n2) {
        this.timeLimit = n2;
        this.timers = new Timer[n];
    }

    public void execute(BenchmarkTest benchmarkTest) {
        for (int i = 0; i < this.timers.length; ++i) {
            this.timers[i] = null;
        }
        long l = System.nanoTime();
        for (int i = 0; i < this.timers.length && (System.nanoTime() - l) / 1000000000L < (long)this.timeLimit; ++i) {
            UI.printInfo(UI.Module.BENCH, "Running iteration %d", i + 1);
            this.timers[i] = new Timer();
            benchmarkTest.kernelBegin();
            this.timers[i].start();
            benchmarkTest.kernelMain();
            this.timers[i].end();
            benchmarkTest.kernelEnd();
        }
        double d = 0.0;
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.NEGATIVE_INFINITY;
        int n = 0;
        for (Timer timer : this.timers) {
            if (timer == null) break;
            double d4 = timer.seconds();
            d2 = Math.min(d2, d4);
            d3 = Math.max(d3, d4);
            d += d4;
            ++n;
        }
        if (n == 0) {
            return;
        }
        d /= (double)n;
        double d5 = 0.0;
        for (Timer timer : this.timers) {
            if (timer == null) break;
            double d6 = timer.seconds();
            d5 += (d6 - d) * (d6 - d);
        }
        d5 = Math.sqrt(d5 / (double)n);
        UI.printInfo(UI.Module.BENCH, "Benchmark results:", new Object[0]);
        UI.printInfo(UI.Module.BENCH, "  * Iterations: %d", n);
        UI.printInfo(UI.Module.BENCH, "  * Average:    %s", Timer.toString(d));
        UI.printInfo(UI.Module.BENCH, "  * Fastest:    %s", Timer.toString(d2));
        UI.printInfo(UI.Module.BENCH, "  * Longest:    %s", Timer.toString(d3));
        UI.printInfo(UI.Module.BENCH, "  * Deviation:  %s", Timer.toString(d5));
        for (int i = 0; i < this.timers.length && this.timers[i] != null; ++i) {
            UI.printDetailed(UI.Module.BENCH, "  * Iteration %d: %s", i + 1, this.timers[i]);
        }
    }
}

