/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.math;

import org.sunflow.math.BoundingBox;
import org.sunflow.math.OrthoNormalBasis;
import org.sunflow.math.Point3;
import org.sunflow.math.Vector3;

public final class Matrix4 {
    private float m00;
    private float m01;
    private float m02;
    private float m03;
    private float m10;
    private float m11;
    private float m12;
    private float m13;
    private float m20;
    private float m21;
    private float m22;
    private float m23;
    private float m30;
    private float m31;
    private float m32;
    private float m33;
    public static final Matrix4 ZERO = new Matrix4();
    public static final Matrix4 IDENTITY = Matrix4.scale(1.0f);

    public Matrix4() {
    }

    public Matrix4(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16) {
        this.m00 = f;
        this.m01 = f2;
        this.m02 = f3;
        this.m03 = f4;
        this.m10 = f5;
        this.m11 = f6;
        this.m12 = f7;
        this.m13 = f8;
        this.m20 = f9;
        this.m21 = f10;
        this.m22 = f11;
        this.m23 = f12;
        this.m30 = f13;
        this.m31 = f14;
        this.m32 = f15;
        this.m33 = f16;
    }

    public Matrix4(float[] fArray, boolean bl) {
        if (bl) {
            this.m00 = fArray[0];
            this.m01 = fArray[1];
            this.m02 = fArray[2];
            this.m03 = fArray[3];
            this.m10 = fArray[4];
            this.m11 = fArray[5];
            this.m12 = fArray[6];
            this.m13 = fArray[7];
            this.m20 = fArray[8];
            this.m21 = fArray[9];
            this.m22 = fArray[10];
            this.m23 = fArray[11];
            this.m30 = fArray[12];
            this.m31 = fArray[13];
            this.m32 = fArray[14];
            this.m33 = fArray[15];
        } else {
            this.m00 = fArray[0];
            this.m01 = fArray[4];
            this.m02 = fArray[8];
            this.m03 = fArray[12];
            this.m10 = fArray[1];
            this.m11 = fArray[5];
            this.m12 = fArray[9];
            this.m13 = fArray[13];
            this.m20 = fArray[2];
            this.m21 = fArray[6];
            this.m22 = fArray[10];
            this.m23 = fArray[14];
            this.m30 = fArray[3];
            this.m31 = fArray[7];
            this.m32 = fArray[11];
            this.m33 = fArray[15];
        }
    }

    public final float[] asRowMajor() {
        return new float[]{this.m00, this.m01, this.m02, this.m03, this.m10, this.m11, this.m12, this.m13, this.m20, this.m21, this.m22, this.m23, this.m30, this.m31, this.m32, this.m33};
    }

    public final float[] asColMajor() {
        return new float[]{this.m00, this.m10, this.m20, this.m30, this.m01, this.m11, this.m21, this.m31, this.m02, this.m12, this.m22, this.m32, this.m03, this.m13, this.m23, this.m33};
    }

    public final float determinant() {
        float f = this.m00 * this.m11 - this.m01 * this.m10;
        float f2 = this.m00 * this.m12 - this.m02 * this.m10;
        float f3 = this.m00 * this.m13 - this.m03 * this.m10;
        float f4 = this.m01 * this.m12 - this.m02 * this.m11;
        float f5 = this.m01 * this.m13 - this.m03 * this.m11;
        float f6 = this.m02 * this.m13 - this.m03 * this.m12;
        float f7 = this.m20 * this.m31 - this.m21 * this.m30;
        float f8 = this.m20 * this.m32 - this.m22 * this.m30;
        float f9 = this.m20 * this.m33 - this.m23 * this.m30;
        float f10 = this.m21 * this.m32 - this.m22 * this.m31;
        float f11 = this.m21 * this.m33 - this.m23 * this.m31;
        float f12 = this.m22 * this.m33 - this.m23 * this.m32;
        return f * f12 - f2 * f11 + f3 * f10 + f4 * f9 - f5 * f8 + f6 * f7;
    }

    public final Matrix4 inverse() {
        float f = this.m00 * this.m11 - this.m01 * this.m10;
        float f2 = this.m22 * this.m33 - this.m23 * this.m32;
        float f3 = this.m00 * this.m12 - this.m02 * this.m10;
        float f4 = this.m21 * this.m33 - this.m23 * this.m31;
        float f5 = this.m00 * this.m13 - this.m03 * this.m10;
        float f6 = this.m21 * this.m32 - this.m22 * this.m31;
        float f7 = this.m01 * this.m12 - this.m02 * this.m11;
        float f8 = this.m20 * this.m33 - this.m23 * this.m30;
        float f9 = this.m01 * this.m13 - this.m03 * this.m11;
        float f10 = this.m20 * this.m32 - this.m22 * this.m30;
        float f11 = this.m02 * this.m13 - this.m03 * this.m12;
        float f12 = this.m20 * this.m31 - this.m21 * this.m30;
        float f13 = f * f2 - f3 * f4 + f5 * f6 + f7 * f8 - f9 * f10 + f11 * f12;
        if (Math.abs(f13) < 1.0E-12f) {
            return null;
        }
        float f14 = 1.0f / f13;
        Matrix4 matrix4 = new Matrix4();
        matrix4.m00 = (this.m11 * f2 - this.m12 * f4 + this.m13 * f6) * f14;
        matrix4.m10 = (-this.m10 * f2 + this.m12 * f8 - this.m13 * f10) * f14;
        matrix4.m20 = (this.m10 * f4 - this.m11 * f8 + this.m13 * f12) * f14;
        matrix4.m30 = (-this.m10 * f6 + this.m11 * f10 - this.m12 * f12) * f14;
        matrix4.m01 = (-this.m01 * f2 + this.m02 * f4 - this.m03 * f6) * f14;
        matrix4.m11 = (this.m00 * f2 - this.m02 * f8 + this.m03 * f10) * f14;
        matrix4.m21 = (-this.m00 * f4 + this.m01 * f8 - this.m03 * f12) * f14;
        matrix4.m31 = (this.m00 * f6 - this.m01 * f10 + this.m02 * f12) * f14;
        matrix4.m02 = (this.m31 * f11 - this.m32 * f9 + this.m33 * f7) * f14;
        matrix4.m12 = (-this.m30 * f11 + this.m32 * f5 - this.m33 * f3) * f14;
        matrix4.m22 = (this.m30 * f9 - this.m31 * f5 + this.m33 * f) * f14;
        matrix4.m32 = (-this.m30 * f7 + this.m31 * f3 - this.m32 * f) * f14;
        matrix4.m03 = (-this.m21 * f11 + this.m22 * f9 - this.m23 * f7) * f14;
        matrix4.m13 = (this.m20 * f11 - this.m22 * f5 + this.m23 * f3) * f14;
        matrix4.m23 = (-this.m20 * f9 + this.m21 * f5 - this.m23 * f) * f14;
        matrix4.m33 = (this.m20 * f7 - this.m21 * f3 + this.m22 * f) * f14;
        return matrix4;
    }

    public final Matrix4 multiply(Matrix4 matrix4) {
        float f = this.m00 * matrix4.m00 + this.m01 * matrix4.m10 + this.m02 * matrix4.m20 + this.m03 * matrix4.m30;
        float f2 = this.m00 * matrix4.m01 + this.m01 * matrix4.m11 + this.m02 * matrix4.m21 + this.m03 * matrix4.m31;
        float f3 = this.m00 * matrix4.m02 + this.m01 * matrix4.m12 + this.m02 * matrix4.m22 + this.m03 * matrix4.m32;
        float f4 = this.m00 * matrix4.m03 + this.m01 * matrix4.m13 + this.m02 * matrix4.m23 + this.m03 * matrix4.m33;
        float f5 = this.m10 * matrix4.m00 + this.m11 * matrix4.m10 + this.m12 * matrix4.m20 + this.m13 * matrix4.m30;
        float f6 = this.m10 * matrix4.m01 + this.m11 * matrix4.m11 + this.m12 * matrix4.m21 + this.m13 * matrix4.m31;
        float f7 = this.m10 * matrix4.m02 + this.m11 * matrix4.m12 + this.m12 * matrix4.m22 + this.m13 * matrix4.m32;
        float f8 = this.m10 * matrix4.m03 + this.m11 * matrix4.m13 + this.m12 * matrix4.m23 + this.m13 * matrix4.m33;
        float f9 = this.m20 * matrix4.m00 + this.m21 * matrix4.m10 + this.m22 * matrix4.m20 + this.m23 * matrix4.m30;
        float f10 = this.m20 * matrix4.m01 + this.m21 * matrix4.m11 + this.m22 * matrix4.m21 + this.m23 * matrix4.m31;
        float f11 = this.m20 * matrix4.m02 + this.m21 * matrix4.m12 + this.m22 * matrix4.m22 + this.m23 * matrix4.m32;
        float f12 = this.m20 * matrix4.m03 + this.m21 * matrix4.m13 + this.m22 * matrix4.m23 + this.m23 * matrix4.m33;
        float f13 = this.m30 * matrix4.m00 + this.m31 * matrix4.m10 + this.m32 * matrix4.m20 + this.m33 * matrix4.m30;
        float f14 = this.m30 * matrix4.m01 + this.m31 * matrix4.m11 + this.m32 * matrix4.m21 + this.m33 * matrix4.m31;
        float f15 = this.m30 * matrix4.m02 + this.m31 * matrix4.m12 + this.m32 * matrix4.m22 + this.m33 * matrix4.m32;
        float f16 = this.m30 * matrix4.m03 + this.m31 * matrix4.m13 + this.m32 * matrix4.m23 + this.m33 * matrix4.m33;
        return new Matrix4(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16);
    }

    public final BoundingBox transform(BoundingBox boundingBox) {
        if (boundingBox.isEmpty()) {
            return new BoundingBox();
        }
        BoundingBox boundingBox2 = new BoundingBox(this.transformP(boundingBox.getMinimum()));
        boundingBox2.include(this.transformP(boundingBox.getMaximum()));
        for (int i = 1; i < 7; ++i) {
            boundingBox2.include(this.transformP(boundingBox.getCorner(i)));
        }
        return boundingBox2;
    }

    public final Vector3 transformV(Vector3 vector3) {
        Vector3 vector32 = new Vector3();
        vector32.x = this.m00 * vector3.x + this.m01 * vector3.y + this.m02 * vector3.z;
        vector32.y = this.m10 * vector3.x + this.m11 * vector3.y + this.m12 * vector3.z;
        vector32.z = this.m20 * vector3.x + this.m21 * vector3.y + this.m22 * vector3.z;
        return vector32;
    }

    public final Vector3 transformTransposeV(Vector3 vector3) {
        Vector3 vector32 = new Vector3();
        vector32.x = this.m00 * vector3.x + this.m10 * vector3.y + this.m20 * vector3.z;
        vector32.y = this.m01 * vector3.x + this.m11 * vector3.y + this.m21 * vector3.z;
        vector32.z = this.m02 * vector3.x + this.m12 * vector3.y + this.m22 * vector3.z;
        return vector32;
    }

    public final Point3 transformP(Point3 point3) {
        Point3 point32 = new Point3();
        point32.x = this.m00 * point3.x + this.m01 * point3.y + this.m02 * point3.z + this.m03;
        point32.y = this.m10 * point3.x + this.m11 * point3.y + this.m12 * point3.z + this.m13;
        point32.z = this.m20 * point3.x + this.m21 * point3.y + this.m22 * point3.z + this.m23;
        return point32;
    }

    public final float transformVX(float f, float f2, float f3) {
        return this.m00 * f + this.m01 * f2 + this.m02 * f3;
    }

    public final float transformVY(float f, float f2, float f3) {
        return this.m10 * f + this.m11 * f2 + this.m12 * f3;
    }

    public final float transformVZ(float f, float f2, float f3) {
        return this.m20 * f + this.m21 * f2 + this.m22 * f3;
    }

    public final float transformTransposeVX(float f, float f2, float f3) {
        return this.m00 * f + this.m10 * f2 + this.m20 * f3;
    }

    public final float transformTransposeVY(float f, float f2, float f3) {
        return this.m01 * f + this.m11 * f2 + this.m21 * f3;
    }

    public final float transformTransposeVZ(float f, float f2, float f3) {
        return this.m02 * f + this.m12 * f2 + this.m22 * f3;
    }

    public final float transformPX(float f, float f2, float f3) {
        return this.m00 * f + this.m01 * f2 + this.m02 * f3 + this.m03;
    }

    public final float transformPY(float f, float f2, float f3) {
        return this.m10 * f + this.m11 * f2 + this.m12 * f3 + this.m13;
    }

    public final float transformPZ(float f, float f2, float f3) {
        return this.m20 * f + this.m21 * f2 + this.m22 * f3 + this.m23;
    }

    public static final Matrix4 translation(float f, float f2, float f3) {
        Matrix4 matrix4 = new Matrix4();
        matrix4.m33 = 1.0f;
        matrix4.m22 = 1.0f;
        matrix4.m11 = 1.0f;
        matrix4.m00 = 1.0f;
        matrix4.m03 = f;
        matrix4.m13 = f2;
        matrix4.m23 = f3;
        return matrix4;
    }

    public static final Matrix4 rotateX(float f) {
        Matrix4 matrix4 = new Matrix4();
        float f2 = (float)Math.sin(f);
        float f3 = (float)Math.cos(f);
        matrix4.m33 = 1.0f;
        matrix4.m00 = 1.0f;
        matrix4.m11 = matrix4.m22 = f3;
        matrix4.m12 = -f2;
        matrix4.m21 = f2;
        return matrix4;
    }

    public static final Matrix4 rotateY(float f) {
        Matrix4 matrix4 = new Matrix4();
        float f2 = (float)Math.sin(f);
        float f3 = (float)Math.cos(f);
        matrix4.m33 = 1.0f;
        matrix4.m11 = 1.0f;
        matrix4.m00 = matrix4.m22 = f3;
        matrix4.m02 = f2;
        matrix4.m20 = -f2;
        return matrix4;
    }

    public static final Matrix4 rotateZ(float f) {
        Matrix4 matrix4 = new Matrix4();
        float f2 = (float)Math.sin(f);
        float f3 = (float)Math.cos(f);
        matrix4.m33 = 1.0f;
        matrix4.m22 = 1.0f;
        matrix4.m00 = matrix4.m11 = f3;
        matrix4.m01 = -f2;
        matrix4.m10 = f2;
        return matrix4;
    }

    public static final Matrix4 rotate(float f, float f2, float f3, float f4) {
        Matrix4 matrix4 = new Matrix4();
        float f5 = 1.0f / (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
        f *= f5;
        f2 *= f5;
        f3 *= f5;
        float f6 = (float)Math.sin(f4);
        float f7 = (float)Math.cos(f4);
        float f8 = 1.0f - f7;
        matrix4.m00 = f8 * f * f + f7;
        matrix4.m11 = f8 * f2 * f2 + f7;
        matrix4.m22 = f8 * f3 * f3 + f7;
        float f9 = f8 * f * f2;
        float f10 = f6 * f3;
        matrix4.m01 = f9 - f10;
        matrix4.m10 = f9 + f10;
        float f11 = f8 * f * f3;
        float f12 = f6 * f2;
        matrix4.m02 = f11 + f12;
        matrix4.m20 = f11 - f12;
        float f13 = f8 * f2 * f3;
        float f14 = f6 * f;
        matrix4.m12 = f13 - f14;
        matrix4.m21 = f13 + f14;
        matrix4.m33 = 1.0f;
        return matrix4;
    }

    public static final Matrix4 scale(float f) {
        Matrix4 matrix4 = new Matrix4();
        matrix4.m11 = matrix4.m22 = f;
        matrix4.m00 = matrix4.m22;
        matrix4.m33 = 1.0f;
        return matrix4;
    }

    public static final Matrix4 scale(float f, float f2, float f3) {
        Matrix4 matrix4 = new Matrix4();
        matrix4.m00 = f;
        matrix4.m11 = f2;
        matrix4.m22 = f3;
        matrix4.m33 = 1.0f;
        return matrix4;
    }

    public static final Matrix4 fromBasis(OrthoNormalBasis orthoNormalBasis) {
        Matrix4 matrix4 = new Matrix4();
        Vector3 vector3 = orthoNormalBasis.transform(new Vector3(1.0f, 0.0f, 0.0f));
        Vector3 vector32 = orthoNormalBasis.transform(new Vector3(0.0f, 1.0f, 0.0f));
        Vector3 vector33 = orthoNormalBasis.transform(new Vector3(0.0f, 0.0f, 1.0f));
        matrix4.m00 = vector3.x;
        matrix4.m01 = vector32.x;
        matrix4.m02 = vector33.x;
        matrix4.m10 = vector3.y;
        matrix4.m11 = vector32.y;
        matrix4.m12 = vector33.y;
        matrix4.m20 = vector3.z;
        matrix4.m21 = vector32.z;
        matrix4.m22 = vector33.z;
        matrix4.m33 = 1.0f;
        return matrix4;
    }

    public static final Matrix4 blend(Matrix4 matrix4, Matrix4 matrix42, float f) {
        Matrix4 matrix43 = new Matrix4();
        matrix43.m00 = (1.0f - f) * matrix4.m00 + f * matrix42.m00;
        matrix43.m01 = (1.0f - f) * matrix4.m01 + f * matrix42.m01;
        matrix43.m02 = (1.0f - f) * matrix4.m02 + f * matrix42.m02;
        matrix43.m03 = (1.0f - f) * matrix4.m03 + f * matrix42.m03;
        matrix43.m10 = (1.0f - f) * matrix4.m10 + f * matrix42.m10;
        matrix43.m11 = (1.0f - f) * matrix4.m11 + f * matrix42.m11;
        matrix43.m12 = (1.0f - f) * matrix4.m12 + f * matrix42.m12;
        matrix43.m13 = (1.0f - f) * matrix4.m13 + f * matrix42.m13;
        matrix43.m20 = (1.0f - f) * matrix4.m20 + f * matrix42.m20;
        matrix43.m21 = (1.0f - f) * matrix4.m21 + f * matrix42.m21;
        matrix43.m22 = (1.0f - f) * matrix4.m22 + f * matrix42.m22;
        matrix43.m23 = (1.0f - f) * matrix4.m23 + f * matrix42.m23;
        matrix43.m30 = (1.0f - f) * matrix4.m30 + f * matrix42.m30;
        matrix43.m31 = (1.0f - f) * matrix4.m31 + f * matrix42.m31;
        matrix43.m32 = (1.0f - f) * matrix4.m32 + f * matrix42.m32;
        matrix43.m33 = (1.0f - f) * matrix4.m33 + f * matrix42.m33;
        return matrix43;
    }
}

