/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.image;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.sunflow.image.Color;
import org.sunflow.image.RGBSpace;
import org.sunflow.system.UI;

public class Bitmap {
    private int[] pixels;
    private int width;
    private int height;
    private boolean isHDR;

    public Bitmap(String string, boolean bl) throws IOException {
        if (string.endsWith(".hdr")) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            this.isHDR = true;
            FileInputStream fileInputStream = new FileInputStream(string);
            boolean bl2 = false;
            boolean bl3 = false;
            this.height = 0;
            this.width = 0;
            int n8 = 0;
            while (this.width == 0 || this.height == 0 || n8 != 10) {
                n7 = fileInputStream.read();
                switch (n7) {
                    case 89: {
                        bl3 = n8 == 45;
                        bl2 = false;
                        break;
                    }
                    case 88: {
                        bl3 = false;
                        bl2 = n8 == 43;
                        break;
                    }
                    case 32: {
                        bl2 &= this.width == 0;
                        bl3 &= this.height == 0;
                        break;
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        if (bl3) {
                            this.height = 10 * this.height + (n7 - 48);
                            break;
                        }
                        if (!bl2) break;
                        this.width = 10 * this.width + (n7 - 48);
                        break;
                    }
                    default: {
                        bl3 = false;
                        bl2 = false;
                    }
                }
                n8 = n7;
            }
            this.pixels = new int[this.width * this.height];
            if (this.width < 8 || this.width > Short.MAX_VALUE) {
                this.readFlatRGBE(fileInputStream, 0, this.width * this.height);
                return;
            }
            n7 = 0;
            int[] nArray = new int[4 * this.width];
            for (int i = this.height; i > 0; --i) {
                n6 = fileInputStream.read();
                n5 = fileInputStream.read();
                n4 = fileInputStream.read();
                n3 = fileInputStream.read();
                if (n6 != 2 || n5 != 2 || (n4 & 0x80) != 0) {
                    this.pixels[n7] = n6 << 24 | n5 << 16 | n4 << 8 | n3;
                    this.readFlatRGBE(fileInputStream, n7 + 1, this.width * i - 1);
                    return;
                }
                if ((n4 << 8 | n3) != this.width) {
                    System.out.println("Invalid scanline width");
                    return;
                }
                n2 = 0;
                for (n = 0; n < 4; ++n) {
                    if (n2 % this.width != 0) {
                        System.out.println("Unaligned access to scanline data");
                    }
                    int n9 = (n + 1) * this.width;
                    while (n2 < n9) {
                        int n10;
                        int n11 = fileInputStream.read();
                        int n12 = fileInputStream.read();
                        if (n11 > 128) {
                            n10 = n11 - 128;
                            if (n10 == 0 || n10 > n9 - n2) {
                                System.out.println("Bad scanline data - invalid RLE run");
                                return;
                            }
                            while (n10-- > 0) {
                                nArray[n2] = n12;
                                ++n2;
                            }
                            continue;
                        }
                        n10 = n11;
                        if (n10 == 0 || n10 > n9 - n2) {
                            System.out.println("Bad scanline data - invalid count");
                            return;
                        }
                        nArray[n2] = n12;
                        ++n2;
                        if (--n10 <= 0) continue;
                        for (int j = 0; j < n10; ++j) {
                            nArray[n2 + j] = fileInputStream.read();
                        }
                        n2 += n10;
                    }
                }
                for (n = 0; n < this.width; ++n) {
                    n6 = nArray[n];
                    n5 = nArray[n + this.width];
                    n4 = nArray[n + 2 * this.width];
                    n3 = nArray[n + 3 * this.width];
                    this.pixels[n7] = n6 << 24 | n5 << 16 | n4 << 8 | n3;
                    ++n7;
                }
            }
            n6 = 0;
            n5 = 0;
            n4 = (this.height - 1) * this.width;
            while (n6 < this.height / 2) {
                n3 = 0;
                n2 = n4;
                while (n3 < this.width) {
                    n = this.pixels[n5];
                    this.pixels[n5] = this.pixels[n2];
                    this.pixels[n2] = n;
                    ++n3;
                    ++n5;
                    ++n2;
                }
                ++n6;
                n4 -= this.width;
            }
        } else if (string.endsWith(".tga")) {
            this.isHDR = false;
            FileInputStream fileInputStream = new FileInputStream(string);
            int n = 0;
            int n13 = 0;
            byte[] byArray = new byte[4];
            int n14 = fileInputStream.read() & 0xFF;
            fileInputStream.read();
            int n15 = fileInputStream.read() & 0xFF;
            fileInputStream.read();
            fileInputStream.read();
            fileInputStream.read();
            fileInputStream.read();
            fileInputStream.read();
            fileInputStream.read();
            fileInputStream.read();
            fileInputStream.read();
            fileInputStream.read();
            this.width = fileInputStream.read() & 0xFF;
            this.width |= (fileInputStream.read() & 0xFF) << 8;
            this.height = fileInputStream.read() & 0xFF;
            this.height |= (fileInputStream.read() & 0xFF) << 8;
            this.pixels = new int[this.width * this.height];
            int n16 = (fileInputStream.read() & 0xFF) / 8;
            int n17 = fileInputStream.read() & 0xFF;
            if (n14 != 0) {
                fileInputStream.skip(n14);
            }
            switch (n15) {
                case 10: {
                    while (n < this.width * this.height) {
                        int n18;
                        int n19 = fileInputStream.read() & 0xFF;
                        if ((n19 & 0x80) == 128) {
                            n19 &= 0x7F;
                            fileInputStream.read(byArray, 0, n16);
                            n13 = (byArray[2] & 0xFF) << 16;
                            n13 |= (byArray[1] & 0xFF) << 8;
                            n13 = bl ? n13 : RGBSpace.SRGB.rgbToLinear(n13 |= byArray[0] & 0xFF);
                            n18 = 0;
                            while (n18 <= n19) {
                                this.pixels[n] = n13;
                                ++n18;
                                ++n;
                            }
                            continue;
                        }
                        n19 &= 0x7F;
                        n18 = 0;
                        while (n18 <= n19) {
                            fileInputStream.read(byArray, 0, n16);
                            n13 = (byArray[2] & 0xFF) << 16;
                            n13 |= (byArray[1] & 0xFF) << 8;
                            this.pixels[n] = bl ? n13 : RGBSpace.SRGB.rgbToLinear(n13 |= byArray[0] & 0xFF);
                            ++n18;
                            ++n;
                        }
                    }
                    break;
                }
                case 2: {
                    for (n = 0; n < this.width * this.height; ++n) {
                        fileInputStream.read(byArray, 0, n16);
                        n13 = (byArray[2] & 0xFF) << 16;
                        n13 |= (byArray[1] & 0xFF) << 8;
                        this.pixels[n] = bl ? n13 : RGBSpace.SRGB.rgbToLinear(n13 |= byArray[0] & 0xFF);
                    }
                    break;
                }
                default: {
                    UI.printWarning(UI.Module.IMG, "Unsupported TGA datatype: %s", n15);
                }
            }
            if ((n17 & 0x20) == 32) {
                n = 0;
                for (int i = 0; i < this.height / 2; ++i) {
                    for (int j = 0; j < this.width; ++j) {
                        int n20 = this.pixels[n];
                        this.pixels[n] = this.pixels[(this.height - i - 1) * this.width + j];
                        this.pixels[(this.height - i - 1) * this.width + j] = n20;
                        ++n;
                    }
                }
            }
            fileInputStream.close();
        } else {
            BufferedImage bufferedImage = ImageIO.read(new File(string));
            this.width = bufferedImage.getWidth();
            this.height = bufferedImage.getHeight();
            this.isHDR = false;
            this.pixels = new int[this.width * this.height];
            int n = 0;
            for (int i = 0; i < this.height; ++i) {
                int n21 = 0;
                while (n21 < this.width) {
                    int n22 = bufferedImage.getRGB(n21, this.height - 1 - i);
                    this.pixels[n] = bl ? n22 : RGBSpace.SRGB.rgbToLinear(n22);
                    ++n21;
                    ++n;
                }
            }
        }
    }

    public static void save(BufferedImage bufferedImage, String string) {
        Bitmap bitmap = new Bitmap(bufferedImage.getWidth(), bufferedImage.getHeight(), false);
        for (int i = 0; i < bitmap.height; ++i) {
            for (int j = 0; j < bitmap.width; ++j) {
                bitmap.pixels[(bitmap.height - 1 - i) * bitmap.width + j] = bufferedImage.getRGB(j, i);
            }
        }
        if (string.endsWith(".tga")) {
            bitmap.saveTGA(string);
        } else {
            bitmap.savePNG(string);
        }
    }

    private void readFlatRGBE(FileInputStream fileInputStream, int n, int n2) throws IOException {
        while (n2-- > 0) {
            int n3 = fileInputStream.read();
            int n4 = fileInputStream.read();
            int n5 = fileInputStream.read();
            int n6 = fileInputStream.read();
            this.pixels[n] = n3 << 24 | n4 << 16 | n5 << 8 | n6;
            ++n;
        }
    }

    public Bitmap(int n, int n2, boolean bl) {
        this.width = n;
        this.height = n2;
        this.isHDR = bl;
        this.pixels = new int[n * n2];
    }

    public void setPixel(int n, int n2, Color color) {
        if (n >= 0 && n < this.width && n2 >= 0 && n2 < this.height) {
            this.pixels[n2 * this.width + n] = this.isHDR ? color.toRGBE() : color.copy().toNonLinear().toRGB();
        }
    }

    public Color getPixel(int n, int n2) {
        if (n >= 0 && n < this.width && n2 >= 0 && n2 < this.height) {
            return this.isHDR ? new Color().setRGBE(this.pixels[n2 * this.width + n]) : new Color(this.pixels[n2 * this.width + n]);
        }
        return Color.BLACK;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void save(String string) {
        if (string.endsWith(".hdr")) {
            this.saveHDR(string);
        } else if (string.endsWith(".png")) {
            this.savePNG(string);
        } else if (string.endsWith(".tga")) {
            this.saveTGA(string);
        } else {
            this.saveHDR(string + ".hdr");
        }
    }

    private void savePNG(String string) {
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 1);
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                bufferedImage.setRGB(j, this.height - 1 - i, this.isHDR ? this.getPixel(j, i).toRGB() : this.pixels[i * this.width + j]);
            }
        }
        try {
            ImageIO.write((RenderedImage)bufferedImage, "png", new File(string));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void saveHDR(String string) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            fileOutputStream.write("#?RGBE\n".getBytes());
            fileOutputStream.write("FORMAT=32-bit_rle_rgbe\n\n".getBytes());
            fileOutputStream.write(("-Y " + this.height + " +X " + this.width + "\n").getBytes());
            for (int i = this.height - 1; i >= 0; --i) {
                for (int j = 0; j < this.width; ++j) {
                    int n = this.isHDR ? this.pixels[i * this.width + j] : new Color(this.pixels[i * this.width + j]).toRGBE();
                    fileOutputStream.write(n >> 24);
                    fileOutputStream.write(n >> 16);
                    fileOutputStream.write(n >> 8);
                    fileOutputStream.write(n);
                }
            }
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void saveTGA(String string) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            byte[] byArray = new byte[]{0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            fileOutputStream.write(byArray);
            fileOutputStream.write(this.width & 0xFF);
            fileOutputStream.write(this.width >> 8 & 0xFF);
            fileOutputStream.write(this.height & 0xFF);
            fileOutputStream.write(this.height >> 8 & 0xFF);
            fileOutputStream.write(32);
            fileOutputStream.write(0);
            for (int i = 0; i < this.height; ++i) {
                for (int j = 0; j < this.width; ++j) {
                    int n = this.isHDR ? this.getPixel(j, i).toRGB() : this.pixels[i * this.width + j];
                    fileOutputStream.write(n & 0xFF);
                    fileOutputStream.write(n >> 8 & 0xFF);
                    fileOutputStream.write(n >> 16 & 0xFF);
                    fileOutputStream.write(255);
                }
            }
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

