/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core.tesselatable;

import org.sunflow.SunflowAPI;
import org.sunflow.core.Instance;
import org.sunflow.core.IntersectionState;
import org.sunflow.core.ParameterList;
import org.sunflow.core.PrimitiveList;
import org.sunflow.core.Ray;
import org.sunflow.core.ShadingState;
import org.sunflow.core.Tesselatable;
import org.sunflow.core.primitive.QuadMesh;
import org.sunflow.core.primitive.TriangleMesh;
import org.sunflow.math.BoundingBox;
import org.sunflow.math.Matrix4;
import org.sunflow.math.OrthoNormalBasis;
import org.sunflow.math.Point3;
import org.sunflow.math.Vector3;
import org.sunflow.system.UI;

public class BezierMesh
implements PrimitiveList,
Tesselatable {
    private int subdivs = 8;
    private boolean smooth = true;
    private boolean quads = false;
    private float[][] patches;

    public BezierMesh() {
        this(null);
    }

    public BezierMesh(float[][] fArray) {
        this.patches = fArray;
    }

    public BoundingBox getWorldBounds(Matrix4 matrix4) {
        BoundingBox boundingBox = new BoundingBox();
        if (matrix4 == null) {
            for (int i = 0; i < this.patches.length; ++i) {
                float[] fArray = this.patches[i];
                for (int j = 0; j < fArray.length; j += 3) {
                    boundingBox.include(fArray[j], fArray[j + 1], fArray[j + 2]);
                }
            }
        } else {
            for (int i = 0; i < this.patches.length; ++i) {
                float[] fArray = this.patches[i];
                for (int j = 0; j < fArray.length; j += 3) {
                    float f = fArray[j];
                    float f2 = fArray[j + 1];
                    float f3 = fArray[j + 2];
                    float f4 = matrix4.transformPX(f, f2, f3);
                    float f5 = matrix4.transformPY(f, f2, f3);
                    float f6 = matrix4.transformPZ(f, f2, f3);
                    boundingBox.include(f4, f5, f6);
                }
            }
        }
        return boundingBox;
    }

    private float[] bernstein(float f) {
        float[] fArray = new float[4];
        float f2 = 1.0f - f;
        fArray[0] = f2 * f2 * f2;
        fArray[1] = 3.0f * f * f2 * f2;
        fArray[2] = 3.0f * f * f * f2;
        fArray[3] = f * f * f;
        return fArray;
    }

    private float[] bernsteinDeriv(float f) {
        if (!this.smooth) {
            return null;
        }
        float[] fArray = new float[4];
        float f2 = 1.0f - f;
        fArray[0] = 3.0f * (0.0f - f2 * f2);
        fArray[1] = 3.0f * (f2 * f2 - 2.0f * f * f2);
        fArray[2] = 3.0f * (2.0f * f * f2 - f * f);
        fArray[3] = 3.0f * (f * f - 0.0f);
        return fArray;
    }

    private void getPatchPoint(float f, float f2, float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, float[] fArray5, Point3 point3, Vector3 vector3) {
        float f3;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            int n2 = 0;
            while (n2 < 4) {
                f3 = fArray2[n2] * fArray3[i];
                f4 += fArray[n + 0] * f3;
                f5 += fArray[n + 1] * f3;
                f6 += fArray[n + 2] * f3;
                ++n2;
                n += 3;
            }
        }
        point3.x = f4;
        point3.y = f5;
        point3.z = f6;
        if (vector3 != null) {
            float f7 = 0.0f;
            float f8 = 0.0f;
            float f9 = 0.0f;
            f3 = 0.0f;
            float f10 = 0.0f;
            float f11 = 0.0f;
            int n3 = 0;
            for (int i = 0; i < 4; ++i) {
                int n4 = 0;
                while (n4 < 4) {
                    float f12 = fArray4[n4] * fArray3[i];
                    f7 += fArray[n3 + 0] * f12;
                    f8 += fArray[n3 + 1] * f12;
                    f9 += fArray[n3 + 2] * f12;
                    float f13 = fArray2[n4] * fArray5[i];
                    f3 += fArray[n3 + 0] * f13;
                    f10 += fArray[n3 + 1] * f13;
                    f11 += fArray[n3 + 2] * f13;
                    ++n4;
                    n3 += 3;
                }
            }
            vector3.x = f8 * f11 - f9 * f10;
            vector3.y = f9 * f3 - f7 * f11;
            vector3.z = f7 * f10 - f8 * f3;
        }
    }

    public PrimitiveList tesselate() {
        float[] fArray = new float[this.patches.length * (this.subdivs + 1) * (this.subdivs + 1) * 3];
        float[] fArray2 = this.smooth ? new float[this.patches.length * (this.subdivs + 1) * (this.subdivs + 1) * 3] : null;
        float[] fArray3 = new float[this.patches.length * (this.subdivs + 1) * (this.subdivs + 1) * 2];
        int[] nArray = new int[this.patches.length * this.subdivs * this.subdivs * (this.quads ? 4 : 6)];
        int n = 0;
        int n2 = 0;
        float f = 1.0f / (float)this.subdivs;
        int n3 = this.subdivs + 1;
        Point3 point3 = new Point3();
        Vector3 vector3 = this.smooth ? new Vector3() : null;
        for (float[] fArray4 : this.patches) {
            int n4;
            int n5;
            int n6 = 0;
            for (n5 = 0; n5 <= this.subdivs; ++n5) {
                float f2 = (float)n5 * f;
                float[] fArray5 = this.bernstein(f2);
                float[] fArray6 = this.bernsteinDeriv(f2);
                n4 = 0;
                while (n4 <= this.subdivs) {
                    float f3 = (float)n4 * f;
                    float[] fArray7 = this.bernstein(f3);
                    float[] fArray8 = this.bernsteinDeriv(f3);
                    this.getPatchPoint(f2, f3, fArray4, fArray5, fArray7, fArray6, fArray8, point3, vector3);
                    fArray[n + n6 + 0] = point3.x;
                    fArray[n + n6 + 1] = point3.y;
                    fArray[n + n6 + 2] = point3.z;
                    if (this.smooth) {
                        fArray2[n + n6 + 0] = vector3.x;
                        fArray2[n + n6 + 1] = vector3.y;
                        fArray2[n + n6 + 2] = vector3.z;
                    }
                    fArray3[(n + n6) / 3 * 2 + 0] = f2;
                    fArray3[(n + n6) / 3 * 2 + 1] = f3;
                    ++n4;
                    n6 += 3;
                }
            }
            n6 = n / 3;
            for (n5 = 0; n5 < this.subdivs; ++n5) {
                for (int i = 0; i < this.subdivs; ++i) {
                    int n7 = (n5 + 0) * n3 + (i + 0);
                    int n8 = (n5 + 1) * n3 + (i + 0);
                    n4 = (n5 + 0) * n3 + (i + 1);
                    int n9 = (n5 + 1) * n3 + (i + 1);
                    if (this.quads) {
                        nArray[n2 + 0] = n6 + n4;
                        nArray[n2 + 1] = n6 + n7;
                        nArray[n2 + 2] = n6 + n8;
                        nArray[n2 + 3] = n6 + n9;
                        n2 += 4;
                        continue;
                    }
                    nArray[n2 + 0] = n6 + n7;
                    nArray[n2 + 1] = n6 + n8;
                    nArray[n2 + 2] = n6 + n4;
                    nArray[n2 + 3] = n6 + n8;
                    nArray[n2 + 4] = n6 + n9;
                    nArray[n2 + 5] = n6 + n4;
                    n2 += 6;
                }
            }
            n += n3 * n3 * 3;
        }
        Object object = new ParameterList();
        ((ParameterList)object).addPoints("points", ParameterList.InterpolationType.VERTEX, fArray);
        if (this.quads) {
            ((ParameterList)object).addIntegerArray("quads", nArray);
        } else {
            ((ParameterList)object).addIntegerArray("triangles", nArray);
        }
        ((ParameterList)object).addTexCoords("uvs", ParameterList.InterpolationType.VERTEX, fArray3);
        if (this.smooth) {
            ((ParameterList)object).addVectors("normals", ParameterList.InterpolationType.VERTEX, fArray2);
        }
        PrimitiveList primitiveList = this.quads ? new QuadMesh() : new TriangleMesh();
        primitiveList.update((ParameterList)object, null);
        ((ParameterList)object).clear(true);
        return primitiveList;
    }

    public boolean update(ParameterList parameterList, SunflowAPI sunflowAPI) {
        this.subdivs = parameterList.getInt("subdivs", this.subdivs);
        this.smooth = parameterList.getBoolean("smooth", this.smooth);
        this.quads = parameterList.getBoolean("quads", this.quads);
        int n = parameterList.getInt("nu", 0);
        int n2 = parameterList.getInt("nv", 0);
        parameterList.setVertexCount(n * n2);
        boolean bl = parameterList.getBoolean("uwrap", false);
        boolean bl2 = parameterList.getBoolean("vwrap", false);
        ParameterList.FloatParameter floatParameter = parameterList.getPointArray("points");
        if (floatParameter != null && floatParameter.interp == ParameterList.InterpolationType.VERTEX) {
            int n3;
            int n4 = bl ? n / 3 : (n - 4) / 3 + 1;
            int n5 = n3 = bl2 ? n2 / 3 : (n2 - 4) / 3 + 1;
            if (n4 < 1 || n3 < 1) {
                UI.printError(UI.Module.GEOM, "Invalid number of patches for bezier mesh - ignoring", new Object[0]);
                return false;
            }
            this.patches = new float[n4 * n3][];
            int n6 = 0;
            for (int i = 0; i < n3; ++i) {
                int n7 = 0;
                while (n7 < n4) {
                    this.patches[n6] = new float[48];
                    float[] fArray = this.patches[n6];
                    int n8 = n7 * 3;
                    int n9 = i * 3;
                    for (int j = 0; j < 4; ++j) {
                        for (int k = 0; k < 4; ++k) {
                            int n10 = (n8 + k) % n;
                            int n11 = (n9 + j) % n2;
                            fArray[3 * (j * 4 + k) + 0] = floatParameter.data[3 * (n10 + n * n11) + 0];
                            fArray[3 * (j * 4 + k) + 1] = floatParameter.data[3 * (n10 + n * n11) + 1];
                            fArray[3 * (j * 4 + k) + 2] = floatParameter.data[3 * (n10 + n * n11) + 2];
                        }
                    }
                    ++n7;
                    ++n6;
                }
            }
        }
        if (this.subdivs < 1) {
            UI.printError(UI.Module.GEOM, "Invalid subdivisions for bezier mesh - ignoring", new Object[0]);
            return false;
        }
        if (this.patches == null) {
            UI.printError(UI.Module.GEOM, "No patch data present in bezier mesh - ignoring", new Object[0]);
            return false;
        }
        return true;
    }

    public int getNumPrimitives() {
        return this.patches.length;
    }

    public float getPrimitiveBound(int n, int n2) {
        float[] fArray = this.patches[n];
        int n3 = n2 >>> 1;
        if ((n2 & 1) == 0) {
            float f = fArray[n3];
            for (int i = n3 + 3; i < fArray.length; i += 3) {
                if (!(f > fArray[i])) continue;
                f = fArray[i];
            }
            return f;
        }
        float f = fArray[n3];
        for (int i = n3 + 3; i < fArray.length; i += 3) {
            if (!(f < fArray[i])) continue;
            f = fArray[i];
        }
        return f;
    }

    public void intersectPrimitive(Ray ray, int n, IntersectionState intersectionState) {
        float[] fArray = intersectionState.getRobustStack();
        float[] fArray2 = this.patches[n];
        for (int i = 0; i < 48; ++i) {
            fArray[i] = fArray2[i];
        }
        fArray[48] = Float.POSITIVE_INFINITY;
        fArray[49] = 0.0f;
        fArray[50] = 0.0f;
        fArray[51] = 1.0f;
        fArray[52] = 1.0f;
        int n2 = 0;
        float f = ray.ox;
        float f2 = 1.0f / ray.dx;
        float f3 = ray.oy;
        float f4 = 1.0f / ray.dy;
        float f5 = ray.oz;
        float f6 = 1.0f / ray.dz;
        while (n2 >= 0) {
            float f7;
            float f8;
            float f9;
            float f10;
            float f11;
            float f12;
            float f13;
            float f14;
            float f15;
            float f16;
            float f17;
            float f18;
            float f19;
            float f20;
            int n3;
            float f21 = ray.getMin();
            float f22 = ray.getMax();
            float f23 = fArray[n2 + 0];
            float f24 = fArray[n2 + 0];
            int n4 = 1;
            int n5 = n2 + 3;
            while (n4 < 16) {
                if (f23 > fArray[n5]) {
                    f23 = fArray[n5];
                }
                if (f24 < fArray[n5]) {
                    f24 = fArray[n5];
                }
                ++n4;
                n5 += 3;
            }
            float f25 = (f23 - f) * f2;
            float f26 = (f24 - f) * f2;
            if (f2 > 0.0f) {
                if (f25 > f21) {
                    f21 = f25;
                }
                if (f26 < f22) {
                    f22 = f26;
                }
            } else {
                if (f26 > f21) {
                    f21 = f26;
                }
                if (f25 < f22) {
                    f22 = f25;
                }
            }
            if (f21 > f22) {
                n2 -= 64;
                continue;
            }
            float f27 = fArray[n2 + 1];
            float f28 = fArray[n2 + 1];
            int n6 = 1;
            int n7 = n2 + 4;
            while (n6 < 16) {
                if (f27 > fArray[n7]) {
                    f27 = fArray[n7];
                }
                if (f28 < fArray[n7]) {
                    f28 = fArray[n7];
                }
                ++n6;
                n7 += 3;
            }
            f25 = (f27 - f3) * f4;
            f26 = (f28 - f3) * f4;
            if (f4 > 0.0f) {
                if (f25 > f21) {
                    f21 = f25;
                }
                if (f26 < f22) {
                    f22 = f26;
                }
            } else {
                if (f26 > f21) {
                    f21 = f26;
                }
                if (f25 < f22) {
                    f22 = f25;
                }
            }
            if (f21 > f22) {
                n2 -= 64;
                continue;
            }
            float f29 = fArray[n2 + 2];
            float f30 = fArray[n2 + 2];
            int n8 = 1;
            int n9 = n2 + 5;
            while (n8 < 16) {
                if (f29 > fArray[n9]) {
                    f29 = fArray[n9];
                }
                if (f30 < fArray[n9]) {
                    f30 = fArray[n9];
                }
                ++n8;
                n9 += 3;
            }
            f25 = (f29 - f5) * f6;
            f26 = (f30 - f5) * f6;
            if (f6 > 0.0f) {
                if (f25 > f21) {
                    f21 = f25;
                }
                if (f26 < f22) {
                    f22 = f26;
                }
            } else {
                if (f26 > f21) {
                    f21 = f26;
                }
                if (f25 < f22) {
                    f22 = f25;
                }
            }
            if (f21 > f22) {
                n2 -= 64;
                continue;
            }
            float f31 = f24 - f23 + (f28 - f27) + (f30 - f29);
            if (Float.floatToRawIntBits(fArray[n2 + 48]) == Float.floatToRawIntBits(f31)) {
                ray.setMax(f21);
                intersectionState.setIntersection(n, fArray[n2 + 49], fArray[n2 + 50]);
                n2 -= 64;
                continue;
            }
            float f32 = 0.0f;
            float f33 = 0.0f;
            for (n3 = 0; n3 < 3; ++n3) {
                f32 += Math.abs(fArray[n2 + 9 + n3] - fArray[n2 + n3]);
                f33 += Math.abs(fArray[n2 + 36 + n3] - fArray[n2 + n3]);
            }
            if (f32 > f33) {
                for (n3 = 0; n3 < 4; ++n3) {
                    for (int i = 0; i < 3; ++i) {
                        f20 = fArray[n2 + (n3 * 4 + 0) * 3 + i];
                        f19 = fArray[n2 + (n3 * 4 + 1) * 3 + i];
                        f18 = fArray[n2 + (n3 * 4 + 2) * 3 + i];
                        f17 = fArray[n2 + (n3 * 4 + 3) * 3 + i];
                        f16 = f20;
                        f15 = (f20 + f19) * 0.5f;
                        f14 = f15 * 0.5f + (f19 + f18) * 0.25f;
                        f13 = f17;
                        f12 = (f18 + f17) * 0.5f;
                        f11 = f12 * 0.5f + (f19 + f18) * 0.25f;
                        f9 = f10 = (f14 + f11) * 0.5f;
                        fArray[n2 + (n3 * 4 + 0) * 3 + i] = f16;
                        fArray[n2 + (n3 * 4 + 1) * 3 + i] = f15;
                        fArray[n2 + (n3 * 4 + 2) * 3 + i] = f14;
                        fArray[n2 + (n3 * 4 + 3) * 3 + i] = f10;
                        fArray[n2 + 64 + (n3 * 4 + 0) * 3 + i] = f9;
                        fArray[n2 + 64 + (n3 * 4 + 1) * 3 + i] = f11;
                        fArray[n2 + 64 + (n3 * 4 + 2) * 3 + i] = f12;
                        fArray[n2 + 64 + (n3 * 4 + 3) * 3 + i] = f13;
                    }
                }
                float f34 = f31;
                fArray[n2 + 64 + 48] = f34;
                fArray[n2 + 48] = f34;
                f8 = fArray[n2 + 49];
                f7 = fArray[n2 + 51];
                fArray[n2 + 49] = f8;
                fArray[n2 + 64 + 50] = fArray[n2 + 50];
                float f35 = (f8 + f7) * 0.5f;
                fArray[n2 + 64 + 49] = f35;
                fArray[n2 + 51] = f35;
                fArray[n2 + 64 + 51] = f7;
                fArray[n2 + 64 + 52] = fArray[n2 + 52];
            } else {
                for (n3 = 0; n3 < 4; ++n3) {
                    for (int i = 0; i < 3; ++i) {
                        f20 = fArray[n2 + (0 + n3) * 3 + i];
                        f19 = fArray[n2 + (4 + n3) * 3 + i];
                        f18 = fArray[n2 + (8 + n3) * 3 + i];
                        f17 = fArray[n2 + (12 + n3) * 3 + i];
                        f16 = f20;
                        f15 = (f20 + f19) * 0.5f;
                        f14 = f15 * 0.5f + (f19 + f18) * 0.25f;
                        f13 = f17;
                        f12 = (f18 + f17) * 0.5f;
                        f11 = f12 * 0.5f + (f19 + f18) * 0.25f;
                        f9 = f10 = (f14 + f11) * 0.5f;
                        fArray[n2 + (0 + n3) * 3 + i] = f16;
                        fArray[n2 + (4 + n3) * 3 + i] = f15;
                        fArray[n2 + (8 + n3) * 3 + i] = f14;
                        fArray[n2 + (12 + n3) * 3 + i] = f10;
                        fArray[n2 + 64 + (0 + n3) * 3 + i] = f9;
                        fArray[n2 + 64 + (4 + n3) * 3 + i] = f11;
                        fArray[n2 + 64 + (8 + n3) * 3 + i] = f12;
                        fArray[n2 + 64 + (12 + n3) * 3 + i] = f13;
                    }
                }
                float f36 = f31;
                fArray[n2 + 64 + 48] = f36;
                fArray[n2 + 48] = f36;
                f8 = fArray[n2 + 50];
                f7 = fArray[n2 + 52];
                fArray[n2 + 64 + 49] = fArray[n2 + 49];
                fArray[n2 + 50] = f8;
                float f37 = (f8 + f7) * 0.5f;
                fArray[n2 + 64 + 50] = f37;
                fArray[n2 + 52] = f37;
                fArray[n2 + 64 + 51] = fArray[n2 + 51];
                fArray[n2 + 64 + 52] = f7;
            }
            n2 += 64;
        }
    }

    public void prepareShadingState(ShadingState shadingState) {
        shadingState.init();
        shadingState.getRay().getPoint(shadingState.getPoint());
        Instance instance = shadingState.getInstance();
        float f = shadingState.getU();
        float f2 = shadingState.getV();
        float[] fArray = this.bernstein(f);
        float[] fArray2 = this.bernsteinDeriv(f);
        float[] fArray3 = this.bernstein(f2);
        float[] fArray4 = this.bernsteinDeriv(f2);
        this.getPatchPoint(f, f2, this.patches[shadingState.getPrimitiveID()], fArray, fArray3, fArray2, fArray4, new Point3(), shadingState.getNormal());
        shadingState.getNormal().set(instance.transformNormalObjectToWorld(shadingState.getNormal()));
        shadingState.getNormal().normalize();
        shadingState.getGeoNormal().set(shadingState.getNormal());
        shadingState.getUV().set(f, f2);
        shadingState.setShader(instance.getShader(0));
        shadingState.setModifier(instance.getModifier(0));
        shadingState.setBasis(OrthoNormalBasis.makeFromW(shadingState.getNormal()));
    }

    public PrimitiveList getBakingPrimitives() {
        return null;
    }
}

