/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core.shader;

import org.sunflow.SunflowAPI;
import org.sunflow.core.ParameterList;
import org.sunflow.core.Shader;
import org.sunflow.core.ShadingState;
import org.sunflow.image.Color;
import org.sunflow.math.Matrix4;
import org.sunflow.math.Point3;

public class WireframeShader
implements Shader {
    private Color lineColor = Color.BLACK;
    private Color fillColor = Color.WHITE;
    private float width = 3.834952E-4f;
    private float cosWidth = (float)Math.cos(this.width);

    public boolean update(ParameterList parameterList, SunflowAPI sunflowAPI) {
        this.lineColor = parameterList.getColor("line", this.lineColor);
        this.fillColor = parameterList.getColor("fill", this.fillColor);
        this.width = parameterList.getFloat("width", this.width);
        this.cosWidth = (float)Math.cos(this.width);
        return true;
    }

    public Color getFillColor(ShadingState shadingState) {
        return this.fillColor;
    }

    public Color getLineColor(ShadingState shadingState) {
        return this.lineColor;
    }

    public Color getRadiance(ShadingState shadingState) {
        Point3[] point3Array = new Point3[3];
        if (!shadingState.getTrianglePoints(point3Array)) {
            return this.getFillColor(shadingState);
        }
        Point3 point3 = shadingState.getPoint();
        Matrix4 matrix4 = shadingState.getWorldToCamera();
        point3 = matrix4.transformP(point3);
        for (int i = 0; i < 3; ++i) {
            point3Array[i] = matrix4.transformP(shadingState.getInstance().transformObjectToWorld(point3Array[i]));
        }
        float f = 1.0f / (float)Math.sqrt(point3.x * point3.x + point3.y * point3.y + point3.z * point3.z);
        int n = 0;
        int n2 = 2;
        while (n < 3) {
            float f2;
            float f3;
            float f4;
            float f5;
            float f6;
            float f7 = (point3.x - point3Array[n].x) * (point3Array[n2].x - point3Array[n].x);
            f7 += (point3.y - point3Array[n].y) * (point3Array[n2].y - point3Array[n].y);
            f7 += (point3.z - point3Array[n].z) * (point3Array[n2].z - point3Array[n].z);
            if ((f6 = (f5 = (1.0f - (f7 /= point3Array[n].distanceToSquared(point3Array[n2]))) * point3Array[n].x + f7 * point3Array[n2].x) * point3.x + (f4 = (1.0f - f7) * point3Array[n].y + f7 * point3Array[n2].y) * point3.y + (f3 = (1.0f - f7) * point3Array[n].z + f7 * point3Array[n2].z) * point3.z) * (f2 = 1.0f / (float)Math.sqrt(f5 * f5 + f4 * f4 + f3 * f3)) * f >= this.cosWidth) {
                return this.getLineColor(shadingState);
            }
            n2 = n++;
        }
        return this.getFillColor(shadingState);
    }

    public void scatterPhoton(ShadingState shadingState, Color color) {
    }
}

