/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core.shader;

import org.sunflow.SunflowAPI;
import org.sunflow.core.ParameterList;
import org.sunflow.core.Ray;
import org.sunflow.core.Shader;
import org.sunflow.core.ShadingState;
import org.sunflow.core.Texture;
import org.sunflow.core.TextureCache;
import org.sunflow.image.Color;
import org.sunflow.math.MathUtils;
import org.sunflow.math.OrthoNormalBasis;
import org.sunflow.math.Vector3;

public class UberShader
implements Shader {
    private Color diff;
    private Color spec;
    private Texture diffmap;
    private Texture specmap;
    private float diffBlend;
    private float specBlend;
    private float glossyness;
    private int numSamples;

    public UberShader() {
        this.diff = this.spec = Color.GRAY;
        this.specmap = null;
        this.diffmap = null;
        this.specBlend = 1.0f;
        this.diffBlend = 1.0f;
        this.glossyness = 0.0f;
        this.numSamples = 4;
    }

    public boolean update(ParameterList parameterList, SunflowAPI sunflowAPI) {
        this.diff = parameterList.getColor("diffuse", this.diff);
        this.spec = parameterList.getColor("specular", this.spec);
        String string = parameterList.getString("diffuse.texture", null);
        if (string != null) {
            this.diffmap = TextureCache.getTexture(sunflowAPI.resolveTextureFilename(string), false);
        }
        if ((string = parameterList.getString("specular.texture", null)) != null) {
            this.specmap = TextureCache.getTexture(sunflowAPI.resolveTextureFilename(string), false);
        }
        this.diffBlend = MathUtils.clamp(parameterList.getFloat("diffuse.blend", this.diffBlend), 0.0f, 1.0f);
        this.specBlend = MathUtils.clamp(parameterList.getFloat("specular.blend", this.diffBlend), 0.0f, 1.0f);
        this.glossyness = MathUtils.clamp(parameterList.getFloat("glossyness", this.glossyness), 0.0f, 1.0f);
        this.numSamples = parameterList.getInt("samples", this.numSamples);
        return true;
    }

    public Color getDiffuse(ShadingState shadingState) {
        return this.diffmap == null ? this.diff : Color.blend(this.diff, this.diffmap.getPixel(shadingState.getUV().x, shadingState.getUV().y), this.diffBlend);
    }

    public Color getSpecular(ShadingState shadingState) {
        return this.specmap == null ? this.spec : Color.blend(this.spec, this.specmap.getPixel(shadingState.getUV().x, shadingState.getUV().y), this.specBlend);
    }

    public Color getRadiance(ShadingState shadingState) {
        shadingState.faceforward();
        shadingState.initLightSamples();
        shadingState.initCausticSamples();
        Color color = this.getDiffuse(shadingState);
        Color color2 = shadingState.diffuse(color);
        if (!shadingState.includeSpecular()) {
            return color2;
        }
        if (this.glossyness == 0.0f) {
            float f = shadingState.getCosND();
            float f2 = 2.0f * f;
            Vector3 vector3 = new Vector3();
            vector3.x = f2 * shadingState.getNormal().x + shadingState.getRay().getDirection().x;
            vector3.y = f2 * shadingState.getNormal().y + shadingState.getRay().getDirection().y;
            vector3.z = f2 * shadingState.getNormal().z + shadingState.getRay().getDirection().z;
            Ray ray = new Ray(shadingState.getPoint(), vector3);
            f = 1.0f - f;
            float f3 = f * f;
            float f4 = f3 * f3 * f;
            Color color3 = Color.white();
            color3.sub(this.spec);
            color3.mul(f4);
            color3.add(this.spec);
            return color2.add(color3.mul(shadingState.traceReflection(ray, 0)));
        }
        return color2.add(shadingState.specularPhong(this.getSpecular(shadingState), 2.0f / this.glossyness, this.numSamples));
    }

    public void scatterPhoton(ShadingState shadingState, Color color) {
        shadingState.faceforward();
        Color color2 = this.getDiffuse(shadingState);
        Color color3 = this.getSpecular(shadingState);
        shadingState.storePhoton(shadingState.getRay().getDirection(), color, color2);
        float f = color2.getAverage();
        float f2 = color3.getAverage();
        double d = shadingState.getRandom(0, 0, 1);
        if (d < (double)f) {
            color.mul(color2).mul(1.0f / f);
            OrthoNormalBasis orthoNormalBasis = shadingState.getBasis();
            double d2 = Math.PI * 2 * d / (double)f;
            double d3 = shadingState.getRandom(0, 1, 1);
            float f3 = (float)Math.sqrt(d3);
            float f4 = (float)Math.sqrt(1.0 - d3);
            Vector3 vector3 = new Vector3((float)Math.cos(d2) * f3, (float)Math.sin(d2) * f3, f4);
            vector3 = orthoNormalBasis.transform(vector3, new Vector3());
            shadingState.traceDiffusePhoton(new Ray(shadingState.getPoint(), vector3), color);
        } else if (d < (double)(f + f2)) {
            if (this.glossyness == 0.0f) {
                float f5 = -Vector3.dot(shadingState.getNormal(), shadingState.getRay().getDirection());
                color.mul(color2).mul(1.0f / f);
                float f6 = 2.0f * f5;
                Vector3 vector3 = new Vector3();
                vector3.x = f6 * shadingState.getNormal().x + shadingState.getRay().getDirection().x;
                vector3.y = f6 * shadingState.getNormal().y + shadingState.getRay().getDirection().y;
                vector3.z = f6 * shadingState.getNormal().z + shadingState.getRay().getDirection().z;
                shadingState.traceReflectionPhoton(new Ray(shadingState.getPoint(), vector3), color);
            } else {
                float f7 = 2.0f * shadingState.getCosND();
                Vector3 vector3 = new Vector3();
                vector3.x = f7 * shadingState.getNormal().x + shadingState.getRay().dx;
                vector3.y = f7 * shadingState.getNormal().y + shadingState.getRay().dy;
                vector3.z = f7 * shadingState.getNormal().z + shadingState.getRay().dz;
                color.mul(this.spec).mul(1.0f / f2);
                OrthoNormalBasis orthoNormalBasis = shadingState.getBasis();
                double d4 = Math.PI * 2 * (d - (double)f2) / (double)f2;
                double d5 = shadingState.getRandom(0, 1, 1);
                float f8 = (float)Math.pow(d5, 1.0f / (1.0f / this.glossyness + 1.0f));
                float f9 = (float)Math.sqrt(1.0f - f8 * f8);
                Vector3 vector32 = new Vector3((float)Math.cos(d4) * f9, (float)Math.sin(d4) * f9, f8);
                vector32 = orthoNormalBasis.transform(vector32, new Vector3());
                shadingState.traceReflectionPhoton(new Ray(shadingState.getPoint(), vector32), color);
            }
        }
    }
}

