/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core.shader;

import org.sunflow.SunflowAPI;
import org.sunflow.core.ParameterList;
import org.sunflow.core.Ray;
import org.sunflow.core.Shader;
import org.sunflow.core.ShadingState;
import org.sunflow.image.Color;
import org.sunflow.math.OrthoNormalBasis;
import org.sunflow.math.Vector3;

public class QuickGrayShader
implements Shader {
    public boolean update(ParameterList parameterList, SunflowAPI sunflowAPI) {
        return true;
    }

    public Color getRadiance(ShadingState shadingState) {
        if (shadingState.getNormal() == null) {
            return shadingState.getShader() != this ? shadingState.getShader().getRadiance(shadingState) : Color.BLACK;
        }
        shadingState.faceforward();
        shadingState.initLightSamples();
        shadingState.initCausticSamples();
        return shadingState.diffuse(Color.GRAY);
    }

    public void scatterPhoton(ShadingState shadingState, Color color) {
        if ((double)Vector3.dot(shadingState.getNormal(), shadingState.getRay().getDirection()) > 0.0) {
            shadingState.getNormal().negate();
            shadingState.getGeoNormal().negate();
        }
        Color color2 = Color.GRAY;
        shadingState.storePhoton(shadingState.getRay().getDirection(), color, color2);
        float f = color2.getAverage();
        double d = shadingState.getRandom(0, 0, 1);
        if (d < (double)f) {
            color.mul(color2).mul(1.0f / f);
            OrthoNormalBasis orthoNormalBasis = shadingState.getBasis();
            double d2 = Math.PI * 2 * d / (double)f;
            double d3 = shadingState.getRandom(0, 1, 1);
            float f2 = (float)Math.sqrt(d3);
            float f3 = (float)Math.sqrt(1.0 - d3);
            Vector3 vector3 = new Vector3((float)Math.cos(d2) * f2, (float)Math.sin(d2) * f2, f3);
            vector3 = orthoNormalBasis.transform(vector3, new Vector3());
            shadingState.traceDiffusePhoton(new Ray(shadingState.getPoint(), vector3), color);
        }
    }
}

