/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core.shader;

import org.sunflow.SunflowAPI;
import org.sunflow.core.ParameterList;
import org.sunflow.core.Ray;
import org.sunflow.core.Shader;
import org.sunflow.core.ShadingState;
import org.sunflow.image.Color;
import org.sunflow.math.Vector3;

public class MirrorShader
implements Shader {
    private Color color = Color.WHITE;

    public boolean update(ParameterList parameterList, SunflowAPI sunflowAPI) {
        this.color = parameterList.getColor("color", this.color);
        return true;
    }

    public Color getRadiance(ShadingState shadingState) {
        if (!shadingState.includeSpecular()) {
            return Color.BLACK;
        }
        shadingState.faceforward();
        float f = shadingState.getCosND();
        float f2 = 2.0f * f;
        Vector3 vector3 = new Vector3();
        vector3.x = f2 * shadingState.getNormal().x + shadingState.getRay().getDirection().x;
        vector3.y = f2 * shadingState.getNormal().y + shadingState.getRay().getDirection().y;
        vector3.z = f2 * shadingState.getNormal().z + shadingState.getRay().getDirection().z;
        Ray ray = new Ray(shadingState.getPoint(), vector3);
        f = 1.0f - f;
        float f3 = f * f;
        float f4 = f3 * f3 * f;
        Color color = Color.white();
        color.sub(this.color);
        color.mul(f4);
        color.add(this.color);
        return color.mul(shadingState.traceReflection(ray, 0));
    }

    public void scatterPhoton(ShadingState shadingState, Color color) {
        float f = this.color.getAverage();
        double d = shadingState.getRandom(0, 0, 1);
        if (d >= (double)f) {
            return;
        }
        shadingState.faceforward();
        float f2 = shadingState.getCosND();
        color.mul(this.color).mul(1.0f / f);
        float f3 = 2.0f * f2;
        Vector3 vector3 = new Vector3();
        vector3.x = f3 * shadingState.getNormal().x + shadingState.getRay().getDirection().x;
        vector3.y = f3 * shadingState.getNormal().y + shadingState.getRay().getDirection().y;
        vector3.z = f3 * shadingState.getNormal().z + shadingState.getRay().getDirection().z;
        shadingState.traceReflectionPhoton(new Ray(shadingState.getPoint(), vector3), color);
    }
}

