/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core.shader;

import org.sunflow.SunflowAPI;
import org.sunflow.core.ParameterList;
import org.sunflow.core.Ray;
import org.sunflow.core.Shader;
import org.sunflow.core.ShadingState;
import org.sunflow.image.Color;
import org.sunflow.math.Vector3;

public class GlassShader
implements Shader {
    private float eta = 1.3f;
    private float f0;
    private Color color = Color.WHITE;
    private float absorbtionDistance = 0.0f;
    private Color absorbtionColor = Color.GRAY;

    public boolean update(ParameterList parameterList, SunflowAPI sunflowAPI) {
        this.color = parameterList.getColor("color", this.color);
        this.eta = parameterList.getFloat("eta", this.eta);
        this.f0 = (1.0f - this.eta) / (1.0f + this.eta);
        this.f0 *= this.f0;
        this.absorbtionDistance = parameterList.getFloat("absorbtion.distance", this.absorbtionDistance);
        this.absorbtionColor = parameterList.getColor("absorbtion.color", this.absorbtionColor);
        return true;
    }

    public Color getRadiance(ShadingState shadingState) {
        float f;
        boolean bl;
        if (!shadingState.includeSpecular()) {
            return Color.BLACK;
        }
        Vector3 vector3 = new Vector3();
        Vector3 vector32 = new Vector3();
        shadingState.faceforward();
        float f2 = shadingState.getCosND();
        boolean bl2 = shadingState.isBehind();
        float f3 = bl2 ? this.eta : 1.0f / this.eta;
        float f4 = 2.0f * f2;
        vector3.x = f4 * shadingState.getNormal().x + shadingState.getRay().getDirection().x;
        vector3.y = f4 * shadingState.getNormal().y + shadingState.getRay().getDirection().y;
        vector3.z = f4 * shadingState.getNormal().z + shadingState.getRay().getDirection().z;
        float f5 = 1.0f - f3 * f3 * (1.0f - f2 * f2);
        boolean bl3 = bl = f5 < 0.0f;
        if (bl) {
            vector32.z = 0.0f;
            vector32.y = 0.0f;
            vector32.x = 0.0f;
        } else {
            f = f3 * f2 - (float)Math.sqrt(f5);
            vector32.x = f3 * shadingState.getRay().dx + f * shadingState.getNormal().x;
            vector32.y = f3 * shadingState.getRay().dy + f * shadingState.getNormal().y;
            vector32.z = f3 * shadingState.getRay().dz + f * shadingState.getNormal().z;
        }
        f = Vector3.dot(shadingState.getNormal(), vector3);
        float f6 = -Vector3.dot(shadingState.getNormal(), vector32);
        float f7 = (f - this.eta * f6) / (f + this.eta * f6);
        float f8 = (this.eta * f - f6) / (this.eta * f + f6);
        float f9 = 0.5f * (f7 * f7 + f8 * f8);
        float f10 = 1.0f - f9;
        Color color = null;
        if (bl2 && this.absorbtionDistance > 0.0f && (color = Color.mul(-shadingState.getRay().getMax() / this.absorbtionDistance, this.absorbtionColor.copy().opposite()).exp()).isBlack()) {
            return Color.BLACK;
        }
        Color color2 = Color.black();
        if (!bl) {
            color2.madd(f10, shadingState.traceRefraction(new Ray(shadingState.getPoint(), vector32), 0)).mul(this.color);
        }
        if (!bl2 || bl) {
            color2.add(Color.mul(f9, shadingState.traceReflection(new Ray(shadingState.getPoint(), vector3), 0)).mul(this.color));
        }
        return color != null ? color2.mul(color) : color2;
    }

    public void scatterPhoton(ShadingState shadingState, Color color) {
        Color color2 = Color.mul(1.0f - this.f0, this.color);
        Color color3 = Color.mul(this.f0, this.color);
        float f = color3.getAverage();
        float f2 = color2.getAverage();
        double d = shadingState.getRandom(0, 0, 1);
        if (d < (double)f) {
            shadingState.faceforward();
            if (shadingState.isBehind()) {
                return;
            }
            float f3 = shadingState.getCosND();
            color.mul(color3).mul(1.0f / f);
            float f4 = 2.0f * f3;
            Vector3 vector3 = new Vector3();
            vector3.x = f4 * shadingState.getNormal().x + shadingState.getRay().getDirection().x;
            vector3.y = f4 * shadingState.getNormal().y + shadingState.getRay().getDirection().y;
            vector3.z = f4 * shadingState.getNormal().z + shadingState.getRay().getDirection().z;
            shadingState.traceReflectionPhoton(new Ray(shadingState.getPoint(), vector3), color);
        } else if (d < (double)(f + f2)) {
            shadingState.faceforward();
            float f5 = shadingState.getCosND();
            float f6 = shadingState.isBehind() ? this.eta : 1.0f / this.eta;
            color.mul(color2).mul(1.0f / f2);
            float f7 = -f6;
            float f8 = 1.0f - f6 * f6 * (1.0f - f5 * f5);
            Vector3 vector3 = new Vector3();
            if (shadingState.isBehind() && this.absorbtionDistance > 0.0f) {
                color.mul(Color.mul(-shadingState.getRay().getMax() / this.absorbtionDistance, this.absorbtionColor.copy().opposite()).exp());
            }
            if (f8 < 0.0f) {
                float f9 = 2.0f * f5;
                vector3.x = f9 * shadingState.getNormal().x + shadingState.getRay().getDirection().x;
                vector3.y = f9 * shadingState.getNormal().y + shadingState.getRay().getDirection().y;
                vector3.z = f9 * shadingState.getNormal().z + shadingState.getRay().getDirection().z;
                shadingState.traceReflectionPhoton(new Ray(shadingState.getPoint(), vector3), color);
            } else {
                float f10 = f6 * f5 - (float)Math.sqrt(f8);
                vector3.x = -f7 * shadingState.getRay().dx + f10 * shadingState.getNormal().x;
                vector3.y = -f7 * shadingState.getRay().dy + f10 * shadingState.getNormal().y;
                vector3.z = -f7 * shadingState.getRay().dz + f10 * shadingState.getNormal().z;
                shadingState.traceRefractionPhoton(new Ray(shadingState.getPoint(), vector3), color);
            }
        }
    }
}

