/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core.renderer;

import java.util.concurrent.PriorityBlockingQueue;
import org.sunflow.core.Display;
import org.sunflow.core.ImageSampler;
import org.sunflow.core.IntersectionState;
import org.sunflow.core.Options;
import org.sunflow.core.Scene;
import org.sunflow.core.ShadingState;
import org.sunflow.image.Color;
import org.sunflow.math.QMC;
import org.sunflow.system.Timer;
import org.sunflow.system.UI;

public class ProgressiveRenderer
implements ImageSampler {
    private Scene scene;
    private int imageWidth = 640;
    private int imageHeight = 480;
    private int[] sigma = null;
    private PriorityBlockingQueue<SmallBucket> smallBucketQueue = null;
    private Display display;
    private int counter;
    private int counterMax;

    public boolean prepare(Options options, Scene scene, int n, int n2) {
        this.scene = scene;
        this.imageWidth = n;
        this.imageHeight = n2;
        this.sigma = QMC.generateSigmaTable(128);
        return true;
    }

    public void render(Display display) {
        int n;
        this.display = display;
        display.imageBegin(this.imageWidth, this.imageHeight, 0);
        SmallBucket smallBucket = new SmallBucket();
        smallBucket.y = 0;
        smallBucket.x = 0;
        int n2 = Math.max(this.imageWidth, this.imageHeight);
        smallBucket.size = 1;
        while (smallBucket.size < n2) {
            smallBucket.size <<= 1;
        }
        this.smallBucketQueue = new PriorityBlockingQueue();
        this.smallBucketQueue.add(smallBucket);
        UI.taskStart("Progressive Render", 0, this.imageWidth * this.imageHeight);
        Timer timer = new Timer();
        timer.start();
        this.counter = 0;
        this.counterMax = this.imageWidth * this.imageHeight;
        Thread[] threadArray = new Thread[this.scene.getThreads()];
        for (n = 0; n < threadArray.length; ++n) {
            threadArray[n] = new SmallBucketThread();
            threadArray[n].start();
        }
        for (n = 0; n < threadArray.length; ++n) {
            try {
                threadArray[n].join();
                continue;
            }
            catch (InterruptedException interruptedException) {
                UI.printError(UI.Module.IPR, "Thread %d of %d was interrupted", n + 1, threadArray.length);
            }
        }
        UI.taskStop();
        timer.end();
        UI.printInfo(UI.Module.IPR, "Rendering time: %s", timer.toString());
        display.imageEnd();
    }

    private int progressiveRenderNext(IntersectionState intersectionState) {
        int n;
        int n2;
        SmallBucket smallBucket = this.smallBucketQueue.poll();
        if (smallBucket == null) {
            return 0;
        }
        int n3 = smallBucket.size / 16;
        boolean bl = !this.smallBucketQueue.isEmpty();
        int n4 = 2 * smallBucket.size / 16 - 1;
        int n5 = 0;
        int n6 = 0;
        for (n2 = smallBucket.y; n6 < 16 && n2 < this.imageHeight; ++n6, n2 += n3) {
            n = 0;
            for (int i = smallBucket.x; n < 16 && i < this.imageWidth; ++n, i += n3) {
                double d;
                if (bl && (i & n4) == 0 && (n2 & n4) == 0) continue;
                int n7 = (i & this.sigma.length - 1) * this.sigma.length + this.sigma[n2 & this.sigma.length - 1];
                double d2 = QMC.halton(1, n7);
                double d3 = QMC.halton(2, n7);
                ShadingState shadingState = this.scene.getRadiance(intersectionState, i, this.imageHeight - 1 - n2, d3, d = QMC.halton(3, n7), d2, n7);
                Color color = shadingState != null ? shadingState.getResult() : Color.BLACK;
                ++n5;
                this.display.imageFill(i, n2, Math.min(n3, this.imageWidth - i), Math.min(n3, this.imageHeight - n2), color);
            }
        }
        if (smallBucket.size >= 32) {
            n6 = smallBucket.size >>> 1;
            for (n2 = 0; n2 < 2; ++n2) {
                if (smallBucket.y + n2 * n6 >= this.imageHeight) continue;
                for (n = 0; n < 2; ++n) {
                    if (smallBucket.x + n * n6 >= this.imageWidth) continue;
                    SmallBucket smallBucket2 = new SmallBucket();
                    smallBucket2.x = smallBucket.x + n * n6;
                    smallBucket2.y = smallBucket.y + n2 * n6;
                    smallBucket2.size = n6;
                    smallBucket2.constrast = 1.0f / (float)n6;
                    this.smallBucketQueue.put(smallBucket2);
                }
            }
        }
        return n5;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SmallBucket
    implements Comparable<SmallBucket> {
        int x;
        int y;
        int size;
        float constrast;

        private SmallBucket() {
        }

        @Override
        public int compareTo(SmallBucket smallBucket) {
            if (this.constrast < smallBucket.constrast) {
                return -1;
            }
            if (this.constrast == smallBucket.constrast) {
                return 0;
            }
            return 1;
        }
    }

    private class SmallBucketThread
    extends Thread {
        private SmallBucketThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            IntersectionState intersectionState = new IntersectionState();
            do {
                int n = ProgressiveRenderer.this.progressiveRenderNext(intersectionState);
                ProgressiveRenderer progressiveRenderer = ProgressiveRenderer.this;
                synchronized (progressiveRenderer) {
                    if (ProgressiveRenderer.this.counter >= ProgressiveRenderer.this.counterMax) {
                        return;
                    }
                    ProgressiveRenderer.this.counter += n;
                    UI.taskUpdate(ProgressiveRenderer.this.counter);
                }
            } while (!UI.taskCanceled());
        }
    }
}

