/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core.renderer;

import org.sunflow.core.BucketOrder;
import org.sunflow.core.Display;
import org.sunflow.core.Filter;
import org.sunflow.core.ImageSampler;
import org.sunflow.core.Instance;
import org.sunflow.core.IntersectionState;
import org.sunflow.core.Options;
import org.sunflow.core.Scene;
import org.sunflow.core.Shader;
import org.sunflow.core.ShadingState;
import org.sunflow.core.bucket.BucketOrderFactory;
import org.sunflow.core.filter.BoxFilter;
import org.sunflow.core.filter.FilterFactory;
import org.sunflow.image.Bitmap;
import org.sunflow.image.Color;
import org.sunflow.math.MathUtils;
import org.sunflow.math.QMC;
import org.sunflow.system.Timer;
import org.sunflow.system.UI;

public class BucketRenderer
implements ImageSampler {
    private Scene scene;
    private Display display;
    private int imageWidth;
    private int imageHeight;
    private String bucketOrderName = "hilbert";
    private BucketOrder bucketOrder;
    private int bucketSize = 32;
    private int bucketCounter;
    private int[] bucketCoords;
    private boolean dumpBuckets = false;
    private int minAADepth;
    private int maxAADepth;
    private int superSampling;
    private float contrastThreshold = 0.1f;
    private boolean jitter = false;
    private boolean displayAA = false;
    private double invSuperSampling;
    private int subPixelSize;
    private int minStepSize;
    private int maxStepSize;
    private int[] sigma;
    private float thresh;
    private boolean useJitter;
    private String filterName = "box";
    private Filter filter;
    private int fs;
    private float fhs;

    public boolean prepare(Options options, Scene scene, int n, int n2) {
        this.scene = scene;
        this.imageWidth = n;
        this.imageHeight = n2;
        this.bucketSize = options.getInt("bucket.size", this.bucketSize);
        this.bucketOrderName = options.getString("bucket.order", this.bucketOrderName);
        this.minAADepth = options.getInt("aa.min", this.minAADepth);
        this.maxAADepth = options.getInt("aa.max", this.maxAADepth);
        this.superSampling = options.getInt("aa.samples", this.superSampling);
        this.displayAA = options.getBoolean("aa.display", this.displayAA);
        this.jitter = options.getBoolean("aa.jitter", this.jitter);
        this.contrastThreshold = options.getFloat("aa.contrast", this.contrastThreshold);
        this.bucketSize = MathUtils.clamp(this.bucketSize, 16, 512);
        int n3 = (this.imageWidth + this.bucketSize - 1) / this.bucketSize;
        int n4 = (this.imageHeight + this.bucketSize - 1) / this.bucketSize;
        this.bucketOrder = BucketOrderFactory.create(this.bucketOrderName);
        this.bucketCoords = this.bucketOrder.getBucketSequence(n3, n4);
        this.minAADepth = MathUtils.clamp(this.minAADepth, -4, 5);
        this.maxAADepth = MathUtils.clamp(this.maxAADepth, this.minAADepth, 5);
        this.superSampling = MathUtils.clamp(this.superSampling, 1, 256);
        this.invSuperSampling = 1.0 / (double)this.superSampling;
        this.subPixelSize = this.maxAADepth > 0 ? 1 << this.maxAADepth : 1;
        int n5 = this.minStepSize = this.maxAADepth >= 0 ? 1 : 1 << -this.maxAADepth;
        this.maxStepSize = this.minAADepth == this.maxAADepth ? this.minStepSize : (this.minAADepth > 0 ? 1 << this.minAADepth : this.subPixelSize << -this.minAADepth);
        this.useJitter = this.jitter && this.maxAADepth > 0;
        this.contrastThreshold = MathUtils.clamp(this.contrastThreshold, 0.0f, 1.0f);
        this.thresh = this.contrastThreshold * (float)Math.pow(2.0, this.minAADepth);
        this.filterName = options.getString("filter", this.filterName);
        this.filter = FilterFactory.get(this.filterName);
        if (this.filter == null) {
            UI.printWarning(UI.Module.BCKT, "Unrecognized filter type: \"%s\" - defaulting to box", this.filterName);
            this.filter = new BoxFilter(1.0f);
            this.filterName = "box";
        }
        this.fhs = this.filter.getSize() * 0.5f;
        this.fs = (int)Math.ceil((float)this.subPixelSize * (this.fhs - 0.5f));
        this.sigma = QMC.generateSigmaTable(this.subPixelSize << 7);
        UI.printInfo(UI.Module.BCKT, "Bucket renderer settings:", new Object[0]);
        UI.printInfo(UI.Module.BCKT, "  * Resolution:         %dx%d", this.imageWidth, this.imageHeight);
        UI.printInfo(UI.Module.BCKT, "  * Bucket size:        %d", this.bucketSize);
        UI.printInfo(UI.Module.BCKT, "  * Number of buckets:  %dx%d", n3, n4);
        if (this.minAADepth != this.maxAADepth) {
            UI.printInfo(UI.Module.BCKT, "  * Anti-aliasing:      %s -> %s (adaptive)", this.aaDepthToString(this.minAADepth), this.aaDepthToString(this.maxAADepth));
        } else {
            UI.printInfo(UI.Module.BCKT, "  * Anti-aliasing:      %s (fixed)", this.aaDepthToString(this.minAADepth));
        }
        UI.printInfo(UI.Module.BCKT, "  * Rays per sample:    %d", this.superSampling);
        UI.printInfo(UI.Module.BCKT, "  * Subpixel jitter:    %s", this.useJitter ? "on" : (this.jitter ? "auto-off" : "off"));
        UI.printInfo(UI.Module.BCKT, "  * Contrast threshold: %.2f", Float.valueOf(this.contrastThreshold));
        UI.printInfo(UI.Module.BCKT, "  * Filter type:        %s", this.filterName);
        UI.printInfo(UI.Module.BCKT, "  * Filter size:        %.2f pixels", Float.valueOf(this.filter.getSize()));
        return true;
    }

    private String aaDepthToString(int n) {
        int n2 = n < 0 ? -(1 << -n) : 1 << n;
        return String.format("%s%d sample%s", n < 0 ? "1/" : "", n2 * n2, n == 0 ? "" : "s");
    }

    public void render(Display display) {
        int n;
        this.display = display;
        display.imageBegin(this.imageWidth, this.imageHeight, this.bucketSize);
        this.bucketCounter = 0;
        UI.taskStart("Rendering", 0, this.bucketCoords.length);
        Timer timer = new Timer();
        timer.start();
        Thread[] threadArray = new Thread[this.scene.getThreads()];
        for (n = 0; n < threadArray.length; ++n) {
            threadArray[n] = new BucketThread(n);
            threadArray[n].setPriority(this.scene.getThreadPriority());
            threadArray[n].start();
        }
        for (n = 0; n < threadArray.length; ++n) {
            try {
                threadArray[n].join();
                continue;
            }
            catch (InterruptedException interruptedException) {
                UI.printError(UI.Module.BCKT, "Bucket processing thread %d of %d was interrupted", n + 1, threadArray.length);
            }
        }
        UI.taskStop();
        timer.end();
        UI.printInfo(UI.Module.BCKT, "Render time: %s", timer.toString());
        display.imageEnd();
    }

    private void renderBucket(Display display, int n, int n2, int n3, IntersectionState intersectionState) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11 = n * this.bucketSize;
        int n12 = n2 * this.bucketSize;
        int n13 = Math.min(this.bucketSize, this.imageWidth - n11);
        int n14 = Math.min(this.bucketSize, this.imageHeight - n12);
        display.imagePrepare(n11, n12, n13, n14, n3);
        Color[] colorArray = new Color[n13 * n14];
        int n15 = n11 * this.subPixelSize - this.fs;
        int n16 = n12 * this.subPixelSize - this.fs;
        int n17 = n13 * this.subPixelSize + this.fs * 2;
        int n18 = n14 * this.subPixelSize + this.fs * 2;
        n17 = n17 + (this.maxStepSize - 1) & ~(this.maxStepSize - 1);
        n18 = n18 + (this.maxStepSize - 1) & ~(this.maxStepSize - 1);
        if (this.maxStepSize > 1) {
            ++n17;
            ++n18;
        }
        ImageSample[] imageSampleArray = new ImageSample[n17 * n18];
        float f = 1.0f / (float)this.subPixelSize;
        int n19 = 0;
        for (n10 = 0; n10 < n18; ++n10) {
            n9 = 0;
            while (n9 < n17) {
                n8 = n15 + n9;
                n7 = n16 + n10;
                n6 = n8 & this.sigma.length - 1;
                n5 = n7 & this.sigma.length - 1;
                n4 = n6 * this.sigma.length + this.sigma[n5];
                float f2 = this.useJitter ? (float)this.sigma[n5] / (float)this.sigma.length : 0.5f;
                float f3 = this.useJitter ? (float)this.sigma[n6] / (float)this.sigma.length : 0.5f;
                float f4 = ((float)n8 + f2) * f;
                float f5 = ((float)n7 + f3) * f;
                f5 = (float)this.imageHeight - f5 - 1.0f;
                imageSampleArray[n19] = new ImageSample(f4, f5, n4);
                ++n9;
                ++n19;
            }
        }
        for (n10 = 0; n10 < n17 - 1; n10 += this.maxStepSize) {
            for (n19 = 0; n19 < n18 - 1; n19 += this.maxStepSize) {
                this.refineSamples(imageSampleArray, n17, n10, n19, this.maxStepSize, this.thresh, intersectionState);
            }
        }
        if (this.dumpBuckets) {
            UI.printInfo(UI.Module.BCKT, "Dumping bucket [%d, %d] to file ...", n, n2);
            Bitmap bitmap = new Bitmap(n17, n18, true);
            n9 = 0;
            for (n19 = n18 - 1; n19 >= 0; --n19) {
                n8 = 0;
                while (n8 < n17) {
                    bitmap.setPixel(n8, n19, imageSampleArray[n9].c.copy().toNonLinear());
                    ++n8;
                    ++n9;
                }
            }
            bitmap.save(String.format("bucket_%04d_%04d.png", n, n2));
        }
        if (this.displayAA) {
            float f6 = f * f;
            n9 = 0;
            for (n19 = 0; n19 < n14; ++n19) {
                n8 = 0;
                while (n8 < n13) {
                    n7 = 0;
                    for (n6 = 0; n6 < this.subPixelSize; ++n6) {
                        for (n5 = 0; n5 < this.subPixelSize; ++n5) {
                            n4 = n8 * this.subPixelSize + this.fs + n6;
                            int n20 = n19 * this.subPixelSize + this.fs + n5;
                            int n21 = n4 + n20 * n17;
                            n7 += imageSampleArray[n21].sampled() ? 1 : 0;
                        }
                    }
                    colorArray[n9] = new Color((float)n7 * f6);
                    ++n8;
                    ++n9;
                }
            }
        } else {
            float f7 = (float)(this.imageHeight - 1) - ((float)n12 + 0.5f);
            n19 = 0;
            n9 = 0;
            while (n19 < n14) {
                float f8 = (float)n11 + 0.5f;
                n7 = 0;
                while (n7 < n13) {
                    Color color = Color.black();
                    float f9 = 0.0f;
                    n4 = -this.fs;
                    int n22 = n19 * this.subPixelSize;
                    while (n4 <= this.fs) {
                        int n23 = -this.fs;
                        int n24 = n7 * this.subPixelSize;
                        int n25 = n24 + n22 * n17;
                        while (n23 <= this.fs) {
                            float f10;
                            float f11 = imageSampleArray[n25].rx - f8;
                            if (!(Math.abs(f11) > this.fhs) && !(Math.abs(f10 = imageSampleArray[n25].ry - f7) > this.fhs)) {
                                float f12 = this.filter.get(f11, f10);
                                color.madd(f12, imageSampleArray[n25].c);
                                f9 += f12;
                            }
                            ++n23;
                            ++n24;
                            ++n25;
                        }
                        ++n4;
                        ++n22;
                    }
                    color.mul(1.0f / f9);
                    colorArray[n9] = color;
                    ++n7;
                    ++n9;
                    f8 += 1.0f;
                }
                ++n19;
                f7 -= 1.0f;
            }
        }
        display.imageUpdate(n11, n12, n13, n14, colorArray);
    }

    private void computeSubPixel(ImageSample imageSample, IntersectionState intersectionState) {
        float f = imageSample.rx;
        float f2 = imageSample.ry;
        double d = QMC.halton(1, imageSample.i);
        double d2 = QMC.halton(2, imageSample.i);
        double d3 = QMC.halton(3, imageSample.i);
        if (this.superSampling > 1) {
            imageSample.add(this.scene.getRadiance(intersectionState, f, f2, d2, d3, d, imageSample.i));
            for (int i = 1; i < this.superSampling; ++i) {
                double d4 = QMC.mod1(d + (double)i * this.invSuperSampling);
                double d5 = QMC.mod1(d2 + QMC.halton(0, i));
                double d6 = QMC.mod1(d3 + QMC.halton(1, i));
                imageSample.add(this.scene.getRadiance(intersectionState, f, f2, d5, d6, d4, imageSample.i + i));
            }
            imageSample.scale((float)this.invSuperSampling);
        } else {
            imageSample.set(this.scene.getRadiance(intersectionState, f, f2, d2, d3, d, imageSample.i));
        }
    }

    private void refineSamples(ImageSample[] imageSampleArray, int n, int n2, int n3, int n4, float f, IntersectionState intersectionState) {
        int n5 = n4;
        int n6 = n4 * n;
        int n7 = n2 + n3 * n;
        ImageSample imageSample = imageSampleArray[n7];
        ImageSample imageSample2 = imageSampleArray[n7 + n6];
        ImageSample imageSample3 = imageSampleArray[n7 + n5];
        ImageSample imageSample4 = imageSampleArray[n7 + n5 + n6];
        if (!imageSample.sampled()) {
            this.computeSubPixel(imageSample, intersectionState);
        }
        if (!imageSample2.sampled()) {
            this.computeSubPixel(imageSample2, intersectionState);
        }
        if (!imageSample3.sampled()) {
            this.computeSubPixel(imageSample3, intersectionState);
        }
        if (!imageSample4.sampled()) {
            this.computeSubPixel(imageSample4, intersectionState);
        }
        if (n4 > this.minStepSize && (imageSample.isDifferent(imageSample2, f) || imageSample.isDifferent(imageSample3, f) || imageSample.isDifferent(imageSample4, f) || imageSample2.isDifferent(imageSample4, f) || imageSample3.isDifferent(imageSample4, f) || imageSample2.isDifferent(imageSample3, f))) {
            this.refineSamples(imageSampleArray, n, n2, n3, n4 >>= 1, f *= 2.0f, intersectionState);
            this.refineSamples(imageSampleArray, n, n2 + n4, n3, n4, f, intersectionState);
            this.refineSamples(imageSampleArray, n, n2, n3 + n4, n4, f, intersectionState);
            this.refineSamples(imageSampleArray, n, n2 + n4, n3 + n4, n4, f, intersectionState);
            return;
        }
        float f2 = 1.0f / (float)n4;
        for (int i = 0; i <= n4; ++i) {
            for (int j = 0; j <= n4; ++j) {
                if (imageSampleArray[n2 + i + (n3 + j) * n].processed()) continue;
                ImageSample.bilerp(imageSampleArray[n2 + i + (n3 + j) * n], imageSample, imageSample2, imageSample3, imageSample4, (float)i * f2, (float)j * f2);
            }
        }
    }

    private static final class ImageSample {
        float rx;
        float ry;
        int i;
        int n;
        Color c;
        Instance instance;
        Shader shader;
        float nx;
        float ny;
        float nz;

        ImageSample(float f, float f2, int n) {
            this.rx = f;
            this.ry = f2;
            this.i = n;
            this.n = 0;
            this.c = null;
            this.instance = null;
            this.shader = null;
            this.nz = 1.0f;
            this.ny = 1.0f;
            this.nx = 1.0f;
        }

        final void set(ShadingState shadingState) {
            if (shadingState == null) {
                this.c = Color.BLACK;
            } else {
                this.c = shadingState.getResult();
                this.checkNanInf();
                this.shader = shadingState.getShader();
                this.instance = shadingState.getInstance();
                if (shadingState.getNormal() != null) {
                    this.nx = shadingState.getNormal().x;
                    this.ny = shadingState.getNormal().y;
                    this.nz = shadingState.getNormal().z;
                }
            }
            this.n = 1;
        }

        final void add(ShadingState shadingState) {
            if (this.n == 0) {
                this.c = Color.black();
            }
            if (shadingState != null) {
                this.c.add(shadingState.getResult());
                this.checkNanInf();
            }
            ++this.n;
        }

        final void checkNanInf() {
            if (this.c.isNan()) {
                UI.printError(UI.Module.BCKT, "NaN shading sample!", new Object[0]);
            } else if (this.c.isInf()) {
                UI.printError(UI.Module.BCKT, "Inf shading sample!", new Object[0]);
            }
        }

        final void scale(float f) {
            this.c.mul(f);
        }

        final boolean processed() {
            return this.c != null;
        }

        final boolean sampled() {
            return this.n > 0;
        }

        final boolean isDifferent(ImageSample imageSample, float f) {
            if (this.instance != imageSample.instance) {
                return true;
            }
            if (this.shader != imageSample.shader) {
                return true;
            }
            if (Color.hasContrast(this.c, imageSample.c, f)) {
                return true;
            }
            float f2 = this.nx * imageSample.nx + this.ny * imageSample.ny + this.nz * imageSample.nz;
            return f2 < 0.9f;
        }

        static final ImageSample bilerp(ImageSample imageSample, ImageSample imageSample2, ImageSample imageSample3, ImageSample imageSample4, ImageSample imageSample5, float f, float f2) {
            float f3 = (1.0f - f) * (1.0f - f2);
            float f4 = (1.0f - f) * f2;
            float f5 = f * (1.0f - f2);
            float f6 = f * f2;
            Color color = imageSample2.c;
            Color color2 = imageSample3.c;
            Color color3 = imageSample4.c;
            Color color4 = imageSample5.c;
            Color color5 = Color.mul(f3, color);
            color5.madd(f4, color2);
            color5.madd(f5, color3);
            color5.madd(f6, color4);
            imageSample.c = color5;
            return imageSample;
        }
    }

    private class BucketThread
    extends Thread {
        private int threadID;

        BucketThread(int n) {
            this.threadID = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            IntersectionState intersectionState = new IntersectionState();
            do {
                int n;
                int n2;
                BucketRenderer bucketRenderer = BucketRenderer.this;
                synchronized (bucketRenderer) {
                    if (BucketRenderer.this.bucketCounter >= BucketRenderer.this.bucketCoords.length) {
                        return;
                    }
                    UI.taskUpdate(BucketRenderer.this.bucketCounter);
                    n2 = BucketRenderer.this.bucketCoords[BucketRenderer.this.bucketCounter + 0];
                    n = BucketRenderer.this.bucketCoords[BucketRenderer.this.bucketCounter + 1];
                    BucketRenderer.this.bucketCounter += 2;
                }
                BucketRenderer.this.renderBucket(BucketRenderer.this.display, n2, n, this.threadID, intersectionState);
            } while (!UI.taskCanceled());
        }
    }
}

