/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core.primitive;

import java.io.FileWriter;
import java.io.IOException;
import org.sunflow.SunflowAPI;
import org.sunflow.core.Instance;
import org.sunflow.core.IntersectionState;
import org.sunflow.core.ParameterList;
import org.sunflow.core.PrimitiveList;
import org.sunflow.core.Ray;
import org.sunflow.core.ShadingState;
import org.sunflow.math.BoundingBox;
import org.sunflow.math.MathUtils;
import org.sunflow.math.Matrix4;
import org.sunflow.math.OrthoNormalBasis;
import org.sunflow.math.Point3;
import org.sunflow.math.Vector3;
import org.sunflow.system.UI;

public class TriangleMesh
implements PrimitiveList {
    private static boolean smallTriangles = false;
    protected float[] points = null;
    protected int[] triangles = null;
    private WaldTriangle[] triaccel;
    private ParameterList.FloatParameter normals = this.uvs = new ParameterList.FloatParameter();
    private ParameterList.FloatParameter uvs;
    private byte[] faceShaders = null;

    public static void setSmallTriangles(boolean bl) {
        if (bl) {
            UI.printInfo(UI.Module.GEOM, "Small trimesh mode: enabled", new Object[0]);
        } else {
            UI.printInfo(UI.Module.GEOM, "Small trimesh mode: disabled", new Object[0]);
        }
        smallTriangles = bl;
    }

    public void writeObj(String string) {
        try {
            int n;
            FileWriter fileWriter = new FileWriter(string);
            fileWriter.write(String.format("o object\n", new Object[0]));
            for (n = 0; n < this.points.length; n += 3) {
                fileWriter.write(String.format("v %g %g %g\n", Float.valueOf(this.points[n]), Float.valueOf(this.points[n + 1]), Float.valueOf(this.points[n + 2])));
            }
            fileWriter.write("s off\n");
            for (n = 0; n < this.triangles.length; n += 3) {
                fileWriter.write(String.format("f %d %d %d\n", this.triangles[n] + 1, this.triangles[n + 1] + 1, this.triangles[n + 2] + 1));
            }
            fileWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public boolean update(ParameterList parameterList, SunflowAPI sunflowAPI) {
        int[] nArray;
        ParameterList.FloatParameter floatParameter;
        boolean bl = false;
        Object object = parameterList.getIntArray("triangles");
        if (object != null) {
            this.triangles = object;
            bl = true;
        }
        if (this.triangles == null) {
            UI.printError(UI.Module.GEOM, "Unable to update mesh - triangle indices are missing", new Object[0]);
            return false;
        }
        if (this.triangles.length % 3 != 0) {
            UI.printWarning(UI.Module.GEOM, "Triangle index data is not a multiple of 3 - triangles may be missing", new Object[0]);
        }
        parameterList.setFaceCount(this.triangles.length / 3);
        object = parameterList.getPointArray("points");
        if (object != null) {
            if (object.interp != ParameterList.InterpolationType.VERTEX) {
                UI.printError(UI.Module.GEOM, "Point interpolation type must be set to \"vertex\" - was \"%s\"", object.interp.name().toLowerCase());
            } else {
                this.points = object.data;
                bl = true;
            }
        }
        if (this.points == null) {
            UI.printError(UI.Module.GEOM, "Unable to update mesh - vertices are missing", new Object[0]);
            return false;
        }
        parameterList.setVertexCount(this.points.length / 3);
        parameterList.setFaceVertexCount(3 * (this.triangles.length / 3));
        object = parameterList.getVectorArray("normals");
        if (object != null) {
            this.normals = object;
        }
        if ((floatParameter = parameterList.getTexCoordArray("uvs")) != null) {
            this.uvs = floatParameter;
        }
        if ((nArray = parameterList.getIntArray("faceshaders")) != null && nArray.length == this.triangles.length / 3) {
            this.faceShaders = new byte[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                if (n > 255) {
                    UI.printWarning(UI.Module.GEOM, "Shader index too large on triangle %d", i);
                }
                this.faceShaders[i] = (byte)(n & 0xFF);
            }
        }
        if (bl) {
            this.init();
        }
        return true;
    }

    public float getPrimitiveBound(int n, int n2) {
        int n3 = 3 * n;
        int n4 = 3 * this.triangles[n3 + 0];
        int n5 = 3 * this.triangles[n3 + 1];
        int n6 = 3 * this.triangles[n3 + 2];
        int n7 = n2 >>> 1;
        if ((n2 & 1) == 0) {
            return MathUtils.min(this.points[n4 + n7], this.points[n5 + n7], this.points[n6 + n7]);
        }
        return MathUtils.max(this.points[n4 + n7], this.points[n5 + n7], this.points[n6 + n7]);
    }

    public BoundingBox getWorldBounds(Matrix4 matrix4) {
        BoundingBox boundingBox = new BoundingBox();
        if (matrix4 == null) {
            for (int i = 0; i < this.points.length; i += 3) {
                boundingBox.include(this.points[i], this.points[i + 1], this.points[i + 2]);
            }
        } else {
            for (int i = 0; i < this.points.length; i += 3) {
                float f = this.points[i];
                float f2 = this.points[i + 1];
                float f3 = this.points[i + 2];
                float f4 = matrix4.transformPX(f, f2, f3);
                float f5 = matrix4.transformPY(f, f2, f3);
                float f6 = matrix4.transformPZ(f, f2, f3);
                boundingBox.include(f4, f5, f6);
            }
        }
        return boundingBox;
    }

    public void intersectPrimitiveRobust(Ray ray, int n, IntersectionState intersectionState) {
        int n2 = 3 * n;
        int n3 = 3 * this.triangles[n2 + 0];
        int n4 = 3 * this.triangles[n2 + 1];
        int n5 = 3 * this.triangles[n2 + 2];
        float[] fArray = intersectionState.getRobustStack();
        int n6 = 0;
        int n7 = 0;
        while (n6 < 3) {
            fArray[n7 + 0] = this.points[n3 + n6];
            fArray[n7 + 1] = this.points[n4 + n6];
            fArray[n7 + 2] = this.points[n5 + n6];
            ++n6;
            n7 += 3;
        }
        fArray[9] = Float.POSITIVE_INFINITY;
        n6 = 0;
        float f = ray.ox;
        float f2 = ray.dx;
        float f3 = 1.0f / f2;
        float f4 = ray.oy;
        float f5 = ray.dy;
        float f6 = 1.0f / f5;
        float f7 = ray.oz;
        float f8 = ray.dz;
        float f9 = 1.0f / f8;
        float f10 = ray.getMin();
        float f11 = ray.getMax();
        while (n6 >= 0) {
            float f12 = f10;
            float f13 = f11;
            float f14 = fArray[n6 + 0];
            float f15 = fArray[n6 + 1];
            float f16 = fArray[n6 + 2];
            float f17 = MathUtils.min(f14, f15, f16);
            float f18 = (f17 - f) * f3;
            float f19 = MathUtils.max(f14, f15, f16);
            float f20 = (f19 - f) * f3;
            if (f3 > 0.0f) {
                if (f18 > f12) {
                    f12 = f18;
                }
                if (f20 < f13) {
                    f13 = f20;
                }
            } else {
                if (f20 > f12) {
                    f12 = f20;
                }
                if (f18 < f13) {
                    f13 = f18;
                }
            }
            if (f12 > f13) {
                n6 -= 10;
                continue;
            }
            float f21 = fArray[n6 + 3];
            float f22 = fArray[n6 + 4];
            float f23 = fArray[n6 + 5];
            float f24 = MathUtils.min(f21, f22, f23);
            f18 = (f24 - f4) * f6;
            float f25 = MathUtils.max(f21, f22, f23);
            f20 = (f25 - f4) * f6;
            if (f6 > 0.0f) {
                if (f18 > f12) {
                    f12 = f18;
                }
                if (f20 < f13) {
                    f13 = f20;
                }
            } else {
                if (f20 > f12) {
                    f12 = f20;
                }
                if (f18 < f13) {
                    f13 = f18;
                }
            }
            if (f12 > f13) {
                n6 -= 10;
                continue;
            }
            float f26 = fArray[n6 + 6];
            float f27 = fArray[n6 + 7];
            float f28 = fArray[n6 + 8];
            float f29 = MathUtils.min(f26, f27, f28);
            f18 = (f29 - f7) * f9;
            float f30 = MathUtils.max(f26, f27, f28);
            f20 = (f30 - f7) * f9;
            if (f9 > 0.0f) {
                if (f18 > f12) {
                    f12 = f18;
                }
                if (f20 < f13) {
                    f13 = f20;
                }
            } else {
                if (f20 > f12) {
                    f12 = f20;
                }
                if (f18 < f13) {
                    f13 = f18;
                }
            }
            if (f12 > f13) {
                n6 -= 10;
                continue;
            }
            float f31 = f19 - f17 + (f25 - f24) + (f30 - f29);
            if (Float.floatToRawIntBits(fArray[n6 + 9]) == Float.floatToRawIntBits(f31)) {
                ray.setMax(f12);
                this.triaccel[n].intersectBox(ray, f14, f21, f26, n, intersectionState);
                return;
            }
            float f32 = (f14 + f15) * 0.5f;
            float f33 = (f21 + f22) * 0.5f;
            float f34 = (f26 + f27) * 0.5f;
            float f35 = (f15 + f16) * 0.5f;
            float f36 = (f22 + f23) * 0.5f;
            float f37 = (f27 + f28) * 0.5f;
            float f38 = (f16 + f14) * 0.5f;
            float f39 = (f23 + f21) * 0.5f;
            float f40 = (f28 + f26) * 0.5f;
            fArray[n6 + 0] = f14;
            fArray[n6 + 1] = f32;
            fArray[n6 + 2] = f38;
            fArray[n6 + 3] = f21;
            fArray[n6 + 4] = f33;
            fArray[n6 + 5] = f39;
            fArray[n6 + 6] = f26;
            fArray[n6 + 7] = f34;
            fArray[n6 + 8] = f40;
            fArray[n6 + 9] = f31;
            fArray[(n6 += 10) + 0] = f15;
            fArray[n6 + 1] = f35;
            fArray[n6 + 2] = f32;
            fArray[n6 + 3] = f22;
            fArray[n6 + 4] = f36;
            fArray[n6 + 5] = f33;
            fArray[n6 + 6] = f27;
            fArray[n6 + 7] = f37;
            fArray[n6 + 8] = f34;
            fArray[n6 + 9] = f31;
            fArray[(n6 += 10) + 0] = f16;
            fArray[n6 + 1] = f38;
            fArray[n6 + 2] = f35;
            fArray[n6 + 3] = f23;
            fArray[n6 + 4] = f39;
            fArray[n6 + 5] = f36;
            fArray[n6 + 6] = f28;
            fArray[n6 + 7] = f40;
            fArray[n6 + 8] = f37;
            fArray[n6 + 9] = f31;
            fArray[(n6 += 10) + 0] = f38;
            fArray[n6 + 1] = f35;
            fArray[n6 + 2] = f32;
            fArray[n6 + 3] = f39;
            fArray[n6 + 4] = f36;
            fArray[n6 + 5] = f33;
            fArray[n6 + 6] = f40;
            fArray[n6 + 7] = f37;
            fArray[n6 + 8] = f34;
            fArray[n6 + 9] = f31;
        }
    }

    private final void intersectTriangleKensler(Ray ray, int n, IntersectionState intersectionState) {
        float f;
        float f2;
        float f3;
        float f4;
        int n2 = 3 * n;
        int n3 = 3 * this.triangles[n2 + 1];
        int n4 = 3 * this.triangles[n2 + 0];
        float f5 = this.points[n3 + 1] - this.points[n4 + 1];
        int n5 = 3 * this.triangles[n2 + 2];
        float f6 = this.points[n4 + 2] - this.points[n5 + 2];
        float f7 = this.points[n3 + 2] - this.points[n4 + 2];
        float f8 = this.points[n4 + 1] - this.points[n5 + 1];
        float f9 = f5 * f6 - f7 * f8;
        float f10 = this.points[n4 + 0] - this.points[n5 + 0];
        float f11 = this.points[n3 + 0] - this.points[n4 + 0];
        float f12 = f7 * f10 - f11 * f6;
        float f13 = f11 * f8 - f5 * f10;
        float f14 = ray.dot(f9, f12, f13);
        float f15 = 1.0f / f14;
        float f16 = f15 * (f4 = f9 * (f3 = this.points[n4 + 0] - ray.ox) + f12 * (f2 = this.points[n4 + 1] - ray.oy) + f13 * (f = this.points[n4 + 2] - ray.oz));
        if (!ray.isInside(f16)) {
            return;
        }
        float f17 = f2 * ray.dz - f * ray.dy;
        float f18 = f * ray.dx - f3 * ray.dz;
        float f19 = f3 * ray.dy - f2 * ray.dx;
        float f20 = f17 * f10 + f18 * f8 + f19 * f6;
        float f21 = f15 * f20;
        if (f21 < 0.0f) {
            return;
        }
        float f22 = f17 * f11 + f18 * f5 + f19 * f7;
        if ((f20 + f22) * f14 > f14 * f14) {
            return;
        }
        float f23 = f15 * f22;
        if (f23 < 0.0f) {
            return;
        }
        ray.setMax(f16);
        intersectionState.setIntersection(n, f21, f23);
    }

    public void intersectPrimitive(Ray ray, int n, IntersectionState intersectionState) {
        if (this.triaccel != null) {
            this.triaccel[n].intersect(ray, n, intersectionState);
            return;
        }
        this.intersectTriangleKensler(ray, n, intersectionState);
    }

    public int getNumPrimitives() {
        return this.triangles.length / 3;
    }

    public void prepareShadingState(ShadingState shadingState) {
        shadingState.init();
        Instance instance = shadingState.getInstance();
        int n = shadingState.getPrimitiveID();
        float f = shadingState.getU();
        float f2 = shadingState.getV();
        float f3 = 1.0f - f - f2;
        shadingState.getRay().getPoint(shadingState.getPoint());
        int n2 = 3 * n;
        int n3 = this.triangles[n2 + 0];
        int n4 = this.triangles[n2 + 1];
        int n5 = this.triangles[n2 + 2];
        Point3 point3 = this.getPoint(n3);
        Point3 point32 = this.getPoint(n4);
        Point3 point33 = this.getPoint(n5);
        Vector3 vector3 = Point3.normal(point3, point32, point33);
        vector3 = instance.transformNormalObjectToWorld(vector3);
        vector3.normalize();
        shadingState.getGeoNormal().set(vector3);
        switch (this.normals.interp) {
            case NONE: 
            case FACE: {
                shadingState.getNormal().set(vector3);
                break;
            }
            case VERTEX: {
                int n6 = 3 * n3;
                int n7 = 3 * n4;
                int n8 = 3 * n5;
                float[] fArray = this.normals.data;
                shadingState.getNormal().x = f3 * fArray[n6 + 0] + f * fArray[n7 + 0] + f2 * fArray[n8 + 0];
                shadingState.getNormal().y = f3 * fArray[n6 + 1] + f * fArray[n7 + 1] + f2 * fArray[n8 + 1];
                shadingState.getNormal().z = f3 * fArray[n6 + 2] + f * fArray[n7 + 2] + f2 * fArray[n8 + 2];
                shadingState.getNormal().set(instance.transformNormalObjectToWorld(shadingState.getNormal()));
                shadingState.getNormal().normalize();
                break;
            }
            case FACEVARYING: {
                int n6 = 3 * n2;
                float[] fArray = this.normals.data;
                shadingState.getNormal().x = f3 * fArray[n6 + 0] + f * fArray[n6 + 3] + f2 * fArray[n6 + 6];
                shadingState.getNormal().y = f3 * fArray[n6 + 1] + f * fArray[n6 + 4] + f2 * fArray[n6 + 7];
                shadingState.getNormal().z = f3 * fArray[n6 + 2] + f * fArray[n6 + 5] + f2 * fArray[n6 + 8];
                shadingState.getNormal().set(instance.transformNormalObjectToWorld(shadingState.getNormal()));
                shadingState.getNormal().normalize();
                break;
            }
        }
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        float f9 = 0.0f;
        switch (this.uvs.interp) {
            case NONE: 
            case FACE: {
                shadingState.getUV().x = 0.0f;
                shadingState.getUV().y = 0.0f;
                break;
            }
            case VERTEX: {
                int n9 = 2 * n3;
                int n10 = 2 * n4;
                int n11 = 2 * n5;
                float[] fArray = this.uvs.data;
                f4 = fArray[n9 + 0];
                f5 = fArray[n9 + 1];
                f6 = fArray[n10 + 0];
                f7 = fArray[n10 + 1];
                f8 = fArray[n11 + 0];
                f9 = fArray[n11 + 1];
                break;
            }
            case FACEVARYING: {
                int n9 = n2 << 1;
                float[] fArray = this.uvs.data;
                f4 = fArray[n9 + 0];
                f5 = fArray[n9 + 1];
                f6 = fArray[n9 + 2];
                f7 = fArray[n9 + 3];
                f8 = fArray[n9 + 4];
                f9 = fArray[n9 + 5];
                break;
            }
        }
        if (this.uvs.interp != ParameterList.InterpolationType.NONE) {
            shadingState.getUV().x = f3 * f4 + f * f6 + f2 * f8;
            shadingState.getUV().y = f3 * f5 + f * f7 + f2 * f9;
            float f10 = f4 - f8;
            float f11 = f6 - f8;
            float f12 = f5 - f9;
            float f13 = f7 - f9;
            Vector3 vector32 = Point3.sub(point3, point33, new Vector3());
            Vector3 vector33 = Point3.sub(point32, point33, new Vector3());
            float f14 = f10 * f13 - f12 * f11;
            if (f14 == 0.0f) {
                shadingState.setBasis(OrthoNormalBasis.makeFromW(shadingState.getNormal()));
            } else {
                float f15 = 1.0f / f14;
                Vector3 vector34 = new Vector3();
                vector34.x = (-f11 * vector32.x + f10 * vector33.x) * f15;
                vector34.y = (-f11 * vector32.y + f10 * vector33.y) * f15;
                vector34.z = (-f11 * vector32.z + f10 * vector33.z) * f15;
                vector34 = instance.transformVectorObjectToWorld(vector34);
                shadingState.setBasis(OrthoNormalBasis.makeFromWV(shadingState.getNormal(), vector34));
            }
        } else {
            shadingState.setBasis(OrthoNormalBasis.makeFromW(shadingState.getNormal()));
        }
        int n12 = this.faceShaders == null ? 0 : this.faceShaders[n] & 0xFF;
        shadingState.setShader(instance.getShader(n12));
        shadingState.setModifier(instance.getModifier(n12));
    }

    public void init() {
        this.triaccel = null;
        int n = this.getNumPrimitives();
        if (!smallTriangles) {
            if (n > 2000000) {
                UI.printWarning(UI.Module.GEOM, "TRI - Too many triangles -- triaccel generation skipped", new Object[0]);
                return;
            }
            this.triaccel = new WaldTriangle[n];
            for (int i = 0; i < n; ++i) {
                this.triaccel[i] = new WaldTriangle(this, i);
            }
        }
    }

    protected Point3 getPoint(int n) {
        return new Point3(this.points[n *= 3], this.points[n + 1], this.points[n + 2]);
    }

    public void getPoint(int n, int n2, Point3 point3) {
        int n3 = 3 * this.triangles[3 * n + n2];
        point3.set(this.points[n3], this.points[n3 + 1], this.points[n3 + 2]);
    }

    public PrimitiveList getBakingPrimitives() {
        switch (this.uvs.interp) {
            case NONE: 
            case FACE: {
                UI.printError(UI.Module.GEOM, "Cannot generate baking surface without texture coordinate data", new Object[0]);
                return null;
            }
        }
        return new BakingSurface();
    }

    private class BakingSurface
    implements PrimitiveList {
        private BakingSurface() {
        }

        public PrimitiveList getBakingPrimitives() {
            return null;
        }

        public int getNumPrimitives() {
            return TriangleMesh.this.getNumPrimitives();
        }

        public float getPrimitiveBound(int n, int n2) {
            if (n2 > 3) {
                return 0.0f;
            }
            switch (((TriangleMesh)TriangleMesh.this).uvs.interp) {
                default: {
                    return 0.0f;
                }
                case VERTEX: {
                    int n3 = 3 * n;
                    int n4 = TriangleMesh.this.triangles[n3 + 0];
                    int n5 = TriangleMesh.this.triangles[n3 + 1];
                    int n6 = TriangleMesh.this.triangles[n3 + 2];
                    int n7 = 2 * n4;
                    int n8 = 2 * n5;
                    int n9 = 2 * n6;
                    float[] fArray = ((TriangleMesh)TriangleMesh.this).uvs.data;
                    switch (n2) {
                        case 0: {
                            return MathUtils.min(fArray[n7 + 0], fArray[n8 + 0], fArray[n9 + 0]);
                        }
                        case 1: {
                            return MathUtils.max(fArray[n7 + 0], fArray[n8 + 0], fArray[n9 + 0]);
                        }
                        case 2: {
                            return MathUtils.min(fArray[n7 + 1], fArray[n8 + 1], fArray[n9 + 1]);
                        }
                        case 3: {
                            return MathUtils.max(fArray[n7 + 1], fArray[n8 + 1], fArray[n9 + 1]);
                        }
                    }
                    return 0.0f;
                }
                case FACEVARYING: 
            }
            int n10 = 6 * n;
            float[] fArray = ((TriangleMesh)TriangleMesh.this).uvs.data;
            switch (n2) {
                case 0: {
                    return MathUtils.min(fArray[n10 + 0], fArray[n10 + 2], fArray[n10 + 4]);
                }
                case 1: {
                    return MathUtils.max(fArray[n10 + 0], fArray[n10 + 2], fArray[n10 + 4]);
                }
                case 2: {
                    return MathUtils.min(fArray[n10 + 1], fArray[n10 + 3], fArray[n10 + 5]);
                }
                case 3: {
                    return MathUtils.max(fArray[n10 + 1], fArray[n10 + 3], fArray[n10 + 5]);
                }
            }
            return 0.0f;
        }

        public BoundingBox getWorldBounds(Matrix4 matrix4) {
            BoundingBox boundingBox = new BoundingBox();
            if (matrix4 == null) {
                for (int i = 0; i < ((TriangleMesh)TriangleMesh.this).uvs.data.length; i += 2) {
                    boundingBox.include(((TriangleMesh)TriangleMesh.this).uvs.data[i], ((TriangleMesh)TriangleMesh.this).uvs.data[i + 1], 0.0f);
                }
            } else {
                for (int i = 0; i < ((TriangleMesh)TriangleMesh.this).uvs.data.length; i += 2) {
                    float f = ((TriangleMesh)TriangleMesh.this).uvs.data[i];
                    float f2 = ((TriangleMesh)TriangleMesh.this).uvs.data[i + 1];
                    float f3 = matrix4.transformPX(f, f2, 0.0f);
                    float f4 = matrix4.transformPY(f, f2, 0.0f);
                    float f5 = matrix4.transformPZ(f, f2, 0.0f);
                    boundingBox.include(f3, f4, f5);
                }
            }
            return boundingBox;
        }

        public void intersectPrimitive(Ray ray, int n, IntersectionState intersectionState) {
            float f;
            double d;
            double d2;
            double d3;
            double d4;
            double d5;
            double d6;
            double d7;
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = 0.0f;
            float f5 = 0.0f;
            float f6 = 0.0f;
            float f7 = 0.0f;
            switch (((TriangleMesh)TriangleMesh.this).uvs.interp) {
                default: {
                    return;
                }
                case VERTEX: {
                    int n2 = 3 * n;
                    int n3 = TriangleMesh.this.triangles[n2 + 0];
                    int n4 = TriangleMesh.this.triangles[n2 + 1];
                    int n5 = TriangleMesh.this.triangles[n2 + 2];
                    int n6 = 2 * n3;
                    int n7 = 2 * n4;
                    int n8 = 2 * n5;
                    float[] fArray = ((TriangleMesh)TriangleMesh.this).uvs.data;
                    f2 = fArray[n6 + 0];
                    f3 = fArray[n6 + 1];
                    f4 = fArray[n7 + 0];
                    f5 = fArray[n7 + 1];
                    f6 = fArray[n8 + 0];
                    f7 = fArray[n8 + 1];
                    break;
                }
                case FACEVARYING: {
                    int n2 = 3 * n << 1;
                    float[] fArray = ((TriangleMesh)TriangleMesh.this).uvs.data;
                    f2 = fArray[n2 + 0];
                    f3 = fArray[n2 + 1];
                    f4 = fArray[n2 + 2];
                    f5 = fArray[n2 + 3];
                    f6 = fArray[n2 + 4];
                    f7 = fArray[n2 + 5];
                    break;
                }
            }
            double d8 = f4 - f2;
            double d9 = f5 - f3;
            double d10 = f6 - f2;
            double d11 = f7 - f3;
            double d12 = (double)(ray.dy * 0.0f) - (double)ray.dz * d11;
            double d13 = (double)ray.dz * d10 - (double)(ray.dx * 0.0f);
            double d14 = (double)ray.dx * d11 - (double)ray.dy * d10;
            double d15 = d8 * d12 + d9 * d13 + 0.0 * d14;
            if (d15 > 0.0) {
                d7 = ray.ox - f2;
                d6 = ray.oy - f3;
                double d16 = ray.oz;
                d5 = d7 * d12 + d6 * d13 + d16 * d14;
                if (d5 < 0.0 || d5 > d15) {
                    return;
                }
                d4 = d6 * 0.0 - d16 * d9;
                d3 = d16 * d8 - d7 * 0.0;
                d2 = d7 * d9 - d6 * d8;
                d = (double)ray.dx * d4 + (double)ray.dy * d3 + (double)ray.dz * d2;
                if (d < 0.0 || d5 + d > d15) {
                    return;
                }
            } else if (d15 < 0.0) {
                d7 = ray.ox - f2;
                d6 = ray.oy - f3;
                double d17 = ray.oz;
                d5 = d7 * d12 + d6 * d13 + d17 * d14;
                if (d5 > 0.0 || d5 < d15) {
                    return;
                }
                d4 = d6 * 0.0 - d17 * d9;
                d3 = d17 * d8 - d7 * 0.0;
                d2 = d7 * d9 - d6 * d8;
                d = (double)ray.dx * d4 + (double)ray.dy * d3 + (double)ray.dz * d2;
                if (d > 0.0 || d5 + d < d15) {
                    return;
                }
            } else {
                return;
            }
            if (ray.isInside(f = (float)((d10 * d4 + d11 * d3 + 0.0 * d2) * (d7 = 1.0 / d15)))) {
                ray.setMax(f);
                intersectionState.setIntersection(n, (float)(d5 * d7), (float)(d * d7));
            }
        }

        public void prepareShadingState(ShadingState shadingState) {
            shadingState.init();
            Instance instance = shadingState.getInstance();
            int n = shadingState.getPrimitiveID();
            float f = shadingState.getU();
            float f2 = shadingState.getV();
            float f3 = 1.0f - f - f2;
            int n2 = 3 * n;
            int n3 = TriangleMesh.this.triangles[n2 + 0];
            int n4 = TriangleMesh.this.triangles[n2 + 1];
            int n5 = TriangleMesh.this.triangles[n2 + 2];
            Point3 point3 = TriangleMesh.this.getPoint(n3);
            Point3 point32 = TriangleMesh.this.getPoint(n4);
            Point3 point33 = TriangleMesh.this.getPoint(n5);
            shadingState.getPoint().x = f3 * point3.x + f * point32.x + f2 * point33.x;
            shadingState.getPoint().y = f3 * point3.y + f * point32.y + f2 * point33.y;
            shadingState.getPoint().z = f3 * point3.z + f * point32.z + f2 * point33.z;
            shadingState.getPoint().set(instance.transformObjectToWorld(shadingState.getPoint()));
            Vector3 vector3 = Point3.normal(point3, point32, point33);
            if (instance != null) {
                vector3 = instance.transformNormalObjectToWorld(vector3);
            }
            vector3.normalize();
            shadingState.getGeoNormal().set(vector3);
            switch (((TriangleMesh)TriangleMesh.this).normals.interp) {
                case NONE: 
                case FACE: {
                    shadingState.getNormal().set(vector3);
                    break;
                }
                case VERTEX: {
                    int n6 = 3 * n3;
                    int n7 = 3 * n4;
                    int n8 = 3 * n5;
                    float[] fArray = ((TriangleMesh)TriangleMesh.this).normals.data;
                    shadingState.getNormal().x = f3 * fArray[n6 + 0] + f * fArray[n7 + 0] + f2 * fArray[n8 + 0];
                    shadingState.getNormal().y = f3 * fArray[n6 + 1] + f * fArray[n7 + 1] + f2 * fArray[n8 + 1];
                    shadingState.getNormal().z = f3 * fArray[n6 + 2] + f * fArray[n7 + 2] + f2 * fArray[n8 + 2];
                    if (instance != null) {
                        shadingState.getNormal().set(instance.transformNormalObjectToWorld(shadingState.getNormal()));
                    }
                    shadingState.getNormal().normalize();
                    break;
                }
                case FACEVARYING: {
                    int n6 = 3 * n2;
                    float[] fArray = ((TriangleMesh)TriangleMesh.this).normals.data;
                    shadingState.getNormal().x = f3 * fArray[n6 + 0] + f * fArray[n6 + 3] + f2 * fArray[n6 + 6];
                    shadingState.getNormal().y = f3 * fArray[n6 + 1] + f * fArray[n6 + 4] + f2 * fArray[n6 + 7];
                    shadingState.getNormal().z = f3 * fArray[n6 + 2] + f * fArray[n6 + 5] + f2 * fArray[n6 + 8];
                    if (instance != null) {
                        shadingState.getNormal().set(instance.transformNormalObjectToWorld(shadingState.getNormal()));
                    }
                    shadingState.getNormal().normalize();
                    break;
                }
            }
            float f4 = 0.0f;
            float f5 = 0.0f;
            float f6 = 0.0f;
            float f7 = 0.0f;
            float f8 = 0.0f;
            float f9 = 0.0f;
            switch (((TriangleMesh)TriangleMesh.this).uvs.interp) {
                case NONE: 
                case FACE: {
                    shadingState.getUV().x = 0.0f;
                    shadingState.getUV().y = 0.0f;
                    break;
                }
                case VERTEX: {
                    int n9 = 2 * n3;
                    int n10 = 2 * n4;
                    int n11 = 2 * n5;
                    float[] fArray = ((TriangleMesh)TriangleMesh.this).uvs.data;
                    f4 = fArray[n9 + 0];
                    f5 = fArray[n9 + 1];
                    f6 = fArray[n10 + 0];
                    f7 = fArray[n10 + 1];
                    f8 = fArray[n11 + 0];
                    f9 = fArray[n11 + 1];
                    break;
                }
                case FACEVARYING: {
                    int n9 = n2 << 1;
                    float[] fArray = ((TriangleMesh)TriangleMesh.this).uvs.data;
                    f4 = fArray[n9 + 0];
                    f5 = fArray[n9 + 1];
                    f6 = fArray[n9 + 2];
                    f7 = fArray[n9 + 3];
                    f8 = fArray[n9 + 4];
                    f9 = fArray[n9 + 5];
                    break;
                }
            }
            if (((TriangleMesh)TriangleMesh.this).uvs.interp != ParameterList.InterpolationType.NONE) {
                shadingState.getUV().x = f3 * f4 + f * f6 + f2 * f8;
                shadingState.getUV().y = f3 * f5 + f * f7 + f2 * f9;
                float f10 = f4 - f8;
                float f11 = f6 - f8;
                float f12 = f5 - f9;
                float f13 = f7 - f9;
                Vector3 vector32 = Point3.sub(point3, point33, new Vector3());
                Vector3 vector33 = Point3.sub(point32, point33, new Vector3());
                float f14 = f10 * f13 - f12 * f11;
                if (f14 == 0.0f) {
                    shadingState.setBasis(OrthoNormalBasis.makeFromW(shadingState.getNormal()));
                } else {
                    float f15 = 1.0f / f14;
                    Vector3 vector34 = new Vector3();
                    vector34.x = (-f11 * vector32.x + f10 * vector33.x) * f15;
                    vector34.y = (-f11 * vector32.y + f10 * vector33.y) * f15;
                    vector34.z = (-f11 * vector32.z + f10 * vector33.z) * f15;
                    if (instance != null) {
                        vector34 = instance.transformVectorObjectToWorld(vector34);
                    }
                    shadingState.setBasis(OrthoNormalBasis.makeFromWV(shadingState.getNormal(), vector34));
                }
            } else {
                shadingState.setBasis(OrthoNormalBasis.makeFromW(shadingState.getNormal()));
            }
            int n12 = TriangleMesh.this.faceShaders == null ? 0 : TriangleMesh.this.faceShaders[n] & 0xFF;
            shadingState.setShader(instance.getShader(n12));
        }

        public boolean update(ParameterList parameterList, SunflowAPI sunflowAPI) {
            return true;
        }
    }

    private static final class WaldTriangle {
        private int k = 0;
        private float nu;
        private float nv;
        private float nd;
        private float bnu;
        private float bnv;
        private float bnd;
        private float cnu;
        private float cnv;
        private float cnd;

        private WaldTriangle(TriangleMesh triangleMesh, int n) {
            float f;
            float f2;
            float f3;
            float f4;
            float f5;
            float f6;
            int n2 = triangleMesh.triangles[(n *= 3) + 0];
            int n3 = triangleMesh.triangles[n + 1];
            int n4 = triangleMesh.triangles[n + 2];
            Point3 point3 = triangleMesh.getPoint(n2);
            Point3 point32 = triangleMesh.getPoint(n3);
            Point3 point33 = triangleMesh.getPoint(n4);
            Vector3 vector3 = Point3.normal(point3, point32, point33);
            this.k = Math.abs(vector3.x) > Math.abs(vector3.y) && Math.abs(vector3.x) > Math.abs(vector3.z) ? 0 : (Math.abs(vector3.y) > Math.abs(vector3.z) ? 1 : 2);
            switch (this.k) {
                case 0: {
                    this.nu = vector3.y / vector3.x;
                    this.nv = vector3.z / vector3.x;
                    this.nd = point3.x + this.nu * point3.y + this.nv * point3.z;
                    f6 = point3.y;
                    f5 = point3.z;
                    f4 = point33.y - f6;
                    f3 = point33.z - f5;
                    f2 = point32.y - f6;
                    f = point32.z - f5;
                    break;
                }
                case 1: {
                    this.nu = vector3.z / vector3.y;
                    this.nv = vector3.x / vector3.y;
                    this.nd = this.nv * point3.x + point3.y + this.nu * point3.z;
                    f6 = point3.z;
                    f5 = point3.x;
                    f4 = point33.z - f6;
                    f3 = point33.x - f5;
                    f2 = point32.z - f6;
                    f = point32.x - f5;
                    break;
                }
                default: {
                    this.nu = vector3.x / vector3.z;
                    this.nv = vector3.y / vector3.z;
                    this.nd = this.nu * point3.x + this.nv * point3.y + point3.z;
                    f6 = point3.x;
                    f5 = point3.y;
                    f4 = point33.x - f6;
                    f3 = point33.y - f5;
                    f2 = point32.x - f6;
                    f = point32.y - f5;
                }
            }
            float f7 = f4 * f - f3 * f2;
            this.bnu = -f3 / f7;
            this.bnv = f4 / f7;
            this.bnd = (f3 * f6 - f4 * f5) / f7;
            this.cnu = f / f7;
            this.cnv = -f2 / f7;
            this.cnd = (f2 * f5 - f * f6) / f7;
        }

        void intersectBox(Ray ray, float f, float f2, float f3, int n, IntersectionState intersectionState) {
            switch (this.k) {
                case 0: {
                    float f4;
                    float f5 = f2;
                    float f6 = f3;
                    float f7 = f5 * this.bnu + f6 * this.bnv + this.bnd;
                    if (f7 < 0.0f) {
                        f7 = 0.0f;
                    }
                    if ((f4 = f5 * this.cnu + f6 * this.cnv + this.cnd) < 0.0f) {
                        f4 = 0.0f;
                    }
                    intersectionState.setIntersection(n, f7, f4);
                    return;
                }
                case 1: {
                    float f8;
                    float f9 = f3;
                    float f10 = f;
                    float f11 = f9 * this.bnu + f10 * this.bnv + this.bnd;
                    if (f11 < 0.0f) {
                        f11 = 0.0f;
                    }
                    if ((f8 = f9 * this.cnu + f10 * this.cnv + this.cnd) < 0.0f) {
                        f8 = 0.0f;
                    }
                    intersectionState.setIntersection(n, f11, f8);
                    return;
                }
                case 2: {
                    float f12;
                    float f13 = f;
                    float f14 = f2;
                    float f15 = f13 * this.bnu + f14 * this.bnv + this.bnd;
                    if (f15 < 0.0f) {
                        f15 = 0.0f;
                    }
                    if ((f12 = f13 * this.cnu + f14 * this.cnv + this.cnd) < 0.0f) {
                        f12 = 0.0f;
                    }
                    intersectionState.setIntersection(n, f15, f12);
                    return;
                }
            }
        }

        void intersect(Ray ray, int n, IntersectionState intersectionState) {
            switch (this.k) {
                case 0: {
                    float f = 1.0f / (ray.dx + this.nu * ray.dy + this.nv * ray.dz);
                    float f2 = (this.nd - ray.ox - this.nu * ray.oy - this.nv * ray.oz) * f;
                    if (!ray.isInside(f2)) {
                        return;
                    }
                    float f3 = ray.oy + f2 * ray.dy;
                    float f4 = ray.oz + f2 * ray.dz;
                    float f5 = f3 * this.bnu + f4 * this.bnv + this.bnd;
                    if (f5 < 0.0f) {
                        return;
                    }
                    float f6 = f3 * this.cnu + f4 * this.cnv + this.cnd;
                    if (f6 < 0.0f) {
                        return;
                    }
                    if (f5 + f6 > 1.0f) {
                        return;
                    }
                    ray.setMax(f2);
                    intersectionState.setIntersection(n, f5, f6);
                    return;
                }
                case 1: {
                    float f = 1.0f / (ray.dy + this.nu * ray.dz + this.nv * ray.dx);
                    float f7 = (this.nd - ray.oy - this.nu * ray.oz - this.nv * ray.ox) * f;
                    if (!ray.isInside(f7)) {
                        return;
                    }
                    float f8 = ray.oz + f7 * ray.dz;
                    float f9 = ray.ox + f7 * ray.dx;
                    float f10 = f8 * this.bnu + f9 * this.bnv + this.bnd;
                    if (f10 < 0.0f) {
                        return;
                    }
                    float f11 = f8 * this.cnu + f9 * this.cnv + this.cnd;
                    if (f11 < 0.0f) {
                        return;
                    }
                    if (f10 + f11 > 1.0f) {
                        return;
                    }
                    ray.setMax(f7);
                    intersectionState.setIntersection(n, f10, f11);
                    return;
                }
                case 2: {
                    float f = 1.0f / (ray.dz + this.nu * ray.dx + this.nv * ray.dy);
                    float f12 = (this.nd - ray.oz - this.nu * ray.ox - this.nv * ray.oy) * f;
                    if (!ray.isInside(f12)) {
                        return;
                    }
                    float f13 = ray.ox + f12 * ray.dx;
                    float f14 = ray.oy + f12 * ray.dy;
                    float f15 = f13 * this.bnu + f14 * this.bnv + this.bnd;
                    if (f15 < 0.0f) {
                        return;
                    }
                    float f16 = f13 * this.cnu + f14 * this.cnv + this.cnd;
                    if (f16 < 0.0f) {
                        return;
                    }
                    if (f15 + f16 > 1.0f) {
                        return;
                    }
                    ray.setMax(f12);
                    intersectionState.setIntersection(n, f15, f16);
                    return;
                }
            }
        }
    }
}

