/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core.primitive;

import org.sunflow.SunflowAPI;
import org.sunflow.core.Instance;
import org.sunflow.core.IntersectionState;
import org.sunflow.core.ParameterList;
import org.sunflow.core.PrimitiveList;
import org.sunflow.core.Ray;
import org.sunflow.core.ShadingState;
import org.sunflow.math.BoundingBox;
import org.sunflow.math.Matrix4;
import org.sunflow.math.OrthoNormalBasis;
import org.sunflow.math.Point3;
import org.sunflow.math.Solvers;
import org.sunflow.math.Vector3;

public class Sphere
implements PrimitiveList {
    public boolean update(ParameterList parameterList, SunflowAPI sunflowAPI) {
        return true;
    }

    public BoundingBox getWorldBounds(Matrix4 matrix4) {
        BoundingBox boundingBox = new BoundingBox(1.0f);
        if (matrix4 != null) {
            boundingBox = matrix4.transform(boundingBox);
        }
        return boundingBox;
    }

    public float getPrimitiveBound(int n, int n2) {
        return (n2 & 1) == 0 ? -1.0f : 1.0f;
    }

    public int getNumPrimitives() {
        return 1;
    }

    public void prepareShadingState(ShadingState shadingState) {
        shadingState.init();
        shadingState.getRay().getPoint(shadingState.getPoint());
        Instance instance = shadingState.getInstance();
        Point3 point3 = instance.transformWorldToObject(shadingState.getPoint());
        shadingState.getNormal().set(point3.x, point3.y, point3.z);
        shadingState.getNormal().normalize();
        float f = (float)Math.atan2(shadingState.getNormal().y, shadingState.getNormal().x);
        if (f < 0.0f) {
            f = (float)((double)f + Math.PI * 2);
        }
        float f2 = (float)Math.acos(shadingState.getNormal().z);
        shadingState.getUV().y = f2 / (float)Math.PI;
        shadingState.getUV().x = f / ((float)Math.PI * 2);
        Vector3 vector3 = new Vector3();
        vector3.x = (float)Math.PI * -2 * shadingState.getNormal().y;
        vector3.y = (float)Math.PI * 2 * shadingState.getNormal().x;
        vector3.z = 0.0f;
        shadingState.setShader(instance.getShader(0));
        shadingState.setModifier(instance.getModifier(0));
        Vector3 vector32 = instance.transformNormalObjectToWorld(shadingState.getNormal());
        vector3 = instance.transformVectorObjectToWorld(vector3);
        shadingState.getNormal().set(vector32);
        shadingState.getNormal().normalize();
        shadingState.getGeoNormal().set(shadingState.getNormal());
        shadingState.setBasis(OrthoNormalBasis.makeFromWV(shadingState.getNormal(), vector3));
    }

    public void intersectPrimitive(Ray ray, int n, IntersectionState intersectionState) {
        float f = ray.dx * ray.dx + ray.dy * ray.dy + ray.dz * ray.dz;
        float f2 = 2.0f * (ray.dx * ray.ox + ray.dy * ray.oy + ray.dz * ray.oz);
        float f3 = ray.ox * ray.ox + ray.oy * ray.oy + ray.oz * ray.oz - 1.0f;
        double[] dArray = Solvers.solveQuadric(f, f2, f3);
        if (dArray != null) {
            if (dArray[0] >= (double)ray.getMax() || dArray[1] <= (double)ray.getMin()) {
                return;
            }
            if (dArray[0] > (double)ray.getMin()) {
                ray.setMax((float)dArray[0]);
            } else {
                ray.setMax((float)dArray[1]);
            }
            intersectionState.setIntersection(0, 0.0f, 0.0f);
        }
    }

    public PrimitiveList getBakingPrimitives() {
        return null;
    }
}

