/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core.primitive;

import org.sunflow.SunflowAPI;
import org.sunflow.core.IntersectionState;
import org.sunflow.core.ParameterList;
import org.sunflow.core.PrimitiveList;
import org.sunflow.core.Ray;
import org.sunflow.core.ShadingState;
import org.sunflow.math.BoundingBox;
import org.sunflow.math.Matrix4;
import org.sunflow.math.OrthoNormalBasis;
import org.sunflow.math.Point3;
import org.sunflow.math.Solvers;
import org.sunflow.math.Vector3;

public class ParticleSurface
implements PrimitiveList {
    private float[] particles = null;
    private float r = 1.0f;
    private float r2 = 1.0f;
    private int n = 0;

    public int getNumPrimitives() {
        return this.n;
    }

    public float getPrimitiveBound(int n, int n2) {
        float f = this.particles[n * 3 + (n2 >>> 1)];
        return (n2 & 1) == 0 ? f - this.r : f + this.r;
    }

    public BoundingBox getWorldBounds(Matrix4 matrix4) {
        BoundingBox boundingBox = new BoundingBox();
        int n = 0;
        int n2 = 0;
        while (n < this.n) {
            boundingBox.include(this.particles[n2], this.particles[n2 + 1], this.particles[n2 + 2]);
            ++n;
            n2 += 3;
        }
        boundingBox.include(boundingBox.getMinimum().x - this.r, boundingBox.getMinimum().y - this.r, boundingBox.getMinimum().z - this.r);
        boundingBox.include(boundingBox.getMaximum().x + this.r, boundingBox.getMaximum().y + this.r, boundingBox.getMaximum().z + this.r);
        return matrix4 == null ? boundingBox : matrix4.transform(boundingBox);
    }

    public void intersectPrimitive(Ray ray, int n, IntersectionState intersectionState) {
        float f = ray.dx * ray.dx + ray.dy * ray.dy + ray.dz * ray.dz;
        int n2 = n * 3;
        float f2 = ray.ox - this.particles[n2 + 0];
        float f3 = ray.oy - this.particles[n2 + 1];
        float f4 = ray.oz - this.particles[n2 + 2];
        float f5 = 2.0f * (ray.dx * f2 + ray.dy * f3 + ray.dz * f4);
        float f6 = f2 * f2 + f3 * f3 + f4 * f4 - this.r2;
        double[] dArray = Solvers.solveQuadric(f, f5, f6);
        if (dArray != null) {
            if (dArray[0] >= (double)ray.getMax() || dArray[1] <= (double)ray.getMin()) {
                return;
            }
            if (dArray[0] > (double)ray.getMin()) {
                ray.setMax((float)dArray[0]);
            } else {
                ray.setMax((float)dArray[1]);
            }
            intersectionState.setIntersection(n, 0.0f, 0.0f);
        }
    }

    public void prepareShadingState(ShadingState shadingState) {
        shadingState.init();
        shadingState.getRay().getPoint(shadingState.getPoint());
        Point3 point3 = shadingState.getInstance().transformWorldToObject(shadingState.getPoint());
        point3.x -= this.particles[3 * shadingState.getPrimitiveID() + 0];
        point3.y -= this.particles[3 * shadingState.getPrimitiveID() + 1];
        point3.z -= this.particles[3 * shadingState.getPrimitiveID() + 2];
        shadingState.getNormal().set(point3.x, point3.y, point3.z);
        shadingState.getNormal().normalize();
        shadingState.setShader(shadingState.getInstance().getShader(0));
        shadingState.setModifier(shadingState.getInstance().getModifier(0));
        Vector3 vector3 = shadingState.getInstance().transformNormalObjectToWorld(shadingState.getNormal());
        shadingState.getNormal().set(vector3);
        shadingState.getNormal().normalize();
        shadingState.getGeoNormal().set(shadingState.getNormal());
        shadingState.setBasis(OrthoNormalBasis.makeFromW(shadingState.getNormal()));
    }

    public boolean update(ParameterList parameterList, SunflowAPI sunflowAPI) {
        ParameterList.FloatParameter floatParameter = parameterList.getPointArray("particles");
        if (floatParameter != null) {
            this.particles = floatParameter.data;
        }
        this.r = parameterList.getFloat("radius", this.r);
        this.r2 = this.r * this.r;
        this.n = parameterList.getInt("num", this.n);
        return this.particles != null && this.n <= this.particles.length / 3;
    }

    public PrimitiveList getBakingPrimitives() {
        return null;
    }
}

