/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core.primitive;

import org.sunflow.SunflowAPI;
import org.sunflow.core.Instance;
import org.sunflow.core.IntersectionState;
import org.sunflow.core.LightSample;
import org.sunflow.core.ParameterList;
import org.sunflow.core.PrimitiveList;
import org.sunflow.core.Ray;
import org.sunflow.core.Shader;
import org.sunflow.core.ShadingState;
import org.sunflow.image.Color;
import org.sunflow.math.BoundingBox;
import org.sunflow.math.Matrix4;
import org.sunflow.math.OrthoNormalBasis;
import org.sunflow.math.Vector3;
import org.sunflow.system.UI;

public class Hair
implements PrimitiveList,
Shader {
    private int numSegments = 1;
    private float[] points = null;
    private ParameterList.FloatParameter widths = new ParameterList.FloatParameter(1.0f);

    public int getNumPrimitives() {
        return this.numSegments * (this.points.length / (3 * (this.numSegments + 1)));
    }

    public float getPrimitiveBound(int n, int n2) {
        int n3 = n / this.numSegments;
        int n4 = n % this.numSegments;
        int n5 = n3 * (this.numSegments + 1) + n4;
        int n6 = n3 * 3 * (this.numSegments + 1);
        int n7 = n6 + n4 * 3;
        int n8 = n7 + 3;
        int n9 = n2 >>> 1;
        if ((n2 & 1) == 0) {
            return Math.min(this.points[n7 + n9] - 0.5f * this.getWidth(n5), this.points[n8 + n9] - 0.5f * this.getWidth(n5 + 1));
        }
        return Math.max(this.points[n7 + n9] + 0.5f * this.getWidth(n5), this.points[n8 + n9] + 0.5f * this.getWidth(n5 + 1));
    }

    public BoundingBox getWorldBounds(Matrix4 matrix4) {
        BoundingBox boundingBox = new BoundingBox();
        int n = 0;
        int n2 = 0;
        while (n < this.points.length) {
            float f = 0.5f * this.getWidth(n2);
            boundingBox.include(this.points[n] - f, this.points[n + 1] - f, this.points[n + 2] - f);
            boundingBox.include(this.points[n] + f, this.points[n + 1] + f, this.points[n + 2] + f);
            n += 3;
            ++n2;
        }
        if (matrix4 != null) {
            boundingBox = matrix4.transform(boundingBox);
        }
        return boundingBox;
    }

    private float getWidth(int n) {
        switch (this.widths.interp) {
            case NONE: {
                return this.widths.data[0];
            }
            case VERTEX: {
                return this.widths.data[n];
            }
        }
        return 0.0f;
    }

    private Vector3 getTangent(int n, int n2, float f) {
        Vector3 vector3 = new Vector3(this.points[n2 + 3] - this.points[n2 + 0], this.points[n2 + 4] - this.points[n2 + 1], this.points[n2 + 5] - this.points[n2 + 2]);
        vector3.normalize();
        if (n == 0 || n == this.numSegments - 1) {
            return vector3;
        }
        if (f <= 0.5f) {
            Vector3 vector32 = new Vector3(this.points[n2 + 0] - this.points[n2 - 3], this.points[n2 + 1] - this.points[n2 - 2], this.points[n2 + 2] - this.points[n2 - 1]);
            vector32.normalize();
            float f2 = f + 0.5f;
            float f3 = 1.0f - f2;
            float f4 = vector32.x * f3 + vector3.x * f2;
            float f5 = vector32.y * f3 + vector3.y * f2;
            float f6 = vector32.z * f3 + vector3.z * f2;
            return new Vector3(f4, f5, f6);
        }
        Vector3 vector33 = new Vector3(this.points[(n2 += 3) + 3] - this.points[n2 + 0], this.points[n2 + 4] - this.points[n2 + 1], this.points[n2 + 5] - this.points[n2 + 2]);
        vector33.normalize();
        float f7 = 1.5f - f;
        float f8 = 1.0f - f7;
        float f9 = vector33.x * f8 + vector3.x * f7;
        float f10 = vector33.y * f8 + vector3.y * f7;
        float f11 = vector33.z * f8 + vector3.z * f7;
        return new Vector3(f9, f10, f11);
    }

    public void intersectPrimitive(Ray ray, int n, IntersectionState intersectionState) {
        int n2 = n / this.numSegments;
        int n3 = n2 * 3 * (this.numSegments + 1);
        int n4 = n % this.numSegments;
        int n5 = n3 + n4 * 3;
        int n6 = n5 + 3;
        float f = this.points[n6 + 0] - this.points[n5 + 0];
        float f2 = this.points[n6 + 2] - this.points[n5 + 2];
        float f3 = ray.dz * f - ray.dx * f2;
        float f4 = this.points[n6 + 1] - this.points[n5 + 1];
        float f5 = ray.dx * f4 - ray.dy * f;
        float f6 = f3 * f2 - f5 * f4;
        float f7 = ray.dy * f2 - ray.dz * f4;
        float f8 = f5 * f - f7 * f2;
        float f9 = f7 * f4 - f3 * f;
        float f10 = f6 * (this.points[n5 + 0] - ray.ox) + f8 * (this.points[n5 + 1] - ray.oy) + f9 * (this.points[n5 + 2] - ray.oz);
        float f11 = 1.0f / (f6 * ray.dx + f8 * ray.dy + f9 * ray.dz);
        float f12 = f10 * f11;
        if (ray.isInside(f12)) {
            int n7 = n2 * (this.numSegments + 1) + n4;
            float f13 = ray.ox + f12 * ray.dx;
            float f14 = f13 - this.points[n5 + 0];
            float f15 = ray.oy + f12 * ray.dy;
            float f16 = f15 - this.points[n5 + 1];
            float f17 = ray.oz + f12 * ray.dz;
            float f18 = f17 - this.points[n5 + 2];
            float f19 = (f * f14 + f4 * f16 + f2 * f18) / (f * f + f4 * f4 + f2 * f2);
            if (f19 <= 0.0f) {
                if (n4 == 0) {
                    return;
                }
                float f20 = this.points[n5 + 0] - f13;
                float f21 = this.points[n5 + 1] - f15;
                float f22 = this.points[n5 + 2] - f17;
                float f23 = f20 * f20 + f21 * f21 + f22 * f22;
                float f24 = this.getWidth(n7);
                if (f23 < f24 * f24 * 0.25f) {
                    ray.setMax(f12);
                    intersectionState.setIntersection(n, 0.0f, 0.0f);
                }
            } else if (f19 >= 1.0f) {
                float f25 = this.points[n6 + 0] - f13;
                float f26 = this.points[n6 + 1] - f15;
                float f27 = this.points[n6 + 2] - f17;
                float f28 = f25 * f25 + f26 * f26 + f27 * f27;
                float f29 = this.getWidth(n7 + 1);
                if (f28 < f29 * f29 * 0.25f) {
                    ray.setMax(f12);
                    intersectionState.setIntersection(n, 0.0f, 1.0f);
                }
            } else {
                float f30 = this.points[n5 + 0] + f19 * f - f13;
                float f31 = this.points[n5 + 1] + f19 * f4 - f15;
                float f32 = this.points[n5 + 2] + f19 * f2 - f17;
                float f33 = f30 * f30 + f31 * f31 + f32 * f32;
                float f34 = (1.0f - f19) * this.getWidth(n7) + f19 * this.getWidth(n7 + 1);
                if (f33 < f34 * f34 * 0.25f) {
                    ray.setMax(f12);
                    intersectionState.setIntersection(n, 0.0f, f19);
                }
            }
        }
    }

    public void prepareShadingState(ShadingState shadingState) {
        shadingState.init();
        Instance instance = shadingState.getInstance();
        shadingState.getRay().getPoint(shadingState.getPoint());
        Ray ray = shadingState.getRay();
        Shader shader = instance.getShader(0);
        shadingState.setShader(shader != null ? shader : this);
        int n = shadingState.getPrimitiveID();
        int n2 = n / this.numSegments;
        int n3 = n % this.numSegments;
        int n4 = n2 * 3 * (this.numSegments + 1);
        int n5 = n4 + n3 * 3;
        Vector3 vector3 = this.getTangent(n3, n5, shadingState.getV());
        vector3 = instance.transformVectorObjectToWorld(vector3);
        shadingState.setBasis(OrthoNormalBasis.makeFromWV(vector3, new Vector3(-ray.dx, -ray.dy, -ray.dz)));
        shadingState.getBasis().swapVW();
        shadingState.getNormal().set(0.0f, 0.0f, 1.0f);
        shadingState.getBasis().transform(shadingState.getNormal());
        shadingState.getGeoNormal().set(shadingState.getNormal());
        shadingState.getUV().set(0.0f, ((float)n3 + shadingState.getV()) / (float)this.numSegments);
    }

    public boolean update(ParameterList parameterList, SunflowAPI sunflowAPI) {
        this.numSegments = parameterList.getInt("segments", this.numSegments);
        if (this.numSegments < 1) {
            UI.printError(UI.Module.HAIR, "Invalid number of segments: %d", this.numSegments);
            return false;
        }
        ParameterList.FloatParameter floatParameter = parameterList.getPointArray("points");
        if (floatParameter != null) {
            if (floatParameter.interp != ParameterList.InterpolationType.VERTEX) {
                UI.printError(UI.Module.HAIR, "Point interpolation type must be set to \"vertex\" - was \"%s\"", floatParameter.interp.name().toLowerCase());
            } else {
                this.points = floatParameter.data;
            }
        }
        if (this.points == null) {
            UI.printError(UI.Module.HAIR, "Unabled to update hair - vertices are missing", new Object[0]);
            return false;
        }
        parameterList.setVertexCount(this.points.length / 3);
        ParameterList.FloatParameter floatParameter2 = parameterList.getFloatArray("widths");
        if (floatParameter2 != null) {
            if (floatParameter2.interp == ParameterList.InterpolationType.NONE || floatParameter2.interp == ParameterList.InterpolationType.VERTEX) {
                this.widths = floatParameter2;
            } else {
                UI.printWarning(UI.Module.HAIR, "Width interpolation type %s is not supported -- ignoring", floatParameter2.interp.name().toLowerCase());
            }
        }
        return true;
    }

    public Color getRadiance(ShadingState shadingState) {
        shadingState.initLightSamples();
        shadingState.initCausticSamples();
        Vector3 vector3 = shadingState.getRay().getDirection();
        vector3.negate();
        Vector3 vector32 = new Vector3();
        Vector3 vector33 = shadingState.getBasis().transform(new Vector3(0.0f, 1.0f, 0.0f));
        Color color = Color.black();
        Color color2 = Color.black();
        for (LightSample lightSample : shadingState) {
            Vector3 vector34 = lightSample.getShadowRay().getDirection();
            float f = Vector3.dot(vector33, vector34);
            float f2 = (float)Math.sqrt(1.0f - f * f);
            color.madd(f2, lightSample.getDiffuseRadiance());
            Vector3.add(vector3, vector34, vector32);
            vector32.normalize();
            float f3 = Vector3.dot(vector33, vector32);
            float f4 = (float)Math.sqrt(1.0f - f3 * f3);
            float f5 = (float)Math.pow(f4, 10.0);
            color2.madd(f5, lightSample.getSpecularRadiance());
        }
        Color color3 = Color.add(color, color2, new Color());
        return Color.blend(color3, shadingState.traceTransparency(), shadingState.getV(), new Color());
    }

    public void scatterPhoton(ShadingState shadingState, Color color) {
    }

    public PrimitiveList getBakingPrimitives() {
        return null;
    }
}

