/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core.primitive;

import org.sunflow.SunflowAPI;
import org.sunflow.core.IntersectionState;
import org.sunflow.core.LightSample;
import org.sunflow.core.LightSource;
import org.sunflow.core.ParameterList;
import org.sunflow.core.PrimitiveList;
import org.sunflow.core.Ray;
import org.sunflow.core.Shader;
import org.sunflow.core.ShadingState;
import org.sunflow.image.Color;
import org.sunflow.math.BoundingBox;
import org.sunflow.math.Matrix4;
import org.sunflow.math.OrthoNormalBasis;
import org.sunflow.math.Point3;
import org.sunflow.math.Vector3;

public class CornellBox
implements PrimitiveList,
Shader,
LightSource {
    private float minX;
    private float minY;
    private float minZ;
    private float maxX;
    private float maxY;
    private float maxZ;
    private Color left;
    private Color right;
    private Color top;
    private Color bottom;
    private Color back;
    private Color radiance;
    private int samples;
    private float lxmin;
    private float lymin;
    private float lxmax;
    private float lymax;
    private float area;
    private BoundingBox lightBounds;

    public CornellBox() {
        Color color;
        this.updateGeometry(new Point3(-1.0f, -1.0f, -1.0f), new Point3(1.0f, 1.0f, 1.0f));
        this.left = new Color(0.8f, 0.25f, 0.25f);
        this.right = new Color(0.25f, 0.25f, 0.8f);
        this.bottom = this.back = (color = new Color(0.7f, 0.7f, 0.7f));
        this.top = this.back;
        this.radiance = Color.WHITE;
        this.samples = 16;
    }

    private void updateGeometry(Point3 point3, Point3 point32) {
        this.lightBounds = new BoundingBox(point3);
        this.lightBounds.include(point32);
        this.minX = this.lightBounds.getMinimum().x;
        this.minY = this.lightBounds.getMinimum().y;
        this.minZ = this.lightBounds.getMinimum().z;
        this.maxX = this.lightBounds.getMaximum().x;
        this.maxY = this.lightBounds.getMaximum().y;
        this.maxZ = this.lightBounds.getMaximum().z;
        this.lightBounds.enlargeUlps();
        this.lxmin = this.maxX / 3.0f + 2.0f * this.minX / 3.0f;
        this.lxmax = this.minX / 3.0f + 2.0f * this.maxX / 3.0f;
        this.lymin = this.maxY / 3.0f + 2.0f * this.minY / 3.0f;
        this.lymax = this.minY / 3.0f + 2.0f * this.maxY / 3.0f;
        this.area = (this.lxmax - this.lxmin) * (this.lymax - this.lymin);
    }

    public boolean update(ParameterList parameterList, SunflowAPI sunflowAPI) {
        Point3 point3 = parameterList.getPoint("corner0", null);
        Point3 point32 = parameterList.getPoint("corner1", null);
        if (point3 != null && point32 != null) {
            this.updateGeometry(point3, point32);
        }
        this.left = parameterList.getColor("leftColor", this.left);
        this.right = parameterList.getColor("rightColor", this.right);
        this.top = parameterList.getColor("topColor", this.top);
        this.bottom = parameterList.getColor("bottomColor", this.bottom);
        this.back = parameterList.getColor("backColor", this.back);
        this.radiance = parameterList.getColor("radiance", this.radiance);
        this.samples = parameterList.getInt("samples", this.samples);
        return true;
    }

    public void init(String string, SunflowAPI sunflowAPI) {
        sunflowAPI.geometry(string, this);
        sunflowAPI.shader(string + ".shader", this);
        sunflowAPI.parameter("shaders", string + ".shader");
        sunflowAPI.instance(string + ".instance", string);
        sunflowAPI.light(string + ".light", this);
    }

    public BoundingBox getBounds() {
        return this.lightBounds;
    }

    public float getBound(int n) {
        switch (n) {
            case 0: {
                return this.minX;
            }
            case 1: {
                return this.maxX;
            }
            case 2: {
                return this.minY;
            }
            case 3: {
                return this.maxY;
            }
            case 4: {
                return this.minZ;
            }
            case 5: {
                return this.maxZ;
            }
        }
        return 0.0f;
    }

    public boolean intersects(BoundingBox boundingBox) {
        BoundingBox boundingBox2 = new BoundingBox();
        boundingBox2.include(new Point3(this.minX, this.minY, this.minZ));
        boundingBox2.include(new Point3(this.maxX, this.maxY, this.maxZ));
        if (boundingBox2.intersects(boundingBox)) {
            if (!boundingBox2.contains(new Point3(boundingBox.getMinimum().x, boundingBox.getMinimum().y, boundingBox.getMinimum().z))) {
                return true;
            }
            if (!boundingBox2.contains(new Point3(boundingBox.getMinimum().x, boundingBox.getMinimum().y, boundingBox.getMaximum().z))) {
                return true;
            }
            if (!boundingBox2.contains(new Point3(boundingBox.getMinimum().x, boundingBox.getMaximum().y, boundingBox.getMinimum().z))) {
                return true;
            }
            if (!boundingBox2.contains(new Point3(boundingBox.getMinimum().x, boundingBox.getMaximum().y, boundingBox.getMaximum().z))) {
                return true;
            }
            if (!boundingBox2.contains(new Point3(boundingBox.getMaximum().x, boundingBox.getMinimum().y, boundingBox.getMinimum().z))) {
                return true;
            }
            if (!boundingBox2.contains(new Point3(boundingBox.getMaximum().x, boundingBox.getMinimum().y, boundingBox.getMaximum().z))) {
                return true;
            }
            if (!boundingBox2.contains(new Point3(boundingBox.getMaximum().x, boundingBox.getMaximum().y, boundingBox.getMinimum().z))) {
                return true;
            }
            if (!boundingBox2.contains(new Point3(boundingBox.getMaximum().x, boundingBox.getMaximum().y, boundingBox.getMaximum().z))) {
                return true;
            }
        }
        return false;
    }

    public void prepareShadingState(ShadingState shadingState) {
        shadingState.init();
        shadingState.getRay().getPoint(shadingState.getPoint());
        int n = shadingState.getPrimitiveID();
        switch (n) {
            case 0: {
                shadingState.getNormal().set(new Vector3(1.0f, 0.0f, 0.0f));
                break;
            }
            case 1: {
                shadingState.getNormal().set(new Vector3(-1.0f, 0.0f, 0.0f));
                break;
            }
            case 2: {
                shadingState.getNormal().set(new Vector3(0.0f, 1.0f, 0.0f));
                break;
            }
            case 3: {
                shadingState.getNormal().set(new Vector3(0.0f, -1.0f, 0.0f));
                break;
            }
            case 4: {
                shadingState.getNormal().set(new Vector3(0.0f, 0.0f, 1.0f));
                break;
            }
            case 5: {
                shadingState.getNormal().set(new Vector3(0.0f, 0.0f, -1.0f));
                break;
            }
            default: {
                shadingState.getNormal().set(new Vector3(0.0f, 0.0f, 0.0f));
            }
        }
        shadingState.getGeoNormal().set(shadingState.getNormal());
        shadingState.setBasis(OrthoNormalBasis.makeFromW(shadingState.getNormal()));
        shadingState.setShader(this);
    }

    public void intersectPrimitive(Ray ray, int n, IntersectionState intersectionState) {
        float f = Float.NEGATIVE_INFINITY;
        float f2 = Float.POSITIVE_INFINITY;
        float f3 = ray.ox;
        float f4 = 1.0f / ray.dx;
        float f5 = (this.minX - f3) * f4;
        float f6 = (this.maxX - f3) * f4;
        int n2 = -1;
        int n3 = -1;
        if (f4 > 0.0f) {
            if (f5 > f) {
                f = f5;
                n2 = 0;
            }
            if (f6 < f2) {
                f2 = f6;
                n3 = 1;
            }
        } else {
            if (f6 > f) {
                f = f6;
                n2 = 1;
            }
            if (f5 < f2) {
                f2 = f5;
                n3 = 0;
            }
        }
        if (f > f2) {
            return;
        }
        float f7 = ray.oy;
        float f8 = 1.0f / ray.dy;
        f5 = (this.minY - f7) * f8;
        f6 = (this.maxY - f7) * f8;
        if (f8 > 0.0f) {
            if (f5 > f) {
                f = f5;
                n2 = 2;
            }
            if (f6 < f2) {
                f2 = f6;
                n3 = 3;
            }
        } else {
            if (f6 > f) {
                f = f6;
                n2 = 3;
            }
            if (f5 < f2) {
                f2 = f5;
                n3 = 2;
            }
        }
        if (f > f2) {
            return;
        }
        float f9 = ray.oz;
        float f10 = 1.0f / ray.dz;
        f5 = (this.minZ - f9) * f10;
        f6 = (this.maxZ - f9) * f10;
        if (f10 > 0.0f) {
            if (f5 > f) {
                f = f5;
                n2 = 4;
            }
            if (f6 < f2) {
                f2 = f6;
                n3 = 5;
            }
        } else {
            if (f6 > f) {
                f = f6;
                n2 = 5;
            }
            if (f5 < f2) {
                f2 = f5;
                n3 = 4;
            }
        }
        if (f > f2) {
            return;
        }
        assert (n2 != -1);
        assert (n3 != -1);
        if (n2 != 2 && ray.isInside(f)) {
            ray.setMax(f);
            intersectionState.setIntersection(n2, 0.0f, 0.0f);
        } else if (n3 != 2 && ray.isInside(f2)) {
            ray.setMax(f2);
            intersectionState.setIntersection(n3, 0.0f, 0.0f);
        }
    }

    public Color getRadiance(ShadingState shadingState) {
        int n = shadingState.getPrimitiveID();
        Color color = null;
        switch (n) {
            case 0: {
                color = this.left;
                break;
            }
            case 1: {
                color = this.right;
                break;
            }
            case 3: {
                color = this.back;
                break;
            }
            case 4: {
                color = this.bottom;
                break;
            }
            case 5: {
                float f = shadingState.getPoint().x;
                float f2 = shadingState.getPoint().y;
                if (f >= this.lxmin && f < this.lxmax && f2 >= this.lymin && f2 < this.lymax && shadingState.getRay().dz > 0.0f) {
                    return shadingState.includeLights() ? this.radiance : Color.BLACK;
                }
                color = this.top;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        shadingState.faceforward();
        shadingState.initLightSamples();
        shadingState.initCausticSamples();
        return shadingState.diffuse(color);
    }

    public void scatterPhoton(ShadingState shadingState, Color color) {
        int n = shadingState.getPrimitiveID();
        Color color2 = null;
        switch (n) {
            case 0: {
                color2 = this.left;
                break;
            }
            case 1: {
                color2 = this.right;
                break;
            }
            case 3: {
                color2 = this.back;
                break;
            }
            case 4: {
                color2 = this.bottom;
                break;
            }
            case 5: {
                float f = shadingState.getPoint().x;
                float f2 = shadingState.getPoint().y;
                if (f >= this.lxmin && f < this.lxmax && f2 >= this.lymin && f2 < this.lymax && shadingState.getRay().dz > 0.0f) {
                    return;
                }
                color2 = this.top;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (Vector3.dot(shadingState.getNormal(), shadingState.getRay().getDirection()) > 0.0f) {
            shadingState.getNormal().negate();
            shadingState.getGeoNormal().negate();
        }
        shadingState.storePhoton(shadingState.getRay().getDirection(), color, color2);
        double d = color2.getAverage();
        double d2 = shadingState.getRandom(0, 0, 1);
        if (d2 < d) {
            color.mul(color2).mul(1.0f / (float)d);
            OrthoNormalBasis orthoNormalBasis = OrthoNormalBasis.makeFromW(shadingState.getNormal());
            double d3 = Math.PI * 2 * d2 / d;
            double d4 = shadingState.getRandom(0, 1, 1);
            float f = (float)Math.sqrt(d4);
            float f3 = (float)Math.sqrt(1.0 - d4);
            Vector3 vector3 = new Vector3((float)Math.cos(d3) * f, (float)Math.sin(d3) * f, f3);
            vector3 = orthoNormalBasis.transform(vector3, new Vector3());
            shadingState.traceDiffusePhoton(new Ray(shadingState.getPoint(), vector3), color);
        }
    }

    public int getNumSamples() {
        return this.samples;
    }

    public void getSamples(ShadingState shadingState) {
        if (this.lightBounds.contains(shadingState.getPoint()) && shadingState.getPoint().z < this.maxZ) {
            int n = shadingState.getDiffuseDepth() > 0 ? 1 : this.samples;
            float f = this.area / (float)n;
            for (int i = 0; i < n; ++i) {
                double d = shadingState.getRandom(i, 0);
                double d2 = shadingState.getRandom(i, 1);
                Point3 point3 = new Point3();
                point3.x = (float)((double)this.lxmin * (1.0 - d) + (double)this.lxmax * d);
                point3.y = (float)((double)this.lymin * (1.0 - d2) + (double)this.lymax * d2);
                point3.z = this.maxZ - 0.001f;
                LightSample lightSample = new LightSample();
                lightSample.setShadowRay(new Ray(shadingState.getPoint(), point3));
                float f2 = lightSample.dot(shadingState.getNormal());
                if (f2 <= 0.0f) {
                    return;
                }
                float f3 = lightSample.getShadowRay().dz;
                if (!(f3 > 0.0f)) continue;
                float f4 = lightSample.getShadowRay().getMax();
                float f5 = f3 / (f4 * f4);
                float f6 = f5 * f;
                lightSample.setRadiance(this.radiance, this.radiance);
                lightSample.getDiffuseRadiance().mul(f6);
                lightSample.getSpecularRadiance().mul(f6);
                lightSample.traceShadow(shadingState);
                shadingState.addSample(lightSample);
            }
        }
    }

    public void getPhoton(double d, double d2, double d3, double d4, Point3 point3, Vector3 vector3, Color color) {
        point3.x = (float)((double)this.lxmin * (1.0 - d3) + (double)this.lxmax * d3);
        point3.y = (float)((double)this.lymin * (1.0 - d4) + (double)this.lymax * d4);
        point3.z = this.maxZ - 0.001f;
        double d5 = Math.PI * 2 * d;
        double d6 = Math.sqrt(d2);
        vector3.set((float)(Math.cos(d5) * d6), (float)(Math.sin(d5) * d6), (float)(-Math.sqrt(1.0 - d2)));
        Color.mul((float)Math.PI * this.area, this.radiance, color);
    }

    public float getPower() {
        return this.radiance.copy().mul((float)Math.PI * this.area).getLuminance();
    }

    public int getNumPrimitives() {
        return 1;
    }

    public float getPrimitiveBound(int n, int n2) {
        switch (n2) {
            case 0: {
                return this.minX;
            }
            case 1: {
                return this.maxX;
            }
            case 2: {
                return this.minY;
            }
            case 3: {
                return this.maxY;
            }
            case 4: {
                return this.minZ;
            }
            case 5: {
                return this.maxZ;
            }
        }
        return 0.0f;
    }

    public BoundingBox getWorldBounds(Matrix4 matrix4) {
        BoundingBox boundingBox = new BoundingBox(this.minX, this.minY, this.minZ);
        boundingBox.include(this.maxX, this.maxY, this.maxZ);
        if (matrix4 == null) {
            return boundingBox;
        }
        return matrix4.transform(boundingBox);
    }

    public PrimitiveList getBakingPrimitives() {
        return null;
    }
}

