/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core.primitive;

import org.sunflow.SunflowAPI;
import org.sunflow.core.IntersectionState;
import org.sunflow.core.ParameterList;
import org.sunflow.core.PrimitiveList;
import org.sunflow.core.Ray;
import org.sunflow.core.ShadingState;
import org.sunflow.math.BoundingBox;
import org.sunflow.math.Matrix4;
import org.sunflow.math.OrthoNormalBasis;
import org.sunflow.math.Vector3;

public class Box
implements PrimitiveList {
    private float minX = -1.0f;
    private float minY = -1.0f;
    private float minZ = -1.0f;
    private float maxX = 1.0f;
    private float maxY = 1.0f;
    private float maxZ = 1.0f;

    public boolean update(ParameterList parameterList, SunflowAPI sunflowAPI) {
        ParameterList.FloatParameter floatParameter = parameterList.getPointArray("points");
        if (floatParameter != null) {
            BoundingBox boundingBox = new BoundingBox();
            for (int i = 0; i < floatParameter.data.length; i += 3) {
                boundingBox.include(floatParameter.data[i], floatParameter.data[i + 1], floatParameter.data[i + 2]);
            }
            this.minX = boundingBox.getMinimum().x;
            this.minY = boundingBox.getMinimum().y;
            this.minZ = boundingBox.getMinimum().z;
            this.maxX = boundingBox.getMaximum().x;
            this.maxY = boundingBox.getMaximum().y;
            this.maxZ = boundingBox.getMaximum().z;
        }
        return true;
    }

    public void prepareShadingState(ShadingState shadingState) {
        shadingState.init();
        shadingState.getRay().getPoint(shadingState.getPoint());
        int n = shadingState.getPrimitiveID();
        switch (n) {
            case 0: {
                shadingState.getNormal().set(new Vector3(1.0f, 0.0f, 0.0f));
                break;
            }
            case 1: {
                shadingState.getNormal().set(new Vector3(-1.0f, 0.0f, 0.0f));
                break;
            }
            case 2: {
                shadingState.getNormal().set(new Vector3(0.0f, 1.0f, 0.0f));
                break;
            }
            case 3: {
                shadingState.getNormal().set(new Vector3(0.0f, -1.0f, 0.0f));
                break;
            }
            case 4: {
                shadingState.getNormal().set(new Vector3(0.0f, 0.0f, 1.0f));
                break;
            }
            case 5: {
                shadingState.getNormal().set(new Vector3(0.0f, 0.0f, -1.0f));
                break;
            }
            default: {
                shadingState.getNormal().set(new Vector3(0.0f, 0.0f, 0.0f));
            }
        }
        shadingState.getGeoNormal().set(shadingState.getNormal());
        shadingState.setBasis(OrthoNormalBasis.makeFromW(shadingState.getNormal()));
        shadingState.setShader(shadingState.getInstance().getShader(0));
        shadingState.setModifier(shadingState.getInstance().getModifier(0));
    }

    public void intersectPrimitive(Ray ray, int n, IntersectionState intersectionState) {
        float f = Float.NEGATIVE_INFINITY;
        float f2 = Float.POSITIVE_INFINITY;
        float f3 = ray.ox;
        float f4 = 1.0f / ray.dx;
        float f5 = (this.minX - f3) * f4;
        float f6 = (this.maxX - f3) * f4;
        int n2 = -1;
        int n3 = -1;
        if (f4 > 0.0f) {
            if (f5 > f) {
                f = f5;
                n2 = 0;
            }
            if (f6 < f2) {
                f2 = f6;
                n3 = 1;
            }
        } else {
            if (f6 > f) {
                f = f6;
                n2 = 1;
            }
            if (f5 < f2) {
                f2 = f5;
                n3 = 0;
            }
        }
        if (f > f2) {
            return;
        }
        float f7 = ray.oy;
        float f8 = 1.0f / ray.dy;
        f5 = (this.minY - f7) * f8;
        f6 = (this.maxY - f7) * f8;
        if (f8 > 0.0f) {
            if (f5 > f) {
                f = f5;
                n2 = 2;
            }
            if (f6 < f2) {
                f2 = f6;
                n3 = 3;
            }
        } else {
            if (f6 > f) {
                f = f6;
                n2 = 3;
            }
            if (f5 < f2) {
                f2 = f5;
                n3 = 2;
            }
        }
        if (f > f2) {
            return;
        }
        float f9 = ray.oz;
        float f10 = 1.0f / ray.dz;
        f5 = (this.minZ - f9) * f10;
        f6 = (this.maxZ - f9) * f10;
        if (f10 > 0.0f) {
            if (f5 > f) {
                f = f5;
                n2 = 4;
            }
            if (f6 < f2) {
                f2 = f6;
                n3 = 5;
            }
        } else {
            if (f6 > f) {
                f = f6;
                n2 = 5;
            }
            if (f5 < f2) {
                f2 = f5;
                n3 = 4;
            }
        }
        if (f > f2) {
            return;
        }
        if (ray.isInside(f)) {
            ray.setMax(f);
            intersectionState.setIntersection(n2, 0.0f, 0.0f);
        } else if (ray.isInside(f2)) {
            ray.setMax(f2);
            intersectionState.setIntersection(n3, 0.0f, 0.0f);
        }
    }

    public int getNumPrimitives() {
        return 1;
    }

    public float getPrimitiveBound(int n, int n2) {
        switch (n2) {
            case 0: {
                return this.minX;
            }
            case 1: {
                return this.maxX;
            }
            case 2: {
                return this.minY;
            }
            case 3: {
                return this.maxY;
            }
            case 4: {
                return this.minZ;
            }
            case 5: {
                return this.maxZ;
            }
        }
        return 0.0f;
    }

    public BoundingBox getWorldBounds(Matrix4 matrix4) {
        BoundingBox boundingBox = new BoundingBox(this.minX, this.minY, this.minZ);
        boundingBox.include(this.maxX, this.maxY, this.maxZ);
        if (matrix4 == null) {
            return boundingBox;
        }
        return matrix4.transform(boundingBox);
    }

    public PrimitiveList getBakingPrimitives() {
        return null;
    }
}

