/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core.primitive;

import org.sunflow.SunflowAPI;
import org.sunflow.core.Instance;
import org.sunflow.core.IntersectionState;
import org.sunflow.core.ParameterList;
import org.sunflow.core.PrimitiveList;
import org.sunflow.core.Ray;
import org.sunflow.core.ShadingState;
import org.sunflow.math.BoundingBox;
import org.sunflow.math.Matrix4;
import org.sunflow.math.OrthoNormalBasis;
import org.sunflow.math.Point3;
import org.sunflow.math.Solvers;
import org.sunflow.math.Vector3;

public class BanchoffSurface
implements PrimitiveList {
    public boolean update(ParameterList parameterList, SunflowAPI sunflowAPI) {
        return true;
    }

    public BoundingBox getWorldBounds(Matrix4 matrix4) {
        BoundingBox boundingBox = new BoundingBox(1.5f);
        if (matrix4 != null) {
            boundingBox = matrix4.transform(boundingBox);
        }
        return boundingBox;
    }

    public float getPrimitiveBound(int n, int n2) {
        return (n2 & 1) == 0 ? -1.5f : 1.5f;
    }

    public int getNumPrimitives() {
        return 1;
    }

    public void prepareShadingState(ShadingState shadingState) {
        shadingState.init();
        shadingState.getRay().getPoint(shadingState.getPoint());
        Instance instance = shadingState.getInstance();
        Point3 point3 = instance.transformWorldToObject(shadingState.getPoint());
        shadingState.getNormal().set(point3.x * (2.0f * point3.x * point3.x - 1.0f), point3.y * (2.0f * point3.y * point3.y - 1.0f), point3.z * (2.0f * point3.z * point3.z - 1.0f));
        shadingState.getNormal().normalize();
        shadingState.setShader(instance.getShader(0));
        shadingState.setModifier(instance.getModifier(0));
        Vector3 vector3 = instance.transformNormalObjectToWorld(shadingState.getNormal());
        shadingState.getNormal().set(vector3);
        shadingState.getNormal().normalize();
        shadingState.getGeoNormal().set(shadingState.getNormal());
        shadingState.setBasis(OrthoNormalBasis.makeFromW(shadingState.getNormal()));
    }

    public void intersectPrimitive(Ray ray, int n, IntersectionState intersectionState) {
        float f = ray.dy * ray.dy;
        float f2 = ray.dz * ray.dz;
        float f3 = ray.dx * ray.dx;
        double d = f * f + f2 * f2 + f3 * f3;
        double d2 = 4.0f * (ray.oy * f * ray.dy + ray.oz * ray.dz * f2 + ray.ox * ray.dx * f3);
        float f4 = ray.oy * ray.oy;
        float f5 = ray.oz * ray.oz;
        float f6 = ray.ox * ray.ox;
        double d3 = -f3 - f - f2 + 6.0f * (f4 * f + f5 * f2 + f6 * f3);
        double d4 = 2.0f * (2.0f * f5 * ray.oz * ray.dz - ray.oz * ray.dz + 2.0f * f6 * ray.ox * ray.dx + 2.0f * f4 * ray.oy * ray.dy - ray.ox * ray.dx - ray.oy * ray.dy);
        double d5 = 0.375f + (-f5 + f5 * f5 - f4 + f4 * f4 - f6 + f6 * f6);
        double[] dArray = Solvers.solveQuartic(d, d2, d3, d4, d5);
        if (dArray != null) {
            if (dArray[0] >= (double)ray.getMax() || dArray[dArray.length - 1] <= (double)ray.getMin()) {
                return;
            }
            for (int i = 0; i < dArray.length; ++i) {
                if (!(dArray[i] > (double)ray.getMin())) continue;
                ray.setMax((float)dArray[i]);
                intersectionState.setIntersection(0, 0.0f, 0.0f);
                return;
            }
        }
    }

    public PrimitiveList getBakingPrimitives() {
        return null;
    }
}

