/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core.photonmap;

import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.sunflow.core.GlobalPhotonMapInterface;
import org.sunflow.core.ShadingState;
import org.sunflow.image.Color;
import org.sunflow.math.BoundingBox;
import org.sunflow.math.MathUtils;
import org.sunflow.math.Point3;
import org.sunflow.math.Vector3;
import org.sunflow.system.UI;

public class GridPhotonMap
implements GlobalPhotonMapInterface {
    private int numGather;
    private float gatherRadius;
    private int numStoredPhotons;
    private int nx;
    private int ny;
    private int nz;
    private BoundingBox bounds;
    private PhotonGroup[] cellHash;
    private int hashSize;
    private int hashPrime;
    private ReentrantReadWriteLock rwl;
    private int numEmit;
    private static final float NORMAL_THRESHOLD = (float)Math.cos(0.17453292519943295);
    private static final int[] PRIMES = new int[]{11, 19, 37, 109, 163, 251, 367, 557, 823, 1237, 1861, 2777, 4177, 6247, 9371, 21089, 31627, 47431, 71143, 106721, 160073, 240101, 360163, 540217, 810343, 1215497, 1823231, 2734867, 4102283, 6153409, 9230113, 13845163};

    public GridPhotonMap(int n, int n2, float f) {
        this.numEmit = n;
        this.numGather = n2;
        this.gatherRadius = f;
        this.numStoredPhotons = 0;
        this.hashSize = 0;
        this.rwl = new ReentrantReadWriteLock();
        n = 100000;
    }

    public void prepare(BoundingBox boundingBox) {
        this.bounds = new BoundingBox(boundingBox);
        this.bounds.enlargeUlps();
        Vector3 vector3 = this.bounds.getExtents();
        this.nx = (int)Math.max(vector3.x / this.gatherRadius + 0.5f, 1.0f);
        this.ny = (int)Math.max(vector3.y / this.gatherRadius + 0.5f, 1.0f);
        this.nz = (int)Math.max(vector3.z / this.gatherRadius + 0.5f, 1.0f);
        int n = this.nx * this.ny * this.nz;
        UI.printInfo(UI.Module.LIGHT, "Initializing grid photon map:", new Object[0]);
        UI.printInfo(UI.Module.LIGHT, "  * Resolution:  %dx%dx%d", this.nx, this.ny, this.nz);
        UI.printInfo(UI.Module.LIGHT, "  * Total cells: %d", n);
        this.hashPrime = 0;
        while (this.hashPrime < PRIMES.length && PRIMES[this.hashPrime] <= n / 5) {
            ++this.hashPrime;
        }
        this.cellHash = new PhotonGroup[PRIMES[this.hashPrime]];
        UI.printInfo(UI.Module.LIGHT, "  * Initial hash size: %d", this.cellHash.length);
    }

    public int size() {
        return this.numStoredPhotons;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(ShadingState shadingState, Vector3 vector3, Color color, Color color2) {
        if (Vector3.dot(shadingState.getNormal(), vector3) > 0.0f) {
            return;
        }
        Point3 point3 = shadingState.getPoint();
        if (!this.bounds.contains(point3)) {
            return;
        }
        Vector3 vector32 = this.bounds.getExtents();
        int n = (int)((point3.x - this.bounds.getMinimum().x) * (float)this.nx / vector32.x);
        int n2 = (int)((point3.y - this.bounds.getMinimum().y) * (float)this.ny / vector32.y);
        int n3 = (int)((point3.z - this.bounds.getMinimum().z) * (float)this.nz / vector32.z);
        n = MathUtils.clamp(n, 0, this.nx - 1);
        n2 = MathUtils.clamp(n2, 0, this.ny - 1);
        n3 = MathUtils.clamp(n3, 0, this.nz - 1);
        int n4 = n + n2 * this.nx + n3 * this.nx * this.ny;
        GridPhotonMap gridPhotonMap = this;
        synchronized (gridPhotonMap) {
            int n5 = n4 % this.cellHash.length;
            PhotonGroup photonGroup = this.cellHash[n5];
            PhotonGroup photonGroup2 = null;
            boolean bl = false;
            while (photonGroup != null) {
                if (photonGroup.id == n4) {
                    bl = true;
                    if (Vector3.dot(shadingState.getNormal(), photonGroup.normal) > NORMAL_THRESHOLD) break;
                }
                photonGroup2 = photonGroup;
                photonGroup = photonGroup.next;
            }
            if (photonGroup == null) {
                photonGroup = new PhotonGroup(n4, shadingState.getNormal());
                if (photonGroup2 == null) {
                    this.cellHash[n5] = photonGroup;
                } else {
                    photonGroup2.next = photonGroup;
                }
                if (!bl) {
                    ++this.hashSize;
                    if (this.hashSize > this.cellHash.length) {
                        this.growPhotonHash();
                    }
                }
            }
            ++photonGroup.count;
            photonGroup.flux.add(color);
            photonGroup.diffuse.add(color2);
            ++this.numStoredPhotons;
        }
    }

    public void init() {
        UI.printInfo(UI.Module.LIGHT, "Initializing photon grid ...", new Object[0]);
        UI.printInfo(UI.Module.LIGHT, "  * Photon hits:      %d", this.numStoredPhotons);
        UI.printInfo(UI.Module.LIGHT, "  * Final hash size:  %d", this.cellHash.length);
        int n = 0;
        for (int i = 0; i < this.cellHash.length; ++i) {
            PhotonGroup photonGroup = this.cellHash[i];
            while (photonGroup != null) {
                photonGroup.diffuse.mul(1.0f / (float)photonGroup.count);
                ++n;
                photonGroup = photonGroup.next;
            }
        }
        UI.printInfo(UI.Module.LIGHT, "  * Num photon cells: %d", n);
    }

    public void precomputeRadiance(boolean bl, boolean bl2) {
    }

    private void growPhotonHash() {
        if (this.hashPrime >= PRIMES.length - 1) {
            return;
        }
        PhotonGroup[] photonGroupArray = new PhotonGroup[PRIMES[++this.hashPrime]];
        for (int i = 0; i < this.cellHash.length; ++i) {
            PhotonGroup photonGroup = this.cellHash[i];
            while (photonGroup != null) {
                int n = photonGroup.id % photonGroupArray.length;
                PhotonGroup photonGroup2 = null;
                PhotonGroup photonGroup3 = photonGroupArray[n];
                while (photonGroup3 != null) {
                    photonGroup2 = photonGroup3;
                    photonGroup3 = photonGroup3.next;
                }
                if (photonGroup2 == null) {
                    photonGroupArray[n] = photonGroup;
                } else {
                    photonGroup2.next = photonGroup;
                }
                photonGroup3 = photonGroup.next;
                photonGroup.next = null;
                photonGroup = photonGroup3;
            }
        }
        this.cellHash = photonGroupArray;
    }

    public synchronized Color getRadiance(Point3 point3, Vector3 vector3) {
        if (!this.bounds.contains(point3)) {
            return Color.BLACK;
        }
        Vector3 vector32 = this.bounds.getExtents();
        int n = (int)((point3.x - this.bounds.getMinimum().x) * (float)this.nx / vector32.x);
        int n2 = (int)((point3.y - this.bounds.getMinimum().y) * (float)this.ny / vector32.y);
        int n3 = (int)((point3.z - this.bounds.getMinimum().z) * (float)this.nz / vector32.z);
        n = MathUtils.clamp(n, 0, this.nx - 1);
        n2 = MathUtils.clamp(n2, 0, this.ny - 1);
        n3 = MathUtils.clamp(n3, 0, this.nz - 1);
        int n4 = n + n2 * this.nx + n3 * this.nx * this.ny;
        this.rwl.readLock().lock();
        PhotonGroup photonGroup = null;
        PhotonGroup photonGroup2 = this.get(n, n2, n3);
        while (photonGroup2 != null) {
            if (photonGroup2.id == n4 && Vector3.dot(vector3, photonGroup2.normal) > NORMAL_THRESHOLD) {
                if (photonGroup2.radiance == null) {
                    photonGroup = photonGroup2;
                    break;
                }
                Color color = photonGroup2.radiance.copy();
                this.rwl.readLock().unlock();
                return color;
            }
            photonGroup2 = photonGroup2.next;
        }
        int n5 = 1;
        while (true) {
            int n6 = 0;
            int n7 = 0;
            Color color = Color.black();
            Color color2 = photonGroup == null ? Color.black() : null;
            for (int i = n3 - (n5 - 1); i <= n3 + (n5 - 1); ++i) {
                for (int j = n2 - (n5 - 1); j <= n2 + (n5 - 1); ++j) {
                    block4: for (int k = n - (n5 - 1); k <= n + (n5 - 1); ++k) {
                        int n8 = k + j * this.nx + i * this.nx * this.ny;
                        PhotonGroup photonGroup3 = this.get(k, j, i);
                        while (photonGroup3 != null) {
                            if (photonGroup3.id == n8 && Vector3.dot(vector3, photonGroup3.normal) > NORMAL_THRESHOLD) {
                                n6 += photonGroup3.count;
                                color.add(photonGroup3.flux);
                                if (color2 == null) continue block4;
                                color2.add(photonGroup3.diffuse);
                                ++n7;
                                continue block4;
                            }
                            photonGroup3 = photonGroup3.next;
                        }
                    }
                }
            }
            if (n6 >= this.numGather || n5 >= 3) {
                float f = (float)(2 * n5 - 1) / 3.0f * (vector32.x / (float)this.nx + vector32.y / (float)this.ny + vector32.z / (float)this.nz);
                f *= f;
                f = (float)((double)f * Math.PI);
                color.mul(1.0f / f);
                this.rwl.readLock().unlock();
                this.rwl.writeLock().lock();
                if (photonGroup == null) {
                    if (n7 > 0) {
                        color2.mul(1.0f / (float)n7);
                    }
                    photonGroup = new PhotonGroup(n4, vector3);
                    photonGroup.diffuse.set(color2);
                    photonGroup.next = this.cellHash[n4 % this.cellHash.length];
                    this.cellHash[n4 % this.cellHash.length] = photonGroup;
                }
                color.mul(photonGroup.diffuse);
                photonGroup.radiance = color.copy();
                this.rwl.writeLock().unlock();
                return color;
            }
            ++n5;
        }
    }

    private PhotonGroup get(int n, int n2, int n3) {
        if (n < 0 || n >= this.nx) {
            return null;
        }
        if (n2 < 0 || n2 >= this.ny) {
            return null;
        }
        if (n3 < 0 || n3 >= this.nz) {
            return null;
        }
        return this.cellHash[(n + n2 * this.nx + n3 * this.nx * this.ny) % this.cellHash.length];
    }

    public boolean allowDiffuseBounced() {
        return true;
    }

    public boolean allowReflectionBounced() {
        return true;
    }

    public boolean allowRefractionBounced() {
        return true;
    }

    public int numEmit() {
        return this.numEmit;
    }

    private class PhotonGroup {
        int id;
        int count;
        Vector3 normal;
        Color flux;
        Color radiance;
        Color diffuse;
        PhotonGroup next;

        PhotonGroup(int n, Vector3 vector3) {
            this.normal = new Vector3(vector3);
            this.flux = Color.black();
            this.diffuse = Color.black();
            this.radiance = null;
            this.count = 0;
            this.id = n;
            this.next = null;
        }
    }
}

