/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core.parser;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.sunflow.SunflowAPI;
import org.sunflow.core.SceneParser;
import org.sunflow.core.primitive.TriangleMesh;
import org.sunflow.core.shader.SimpleShader;
import org.sunflow.system.Parser;
import org.sunflow.system.UI;

public class TriParser
implements SceneParser {
    public boolean parse(String string, SunflowAPI sunflowAPI) {
        try {
            int n;
            UI.printInfo(UI.Module.USER, "TRI - Reading geometry: \"%s\" ...", string);
            Parser parser = new Parser(string);
            float[] fArray = new float[3 * parser.getNextInt()];
            for (int i = 0; i < fArray.length; i += 3) {
                fArray[i + 0] = parser.getNextFloat();
                fArray[i + 1] = parser.getNextFloat();
                fArray[i + 2] = parser.getNextFloat();
                parser.getNextToken();
                parser.getNextToken();
            }
            int[] nArray = new int[parser.getNextInt() * 3];
            for (int i = 0; i < nArray.length; i += 3) {
                nArray[i + 0] = parser.getNextInt();
                nArray[i + 1] = parser.getNextInt();
                nArray[i + 2] = parser.getNextInt();
            }
            sunflowAPI.parameter("triangles", nArray);
            sunflowAPI.parameter("points", "point", "vertex", fArray);
            sunflowAPI.geometry(string, new TriangleMesh());
            sunflowAPI.shader(string + ".shader", new SimpleShader());
            sunflowAPI.parameter("shaders", string + ".shader");
            sunflowAPI.instance(string + ".instance", string);
            parser.close();
            RandomAccessFile randomAccessFile = new RandomAccessFile(string.replace(".tri", ".ra3"), "rw");
            MappedByteBuffer mappedByteBuffer = randomAccessFile.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, 8 + 4 * (fArray.length + nArray.length));
            mappedByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer = mappedByteBuffer.asIntBuffer();
            FloatBuffer floatBuffer = mappedByteBuffer.asFloatBuffer();
            intBuffer.put(0, fArray.length / 3);
            intBuffer.put(1, nArray.length / 3);
            for (n = 0; n < fArray.length; ++n) {
                floatBuffer.put(2 + n, fArray[n]);
            }
            for (n = 0; n < nArray.length; ++n) {
                intBuffer.put(2 + fArray.length + n, nArray[n]);
            }
            randomAccessFile.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return false;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        return true;
    }
}

