/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core.parser;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.sunflow.SunflowAPI;
import org.sunflow.core.SceneParser;
import org.sunflow.core.primitive.Hair;
import org.sunflow.system.Parser;
import org.sunflow.system.UI;
import org.sunflow.util.FloatArray;
import org.sunflow.util.IntArray;

public class ShaveRibParser
implements SceneParser {
    public boolean parse(String string, SunflowAPI sunflowAPI) {
        try {
            Parser parser = new Parser(string);
            parser.checkNextToken("version");
            parser.checkNextToken("3.04");
            parser.checkNextToken("TransformBegin");
            if (parser.peekNextToken("Procedural")) {
                boolean bl = false;
                block4: while (!bl) {
                    String string2;
                    parser.checkNextToken("DelayedReadArchive");
                    parser.checkNextToken("[");
                    String string3 = parser.getNextToken();
                    UI.printInfo(UI.Module.USER, "RIB - Reading voxel: \"%s\" ...", string3);
                    sunflowAPI.parse(string3);
                    parser.checkNextToken("]");
                    do {
                        if ((string2 = parser.getNextToken()) != null && !string2.equals("TransformEnd")) continue;
                        bl = true;
                        continue block4;
                    } while (!string2.equals("Procedural"));
                }
                return true;
            }
            boolean bl = false;
            if (parser.peekNextToken("Basis")) {
                bl = true;
                parser.checkNextToken("catmull-rom");
                parser.checkNextToken("1");
                parser.checkNextToken("catmull-rom");
                parser.checkNextToken("1");
            }
            while (parser.peekNextToken("Declare")) {
                parser.getNextToken();
                parser.getNextToken();
            }
            int n = 0;
            boolean bl2 = false;
            parser.checkNextToken("Curves");
            do {
                String string4;
                int n2;
                if (bl) {
                    parser.checkNextToken("cubic");
                } else {
                    parser.checkNextToken("linear");
                }
                int[] nArray = this.parseIntArray(parser);
                for (n2 = 1; n2 < nArray.length; ++n2) {
                    if (nArray[0] == nArray[n2]) continue;
                    UI.printError(UI.Module.USER, "RIB - Found variable number of hair segments", new Object[0]);
                    return false;
                }
                n2 = nArray.length;
                UI.printInfo(UI.Module.USER, "RIB - Parsed %d hair curves", n2);
                sunflowAPI.parameter("segments", nArray[0] - 1);
                parser.checkNextToken("nonperiodic");
                parser.checkNextToken("P");
                float[] fArray = this.parseFloatArray(parser);
                if (fArray.length != 3 * n2 * nArray[0]) {
                    UI.printError(UI.Module.USER, "RIB - Invalid number of points - expecting %d - found %d", n2 * nArray[0], fArray.length / 3);
                    return false;
                }
                sunflowAPI.parameter("points", "point", "vertex", fArray);
                UI.printInfo(UI.Module.USER, "RIB - Parsed %d hair vertices", fArray.length / 3);
                parser.checkNextToken("width");
                float[] fArray2 = this.parseFloatArray(parser);
                if (fArray2.length != n2 * nArray[0]) {
                    UI.printError(UI.Module.USER, "RIB - Invalid number of hair widths - expecting %d - found %d", n2 * nArray[0], fArray2.length);
                    return false;
                }
                sunflowAPI.parameter("widths", "float", "vertex", fArray2);
                UI.printInfo(UI.Module.USER, "RIB - Parsed %d hair widths", fArray2.length);
                String string5 = String.format("%s[%d]", string, n);
                UI.printInfo(UI.Module.USER, "RIB - Creating hair object \"%s\"", string5);
                sunflowAPI.geometry(string5, new Hair());
                sunflowAPI.instance(string5 + ".instance", string5);
                UI.printInfo(UI.Module.USER, "RIB - Searching for next curve group ...", new Object[0]);
                do {
                    if ((string4 = parser.getNextToken()) != null && !string4.equals("TransformEnd")) continue;
                    bl2 = true;
                    break;
                } while (!string4.equals("Curves"));
                ++n;
            } while (!bl2);
            UI.printInfo(UI.Module.USER, "RIB - Finished reading rib file", new Object[0]);
        }
        catch (FileNotFoundException fileNotFoundException) {
            UI.printError(UI.Module.USER, "RIB - File not found: %s", string);
            fileNotFoundException.printStackTrace();
            return false;
        }
        catch (Parser.ParserException parserException) {
            UI.printError(UI.Module.USER, "RIB - Parser exception: %s", parserException);
            parserException.printStackTrace();
            return false;
        }
        catch (IOException iOException) {
            UI.printError(UI.Module.USER, "RIB - I/O exception: %s", iOException);
            iOException.printStackTrace();
            return false;
        }
        return true;
    }

    private int[] parseIntArray(Parser parser) throws IOException {
        IntArray intArray = new IntArray();
        boolean bl = false;
        do {
            String string;
            if ((string = parser.getNextToken()).startsWith("[")) {
                string = string.substring(1);
            }
            if (string.endsWith("]")) {
                string = string.substring(0, string.length() - 1);
                bl = true;
            }
            intArray.add(Integer.parseInt(string));
        } while (!bl);
        return intArray.trim();
    }

    private float[] parseFloatArray(Parser parser) throws IOException {
        FloatArray floatArray = new FloatArray();
        boolean bl = false;
        do {
            String string;
            if ((string = parser.getNextToken()).startsWith("[")) {
                string = string.substring(1);
            }
            if (string.endsWith("]")) {
                string = string.substring(0, string.length() - 1);
                bl = true;
            }
            floatArray.add(Float.parseFloat(string));
        } while (!bl);
        return floatArray.trim();
    }
}

