/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringReader;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.codehaus.janino.ClassBodyEvaluator;
import org.codehaus.janino.CompileException;
import org.codehaus.janino.Parser;
import org.codehaus.janino.Scanner;
import org.sunflow.SunflowAPI;
import org.sunflow.core.SceneParser;
import org.sunflow.core.Shader;
import org.sunflow.core.Tesselatable;
import org.sunflow.core.camera.FisheyeLens;
import org.sunflow.core.camera.PinholeLens;
import org.sunflow.core.camera.SphericalLens;
import org.sunflow.core.camera.ThinLens;
import org.sunflow.core.light.DirectionalSpotlight;
import org.sunflow.core.light.ImageBasedLight;
import org.sunflow.core.light.PointLight;
import org.sunflow.core.light.SphereLight;
import org.sunflow.core.light.SunSkyLight;
import org.sunflow.core.light.TriangleMeshLight;
import org.sunflow.core.modifiers.BumpMappingModifier;
import org.sunflow.core.modifiers.NormalMapModifier;
import org.sunflow.core.primitive.Background;
import org.sunflow.core.primitive.BanchoffSurface;
import org.sunflow.core.primitive.CornellBox;
import org.sunflow.core.primitive.Hair;
import org.sunflow.core.primitive.JuliaFractal;
import org.sunflow.core.primitive.ParticleSurface;
import org.sunflow.core.primitive.Plane;
import org.sunflow.core.primitive.Sphere;
import org.sunflow.core.primitive.Torus;
import org.sunflow.core.primitive.TriangleMesh;
import org.sunflow.core.shader.AmbientOcclusionShader;
import org.sunflow.core.shader.AnisotropicWardShader;
import org.sunflow.core.shader.ConstantShader;
import org.sunflow.core.shader.DiffuseShader;
import org.sunflow.core.shader.GlassShader;
import org.sunflow.core.shader.IDShader;
import org.sunflow.core.shader.MirrorShader;
import org.sunflow.core.shader.PhongShader;
import org.sunflow.core.shader.ShinyDiffuseShader;
import org.sunflow.core.shader.TexturedAmbientOcclusionShader;
import org.sunflow.core.shader.TexturedDiffuseShader;
import org.sunflow.core.shader.TexturedPhongShader;
import org.sunflow.core.shader.TexturedShinyDiffuseShader;
import org.sunflow.core.shader.TexturedWardShader;
import org.sunflow.core.shader.UberShader;
import org.sunflow.core.shader.ViewCausticsShader;
import org.sunflow.core.shader.ViewGlobalPhotonsShader;
import org.sunflow.core.shader.ViewIrradianceShader;
import org.sunflow.core.tesselatable.BezierMesh;
import org.sunflow.core.tesselatable.FileMesh;
import org.sunflow.core.tesselatable.Gumbo;
import org.sunflow.core.tesselatable.Teapot;
import org.sunflow.image.Color;
import org.sunflow.math.Matrix4;
import org.sunflow.math.Point3;
import org.sunflow.math.Vector3;
import org.sunflow.system.Parser;
import org.sunflow.system.Timer;
import org.sunflow.system.UI;

public class SCParser
implements SceneParser {
    private Parser p;
    private int numLightSamples;

    public boolean parse(String string, SunflowAPI sunflowAPI) {
        String string2 = new File(string).getAbsoluteFile().getParentFile().getAbsolutePath();
        this.numLightSamples = 1;
        Timer timer = new Timer();
        timer.start();
        UI.printInfo(UI.Module.API, "Parsing \"%s\" ...", string);
        try {
            String string3;
            this.p = new Parser(string);
            while ((string3 = this.p.getNextToken()) != null) {
                String string4;
                if (string3.equals("image")) {
                    UI.printInfo(UI.Module.API, "Reading image settings ...", new Object[0]);
                    this.parseImageBlock(sunflowAPI);
                    continue;
                }
                if (string3.equals("background")) {
                    UI.printInfo(UI.Module.API, "Reading background ...", new Object[0]);
                    this.parseBackgroundBlock(sunflowAPI);
                    continue;
                }
                if (string3.equals("accel")) {
                    UI.printInfo(UI.Module.API, "Reading accelerator type ...", new Object[0]);
                    this.p.getNextToken();
                    UI.printWarning(UI.Module.API, "Setting accelerator type is not recommended - ignoring", new Object[0]);
                    continue;
                }
                if (string3.equals("filter")) {
                    UI.printInfo(UI.Module.API, "Reading image filter type ...", new Object[0]);
                    this.parseFilter(sunflowAPI);
                    continue;
                }
                if (string3.equals("bucket")) {
                    UI.printInfo(UI.Module.API, "Reading bucket settings ...", new Object[0]);
                    sunflowAPI.parameter("bucket.size", this.p.getNextInt());
                    sunflowAPI.parameter("bucket.order", this.p.getNextToken());
                    sunflowAPI.options("::options");
                    continue;
                }
                if (string3.equals("photons")) {
                    UI.printInfo(UI.Module.API, "Reading photon settings ...", new Object[0]);
                    this.parsePhotonBlock(sunflowAPI);
                    continue;
                }
                if (string3.equals("gi")) {
                    UI.printInfo(UI.Module.API, "Reading global illumination settings ...", new Object[0]);
                    this.parseGIBlock(sunflowAPI);
                    continue;
                }
                if (string3.equals("lightserver")) {
                    UI.printInfo(UI.Module.API, "Reading light server settings ...", new Object[0]);
                    this.parseLightserverBlock(sunflowAPI);
                    continue;
                }
                if (string3.equals("trace-depths")) {
                    UI.printInfo(UI.Module.API, "Reading trace depths ...", new Object[0]);
                    this.parseTraceBlock(sunflowAPI);
                    continue;
                }
                if (string3.equals("camera")) {
                    this.parseCamera(sunflowAPI);
                    continue;
                }
                if (string3.equals("shader")) {
                    if (this.parseShader(sunflowAPI)) continue;
                    return false;
                }
                if (string3.equals("modifier")) {
                    if (this.parseModifier(sunflowAPI)) continue;
                    return false;
                }
                if (string3.equals("override")) {
                    sunflowAPI.shaderOverride(this.p.getNextToken(), this.p.getNextBoolean());
                    continue;
                }
                if (string3.equals("object")) {
                    this.parseObjectBlock(sunflowAPI);
                    continue;
                }
                if (string3.equals("instance")) {
                    this.parseInstanceBlock(sunflowAPI);
                    continue;
                }
                if (string3.equals("light")) {
                    this.parseLightBlock(sunflowAPI);
                    continue;
                }
                if (string3.equals("texturepath")) {
                    string4 = this.p.getNextToken();
                    if (!new File(string4).isAbsolute()) {
                        string4 = string2 + File.separator + string4;
                    }
                    sunflowAPI.addTextureSearchPath(string4);
                    continue;
                }
                if (string3.equals("includepath")) {
                    string4 = this.p.getNextToken();
                    if (!new File(string4).isAbsolute()) {
                        string4 = string2 + File.separator + string4;
                    }
                    sunflowAPI.addIncludeSearchPath(string4);
                    continue;
                }
                if (string3.equals("include")) {
                    string4 = this.p.getNextToken();
                    UI.printInfo(UI.Module.API, "Including: \"%s\" ...", string4);
                    sunflowAPI.parse(string4);
                    continue;
                }
                UI.printWarning(UI.Module.API, "Unrecognized token %s", string3);
            }
            this.p.close();
        }
        catch (Parser.ParserException parserException) {
            UI.printError(UI.Module.API, "%s", parserException.getMessage());
            parserException.printStackTrace();
            return false;
        }
        catch (FileNotFoundException fileNotFoundException) {
            UI.printError(UI.Module.API, "%s", fileNotFoundException.getMessage());
            return false;
        }
        catch (IOException iOException) {
            UI.printError(UI.Module.API, "%s", iOException.getMessage());
            return false;
        }
        timer.end();
        UI.printInfo(UI.Module.API, "Done parsing.", new Object[0]);
        UI.printInfo(UI.Module.API, "Parsing time: %s", timer.toString());
        return true;
    }

    private void parseImageBlock(SunflowAPI sunflowAPI) throws IOException, Parser.ParserException {
        this.p.checkNextToken("{");
        if (this.p.peekNextToken("resolution")) {
            sunflowAPI.parameter("resolutionX", this.p.getNextInt());
            sunflowAPI.parameter("resolutionY", this.p.getNextInt());
        }
        if (this.p.peekNextToken("aa")) {
            sunflowAPI.parameter("aa.min", this.p.getNextInt());
            sunflowAPI.parameter("aa.max", this.p.getNextInt());
        }
        if (this.p.peekNextToken("samples")) {
            sunflowAPI.parameter("aa.samples", this.p.getNextInt());
        }
        if (this.p.peekNextToken("contrast")) {
            sunflowAPI.parameter("aa.contrast", this.p.getNextFloat());
        }
        if (this.p.peekNextToken("filter")) {
            sunflowAPI.parameter("filter", this.p.getNextToken());
        }
        if (this.p.peekNextToken("jitter")) {
            sunflowAPI.parameter("aa.jitter", this.p.getNextBoolean());
        }
        if (this.p.peekNextToken("show-aa")) {
            UI.printWarning(UI.Module.API, "Deprecated: show-aa ignored", new Object[0]);
            this.p.getNextBoolean();
        }
        if (this.p.peekNextToken("output")) {
            UI.printWarning(UI.Module.API, "Deprecated: output statement ignored", new Object[0]);
            this.p.getNextToken();
        }
        sunflowAPI.options("::options");
        this.p.checkNextToken("}");
    }

    private void parseBackgroundBlock(SunflowAPI sunflowAPI) throws IOException, Parser.ParserException {
        this.p.checkNextToken("{");
        this.p.checkNextToken("color");
        sunflowAPI.parameter("color", this.parseColor());
        sunflowAPI.shader("background.shader", new ConstantShader());
        sunflowAPI.geometry("background", new Background());
        sunflowAPI.parameter("shaders", "background.shader");
        sunflowAPI.instance("background.instance", "background");
        this.p.checkNextToken("}");
    }

    private void parseFilter(SunflowAPI sunflowAPI) throws IOException, Parser.ParserException {
        boolean bl;
        UI.printWarning(UI.Module.API, "Deprecated keyword \"filter\" - set this option in the image block", new Object[0]);
        String string = this.p.getNextToken();
        sunflowAPI.parameter("filter", string);
        sunflowAPI.options("::options");
        boolean bl2 = bl = string.equals("box") || string.equals("gaussian") || string.equals("blackman-harris") || string.equals("sinc") || string.equals("triangle");
        if (bl) {
            this.p.getNextFloat();
            this.p.getNextFloat();
        }
    }

    private void parsePhotonBlock(SunflowAPI sunflowAPI) throws Parser.ParserException, IOException {
        int n = 0;
        boolean bl = false;
        this.p.checkNextToken("{");
        if (this.p.peekNextToken("emit")) {
            UI.printWarning(UI.Module.API, "Shared photon emit values are deprectated - specify number of photons to emit per map", new Object[0]);
            n = this.p.getNextInt();
            bl = true;
        }
        if (this.p.peekNextToken("global")) {
            UI.printWarning(UI.Module.API, "Global photon map setting belonds inside the gi block - ignoring", new Object[0]);
            if (!bl) {
                this.p.getNextInt();
            }
            this.p.getNextToken();
            this.p.getNextInt();
            this.p.getNextFloat();
        }
        this.p.checkNextToken("caustics");
        if (!bl) {
            n = this.p.getNextInt();
        }
        sunflowAPI.parameter("caustics.emit", n);
        sunflowAPI.parameter("caustics", this.p.getNextToken());
        sunflowAPI.parameter("caustics.gather", this.p.getNextInt());
        sunflowAPI.parameter("caustics.radius", this.p.getNextFloat());
        sunflowAPI.options("::options");
        this.p.checkNextToken("}");
    }

    private void parseGIBlock(SunflowAPI sunflowAPI) throws Parser.ParserException, IOException {
        this.p.checkNextToken("{");
        this.p.checkNextToken("type");
        if (this.p.peekNextToken("irr-cache")) {
            sunflowAPI.parameter("gi.engine", "irr-cache");
            this.p.checkNextToken("samples");
            sunflowAPI.parameter("gi.irr-cache.samples", this.p.getNextInt());
            this.p.checkNextToken("tolerance");
            sunflowAPI.parameter("gi.irr-cache.tolerance", this.p.getNextFloat());
            this.p.checkNextToken("spacing");
            sunflowAPI.parameter("gi.irr-cache.min_spacing", this.p.getNextFloat());
            sunflowAPI.parameter("gi.irr-cache.max_spacing", this.p.getNextFloat());
            if (this.p.peekNextToken("global")) {
                sunflowAPI.parameter("gi.irr-cache.gmap.emit", this.p.getNextInt());
                sunflowAPI.parameter("gi.irr-cache.gmap", this.p.getNextToken());
                sunflowAPI.parameter("gi.irr-cache.gmap.gather", this.p.getNextInt());
                sunflowAPI.parameter("gi.irr-cache.gmap.radius", this.p.getNextFloat());
            }
        } else if (this.p.peekNextToken("path")) {
            sunflowAPI.parameter("gi.engine", "path");
            this.p.checkNextToken("samples");
            sunflowAPI.parameter("gi.path.samples", this.p.getNextInt());
            if (this.p.peekNextToken("bounces")) {
                UI.printWarning(UI.Module.API, "Deprecated setting: bounces - use diffuse trace depth instead", new Object[0]);
                this.p.getNextInt();
            }
        } else if (this.p.peekNextToken("fake")) {
            sunflowAPI.parameter("gi.engine", "fake");
            this.p.checkNextToken("up");
            sunflowAPI.parameter("gi.fake.up", this.parseVector());
            this.p.checkNextToken("sky");
            sunflowAPI.parameter("gi.fake.sky", this.parseColor());
            this.p.checkNextToken("ground");
            sunflowAPI.parameter("gi.fake.ground", this.parseColor());
        } else if (this.p.peekNextToken("igi")) {
            sunflowAPI.parameter("gi.engine", "igi");
            this.p.checkNextToken("samples");
            sunflowAPI.parameter("gi.igi.samples", this.p.getNextInt());
            this.p.checkNextToken("sets");
            sunflowAPI.parameter("gi.igi.sets", this.p.getNextInt());
            if (!this.p.peekNextToken("b")) {
                this.p.checkNextToken("c");
            }
            sunflowAPI.parameter("gi.igi.c", this.p.getNextFloat());
            this.p.checkNextToken("bias-samples");
            sunflowAPI.parameter("gi.igi.bias_samples", this.p.getNextInt());
        } else if (this.p.peekNextToken("ambocc")) {
            sunflowAPI.parameter("gi.engine", "ambocc");
            this.p.checkNextToken("bright");
            sunflowAPI.parameter("gi.ambocc.bright", this.parseColor());
            this.p.checkNextToken("dark");
            sunflowAPI.parameter("gi.ambocc.dark", this.parseColor());
            this.p.checkNextToken("samples");
            sunflowAPI.parameter("gi.ambocc.samples", this.p.getNextInt());
            if (this.p.peekNextToken("maxdist")) {
                sunflowAPI.parameter("gi.ambocc.maxdist", this.p.getNextFloat());
            }
        } else if (this.p.peekNextToken("none") || this.p.peekNextToken("null")) {
            sunflowAPI.parameter("gi.engine", "none");
        } else {
            UI.printWarning(UI.Module.API, "Unrecognized gi engine type \"%s\" - ignoring", this.p.getNextToken());
        }
        sunflowAPI.options("::options");
        this.p.checkNextToken("}");
    }

    private void parseLightserverBlock(SunflowAPI sunflowAPI) throws Parser.ParserException, IOException {
        this.p.checkNextToken("{");
        if (this.p.peekNextToken("shadows")) {
            UI.printWarning(UI.Module.API, "Deprecated: shadows setting ignored", new Object[0]);
            this.p.getNextBoolean();
        }
        if (this.p.peekNextToken("direct-samples")) {
            UI.printWarning(UI.Module.API, "Deprecated: use samples keyword in area light definitions", new Object[0]);
            this.numLightSamples = this.p.getNextInt();
        }
        if (this.p.peekNextToken("glossy-samples")) {
            UI.printWarning(UI.Module.API, "Deprecated: use samples keyword in glossy shader definitions", new Object[0]);
            this.p.getNextInt();
        }
        if (this.p.peekNextToken("max-depth")) {
            UI.printWarning(UI.Module.API, "Deprecated: max-depth setting - use trace-depths block instead", new Object[0]);
            int n = this.p.getNextInt();
            sunflowAPI.parameter("depths.diffuse", 1);
            sunflowAPI.parameter("depths.reflection", n - 1);
            sunflowAPI.parameter("depths.refraction", 0);
            sunflowAPI.options("::options");
        }
        if (this.p.peekNextToken("global")) {
            UI.printWarning(UI.Module.API, "Deprecated: global settings ignored - use photons block instead", new Object[0]);
            this.p.getNextBoolean();
            this.p.getNextInt();
            this.p.getNextInt();
            this.p.getNextInt();
            this.p.getNextFloat();
        }
        if (this.p.peekNextToken("caustics")) {
            UI.printWarning(UI.Module.API, "Deprecated: caustics settings ignored - use photons block instead", new Object[0]);
            this.p.getNextBoolean();
            this.p.getNextInt();
            this.p.getNextFloat();
            this.p.getNextInt();
            this.p.getNextFloat();
        }
        if (this.p.peekNextToken("irr-cache")) {
            UI.printWarning(UI.Module.API, "Deprecated: irradiance cache settings ignored - use gi block instead", new Object[0]);
            this.p.getNextInt();
            this.p.getNextFloat();
            this.p.getNextFloat();
            this.p.getNextFloat();
        }
        this.p.checkNextToken("}");
    }

    private void parseTraceBlock(SunflowAPI sunflowAPI) throws Parser.ParserException, IOException {
        this.p.checkNextToken("{");
        if (this.p.peekNextToken("diff")) {
            sunflowAPI.parameter("depths.diffuse", this.p.getNextInt());
        }
        if (this.p.peekNextToken("refl")) {
            sunflowAPI.parameter("depths.reflection", this.p.getNextInt());
        }
        if (this.p.peekNextToken("refr")) {
            sunflowAPI.parameter("depths.refraction", this.p.getNextInt());
        }
        this.p.checkNextToken("}");
        sunflowAPI.options("::options");
    }

    private void parseCamera(SunflowAPI sunflowAPI) throws Parser.ParserException, IOException {
        this.p.checkNextToken("{");
        this.p.checkNextToken("type");
        String string = this.p.getNextToken();
        UI.printInfo(UI.Module.API, "Reading %s camera ...", string);
        this.parseCameraTransform(sunflowAPI);
        String string2 = sunflowAPI.getUniqueName("camera");
        if (string.equals("pinhole")) {
            this.p.checkNextToken("fov");
            sunflowAPI.parameter("fov", this.p.getNextFloat());
            this.p.checkNextToken("aspect");
            sunflowAPI.parameter("aspect", this.p.getNextFloat());
            sunflowAPI.camera(string2, new PinholeLens());
        } else if (string.equals("thinlens")) {
            this.p.checkNextToken("fov");
            sunflowAPI.parameter("fov", this.p.getNextFloat());
            this.p.checkNextToken("aspect");
            sunflowAPI.parameter("aspect", this.p.getNextFloat());
            this.p.checkNextToken("fdist");
            sunflowAPI.parameter("focus.distance", this.p.getNextFloat());
            this.p.checkNextToken("lensr");
            sunflowAPI.parameter("lens.radius", this.p.getNextFloat());
            if (this.p.peekNextToken("sides")) {
                sunflowAPI.parameter("lens.sides", this.p.getNextInt());
            }
            if (this.p.peekNextToken("rotation")) {
                sunflowAPI.parameter("lens.rotation", this.p.getNextFloat());
            }
            sunflowAPI.camera(string2, new ThinLens());
        } else if (string.equals("spherical")) {
            sunflowAPI.camera(string2, new SphericalLens());
        } else if (string.equals("fisheye")) {
            sunflowAPI.camera(string2, new FisheyeLens());
        } else {
            UI.printWarning(UI.Module.API, "Unrecognized camera type: %s", this.p.getNextToken());
            this.p.checkNextToken("}");
            return;
        }
        this.p.checkNextToken("}");
        if (string2 != null) {
            sunflowAPI.parameter("camera", string2);
            sunflowAPI.options("::options");
        }
    }

    private void parseCameraTransform(SunflowAPI sunflowAPI) throws Parser.ParserException, IOException {
        if (this.p.peekNextToken("steps")) {
            int n = this.p.getNextInt();
            sunflowAPI.parameter("transform.steps", n);
            for (int i = 0; i < n; ++i) {
                this.parseCameraMatrix(i, sunflowAPI);
            }
        } else {
            this.parseCameraMatrix(-1, sunflowAPI);
        }
    }

    private void parseCameraMatrix(int n, SunflowAPI sunflowAPI) throws IOException, Parser.ParserException {
        String string;
        String string2 = string = n < 0 ? "" : String.format("[%d]", n);
        if (this.p.peekNextToken("transform")) {
            sunflowAPI.parameter(String.format("transform%s", string), this.parseMatrix());
        } else {
            if (n >= 0) {
                this.p.checkNextToken("{");
            }
            this.p.checkNextToken("eye");
            sunflowAPI.parameter(String.format("eye%s", string), this.parsePoint());
            this.p.checkNextToken("target");
            sunflowAPI.parameter(String.format("target%s", string), this.parsePoint());
            this.p.checkNextToken("up");
            sunflowAPI.parameter(String.format("up%s", string), this.parseVector());
            if (n >= 0) {
                this.p.checkNextToken("}");
            }
        }
    }

    private boolean parseShader(SunflowAPI sunflowAPI) throws Parser.ParserException, IOException {
        this.p.checkNextToken("{");
        this.p.checkNextToken("name");
        String string = this.p.getNextToken();
        UI.printInfo(UI.Module.API, "Reading shader: %s ...", string);
        this.p.checkNextToken("type");
        if (this.p.peekNextToken("diffuse")) {
            if (this.p.peekNextToken("diff")) {
                sunflowAPI.parameter("diffuse", this.parseColor());
                sunflowAPI.shader(string, new DiffuseShader());
            } else if (this.p.peekNextToken("texture")) {
                sunflowAPI.parameter("texture", this.p.getNextToken());
                sunflowAPI.shader(string, new TexturedDiffuseShader());
            } else {
                UI.printWarning(UI.Module.API, "Unrecognized option in diffuse shader block: %s", this.p.getNextToken());
            }
        } else if (this.p.peekNextToken("phong")) {
            String string2 = null;
            if (this.p.peekNextToken("texture")) {
                string2 = this.p.getNextToken();
                sunflowAPI.parameter("texture", string2);
            } else {
                this.p.checkNextToken("diff");
                sunflowAPI.parameter("diffuse", this.parseColor());
            }
            this.p.checkNextToken("spec");
            sunflowAPI.parameter("specular", this.parseColor());
            sunflowAPI.parameter("power", this.p.getNextFloat());
            if (this.p.peekNextToken("samples")) {
                sunflowAPI.parameter("samples", this.p.getNextInt());
            }
            if (string2 != null) {
                sunflowAPI.shader(string, new TexturedPhongShader());
            } else {
                sunflowAPI.shader(string, new PhongShader());
            }
        } else if (this.p.peekNextToken("amb-occ") || this.p.peekNextToken("amb-occ2")) {
            String string3 = null;
            if (this.p.peekNextToken("diff") || this.p.peekNextToken("bright")) {
                sunflowAPI.parameter("bright", this.parseColor());
            } else if (this.p.peekNextToken("texture")) {
                string3 = this.p.getNextToken();
                sunflowAPI.parameter("texture", string3);
            }
            if (this.p.peekNextToken("dark")) {
                sunflowAPI.parameter("dark", this.parseColor());
                this.p.checkNextToken("samples");
                sunflowAPI.parameter("samples", this.p.getNextInt());
                this.p.checkNextToken("dist");
                sunflowAPI.parameter("maxdist", this.p.getNextFloat());
            }
            if (string3 == null) {
                sunflowAPI.shader(string, new AmbientOcclusionShader());
            } else {
                sunflowAPI.shader(string, new TexturedAmbientOcclusionShader());
            }
        } else if (this.p.peekNextToken("mirror")) {
            this.p.checkNextToken("refl");
            sunflowAPI.parameter("color", this.parseColor());
            sunflowAPI.shader(string, new MirrorShader());
        } else if (this.p.peekNextToken("glass")) {
            this.p.checkNextToken("eta");
            sunflowAPI.parameter("eta", this.p.getNextFloat());
            this.p.checkNextToken("color");
            sunflowAPI.parameter("color", this.parseColor());
            if (this.p.peekNextToken("absorbtion.distance")) {
                sunflowAPI.parameter("absorbtion.distance", this.p.getNextFloat());
            }
            if (this.p.peekNextToken("absorbtion.color")) {
                sunflowAPI.parameter("absorbtion.color", this.parseColor());
            }
            sunflowAPI.shader(string, new GlassShader());
        } else if (this.p.peekNextToken("shiny")) {
            String string4 = null;
            if (this.p.peekNextToken("texture")) {
                string4 = this.p.getNextToken();
                sunflowAPI.parameter("texture", string4);
            } else {
                this.p.checkNextToken("diff");
                sunflowAPI.parameter("diffuse", this.parseColor());
            }
            this.p.checkNextToken("refl");
            sunflowAPI.parameter("shiny", this.p.getNextFloat());
            if (string4 == null) {
                sunflowAPI.shader(string, new ShinyDiffuseShader());
            } else {
                sunflowAPI.shader(string, new TexturedShinyDiffuseShader());
            }
        } else if (this.p.peekNextToken("ward")) {
            String string5 = null;
            if (this.p.peekNextToken("texture")) {
                string5 = this.p.getNextToken();
                sunflowAPI.parameter("texture", string5);
            } else {
                this.p.checkNextToken("diff");
                sunflowAPI.parameter("diffuse", this.parseColor());
            }
            this.p.checkNextToken("spec");
            sunflowAPI.parameter("specular", this.parseColor());
            this.p.checkNextToken("rough");
            sunflowAPI.parameter("roughnessX", this.p.getNextFloat());
            sunflowAPI.parameter("roughnessY", this.p.getNextFloat());
            if (this.p.peekNextToken("samples")) {
                sunflowAPI.parameter("samples", this.p.getNextInt());
            }
            if (string5 != null) {
                sunflowAPI.shader(string, new TexturedWardShader());
            } else {
                sunflowAPI.shader(string, new AnisotropicWardShader());
            }
        } else if (this.p.peekNextToken("view-caustics")) {
            sunflowAPI.shader(string, new ViewCausticsShader());
        } else if (this.p.peekNextToken("view-irradiance")) {
            sunflowAPI.shader(string, new ViewIrradianceShader());
        } else if (this.p.peekNextToken("view-global")) {
            sunflowAPI.shader(string, new ViewGlobalPhotonsShader());
        } else if (this.p.peekNextToken("constant")) {
            this.p.peekNextToken("color");
            sunflowAPI.parameter("color", this.parseColor());
            sunflowAPI.shader(string, new ConstantShader());
        } else if (this.p.peekNextToken("janino")) {
            String string6 = this.p.getNextCodeBlock();
            try {
                Shader shader = (Shader)ClassBodyEvaluator.createFastClassBodyEvaluator(new Scanner(null, new StringReader(string6)), Shader.class, ClassLoader.getSystemClassLoader());
                sunflowAPI.shader(string, shader);
            }
            catch (CompileException compileException) {
                UI.printDetailed(UI.Module.API, "Compiling: %s", string6);
                UI.printError(UI.Module.API, "%s", compileException.getMessage());
                compileException.printStackTrace();
                return false;
            }
            catch (Parser.ParseException parseException) {
                UI.printDetailed(UI.Module.API, "Compiling: %s", string6);
                UI.printError(UI.Module.API, "%s", parseException.getMessage());
                parseException.printStackTrace();
                return false;
            }
            catch (Scanner.ScanException scanException) {
                UI.printDetailed(UI.Module.API, "Compiling: %s", string6);
                UI.printError(UI.Module.API, "%s", scanException.getMessage());
                scanException.printStackTrace();
                return false;
            }
            catch (IOException iOException) {
                UI.printDetailed(UI.Module.API, "Compiling: %s", string6);
                UI.printError(UI.Module.API, "%s", iOException.getMessage());
                iOException.printStackTrace();
                return false;
            }
        } else if (this.p.peekNextToken("id")) {
            sunflowAPI.shader(string, new IDShader());
        } else if (this.p.peekNextToken("uber")) {
            if (this.p.peekNextToken("diff")) {
                sunflowAPI.parameter("diffuse", this.parseColor());
            }
            if (this.p.peekNextToken("diff.texture")) {
                sunflowAPI.parameter("diffuse.texture", this.p.getNextToken());
            }
            if (this.p.peekNextToken("diff.blend")) {
                sunflowAPI.parameter("diffuse.blend", this.p.getNextFloat());
            }
            if (this.p.peekNextToken("refl") || this.p.peekNextToken("spec")) {
                sunflowAPI.parameter("specular", this.parseColor());
            }
            if (this.p.peekNextToken("texture")) {
                UI.printWarning(UI.Module.API, "Deprecated uber shader parameter \"texture\" - please use \"diffuse.texture\" and \"diffuse.blend\" instead", new Object[0]);
                sunflowAPI.parameter("diffuse.texture", this.p.getNextToken());
                sunflowAPI.parameter("diffuse.blend", this.p.getNextFloat());
            }
            if (this.p.peekNextToken("spec.texture")) {
                sunflowAPI.parameter("specular.texture", this.p.getNextToken());
            }
            if (this.p.peekNextToken("spec.blend")) {
                sunflowAPI.parameter("specular.blend", this.p.getNextFloat());
            }
            if (this.p.peekNextToken("glossy")) {
                sunflowAPI.parameter("glossyness", this.p.getNextFloat());
            }
            if (this.p.peekNextToken("samples")) {
                sunflowAPI.parameter("samples", this.p.getNextInt());
            }
            sunflowAPI.shader(string, new UberShader());
        } else {
            UI.printWarning(UI.Module.API, "Unrecognized shader type: %s", this.p.getNextToken());
        }
        this.p.checkNextToken("}");
        return true;
    }

    private boolean parseModifier(SunflowAPI sunflowAPI) throws Parser.ParserException, IOException {
        this.p.checkNextToken("{");
        this.p.checkNextToken("name");
        String string = this.p.getNextToken();
        UI.printInfo(UI.Module.API, "Reading shader: %s ...", string);
        this.p.checkNextToken("type");
        if (this.p.peekNextToken("bump")) {
            this.p.checkNextToken("texture");
            sunflowAPI.parameter("texture", this.p.getNextToken());
            this.p.checkNextToken("scale");
            sunflowAPI.parameter("scale", this.p.getNextFloat());
            sunflowAPI.modifier(string, new BumpMappingModifier());
        } else if (this.p.peekNextToken("normalmap")) {
            this.p.checkNextToken("texture");
            sunflowAPI.parameter("texture", this.p.getNextToken());
            sunflowAPI.modifier(string, new NormalMapModifier());
        } else {
            UI.printWarning(UI.Module.API, "Unrecognized modifier type: %s", this.p.getNextToken());
        }
        this.p.checkNextToken("}");
        return true;
    }

    private void parseObjectBlock(SunflowAPI sunflowAPI) throws Parser.ParserException, IOException {
        int n;
        this.p.checkNextToken("{");
        boolean bl = false;
        Matrix4 matrix4 = null;
        String string = null;
        String[] stringArray = null;
        String[] stringArray2 = null;
        if (this.p.peekNextToken("noinstance")) {
            bl = true;
        } else {
            int n2;
            if (this.p.peekNextToken("shaders")) {
                n2 = this.p.getNextInt();
                stringArray = new String[n2];
                for (n = 0; n < n2; ++n) {
                    stringArray[n] = this.p.getNextToken();
                }
            } else {
                this.p.checkNextToken("shader");
                stringArray = new String[]{this.p.getNextToken()};
            }
            if (this.p.peekNextToken("modifiers")) {
                n2 = this.p.getNextInt();
                stringArray2 = new String[n2];
                for (n = 0; n < n2; ++n) {
                    stringArray2[n] = this.p.getNextToken();
                }
            } else if (this.p.peekNextToken("modifier")) {
                stringArray2 = new String[]{this.p.getNextToken()};
            }
            if (this.p.peekNextToken("transform")) {
                matrix4 = this.parseMatrix();
            }
        }
        if (this.p.peekNextToken("accel")) {
            sunflowAPI.parameter("accel", this.p.getNextToken());
        }
        this.p.checkNextToken("type");
        String string2 = this.p.getNextToken();
        string = this.p.peekNextToken("name") ? this.p.getNextToken() : sunflowAPI.getUniqueName(string2);
        if (string2.equals("mesh")) {
            UI.printWarning(UI.Module.API, "Deprecated object type: mesh", new Object[0]);
            UI.printInfo(UI.Module.API, "Reading mesh: %s ...", string);
            n = this.p.getNextInt();
            int n3 = this.p.getNextInt();
            float[] fArray = new float[n * 3];
            float[] fArray2 = new float[n * 3];
            float[] fArray3 = new float[n * 2];
            for (int i = 0; i < n; ++i) {
                this.p.checkNextToken("v");
                fArray[3 * i + 0] = this.p.getNextFloat();
                fArray[3 * i + 1] = this.p.getNextFloat();
                fArray[3 * i + 2] = this.p.getNextFloat();
                fArray2[3 * i + 0] = this.p.getNextFloat();
                fArray2[3 * i + 1] = this.p.getNextFloat();
                fArray2[3 * i + 2] = this.p.getNextFloat();
                fArray3[2 * i + 0] = this.p.getNextFloat();
                fArray3[2 * i + 1] = this.p.getNextFloat();
            }
            int[] nArray = new int[n3 * 3];
            for (int i = 0; i < n3; ++i) {
                this.p.checkNextToken("t");
                nArray[i * 3 + 0] = this.p.getNextInt();
                nArray[i * 3 + 1] = this.p.getNextInt();
                nArray[i * 3 + 2] = this.p.getNextInt();
            }
            sunflowAPI.parameter("triangles", nArray);
            sunflowAPI.parameter("points", "point", "vertex", fArray);
            sunflowAPI.parameter("normals", "vector", "vertex", fArray2);
            sunflowAPI.parameter("uvs", "texcoord", "vertex", fArray3);
            sunflowAPI.geometry(string, new TriangleMesh());
        } else if (string2.equals("flat-mesh")) {
            UI.printWarning(UI.Module.API, "Deprecated object type: flat-mesh", new Object[0]);
            UI.printInfo(UI.Module.API, "Reading flat mesh: %s ...", string);
            n = this.p.getNextInt();
            int n4 = this.p.getNextInt();
            float[] fArray = new float[n * 3];
            float[] fArray4 = new float[n * 2];
            for (int i = 0; i < n; ++i) {
                this.p.checkNextToken("v");
                fArray[3 * i + 0] = this.p.getNextFloat();
                fArray[3 * i + 1] = this.p.getNextFloat();
                fArray[3 * i + 2] = this.p.getNextFloat();
                this.p.getNextFloat();
                this.p.getNextFloat();
                this.p.getNextFloat();
                fArray4[2 * i + 0] = this.p.getNextFloat();
                fArray4[2 * i + 1] = this.p.getNextFloat();
            }
            int[] nArray = new int[n4 * 3];
            for (int i = 0; i < n4; ++i) {
                this.p.checkNextToken("t");
                nArray[i * 3 + 0] = this.p.getNextInt();
                nArray[i * 3 + 1] = this.p.getNextInt();
                nArray[i * 3 + 2] = this.p.getNextInt();
            }
            sunflowAPI.parameter("triangles", nArray);
            sunflowAPI.parameter("points", "point", "vertex", fArray);
            sunflowAPI.parameter("uvs", "texcoord", "vertex", fArray4);
            sunflowAPI.geometry(string, new TriangleMesh());
        } else if (string2.equals("sphere")) {
            UI.printInfo(UI.Module.API, "Reading sphere ...", new Object[0]);
            sunflowAPI.geometry(string, new Sphere());
            if (matrix4 == null && !bl) {
                this.p.checkNextToken("c");
                float f = this.p.getNextFloat();
                float f2 = this.p.getNextFloat();
                float f3 = this.p.getNextFloat();
                this.p.checkNextToken("r");
                float f4 = this.p.getNextFloat();
                sunflowAPI.parameter("transform", Matrix4.translation(f, f2, f3).multiply(Matrix4.scale(f4)));
                sunflowAPI.parameter("shaders", stringArray);
                if (stringArray2 != null) {
                    sunflowAPI.parameter("modifiers", stringArray2);
                }
                sunflowAPI.instance(string + ".instance", string);
                bl = true;
            }
        } else if (string2.equals("banchoff")) {
            UI.printInfo(UI.Module.API, "Reading banchoff ...", new Object[0]);
            sunflowAPI.geometry(string, new BanchoffSurface());
        } else if (string2.equals("torus")) {
            UI.printInfo(UI.Module.API, "Reading torus ...", new Object[0]);
            this.p.checkNextToken("r");
            sunflowAPI.parameter("radiusInner", this.p.getNextFloat());
            sunflowAPI.parameter("radiusOuter", this.p.getNextFloat());
            sunflowAPI.geometry(string, new Torus());
        } else if (string2.equals("plane")) {
            UI.printInfo(UI.Module.API, "Reading plane ...", new Object[0]);
            this.p.checkNextToken("p");
            sunflowAPI.parameter("center", this.parsePoint());
            if (this.p.peekNextToken("n")) {
                sunflowAPI.parameter("normal", this.parseVector());
            } else {
                this.p.checkNextToken("p");
                sunflowAPI.parameter("point1", this.parsePoint());
                this.p.checkNextToken("p");
                sunflowAPI.parameter("point2", this.parsePoint());
            }
            sunflowAPI.geometry(string, new Plane());
        } else if (string2.equals("cornellbox")) {
            UI.printInfo(UI.Module.API, "Reading cornell box ...", new Object[0]);
            if (matrix4 != null) {
                UI.printWarning(UI.Module.API, "Instancing is not supported on cornell box -- ignoring transform", new Object[0]);
            }
            this.p.checkNextToken("corner0");
            sunflowAPI.parameter("corner0", this.parsePoint());
            this.p.checkNextToken("corner1");
            sunflowAPI.parameter("corner1", this.parsePoint());
            this.p.checkNextToken("left");
            sunflowAPI.parameter("leftColor", this.parseColor());
            this.p.checkNextToken("right");
            sunflowAPI.parameter("rightColor", this.parseColor());
            this.p.checkNextToken("top");
            sunflowAPI.parameter("topColor", this.parseColor());
            this.p.checkNextToken("bottom");
            sunflowAPI.parameter("bottomColor", this.parseColor());
            this.p.checkNextToken("back");
            sunflowAPI.parameter("backColor", this.parseColor());
            this.p.checkNextToken("emit");
            sunflowAPI.parameter("radiance", this.parseColor());
            if (this.p.peekNextToken("samples")) {
                sunflowAPI.parameter("samples", this.p.getNextInt());
            }
            new CornellBox().init(string, sunflowAPI);
            bl = true;
        } else if (string2.equals("generic-mesh")) {
            UI.printInfo(UI.Module.API, "Reading generic mesh: %s ... ", string);
            this.p.checkNextToken("points");
            n = this.p.getNextInt();
            sunflowAPI.parameter("points", "point", "vertex", this.parseFloatArray(n * 3));
            this.p.checkNextToken("triangles");
            int n5 = this.p.getNextInt();
            sunflowAPI.parameter("triangles", this.parseIntArray(n5 * 3));
            this.p.checkNextToken("normals");
            if (this.p.peekNextToken("vertex")) {
                sunflowAPI.parameter("normals", "vector", "vertex", this.parseFloatArray(n * 3));
            } else if (this.p.peekNextToken("facevarying")) {
                sunflowAPI.parameter("normals", "vector", "facevarying", this.parseFloatArray(n5 * 9));
            } else {
                this.p.checkNextToken("none");
            }
            this.p.checkNextToken("uvs");
            if (this.p.peekNextToken("vertex")) {
                sunflowAPI.parameter("uvs", "texcoord", "vertex", this.parseFloatArray(n * 2));
            } else if (this.p.peekNextToken("facevarying")) {
                sunflowAPI.parameter("uvs", "texcoord", "facevarying", this.parseFloatArray(n5 * 6));
            } else {
                this.p.checkNextToken("none");
            }
            if (this.p.peekNextToken("face_shaders")) {
                sunflowAPI.parameter("faceshaders", this.parseIntArray(n5));
            }
            sunflowAPI.geometry(string, new TriangleMesh());
        } else if (string2.equals("hair")) {
            UI.printInfo(UI.Module.API, "Reading hair curves: %s ... ", string);
            this.p.checkNextToken("segments");
            sunflowAPI.parameter("segments", this.p.getNextInt());
            this.p.checkNextToken("width");
            sunflowAPI.parameter("widths", this.p.getNextFloat());
            this.p.checkNextToken("points");
            sunflowAPI.parameter("points", "point", "vertex", this.parseFloatArray(this.p.getNextInt()));
            sunflowAPI.geometry(string, new Hair());
        } else if (string2.equals("janino-tesselatable")) {
            UI.printInfo(UI.Module.API, "Reading procedural primitive: %s ... ", string);
            String string3 = this.p.getNextCodeBlock();
            try {
                Tesselatable tesselatable = (Tesselatable)ClassBodyEvaluator.createFastClassBodyEvaluator(new Scanner(null, new StringReader(string3)), Tesselatable.class, ClassLoader.getSystemClassLoader());
                sunflowAPI.geometry(string, tesselatable);
            }
            catch (CompileException compileException) {
                UI.printDetailed(UI.Module.API, "Compiling: %s", string3);
                UI.printError(UI.Module.API, "%s", compileException.getMessage());
                compileException.printStackTrace();
                bl = true;
            }
            catch (Parser.ParseException parseException) {
                UI.printDetailed(UI.Module.API, "Compiling: %s", string3);
                UI.printError(UI.Module.API, "%s", parseException.getMessage());
                parseException.printStackTrace();
                bl = true;
            }
            catch (Scanner.ScanException scanException) {
                UI.printDetailed(UI.Module.API, "Compiling: %s", string3);
                UI.printError(UI.Module.API, "%s", scanException.getMessage());
                scanException.printStackTrace();
                bl = true;
            }
            catch (IOException iOException) {
                UI.printDetailed(UI.Module.API, "Compiling: %s", string3);
                UI.printError(UI.Module.API, "%s", iOException.getMessage());
                iOException.printStackTrace();
                bl = true;
            }
        } else if (string2.equals("teapot")) {
            UI.printInfo(UI.Module.API, "Reading teapot: %s ... ", string);
            n = 0;
            if (this.p.peekNextToken("subdivs")) {
                sunflowAPI.parameter("subdivs", this.p.getNextInt());
                n = 1;
            }
            if (this.p.peekNextToken("smooth")) {
                sunflowAPI.parameter("smooth", this.p.getNextBoolean());
                n = 1;
            }
            if (n != 0) {
                sunflowAPI.geometry(string, new Teapot());
            } else {
                sunflowAPI.geometry(string, new Teapot());
            }
        } else if (string2.equals("gumbo")) {
            UI.printInfo(UI.Module.API, "Reading gumbo: %s ... ", string);
            n = 0;
            if (this.p.peekNextToken("subdivs")) {
                sunflowAPI.parameter("subdivs", this.p.getNextInt());
                n = 1;
            }
            if (this.p.peekNextToken("smooth")) {
                sunflowAPI.parameter("smooth", this.p.getNextBoolean());
                n = 1;
            }
            if (n != 0) {
                sunflowAPI.geometry(string, new Gumbo());
            } else {
                sunflowAPI.geometry(string, new Gumbo());
            }
        } else if (string2.equals("julia")) {
            UI.printInfo(UI.Module.API, "Reading julia fractal: %s ... ", string);
            if (this.p.peekNextToken("q")) {
                sunflowAPI.parameter("cw", this.p.getNextFloat());
                sunflowAPI.parameter("cx", this.p.getNextFloat());
                sunflowAPI.parameter("cy", this.p.getNextFloat());
                sunflowAPI.parameter("cz", this.p.getNextFloat());
            }
            if (this.p.peekNextToken("iterations")) {
                sunflowAPI.parameter("iterations", this.p.getNextInt());
            }
            if (this.p.peekNextToken("epsilon")) {
                sunflowAPI.parameter("epsilon", this.p.getNextFloat());
            }
            sunflowAPI.geometry(string, new JuliaFractal());
        } else if (string2.equals("particles") || string2.equals("dlasurface")) {
            if (string2.equals("dlasurface")) {
                UI.printWarning(UI.Module.API, "Deprecated object type: \"dlasurface\" - please use \"particles\" instead", new Object[0]);
            }
            this.p.checkNextToken("filename");
            String string4 = this.p.getNextToken();
            boolean bl2 = false;
            if (this.p.peekNextToken("little_endian")) {
                bl2 = true;
            }
            UI.printInfo(UI.Module.USER, "Loading particle file: %s", string4);
            File file = new File(string4);
            FileInputStream fileInputStream = new FileInputStream(string4);
            MappedByteBuffer mappedByteBuffer = fileInputStream.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
            if (bl2) {
                mappedByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            }
            FloatBuffer floatBuffer = mappedByteBuffer.asFloatBuffer();
            float[] fArray = new float[floatBuffer.capacity()];
            for (int i = 0; i < fArray.length; ++i) {
                fArray[i] = floatBuffer.get(i);
            }
            fileInputStream.close();
            sunflowAPI.parameter("particles", "point", "vertex", fArray);
            if (this.p.peekNextToken("num")) {
                sunflowAPI.parameter("num", this.p.getNextInt());
            } else {
                sunflowAPI.parameter("num", fArray.length / 3);
            }
            this.p.checkNextToken("radius");
            sunflowAPI.parameter("radius", this.p.getNextFloat());
            sunflowAPI.geometry(string, new ParticleSurface());
        } else if (string2.equals("file-mesh")) {
            UI.printInfo(UI.Module.API, "Reading file mesh: %s ... ", string);
            this.p.checkNextToken("filename");
            sunflowAPI.parameter("filename", this.p.getNextToken());
            if (this.p.peekNextToken("smooth_normals")) {
                sunflowAPI.parameter("smooth_normals", this.p.getNextBoolean());
            }
            sunflowAPI.geometry(string, new FileMesh());
        } else if (string2.equals("bezier-mesh")) {
            UI.printInfo(UI.Module.API, "Reading bezier mesh: %s ... ", string);
            this.p.checkNextToken("n");
            n = this.p.getNextInt();
            sunflowAPI.parameter("nu", n);
            int n6 = this.p.getNextInt();
            sunflowAPI.parameter("nv", n6);
            if (this.p.peekNextToken("wrap")) {
                sunflowAPI.parameter("uwrap", this.p.getNextBoolean());
                sunflowAPI.parameter("vwrap", this.p.getNextBoolean());
            }
            this.p.checkNextToken("points");
            float[] fArray = new float[3 * n * n6];
            for (int i = 0; i < fArray.length; ++i) {
                fArray[i] = this.p.getNextFloat();
            }
            sunflowAPI.parameter("points", "point", "vertex", fArray);
            if (this.p.peekNextToken("subdivs")) {
                sunflowAPI.parameter("subdivs", this.p.getNextInt());
            }
            if (this.p.peekNextToken("smooth")) {
                sunflowAPI.parameter("smooth", this.p.getNextBoolean());
            }
            sunflowAPI.geometry(string, new BezierMesh());
        } else {
            UI.printWarning(UI.Module.API, "Unrecognized object type: %s", this.p.getNextToken());
            bl = true;
        }
        if (!bl) {
            sunflowAPI.parameter("shaders", stringArray);
            if (stringArray2 != null) {
                sunflowAPI.parameter("modifiers", stringArray2);
            }
            if (matrix4 != null) {
                sunflowAPI.parameter("transform", matrix4);
            }
            sunflowAPI.instance(string + ".instance", string);
        }
        this.p.checkNextToken("}");
    }

    private void parseInstanceBlock(SunflowAPI sunflowAPI) throws Parser.ParserException, IOException {
        int n;
        String[] stringArray;
        this.p.checkNextToken("{");
        this.p.checkNextToken("name");
        String string = this.p.getNextToken();
        UI.printInfo(UI.Module.API, "Reading instance: %s ...", string);
        this.p.checkNextToken("geometry");
        String string2 = this.p.getNextToken();
        this.p.checkNextToken("transform");
        sunflowAPI.parameter("transform", this.parseMatrix());
        if (this.p.peekNextToken("shaders")) {
            int n2 = this.p.getNextInt();
            stringArray = new String[n2];
            for (n = 0; n < n2; ++n) {
                stringArray[n] = this.p.getNextToken();
            }
        } else {
            this.p.checkNextToken("shader");
            stringArray = new String[]{this.p.getNextToken()};
        }
        sunflowAPI.parameter("shaders", stringArray);
        String[] stringArray2 = null;
        if (this.p.peekNextToken("modifiers")) {
            n = this.p.getNextInt();
            stringArray2 = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray2[i] = this.p.getNextToken();
            }
        } else if (this.p.peekNextToken("modifier")) {
            stringArray2 = new String[]{this.p.getNextToken()};
        }
        if (stringArray2 != null) {
            sunflowAPI.parameter("modifiers", stringArray2);
        }
        sunflowAPI.instance(string, string2);
        this.p.checkNextToken("}");
    }

    private void parseLightBlock(SunflowAPI sunflowAPI) throws Parser.ParserException, IOException {
        this.p.checkNextToken("{");
        this.p.checkNextToken("type");
        if (this.p.peekNextToken("mesh")) {
            int n;
            UI.printWarning(UI.Module.API, "Deprecated light type: mesh", new Object[0]);
            this.p.checkNextToken("name");
            String string = this.p.getNextToken();
            UI.printInfo(UI.Module.API, "Reading light mesh: %s ...", string);
            this.p.checkNextToken("emit");
            sunflowAPI.parameter("radiance", this.parseColor());
            int n2 = this.numLightSamples;
            if (this.p.peekNextToken("samples")) {
                n2 = this.p.getNextInt();
            } else {
                UI.printWarning(UI.Module.API, "Samples keyword not found - defaulting to %d", n2);
            }
            sunflowAPI.parameter("samples", n2);
            int n3 = this.p.getNextInt();
            int n4 = this.p.getNextInt();
            float[] fArray = new float[3 * n3];
            int[] nArray = new int[3 * n4];
            for (n = 0; n < n3; ++n) {
                this.p.checkNextToken("v");
                fArray[3 * n + 0] = this.p.getNextFloat();
                fArray[3 * n + 1] = this.p.getNextFloat();
                fArray[3 * n + 2] = this.p.getNextFloat();
                this.p.getNextFloat();
                this.p.getNextFloat();
                this.p.getNextFloat();
                this.p.getNextFloat();
                this.p.getNextFloat();
            }
            for (n = 0; n < n4; ++n) {
                this.p.checkNextToken("t");
                nArray[3 * n + 0] = this.p.getNextInt();
                nArray[3 * n + 1] = this.p.getNextInt();
                nArray[3 * n + 2] = this.p.getNextInt();
            }
            sunflowAPI.parameter("points", "point", "vertex", fArray);
            sunflowAPI.parameter("triangles", nArray);
            TriangleMeshLight triangleMeshLight = new TriangleMeshLight();
            triangleMeshLight.init(string, sunflowAPI);
        } else if (this.p.peekNextToken("point")) {
            Color color;
            UI.printInfo(UI.Module.API, "Reading point light ...", new Object[0]);
            if (this.p.peekNextToken("color")) {
                color = this.parseColor();
                this.p.checkNextToken("power");
                float f = this.p.getNextFloat();
                color.mul(f);
            } else {
                UI.printWarning(UI.Module.API, "Deprecated color specification - please use color and power instead", new Object[0]);
                this.p.checkNextToken("power");
                color = this.parseColor();
            }
            this.p.checkNextToken("p");
            sunflowAPI.parameter("center", this.parsePoint());
            sunflowAPI.parameter("power", color);
            sunflowAPI.light(sunflowAPI.getUniqueName("pointlight"), new PointLight());
        } else if (this.p.peekNextToken("spherical")) {
            UI.printInfo(UI.Module.API, "Reading spherical light ...", new Object[0]);
            this.p.checkNextToken("color");
            Color color = this.parseColor();
            this.p.checkNextToken("radiance");
            color.mul(this.p.getNextFloat());
            sunflowAPI.parameter("radiance", color);
            this.p.checkNextToken("center");
            sunflowAPI.parameter("center", this.parsePoint());
            this.p.checkNextToken("radius");
            sunflowAPI.parameter("radius", this.p.getNextFloat());
            this.p.checkNextToken("samples");
            sunflowAPI.parameter("samples", this.p.getNextInt());
            SphereLight sphereLight = new SphereLight();
            sphereLight.init(sunflowAPI.getUniqueName("spherelight"), sunflowAPI);
        } else if (this.p.peekNextToken("directional")) {
            UI.printInfo(UI.Module.API, "Reading directional light ...", new Object[0]);
            this.p.checkNextToken("source");
            Point3 point3 = this.parsePoint();
            sunflowAPI.parameter("source", point3);
            this.p.checkNextToken("target");
            Point3 point32 = this.parsePoint();
            sunflowAPI.parameter("dir", Point3.sub(point32, point3, new Vector3()));
            this.p.checkNextToken("radius");
            sunflowAPI.parameter("radius", this.p.getNextFloat());
            this.p.checkNextToken("emit");
            Color color = this.parseColor();
            if (this.p.peekNextToken("intensity")) {
                float f = this.p.getNextFloat();
                color.mul(f);
            } else {
                UI.printWarning(UI.Module.API, "Deprecated color specification - please use emit and intensity instead", new Object[0]);
            }
            sunflowAPI.parameter("radiance", color);
            sunflowAPI.light(sunflowAPI.getUniqueName("dirlight"), new DirectionalSpotlight());
        } else if (this.p.peekNextToken("ibl")) {
            UI.printInfo(UI.Module.API, "Reading image based light ...", new Object[0]);
            this.p.checkNextToken("image");
            sunflowAPI.parameter("texture", this.p.getNextToken());
            this.p.checkNextToken("center");
            sunflowAPI.parameter("center", this.parseVector());
            this.p.checkNextToken("up");
            sunflowAPI.parameter("up", this.parseVector());
            this.p.checkNextToken("lock");
            sunflowAPI.parameter("fixed", this.p.getNextBoolean());
            int n = this.numLightSamples;
            if (this.p.peekNextToken("samples")) {
                n = this.p.getNextInt();
            } else {
                UI.printWarning(UI.Module.API, "Samples keyword not found - defaulting to %d", n);
            }
            sunflowAPI.parameter("samples", n);
            ImageBasedLight imageBasedLight = new ImageBasedLight();
            imageBasedLight.init(sunflowAPI.getUniqueName("ibl"), sunflowAPI);
        } else if (this.p.peekNextToken("meshlight")) {
            this.p.checkNextToken("name");
            String string = this.p.getNextToken();
            UI.printInfo(UI.Module.API, "Reading meshlight: %s ...", string);
            this.p.checkNextToken("emit");
            Color color = this.parseColor();
            if (this.p.peekNextToken("radiance")) {
                float f = this.p.getNextFloat();
                color.mul(f);
            } else {
                UI.printWarning(UI.Module.API, "Deprecated color specification - please use emit and radiance instead", new Object[0]);
            }
            sunflowAPI.parameter("radiance", color);
            int n = this.numLightSamples;
            if (this.p.peekNextToken("samples")) {
                n = this.p.getNextInt();
            } else {
                UI.printWarning(UI.Module.API, "Samples keyword not found - defaulting to %d", n);
            }
            sunflowAPI.parameter("samples", n);
            this.p.checkNextToken("points");
            int n5 = this.p.getNextInt();
            sunflowAPI.parameter("points", "point", "vertex", this.parseFloatArray(n5 * 3));
            this.p.checkNextToken("triangles");
            int n6 = this.p.getNextInt();
            sunflowAPI.parameter("triangles", this.parseIntArray(n6 * 3));
            TriangleMeshLight triangleMeshLight = new TriangleMeshLight();
            triangleMeshLight.init(string, sunflowAPI);
        } else if (this.p.peekNextToken("sunsky")) {
            this.p.checkNextToken("up");
            sunflowAPI.parameter("up", this.parseVector());
            this.p.checkNextToken("east");
            sunflowAPI.parameter("east", this.parseVector());
            this.p.checkNextToken("sundir");
            sunflowAPI.parameter("sundir", this.parseVector());
            this.p.checkNextToken("turbidity");
            sunflowAPI.parameter("turbidity", this.p.getNextFloat());
            if (this.p.peekNextToken("samples")) {
                sunflowAPI.parameter("samples", this.p.getNextInt());
            }
            SunSkyLight sunSkyLight = new SunSkyLight();
            sunSkyLight.init(sunflowAPI.getUniqueName("sunsky"), sunflowAPI);
        } else {
            UI.printWarning(UI.Module.API, "Unrecognized object type: %s", this.p.getNextToken());
        }
        this.p.checkNextToken("}");
    }

    private Color parseColor() throws IOException, Parser.ParserException {
        if (this.p.peekNextToken("{")) {
            String string = this.p.getNextToken();
            Color color = null;
            if (string.equals("sRGB nonlinear")) {
                float f = this.p.getNextFloat();
                float f2 = this.p.getNextFloat();
                float f3 = this.p.getNextFloat();
                color = new Color(f, f2, f3);
                color.toLinear();
            } else if (string.equals("sRGB linear")) {
                float f = this.p.getNextFloat();
                float f4 = this.p.getNextFloat();
                float f5 = this.p.getNextFloat();
                color = new Color(f, f4, f5);
            } else {
                UI.printWarning(UI.Module.API, "Unrecognized color space: %s", string);
            }
            this.p.checkNextToken("}");
            return color;
        }
        float f = this.p.getNextFloat();
        float f6 = this.p.getNextFloat();
        float f7 = this.p.getNextFloat();
        return new Color(f, f6, f7);
    }

    private Point3 parsePoint() throws IOException {
        float f = this.p.getNextFloat();
        float f2 = this.p.getNextFloat();
        float f3 = this.p.getNextFloat();
        return new Point3(f, f2, f3);
    }

    private Vector3 parseVector() throws IOException {
        float f = this.p.getNextFloat();
        float f2 = this.p.getNextFloat();
        float f3 = this.p.getNextFloat();
        return new Vector3(f, f2, f3);
    }

    private int[] parseIntArray(int n) throws IOException {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.p.getNextInt();
        }
        return nArray;
    }

    private float[] parseFloatArray(int n) throws IOException {
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = this.p.getNextFloat();
        }
        return fArray;
    }

    private Matrix4 parseMatrix() throws IOException, Parser.ParserException {
        if (this.p.peekNextToken("row")) {
            return new Matrix4(this.parseFloatArray(16), true);
        }
        if (this.p.peekNextToken("col")) {
            return new Matrix4(this.parseFloatArray(16), false);
        }
        Matrix4 matrix4 = Matrix4.IDENTITY;
        this.p.checkNextToken("{");
        while (!this.p.peekNextToken("}")) {
            float f;
            float f2;
            float f3;
            Matrix4 matrix42 = null;
            if (this.p.peekNextToken("translate")) {
                f3 = this.p.getNextFloat();
                f2 = this.p.getNextFloat();
                f = this.p.getNextFloat();
                matrix42 = Matrix4.translation(f3, f2, f);
            } else if (this.p.peekNextToken("scaleu")) {
                f3 = this.p.getNextFloat();
                matrix42 = Matrix4.scale(f3);
            } else if (this.p.peekNextToken("scale")) {
                f3 = this.p.getNextFloat();
                f2 = this.p.getNextFloat();
                f = this.p.getNextFloat();
                matrix42 = Matrix4.scale(f3, f2, f);
            } else if (this.p.peekNextToken("rotatex")) {
                f3 = this.p.getNextFloat();
                matrix42 = Matrix4.rotateX((float)Math.toRadians(f3));
            } else if (this.p.peekNextToken("rotatey")) {
                f3 = this.p.getNextFloat();
                matrix42 = Matrix4.rotateY((float)Math.toRadians(f3));
            } else if (this.p.peekNextToken("rotatez")) {
                f3 = this.p.getNextFloat();
                matrix42 = Matrix4.rotateZ((float)Math.toRadians(f3));
            } else if (this.p.peekNextToken("rotate")) {
                f3 = this.p.getNextFloat();
                f2 = this.p.getNextFloat();
                f = this.p.getNextFloat();
                float f4 = this.p.getNextFloat();
                matrix42 = Matrix4.rotate(f3, f2, f, (float)Math.toRadians(f4));
            } else {
                UI.printWarning(UI.Module.API, "Unrecognized transformation type: %s", this.p.getNextToken());
            }
            if (matrix42 == null) continue;
            matrix4 = matrix42.multiply(matrix4);
        }
        return matrix4;
    }
}

