/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.sunflow.SunflowAPI;
import org.sunflow.core.SceneParser;
import org.sunflow.core.Shader;
import org.sunflow.core.primitive.TriangleMesh;
import org.sunflow.core.shader.SimpleShader;
import org.sunflow.system.UI;

public class RA3Parser
implements SceneParser {
    public boolean parse(String string, SunflowAPI sunflowAPI) {
        try {
            UI.printInfo(UI.Module.USER, "RA3 - Reading geometry: \"%s\" ...", string);
            File file = new File(string);
            FileInputStream fileInputStream = new FileInputStream(string);
            MappedByteBuffer mappedByteBuffer = fileInputStream.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
            mappedByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            IntBuffer intBuffer = mappedByteBuffer.asIntBuffer();
            FloatBuffer floatBuffer = mappedByteBuffer.asFloatBuffer();
            int n = intBuffer.get(0);
            int n2 = intBuffer.get(1);
            UI.printInfo(UI.Module.USER, "RA3 -   * Reading %d vertices ...", n);
            float[] fArray = new float[3 * n];
            for (int i = 0; i < fArray.length; ++i) {
                fArray[i] = floatBuffer.get(2 + i);
            }
            UI.printInfo(UI.Module.USER, "RA3 -   * Reading %d triangles ...", n2);
            int[] nArray = new int[3 * n2];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = intBuffer.get(2 + fArray.length + i);
            }
            fileInputStream.close();
            UI.printInfo(UI.Module.USER, "RA3 -   * Creating mesh ...", new Object[0]);
            sunflowAPI.parameter("triangles", nArray);
            sunflowAPI.parameter("points", "point", "vertex", fArray);
            sunflowAPI.geometry(string, new TriangleMesh());
            Shader shader = sunflowAPI.lookupShader("ra3shader");
            if (shader == null) {
                sunflowAPI.shader(string + ".shader", new SimpleShader());
                sunflowAPI.parameter("shaders", string + ".shader");
            } else {
                sunflowAPI.parameter("shaders", "ra3shader");
            }
            sunflowAPI.instance(string + ".instance", string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return false;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        return true;
    }
}

