/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.channels.FileChannel;
import org.sunflow.SunflowAPI;
import org.sunflow.core.SceneParser;
import org.sunflow.core.camera.PinholeLens;
import org.sunflow.core.primitive.TriangleMesh;
import org.sunflow.core.shader.SimpleShader;
import org.sunflow.math.Point3;
import org.sunflow.math.Vector3;
import org.sunflow.system.Parser;
import org.sunflow.system.UI;

public class RA2Parser
implements SceneParser {
    public boolean parse(String string, SunflowAPI sunflowAPI) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        try {
            UI.printInfo(UI.Module.USER, "RA2 - Reading geometry: \"%s\" ...", string);
            object5 = new File(string);
            object4 = new FileInputStream(string);
            object3 = ((FileInputStream)object4).getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, ((File)object5).length());
            ((ByteBuffer)object3).order(ByteOrder.LITTLE_ENDIAN);
            object2 = ((ByteBuffer)object3).asFloatBuffer();
            object = new float[((Buffer)object2).capacity()];
            for (int i = 0; i < ((float[])object).length; ++i) {
                object[i] = ((FloatBuffer)object2).get(i);
            }
            ((FileInputStream)object4).close();
            sunflowAPI.parameter("points", "point", "vertex", (float[])object);
            int[] nArray = new int[3 * (((float[])object).length / 9)];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = i;
            }
            sunflowAPI.parameter("triangles", nArray);
            sunflowAPI.geometry(string, new TriangleMesh());
            sunflowAPI.shader(string + ".shader", new SimpleShader());
            sunflowAPI.parameter("shaders", string + ".shader");
            sunflowAPI.instance(string + ".instance", string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return false;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        try {
            string = string.replace(".ra2", ".txt");
            UI.printInfo(UI.Module.USER, "RA2 - Reading camera  : \"%s\" ...", string);
            object5 = new Parser(string);
            object4 = new Point3();
            ((Point3)object4).x = ((Parser)object5).getNextFloat();
            ((Point3)object4).y = ((Parser)object5).getNextFloat();
            ((Point3)object4).z = ((Parser)object5).getNextFloat();
            object3 = new Point3();
            ((Point3)object3).x = ((Parser)object5).getNextFloat();
            ((Point3)object3).y = ((Parser)object5).getNextFloat();
            ((Point3)object3).z = ((Parser)object5).getNextFloat();
            object2 = new Vector3();
            switch (((Parser)object5).getNextInt()) {
                case 0: {
                    ((Vector3)object2).set(1.0f, 0.0f, 0.0f);
                    break;
                }
                case 1: {
                    ((Vector3)object2).set(0.0f, 1.0f, 0.0f);
                    break;
                }
                case 2: {
                    ((Vector3)object2).set(0.0f, 0.0f, 1.0f);
                    break;
                }
                default: {
                    UI.printWarning(UI.Module.USER, "RA2 - Invalid up vector specification - using Z axis", new Object[0]);
                    ((Vector3)object2).set(0.0f, 0.0f, 1.0f);
                }
            }
            sunflowAPI.parameter("eye", (Point3)object4);
            sunflowAPI.parameter("target", (Point3)object3);
            sunflowAPI.parameter("up", (Vector3)object2);
            object = sunflowAPI.getUniqueName("camera");
            sunflowAPI.parameter("fov", 80.0f);
            sunflowAPI.camera((String)object, new PinholeLens());
            sunflowAPI.parameter("camera", (String)object);
            sunflowAPI.parameter("resolutionX", 1024);
            sunflowAPI.parameter("resolutionY", 1024);
            sunflowAPI.options("::options");
            ((Parser)object5).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            UI.printWarning(UI.Module.USER, "RA2 - Camera file not found", new Object[0]);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        return true;
    }
}

