/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core.light;

import org.sunflow.SunflowAPI;
import org.sunflow.core.LightSample;
import org.sunflow.core.LightSource;
import org.sunflow.core.ParameterList;
import org.sunflow.core.Ray;
import org.sunflow.core.Shader;
import org.sunflow.core.ShadingState;
import org.sunflow.core.primitive.TriangleMesh;
import org.sunflow.image.Color;
import org.sunflow.math.MathUtils;
import org.sunflow.math.OrthoNormalBasis;
import org.sunflow.math.Point3;
import org.sunflow.math.Vector3;

public class TriangleMeshLight
extends TriangleMesh
implements Shader {
    private Color radiance = Color.WHITE;
    private int numSamples = 4;

    public boolean update(ParameterList parameterList, SunflowAPI sunflowAPI) {
        this.radiance = parameterList.getColor("radiance", this.radiance);
        this.numSamples = parameterList.getInt("samples", this.numSamples);
        return super.update(parameterList, sunflowAPI);
    }

    public void init(String string, SunflowAPI sunflowAPI) {
        sunflowAPI.geometry(string, this);
        sunflowAPI.shader(string + ".shader", this);
        sunflowAPI.parameter("shaders", string + ".shader");
        sunflowAPI.instance(string + ".instance", string);
        int n = 0;
        int n2 = 0;
        while (n < this.triangles.length) {
            TriangleLight triangleLight = new TriangleLight(n2);
            String string2 = String.format("%s.light[%d]", string, n2);
            sunflowAPI.light(string2, triangleLight);
            n += 3;
            ++n2;
        }
    }

    public Color getRadiance(ShadingState shadingState) {
        if (!shadingState.includeLights()) {
            return Color.BLACK;
        }
        shadingState.faceforward();
        return shadingState.isBehind() ? Color.BLACK : this.radiance;
    }

    public void scatterPhoton(ShadingState shadingState, Color color) {
    }

    private class TriangleLight
    implements LightSource {
        private int tri3;
        private float area;
        private Vector3 ng;

        TriangleLight(int n) {
            this.tri3 = 3 * n;
            int n2 = TriangleMeshLight.this.triangles[this.tri3 + 0];
            int n3 = TriangleMeshLight.this.triangles[this.tri3 + 1];
            int n4 = TriangleMeshLight.this.triangles[this.tri3 + 2];
            Point3 point3 = TriangleMeshLight.this.getPoint(n2);
            Point3 point32 = TriangleMeshLight.this.getPoint(n3);
            Point3 point33 = TriangleMeshLight.this.getPoint(n4);
            this.ng = Point3.normal(point3, point32, point33);
            this.area = 0.5f * this.ng.length();
            this.ng.normalize();
        }

        public boolean update(ParameterList parameterList, SunflowAPI sunflowAPI) {
            return true;
        }

        public int getNumSamples() {
            return TriangleMeshLight.this.numSamples;
        }

        private final boolean intersectTriangleKensler(Ray ray) {
            float f;
            float f2;
            float f3;
            float f4;
            float f5;
            float f6;
            int n = 3 * TriangleMeshLight.this.triangles[this.tri3 + 0];
            int n2 = 3 * TriangleMeshLight.this.triangles[this.tri3 + 1];
            int n3 = 3 * TriangleMeshLight.this.triangles[this.tri3 + 2];
            float f7 = TriangleMeshLight.this.points[n2 + 0] - TriangleMeshLight.this.points[n + 0];
            float f8 = TriangleMeshLight.this.points[n2 + 1] - TriangleMeshLight.this.points[n + 1];
            float f9 = TriangleMeshLight.this.points[n2 + 2] - TriangleMeshLight.this.points[n + 2];
            float f10 = TriangleMeshLight.this.points[n + 0] - TriangleMeshLight.this.points[n3 + 0];
            float f11 = TriangleMeshLight.this.points[n + 1] - TriangleMeshLight.this.points[n3 + 1];
            float f12 = TriangleMeshLight.this.points[n + 2] - TriangleMeshLight.this.points[n3 + 2];
            float f13 = f8 * f12 - f9 * f11;
            float f14 = ray.dot(f13, f6 = f9 * f10 - f7 * f12, f5 = f7 * f11 - f8 * f10);
            float f15 = 1.0f / f14;
            float f16 = f15 * (f4 = f13 * (f3 = TriangleMeshLight.this.points[n + 0] - ray.ox) + f6 * (f2 = TriangleMeshLight.this.points[n + 1] - ray.oy) + f5 * (f = TriangleMeshLight.this.points[n + 2] - ray.oz));
            if (f16 <= 0.0f) {
                return false;
            }
            float f17 = f2 * ray.dz - f * ray.dy;
            float f18 = f * ray.dx - f3 * ray.dz;
            float f19 = f3 * ray.dy - f2 * ray.dx;
            float f20 = f17 * f10 + f18 * f11 + f19 * f12;
            float f21 = f15 * f20;
            if (f21 < 0.0f) {
                return false;
            }
            float f22 = f17 * f7 + f18 * f8 + f19 * f9;
            if ((f20 + f22) * f14 > f14 * f14) {
                return false;
            }
            float f23 = f15 * f22;
            if (f23 < 0.0f) {
                return false;
            }
            ray.setMax(f16 - 0.001f);
            return true;
        }

        public void getSamples(ShadingState shadingState) {
            if (TriangleMeshLight.this.numSamples == 0) {
                return;
            }
            Vector3 vector3 = shadingState.getNormal();
            Point3 point3 = shadingState.getPoint();
            Vector3 vector32 = Point3.sub(TriangleMeshLight.this.getPoint(TriangleMeshLight.this.triangles[this.tri3 + 0]), point3, new Vector3());
            if (Vector3.dot(vector32, this.ng) >= 0.0f) {
                return;
            }
            Vector3 vector33 = Point3.sub(TriangleMeshLight.this.getPoint(TriangleMeshLight.this.triangles[this.tri3 + 1]), point3, new Vector3());
            Vector3 vector34 = Point3.sub(TriangleMeshLight.this.getPoint(TriangleMeshLight.this.triangles[this.tri3 + 2]), point3, new Vector3());
            if (Vector3.dot(vector32, vector3) <= 0.0f && Vector3.dot(vector33, vector3) <= 0.0f && Vector3.dot(vector34, vector3) <= 0.0f) {
                return;
            }
            vector32.normalize();
            vector33.normalize();
            vector34.normalize();
            float f = Vector3.dot(vector34, vector32);
            Vector3 vector35 = new Vector3();
            vector35.x = vector34.x - f * vector32.x;
            vector35.y = vector34.y - f * vector32.y;
            vector35.z = vector34.z - f * vector32.z;
            float f2 = vector35.length();
            if (!(f2 > 1.0E-6f)) {
                return;
            }
            vector35.div(f2);
            Vector3 vector36 = Vector3.cross(vector32, vector33, new Vector3());
            float f3 = vector36.length();
            if (!(f3 > 1.0E-6f)) {
                return;
            }
            vector36.div(f3);
            Vector3 vector37 = Vector3.cross(vector33, vector34, new Vector3());
            float f4 = vector37.length();
            if (!(f4 > 1.0E-6f)) {
                return;
            }
            vector37.div(f4);
            Vector3 vector38 = Vector3.cross(vector34, vector32, new Vector3());
            float f5 = vector38.length();
            if (!(f5 > 1.0E-6f)) {
                return;
            }
            vector38.div(f5);
            float f6 = MathUtils.clamp(-Vector3.dot(vector38, vector36), -1.0f, 1.0f);
            float f7 = MathUtils.clamp(-Vector3.dot(vector36, vector37), -1.0f, 1.0f);
            float f8 = MathUtils.clamp(-Vector3.dot(vector37, vector38), -1.0f, 1.0f);
            float f9 = (float)Math.acos(f6);
            float f10 = (float)Math.acos(f7);
            float f11 = (float)Math.acos(f8);
            float f12 = f9 + f10 + f11 - (float)Math.PI;
            float f13 = MathUtils.clamp(Vector3.dot(vector32, vector33), -1.0f, 1.0f);
            float f14 = (float)Math.sin(f9);
            float f15 = f14 * f13;
            int n = shadingState.getDiffuseDepth() > 0 ? 1 : TriangleMeshLight.this.numSamples;
            Color color = Color.mul(f12 / (float)n, TriangleMeshLight.this.radiance);
            for (int i = 0; i < n; ++i) {
                Ray ray;
                float f16;
                float f17;
                float f18;
                float f19;
                float f20;
                float f21;
                float f22;
                float f23;
                double d = shadingState.getRandom(i, 0, n);
                double d2 = shadingState.getRandom(i, 1, n);
                float f24 = (float)d * f12 - f9 + (float)Math.PI;
                float f25 = (float)Math.sin(f24);
                float f26 = f25 - f15;
                float f27 = (-f26 + f6 * ((f23 = (float)Math.cos(f24)) * -f26 + f25 * (f22 = f23 + f6))) / (f14 * (f25 * -f26 - f23 * f22));
                float f28 = 1.0f - f27 * f27;
                if (f28 < 0.0f) {
                    f28 = 0.0f;
                }
                if ((f21 = 1.0f - (f20 = 1.0f - (float)d2 * (1.0f - (f = vector33.dot(f19 = f27 * vector32.x + (f18 = (float)Math.sqrt(f28)) * vector35.x, f17 = f27 * vector32.y + f18 * vector35.y, f16 = f27 * vector32.z + f18 * vector35.z)))) * f20) < 0.0f) {
                    f21 = 0.0f;
                }
                Vector3 vector39 = new Vector3();
                vector39.x = f19 - f * vector33.x;
                vector39.y = f17 - f * vector33.y;
                vector39.z = f16 - f * vector33.z;
                vector39.normalize();
                float f29 = (float)Math.sqrt(f21);
                Vector3 vector310 = new Vector3();
                vector310.x = f20 * vector33.x + f29 * vector39.x;
                vector310.y = f20 * vector33.y + f29 * vector39.y;
                vector310.z = f20 * vector33.z + f29 * vector39.z;
                if (!(Vector3.dot(vector310, vector3) > 0.0f && Vector3.dot(vector310, shadingState.getGeoNormal()) > 0.0f && Vector3.dot(vector310, this.ng) < 0.0f && this.intersectTriangleKensler(ray = new Ray(shadingState.getPoint(), vector310)))) continue;
                LightSample lightSample = new LightSample();
                lightSample.setShadowRay(ray);
                lightSample.setRadiance(color, color);
                lightSample.traceShadow(shadingState);
                shadingState.addSample(lightSample);
            }
        }

        public void getPhoton(double d, double d2, double d3, double d4, Point3 point3, Vector3 vector3, Color color) {
            double d5 = Math.sqrt(1.0 - d3);
            float f = (float)(d4 * d5);
            float f2 = (float)(1.0 - d5);
            float f3 = 1.0f - f - f2;
            int n = 3 * TriangleMeshLight.this.triangles[this.tri3 + 0];
            int n2 = 3 * TriangleMeshLight.this.triangles[this.tri3 + 1];
            int n3 = 3 * TriangleMeshLight.this.triangles[this.tri3 + 2];
            point3.x = f3 * TriangleMeshLight.this.points[n + 0] + f * TriangleMeshLight.this.points[n2 + 0] + f2 * TriangleMeshLight.this.points[n3 + 0];
            point3.y = f3 * TriangleMeshLight.this.points[n + 1] + f * TriangleMeshLight.this.points[n2 + 1] + f2 * TriangleMeshLight.this.points[n3 + 1];
            point3.z = f3 * TriangleMeshLight.this.points[n + 2] + f * TriangleMeshLight.this.points[n2 + 2] + f2 * TriangleMeshLight.this.points[n3 + 2];
            point3.x += 0.001f * this.ng.x;
            point3.y += 0.001f * this.ng.y;
            point3.z += 0.001f * this.ng.z;
            OrthoNormalBasis orthoNormalBasis = OrthoNormalBasis.makeFromW(this.ng);
            f = (float)(Math.PI * 2 * d);
            d5 = Math.sqrt(d2);
            orthoNormalBasis.transform(new Vector3((float)(Math.cos(f) * d5), (float)(Math.sin(f) * d5), (float)Math.sqrt(1.0 - d2)), vector3);
            Color.mul((float)Math.PI * this.area, TriangleMeshLight.this.radiance, color);
        }

        public float getPower() {
            return TriangleMeshLight.this.radiance.copy().mul((float)Math.PI * this.area).getLuminance();
        }
    }
}

