/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core.light;

import org.sunflow.SunflowAPI;
import org.sunflow.core.IntersectionState;
import org.sunflow.core.LightSample;
import org.sunflow.core.LightSource;
import org.sunflow.core.ParameterList;
import org.sunflow.core.PrimitiveList;
import org.sunflow.core.Ray;
import org.sunflow.core.Shader;
import org.sunflow.core.ShadingState;
import org.sunflow.image.ChromaticitySpectrum;
import org.sunflow.image.Color;
import org.sunflow.image.ConstantSpectralCurve;
import org.sunflow.image.IrregularSpectralCurve;
import org.sunflow.image.RGBSpace;
import org.sunflow.image.RegularSpectralCurve;
import org.sunflow.image.SpectralCurve;
import org.sunflow.image.XYZColor;
import org.sunflow.math.BoundingBox;
import org.sunflow.math.MathUtils;
import org.sunflow.math.Matrix4;
import org.sunflow.math.OrthoNormalBasis;
import org.sunflow.math.Point3;
import org.sunflow.math.Vector3;

public class SunSkyLight
implements LightSource,
PrimitiveList,
Shader {
    private int numSkySamples = 64;
    private OrthoNormalBasis basis;
    private Vector3 sunDirWorld;
    private float turbidity = 6.0f;
    private Vector3 sunDir;
    private SpectralCurve sunSpectralRadiance;
    private Color sunColor;
    private float sunTheta;
    private double zenithY;
    private double zenithx;
    private double zenithy;
    private final double[] perezY = new double[5];
    private final double[] perezx = new double[5];
    private final double[] perezy = new double[5];
    private float jacobian;
    private float[] colHistogram;
    private float[][] imageHistogram;
    private static final float[] solAmplitudes = new float[]{165.5f, 162.3f, 211.2f, 258.8f, 258.2f, 242.3f, 267.6f, 296.6f, 305.4f, 300.6f, 306.6f, 288.3f, 287.1f, 278.2f, 271.0f, 272.3f, 263.6f, 255.0f, 250.6f, 253.1f, 253.5f, 251.3f, 246.3f, 241.7f, 236.8f, 232.1f, 228.2f, 223.4f, 219.7f, 215.3f, 211.0f, 207.3f, 202.4f, 198.7f, 194.3f, 190.7f, 186.3f, 182.6f};
    private static final RegularSpectralCurve solCurve = new RegularSpectralCurve(solAmplitudes, 380.0f, 750.0f);
    private static final float[] k_oWavelengths = new float[]{300.0f, 305.0f, 310.0f, 315.0f, 320.0f, 325.0f, 330.0f, 335.0f, 340.0f, 345.0f, 350.0f, 355.0f, 445.0f, 450.0f, 455.0f, 460.0f, 465.0f, 470.0f, 475.0f, 480.0f, 485.0f, 490.0f, 495.0f, 500.0f, 505.0f, 510.0f, 515.0f, 520.0f, 525.0f, 530.0f, 535.0f, 540.0f, 545.0f, 550.0f, 555.0f, 560.0f, 565.0f, 570.0f, 575.0f, 580.0f, 585.0f, 590.0f, 595.0f, 600.0f, 605.0f, 610.0f, 620.0f, 630.0f, 640.0f, 650.0f, 660.0f, 670.0f, 680.0f, 690.0f, 700.0f, 710.0f, 720.0f, 730.0f, 740.0f, 750.0f, 760.0f, 770.0f, 780.0f, 790.0f};
    private static final float[] k_oAmplitudes = new float[]{10.0f, 4.8f, 2.7f, 1.35f, 0.8f, 0.38f, 0.16f, 0.075f, 0.04f, 0.019f, 0.007f, 0.0f, 0.003f, 0.003f, 0.004f, 0.006f, 0.008f, 0.009f, 0.012f, 0.014f, 0.017f, 0.021f, 0.025f, 0.03f, 0.035f, 0.04f, 0.045f, 0.048f, 0.057f, 0.063f, 0.07f, 0.075f, 0.08f, 0.085f, 0.095f, 0.103f, 0.11f, 0.12f, 0.122f, 0.12f, 0.118f, 0.115f, 0.12f, 0.125f, 0.13f, 0.12f, 0.105f, 0.09f, 0.079f, 0.067f, 0.057f, 0.048f, 0.036f, 0.028f, 0.023f, 0.018f, 0.014f, 0.011f, 0.01f, 0.009f, 0.007f, 0.004f, 0.0f, 0.0f};
    private static final float[] k_gWavelengths = new float[]{759.0f, 760.0f, 770.0f, 771.0f};
    private static final float[] k_gAmplitudes = new float[]{0.0f, 3.0f, 0.21f, 0.0f};
    private static final float[] k_waWavelengths = new float[]{689.0f, 690.0f, 700.0f, 710.0f, 720.0f, 730.0f, 740.0f, 750.0f, 760.0f, 770.0f, 780.0f, 790.0f, 800.0f};
    private static final float[] k_waAmplitudes = new float[]{0.0f, 0.016f, 0.024f, 0.0125f, 1.0f, 0.87f, 0.061f, 0.001f, 1.0E-5f, 1.0E-5f, 6.0E-4f, 0.0175f, 0.036f};
    private static final IrregularSpectralCurve k_oCurve = new IrregularSpectralCurve(k_oWavelengths, k_oAmplitudes);
    private static final IrregularSpectralCurve k_gCurve = new IrregularSpectralCurve(k_gWavelengths, k_gAmplitudes);
    private static final IrregularSpectralCurve k_waCurve = new IrregularSpectralCurve(k_waWavelengths, k_waAmplitudes);

    public SunSkyLight() {
        this.sunDirWorld = new Vector3(1.0f, 1.0f, 1.0f);
        this.basis = OrthoNormalBasis.makeFromWV(new Vector3(0.0f, 0.0f, 1.0f), new Vector3(0.0f, 1.0f, 0.0f));
        this.initSunSky();
    }

    private SpectralCurve computeAttenuatedSunlight(float f, float f2) {
        float[] fArray = new float[91];
        double d = 0.0460836582205 * (double)f2 - 0.04586025928522;
        double d2 = 1.0 / (Math.cos(f) + 9.4E-4 * Math.pow(1.6386 - (double)f, -1.253));
        int n = 0;
        for (int i = 350; i <= 800; i += 5) {
            double d3 = Math.exp(-d2 * 0.008735 * Math.pow((double)i / 1000.0, -4.08));
            double d4 = Math.exp(-d2 * d * Math.pow((double)i / 1000.0, -1.3));
            double d5 = Math.exp(-d2 * (double)k_oCurve.sample(i) * 0.35);
            double d6 = Math.exp(-1.41 * (double)k_gCurve.sample(i) * d2 / Math.pow(1.0 + 118.93 * (double)k_gCurve.sample(i) * d2, 0.45));
            double d7 = Math.exp(-0.2385 * (double)k_waCurve.sample(i) * 2.0 * d2 / Math.pow(1.0 + 20.07 * (double)k_waCurve.sample(i) * 2.0 * d2, 0.45));
            double d8 = (double)solCurve.sample(i) * d3 * d4 * d5 * d6 * d7;
            fArray[n] = (float)d8;
            ++n;
        }
        return new RegularSpectralCurve(fArray, 350.0f, 800.0f);
    }

    private double perezFunction(double[] dArray, double d, double d2, double d3) {
        double d4 = (1.0 + dArray[0] * Math.exp(dArray[1])) * (1.0 + dArray[2] * Math.exp(dArray[3] * (double)this.sunTheta) + dArray[4] * Math.cos(this.sunTheta) * Math.cos(this.sunTheta));
        double d5 = (1.0 + dArray[0] * Math.exp(dArray[1] / Math.cos(d))) * (1.0 + dArray[2] * Math.exp(dArray[3] * d2) + dArray[4] * Math.cos(d2) * Math.cos(d2));
        return d3 * d5 / d4;
    }

    private void initSunSky() {
        int n;
        this.sunDirWorld.normalize();
        this.sunDir = this.basis.untransform(this.sunDirWorld, new Vector3());
        this.sunDir.normalize();
        this.sunTheta = (float)Math.acos(MathUtils.clamp(this.sunDir.z, -1.0f, 1.0f));
        if (this.sunDir.z > 0.0f) {
            this.sunSpectralRadiance = this.computeAttenuatedSunlight(this.sunTheta, this.turbidity);
            this.sunColor = RGBSpace.SRGB.convertXYZtoRGB(this.sunSpectralRadiance.toXYZ().mul(1.0E-4f)).constrainRGB();
        } else {
            this.sunSpectralRadiance = new ConstantSpectralCurve(0.0f);
        }
        float f = this.sunTheta * this.sunTheta;
        float f2 = this.sunTheta * f;
        float f3 = this.turbidity;
        float f4 = this.turbidity * this.turbidity;
        double d = (0.4444444444444444 - (double)f3 / 120.0) * (Math.PI - 2.0 * (double)this.sunTheta);
        this.zenithY = (4.0453 * (double)f3 - 4.971) * Math.tan(d) - 0.2155 * (double)f3 + 2.4192;
        this.zenithY *= 1000.0;
        this.zenithx = (0.00165 * (double)f2 - 0.00374 * (double)f + 0.00208 * (double)this.sunTheta + 0.0) * (double)f4 + (-0.02902 * (double)f2 + 0.06377 * (double)f - 0.03202 * (double)this.sunTheta + 0.00394) * (double)f3 + (0.11693 * (double)f2 - 0.21196 * (double)f + 0.06052 * (double)this.sunTheta + 0.25885);
        this.zenithy = (0.00275 * (double)f2 - 0.0061 * (double)f + 0.00316 * (double)this.sunTheta + 0.0) * (double)f4 + (-0.04212 * (double)f2 + 0.0897 * (double)f - 0.04153 * (double)this.sunTheta + 0.00515) * (double)f3 + (0.15346 * (double)f2 - 0.26756 * (double)f + 0.06669 * (double)this.sunTheta + 0.26688);
        this.perezY[0] = 0.17872 * (double)f3 - 1.46303;
        this.perezY[1] = -0.3554 * (double)f3 + 0.42749;
        this.perezY[2] = -0.02266 * (double)f3 + 5.32505;
        this.perezY[3] = 0.12064 * (double)f3 - 2.57705;
        this.perezY[4] = -0.06696 * (double)f3 + 0.37027;
        this.perezx[0] = -0.01925 * (double)f3 - 0.25922;
        this.perezx[1] = -0.06651 * (double)f3 + 8.1E-4;
        this.perezx[2] = -4.1E-4 * (double)f3 + 0.21247;
        this.perezx[3] = -0.06409 * (double)f3 - 0.89887;
        this.perezx[4] = -0.00325 * (double)f3 + 0.04517;
        this.perezy[0] = -0.01669 * (double)f3 - 0.26078;
        this.perezy[1] = -0.09495 * (double)f3 + 0.00921;
        this.perezy[2] = -0.00792 * (double)f3 + 0.21023;
        this.perezy[3] = -0.04405 * (double)f3 - 1.65369;
        this.perezy[4] = -0.01092 * (double)f3 + 0.05291;
        this.imageHistogram = new float[32][32];
        this.colHistogram = new float[32];
        float f5 = 0.03125f;
        float f6 = 0.03125f;
        for (n = 0; n < 32; ++n) {
            int n2;
            for (n2 = 0; n2 < 32; ++n2) {
                float f7 = ((float)n + 0.5f) * f5;
                float f8 = ((float)n2 + 0.5f) * f6;
                Color color = this.getSkyRGB(this.getDirection(f7, f8));
                this.imageHistogram[n][n2] = color.getLuminance() * (float)Math.sin(Math.PI * (double)f8);
                if (n2 <= 0) continue;
                float[] fArray = this.imageHistogram[n];
                int n3 = n2;
                fArray[n3] = fArray[n3] + this.imageHistogram[n][n2 - 1];
            }
            this.colHistogram[n] = this.imageHistogram[n][31];
            if (n > 0) {
                int n4 = n;
                this.colHistogram[n4] = this.colHistogram[n4] + this.colHistogram[n - 1];
            }
            n2 = 0;
            while (n2 < 32) {
                float[] fArray = this.imageHistogram[n];
                int n5 = n2++;
                fArray[n5] = fArray[n5] / this.imageHistogram[n][31];
            }
        }
        n = 0;
        while (n < 32) {
            int n6 = n++;
            this.colHistogram[n6] = this.colHistogram[n6] / this.colHistogram[31];
        }
        this.jacobian = 0.01927657f;
    }

    public boolean update(ParameterList parameterList, SunflowAPI sunflowAPI) {
        Vector3 vector3 = parameterList.getVector("up", null);
        Vector3 vector32 = parameterList.getVector("east", null);
        if (vector3 != null && vector32 != null) {
            this.basis = OrthoNormalBasis.makeFromWV(vector3, vector32);
        } else if (vector3 != null) {
            this.basis = OrthoNormalBasis.makeFromW(vector3);
        }
        this.numSkySamples = parameterList.getInt("samples", this.numSkySamples);
        this.sunDirWorld = parameterList.getVector("sundir", this.sunDirWorld);
        this.turbidity = parameterList.getFloat("turbidity", this.turbidity);
        this.initSunSky();
        return true;
    }

    public void init(String string, SunflowAPI sunflowAPI) {
        sunflowAPI.geometry(string, this);
        sunflowAPI.shader(string + ".shader", this);
        sunflowAPI.parameter("shaders", string + ".shader");
        sunflowAPI.instance(string + ".instance", string);
        sunflowAPI.light(string + ".light", this);
    }

    private Color getSkyRGB(Vector3 vector3) {
        if (vector3.z < 0.0f) {
            return Color.BLACK;
        }
        if (vector3.z < 0.001f) {
            vector3.z = 0.001f;
        }
        vector3.normalize();
        double d = Math.acos(MathUtils.clamp(vector3.z, -1.0f, 1.0f));
        double d2 = Math.acos(MathUtils.clamp(Vector3.dot(vector3, this.sunDir), -1.0f, 1.0f));
        double d3 = this.perezFunction(this.perezx, d, d2, this.zenithx);
        double d4 = this.perezFunction(this.perezy, d, d2, this.zenithy);
        double d5 = this.perezFunction(this.perezY, d, d2, this.zenithY) * 1.0E-4;
        XYZColor xYZColor = ChromaticitySpectrum.get((float)d3, (float)d4);
        float f = (float)((double)xYZColor.getX() * d5 / (double)xYZColor.getY());
        float f2 = (float)((double)xYZColor.getZ() * d5 / (double)xYZColor.getY());
        return RGBSpace.SRGB.convertXYZtoRGB(f, (float)d5, f2);
    }

    public int getNumSamples() {
        return 1 + this.numSkySamples;
    }

    public void getPhoton(double d, double d2, double d3, double d4, Point3 point3, Vector3 vector3, Color color) {
    }

    public float getPower() {
        return 0.0f;
    }

    public void getSamples(ShadingState shadingState) {
        if (Vector3.dot(this.sunDirWorld, shadingState.getGeoNormal()) > 0.0f && Vector3.dot(this.sunDirWorld, shadingState.getNormal()) > 0.0f) {
            LightSample lightSample = new LightSample();
            lightSample.setShadowRay(new Ray(shadingState.getPoint(), this.sunDirWorld));
            lightSample.getShadowRay().setMax(Float.MAX_VALUE);
            lightSample.setRadiance(this.sunColor, this.sunColor);
            lightSample.traceShadow(shadingState);
            shadingState.addSample(lightSample);
        }
        int n = shadingState.getDiffuseDepth() > 0 ? 1 : this.numSkySamples;
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3;
            double d = shadingState.getRandom(i, 0, n);
            double d2 = shadingState.getRandom(i, 1, n);
            for (n3 = 0; d >= (double)this.colHistogram[n3] && n3 < this.colHistogram.length - 1; ++n3) {
            }
            float[] fArray = this.imageHistogram[n3];
            for (n2 = 0; d2 >= (double)fArray[n2] && n2 < fArray.length - 1; ++n2) {
            }
            float f = (float)(n3 == 0 ? d / (double)this.colHistogram[0] : (d - (double)this.colHistogram[n3 - 1]) / (double)(this.colHistogram[n3] - this.colHistogram[n3 - 1]));
            float f2 = (float)(n2 == 0 ? d2 / (double)fArray[0] : (d2 - (double)fArray[n2 - 1]) / (double)(fArray[n2] - fArray[n2 - 1]));
            float f3 = n3 == 0 ? this.colHistogram[0] : this.colHistogram[n3] - this.colHistogram[n3 - 1];
            float f4 = n2 == 0 ? fArray[0] : fArray[n2] - fArray[n2 - 1];
            float f5 = ((float)n3 + f) / (float)this.colHistogram.length;
            float f6 = ((float)n2 + f2) / (float)fArray.length;
            float f7 = (float)Math.sin((double)f6 * Math.PI) * this.jacobian / ((float)n * f3 * f4);
            Vector3 vector3 = this.getDirection(f5, f6);
            Vector3 vector32 = this.basis.transform(vector3, new Vector3());
            if (!(Vector3.dot(vector32, shadingState.getGeoNormal()) > 0.0f) || !(Vector3.dot(vector32, shadingState.getNormal()) > 0.0f)) continue;
            LightSample lightSample = new LightSample();
            lightSample.setShadowRay(new Ray(shadingState.getPoint(), vector32));
            lightSample.getShadowRay().setMax(Float.MAX_VALUE);
            Color color = this.getSkyRGB(vector3);
            lightSample.setRadiance(color, color);
            lightSample.getDiffuseRadiance().mul(f7);
            lightSample.getSpecularRadiance().mul(f7);
            lightSample.traceShadow(shadingState);
            shadingState.addSample(lightSample);
        }
    }

    public PrimitiveList getBakingPrimitives() {
        return null;
    }

    public int getNumPrimitives() {
        return 1;
    }

    public float getPrimitiveBound(int n, int n2) {
        return 0.0f;
    }

    public BoundingBox getWorldBounds(Matrix4 matrix4) {
        return null;
    }

    public void intersectPrimitive(Ray ray, int n, IntersectionState intersectionState) {
        if (ray.getMax() == Float.POSITIVE_INFINITY) {
            intersectionState.setIntersection(0, 0.0f, 0.0f);
        }
    }

    public void prepareShadingState(ShadingState shadingState) {
        if (shadingState.includeLights()) {
            shadingState.setShader(this);
        }
    }

    public Color getRadiance(ShadingState shadingState) {
        return this.getSkyRGB(this.basis.untransform(shadingState.getRay().getDirection())).constrainRGB();
    }

    public void scatterPhoton(ShadingState shadingState, Color color) {
    }

    private Vector3 getDirection(float f, float f2) {
        Vector3 vector3 = new Vector3();
        double d = 0.0;
        double d2 = 0.0;
        d2 = (double)(f * 2.0f) * Math.PI;
        d = (double)f2 * Math.PI;
        double d3 = Math.sin(d);
        vector3.x = (float)(-d3 * Math.cos(d2));
        vector3.y = (float)Math.cos(d);
        vector3.z = (float)(d3 * Math.sin(d2));
        return vector3;
    }
}

