/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core.light;

import org.sunflow.SunflowAPI;
import org.sunflow.core.LightSample;
import org.sunflow.core.LightSource;
import org.sunflow.core.ParameterList;
import org.sunflow.core.Ray;
import org.sunflow.core.Shader;
import org.sunflow.core.ShadingState;
import org.sunflow.core.primitive.Sphere;
import org.sunflow.image.Color;
import org.sunflow.math.Matrix4;
import org.sunflow.math.OrthoNormalBasis;
import org.sunflow.math.Point3;
import org.sunflow.math.Solvers;
import org.sunflow.math.Vector3;

public class SphereLight
implements LightSource,
Shader {
    private Color radiance = Color.WHITE;
    private int numSamples = 4;
    private Point3 center = new Point3();
    private float radius = 1.0f;
    private float r2 = 1.0f;

    public boolean update(ParameterList parameterList, SunflowAPI sunflowAPI) {
        this.radiance = parameterList.getColor("radiance", this.radiance);
        this.numSamples = parameterList.getInt("samples", this.numSamples);
        this.radius = parameterList.getFloat("radius", this.radius);
        this.r2 = this.radius * this.radius;
        this.center = parameterList.getPoint("center", this.center);
        return true;
    }

    public void init(String string, SunflowAPI sunflowAPI) {
        sunflowAPI.light(string, this);
        sunflowAPI.geometry(string + ".geo", new Sphere());
        sunflowAPI.shader(string + ".shader", this);
        sunflowAPI.parameter("shaders", string + ".shader");
        sunflowAPI.parameter("transform", Matrix4.translation(this.center.x, this.center.y, this.center.z).multiply(Matrix4.scale(this.radius)));
        sunflowAPI.instance(string + ".instance", string + ".geo");
    }

    public int getNumSamples() {
        return this.numSamples;
    }

    public int getLowSamples() {
        return 1;
    }

    public boolean isVisible(ShadingState shadingState) {
        return shadingState.getPoint().distanceToSquared(this.center) > this.r2;
    }

    public void getSamples(ShadingState shadingState) {
        if (this.getNumSamples() <= 0) {
            return;
        }
        Vector3 vector3 = Point3.sub(this.center, shadingState.getPoint(), new Vector3());
        float f = vector3.lengthSquared();
        if (f <= this.r2) {
            return;
        }
        float f2 = vector3.x + shadingState.getNormal().x * this.radius;
        float f3 = vector3.y + shadingState.getNormal().y * this.radius;
        float f4 = vector3.z + shadingState.getNormal().z * this.radius;
        if (shadingState.getNormal().dot(f2, f3, f4) <= 0.0f) {
            return;
        }
        float f5 = (float)Math.sqrt(Math.max(0.0f, 1.0f - this.r2 / Vector3.dot(vector3, vector3)));
        OrthoNormalBasis orthoNormalBasis = OrthoNormalBasis.makeFromW(vector3);
        int n = shadingState.getDiffuseDepth() > 0 ? 1 : this.getNumSamples();
        float f6 = (float)(Math.PI * 2 * (double)(1.0f - f5));
        Color color = Color.mul(f6 / (float)n, this.radiance);
        for (int i = 0; i < n; ++i) {
            float f7;
            float f8;
            double d = shadingState.getRandom(i, 0, n);
            double d2 = shadingState.getRandom(i, 1, n);
            double d3 = (1.0 - d) * (double)f5 + d;
            double d4 = Math.sqrt(1.0 - d3 * d3);
            double d5 = d2 * 2.0 * Math.PI;
            Vector3 vector32 = new Vector3((float)(Math.cos(d5) * d4), (float)(Math.sin(d5) * d4), (float)d3);
            orthoNormalBasis.transform(vector32);
            float f9 = Vector3.dot(vector32, shadingState.getNormal());
            if (f9 <= 0.0f) continue;
            float f10 = shadingState.getPoint().x - this.center.x;
            float f11 = shadingState.getPoint().y - this.center.y;
            float f12 = shadingState.getPoint().z - this.center.z;
            float f13 = Vector3.dot(vector32, vector32);
            double[] dArray = Solvers.solveQuadric(f13, f8 = 2.0f * (vector32.x * f10 + vector32.y * f11 + vector32.z * f12), f7 = f10 * f10 + f11 * f11 + f12 * f12 - this.r2);
            if (dArray == null) continue;
            LightSample lightSample = new LightSample();
            lightSample.setShadowRay(new Ray(shadingState.getPoint(), vector32));
            lightSample.getShadowRay().setMax((float)dArray[0] - 0.001f);
            lightSample.setRadiance(color, color);
            lightSample.traceShadow(shadingState);
            shadingState.addSample(lightSample);
        }
    }

    public void getPhoton(double d, double d2, double d3, double d4, Point3 point3, Vector3 vector3, Color color) {
        float f = (float)(1.0 - 2.0 * d3);
        float f2 = (float)Math.sqrt(Math.max(0.0f, 1.0f - f * f));
        float f3 = (float)(Math.PI * 2 * d4);
        float f4 = f2 * (float)Math.cos(f3);
        float f5 = f2 * (float)Math.sin(f3);
        point3.x = this.center.x + f4 * this.radius;
        point3.y = this.center.y + f5 * this.radius;
        point3.z = this.center.z + f * this.radius;
        OrthoNormalBasis orthoNormalBasis = OrthoNormalBasis.makeFromW(new Vector3(f4, f5, f));
        f3 = (float)(Math.PI * 2 * d);
        float f6 = (float)Math.cos(f3);
        float f7 = (float)Math.sin(f3);
        float f8 = (float)Math.sqrt(d2);
        float f9 = (float)Math.sqrt(1.0 - d2);
        vector3.x = f6 * f8;
        vector3.y = f7 * f8;
        vector3.z = f9;
        orthoNormalBasis.transform(vector3);
        color.set(this.radiance);
        color.mul((float)(39.47841760435743 * (double)this.r2));
    }

    public float getPower() {
        return this.radiance.copy().mul((float)(39.47841760435743 * (double)this.r2)).getLuminance();
    }

    public Color getRadiance(ShadingState shadingState) {
        if (!shadingState.includeLights()) {
            return Color.BLACK;
        }
        shadingState.faceforward();
        return shadingState.isBehind() ? Color.BLACK : this.radiance;
    }

    public void scatterPhoton(ShadingState shadingState, Color color) {
    }
}

