/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core.gi;

import org.sunflow.core.GIEngine;
import org.sunflow.core.Options;
import org.sunflow.core.Ray;
import org.sunflow.core.Scene;
import org.sunflow.core.ShadingState;
import org.sunflow.image.Color;
import org.sunflow.math.OrthoNormalBasis;
import org.sunflow.math.Vector3;
import org.sunflow.system.UI;

public class PathTracingGIEngine
implements GIEngine {
    private int samples;

    public PathTracingGIEngine(Options options) {
        this.samples = options.getInt("gi.path.samples", 16);
    }

    public boolean requiresPhotons() {
        return false;
    }

    public boolean init(Scene scene) {
        this.samples = Math.max(0, this.samples);
        UI.printInfo(UI.Module.LIGHT, "Path tracer settings:", new Object[0]);
        UI.printInfo(UI.Module.LIGHT, "  * Samples: %d", this.samples);
        return true;
    }

    public Color getIrradiance(ShadingState shadingState, Color color) {
        if (this.samples <= 0) {
            return Color.BLACK;
        }
        Color color2 = Color.black();
        OrthoNormalBasis orthoNormalBasis = shadingState.getBasis();
        Vector3 vector3 = new Vector3();
        int n = shadingState.getDiffuseDepth() == 0 ? this.samples : 1;
        for (int i = 0; i < n; ++i) {
            float f = (float)shadingState.getRandom(i, 0, n);
            float f2 = (float)shadingState.getRandom(i, 1, n);
            float f3 = (float)((double)(f * 2.0f) * Math.PI);
            float f4 = (float)Math.cos(f3);
            float f5 = (float)Math.sin(f3);
            float f6 = (float)Math.sqrt(f2);
            float f7 = (float)Math.sqrt(1.0f - f2);
            vector3.x = f4 * f6;
            vector3.y = f5 * f6;
            vector3.z = f7;
            orthoNormalBasis.transform(vector3);
            ShadingState shadingState2 = shadingState.traceFinalGather(new Ray(shadingState.getPoint(), vector3), i);
            if (shadingState2 == null) continue;
            shadingState2.getInstance().prepareShadingState(shadingState2);
            if (shadingState2.getShader() == null) continue;
            color2.add(shadingState2.getShader().getRadiance(shadingState2));
        }
        color2.mul((float)Math.PI / (float)n);
        return color2;
    }

    public Color getGlobalRadiance(ShadingState shadingState) {
        return Color.BLACK;
    }
}

