/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core.gi;

import java.util.ArrayList;
import org.sunflow.core.GIEngine;
import org.sunflow.core.Options;
import org.sunflow.core.PhotonStore;
import org.sunflow.core.Ray;
import org.sunflow.core.Scene;
import org.sunflow.core.ShadingState;
import org.sunflow.image.Color;
import org.sunflow.math.BoundingBox;
import org.sunflow.math.OrthoNormalBasis;
import org.sunflow.math.Point3;
import org.sunflow.math.Vector3;
import org.sunflow.system.UI;

public class InstantGI
implements GIEngine {
    private int numPhotons;
    private int numSets;
    private float c;
    private int numBias;
    private PointLight[][] virtualLights;

    public InstantGI(Options options) {
        this.numPhotons = options.getInt("gi.igi.samples", 64);
        this.numSets = options.getInt("gi.igi.sets", 1);
        this.c = options.getFloat("gi.igi.c", 3.0E-5f);
        this.numBias = options.getInt("gi.igi.bias_samples", 0);
        this.virtualLights = null;
    }

    public Color getGlobalRadiance(ShadingState shadingState) {
        Point3 point3 = shadingState.getPoint();
        Vector3 vector3 = shadingState.getNormal();
        int n = (int)(shadingState.getRandom(0, 1, 1) * (double)this.numSets);
        float f = 0.0f;
        float f2 = 1.0f;
        Color color = null;
        for (PointLight pointLight : this.virtualLights[n]) {
            float f3;
            f = Math.max(f, pointLight.power.getAverage());
            if (!(Vector3.dot(vector3, pointLight.n) > 0.9f) || !((f3 = pointLight.p.distanceToSquared(point3)) < f2)) continue;
            color = pointLight.power;
            f2 = f3;
        }
        return color == null ? Color.BLACK : color.copy().mul(1.0f / f);
    }

    public boolean init(Scene scene) {
        if (this.numSets < 1) {
            this.numSets = 1;
        }
        UI.printInfo(UI.Module.LIGHT, "Instant Global Illumination settings:", new Object[0]);
        UI.printInfo(UI.Module.LIGHT, "  * Samples:     %d", this.numPhotons);
        UI.printInfo(UI.Module.LIGHT, "  * Sets:        %d", this.numSets);
        UI.printInfo(UI.Module.LIGHT, "  * Bias bound:  %f", Float.valueOf(this.c));
        UI.printInfo(UI.Module.LIGHT, "  * Bias rays:   %d", this.numBias);
        this.virtualLights = new PointLight[this.numSets][];
        if (this.numPhotons > 0) {
            int n = 0;
            int n2 = 0;
            while (n < this.virtualLights.length) {
                PointLightStore pointLightStore = new PointLightStore();
                if (!scene.calculatePhotons(pointLightStore, "virtual", n2)) {
                    return false;
                }
                this.virtualLights[n] = pointLightStore.virtualLights.toArray(new PointLight[pointLightStore.virtualLights.size()]);
                UI.printInfo(UI.Module.LIGHT, "Stored %d virtual point lights for set %d of %d", this.virtualLights[n].length, n + 1, this.numSets);
                ++n;
                n2 += this.numPhotons;
            }
        } else {
            for (int i = 0; i < this.virtualLights.length; ++i) {
                this.virtualLights[i] = new PointLight[0];
            }
        }
        return true;
    }

    public Color getIrradiance(ShadingState shadingState, Color color) {
        int n;
        float f;
        float f2;
        float f3;
        float f4;
        float f5 = (float)Math.PI * this.c / color.getMax();
        Color color2 = Color.black();
        Point3 point3 = shadingState.getPoint();
        Vector3 vector3 = shadingState.getNormal();
        int n2 = (int)(shadingState.getRandom(0, 1, 1) * (double)this.numSets);
        for (PointLight pointLight : this.virtualLights[n2]) {
            Ray ray = new Ray(point3, pointLight.p);
            f4 = -(ray.dx * pointLight.n.x + ray.dy * pointLight.n.y + ray.dz * pointLight.n.z);
            f3 = ray.dx * vector3.x + ray.dy * vector3.y + ray.dz * vector3.z;
            if (!(f4 > 0.0f) || !(f3 > 0.0f)) continue;
            f2 = ray.getMax() * ray.getMax();
            Color color3 = shadingState.traceShadow(ray);
            Color color4 = Color.blend(pointLight.power, Color.BLACK, color3);
            f = f3 * f4 / f2;
            color2.madd(0.25f * Math.min(f, f5), color4);
        }
        int n3 = n = shadingState.getDiffuseDepth() == 0 || this.numBias <= 0 ? this.numBias : 1;
        if (n <= 0) {
            return color2;
        }
        OrthoNormalBasis orthoNormalBasis = shadingState.getBasis();
        Vector3 vector32 = new Vector3();
        float f6 = (float)Math.PI / (float)n;
        for (int i = 0; i < n; ++i) {
            float f7;
            f4 = (float)shadingState.getRandom(i, 0, n);
            f3 = (float)shadingState.getRandom(i, 1, n);
            f2 = (float)((double)(f4 * 2.0f) * Math.PI);
            float f8 = (float)Math.cos(f2);
            float f9 = (float)Math.sin(f2);
            f = (float)Math.sqrt(f3);
            float f10 = (float)Math.sqrt(1.0f - f3);
            vector32.x = f8 * f;
            vector32.y = f9 * f;
            vector32.z = f10;
            orthoNormalBasis.transform(vector32);
            Ray ray = new Ray(shadingState.getPoint(), vector32);
            ray.setMax((float)Math.sqrt(f10 / f5));
            ShadingState shadingState2 = shadingState.traceFinalGather(ray, i);
            if (shadingState2 == null) continue;
            shadingState2.getInstance().prepareShadingState(shadingState2);
            if (shadingState2.getShader() == null) continue;
            float f11 = shadingState2.getRay().getMax();
            float f12 = f11 * f11;
            float f13 = -Vector3.dot(vector32, shadingState2.getNormal());
            if (!(f13 > 0.0f) || !((f7 = f10 * f13 / f12) > f5)) continue;
            color2.madd(f6 * (f7 - f5) / f7, shadingState2.getShader().getRadiance(shadingState2));
        }
        return color2;
    }

    private class PointLightStore
    implements PhotonStore {
        ArrayList<PointLight> virtualLights = new ArrayList();

        private PointLightStore() {
        }

        public int numEmit() {
            return InstantGI.this.numPhotons;
        }

        public void prepare(BoundingBox boundingBox) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void store(ShadingState shadingState, Vector3 vector3, Color color, Color color2) {
            shadingState.faceforward();
            PointLight pointLight = new PointLight();
            pointLight.p = shadingState.getPoint();
            pointLight.n = shadingState.getNormal();
            pointLight.power = color;
            PointLightStore pointLightStore = this;
            synchronized (pointLightStore) {
                this.virtualLights.add(pointLight);
            }
        }

        public void init() {
        }

        public boolean allowDiffuseBounced() {
            return true;
        }

        public boolean allowReflectionBounced() {
            return true;
        }

        public boolean allowRefractionBounced() {
            return true;
        }
    }

    private static class PointLight {
        Point3 p;
        Vector3 n;
        Color power;

        private PointLight() {
        }
    }
}

