/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core.gi;

import org.sunflow.core.GIEngine;
import org.sunflow.core.Options;
import org.sunflow.core.gi.AmbientOcclusionGIEngine;
import org.sunflow.core.gi.FakeGIEngine;
import org.sunflow.core.gi.InstantGI;
import org.sunflow.core.gi.IrradianceCacheGIEngine;
import org.sunflow.core.gi.PathTracingGIEngine;
import org.sunflow.system.UI;

public final class GIEngineFactory {
    public static final GIEngine create(Options options) {
        String string = options.getString("gi.engine", null);
        if (string == null || string.equals("null") || string.equals("none")) {
            return null;
        }
        if (string.equals("ambocc")) {
            return new AmbientOcclusionGIEngine(options);
        }
        if (string.equals("fake")) {
            return new FakeGIEngine(options);
        }
        if (string.equals("igi")) {
            return new InstantGI(options);
        }
        if (string.equals("irr-cache")) {
            return new IrradianceCacheGIEngine(options);
        }
        if (string.equals("path")) {
            return new PathTracingGIEngine(options);
        }
        UI.printWarning(UI.Module.LIGHT, "Unrecognized GI engine type \"%s\" - ignoring", string);
        return null;
    }
}

