/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core.gi;

import org.sunflow.core.GIEngine;
import org.sunflow.core.Options;
import org.sunflow.core.Scene;
import org.sunflow.core.ShadingState;
import org.sunflow.image.Color;
import org.sunflow.math.Vector3;

public class FakeGIEngine
implements GIEngine {
    private Vector3 up;
    private Color sky;
    private Color ground;

    public FakeGIEngine(Options options) {
        this.up = options.getVector("gi.fake.up", new Vector3(0.0f, 1.0f, 0.0f)).normalize();
        this.sky = options.getColor("gi.fake.sky", Color.WHITE).copy();
        this.ground = options.getColor("gi.fake.ground", Color.BLACK).copy();
        this.sky.mul((float)Math.PI);
        this.ground.mul((float)Math.PI);
    }

    public Color getIrradiance(ShadingState shadingState, Color color) {
        float f;
        float f2 = Vector3.dot(this.up, shadingState.getNormal());
        float f3 = 1.0f - f2 * f2;
        float f4 = f = f3 > 0.0f ? (float)Math.sqrt(f3) * 0.5f : 0.0f;
        if (f2 > 0.0f) {
            return Color.blend(this.sky, this.ground, f);
        }
        return Color.blend(this.ground, this.sky, f);
    }

    public Color getGlobalRadiance(ShadingState shadingState) {
        return Color.BLACK;
    }

    public boolean init(Scene scene) {
        return true;
    }
}

