/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core.gi;

import org.sunflow.core.GIEngine;
import org.sunflow.core.Options;
import org.sunflow.core.Ray;
import org.sunflow.core.Scene;
import org.sunflow.core.ShadingState;
import org.sunflow.image.Color;
import org.sunflow.math.OrthoNormalBasis;
import org.sunflow.math.Vector3;

public class AmbientOcclusionGIEngine
implements GIEngine {
    private Color bright;
    private Color dark;
    private int samples;
    private float maxDist;

    public AmbientOcclusionGIEngine(Options options) {
        this.bright = options.getColor("gi.ambocc.bright", Color.WHITE);
        this.dark = options.getColor("gi.ambocc.dark", Color.BLACK);
        this.samples = options.getInt("gi.ambocc.samples", 32);
        this.maxDist = options.getFloat("gi.ambocc.maxdist", 0.0f);
        this.maxDist = this.maxDist <= 0.0f ? Float.POSITIVE_INFINITY : this.maxDist;
    }

    public Color getGlobalRadiance(ShadingState shadingState) {
        return Color.BLACK;
    }

    public boolean init(Scene scene) {
        return true;
    }

    public Color getIrradiance(ShadingState shadingState, Color color) {
        OrthoNormalBasis orthoNormalBasis = shadingState.getBasis();
        Vector3 vector3 = new Vector3();
        Color color2 = Color.black();
        for (int i = 0; i < this.samples; ++i) {
            float f = (float)shadingState.getRandom(i, 0, this.samples);
            float f2 = (float)shadingState.getRandom(i, 1, this.samples);
            float f3 = (float)(Math.PI * 2 * (double)f);
            float f4 = (float)Math.cos(f3);
            float f5 = (float)Math.sin(f3);
            float f6 = (float)Math.sqrt(f2);
            float f7 = (float)Math.sqrt(1.0f - f2);
            vector3.x = f4 * f6;
            vector3.y = f5 * f6;
            vector3.z = f7;
            orthoNormalBasis.transform(vector3);
            Ray ray = new Ray(shadingState.getPoint(), vector3);
            ray.setMax(this.maxDist);
            color2.add(Color.blend(this.bright, this.dark, shadingState.traceShadow(ray)));
        }
        return color2.mul((float)Math.PI / (float)this.samples);
    }
}

