/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core.display;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.zip.Deflater;
import org.sunflow.core.Display;
import org.sunflow.image.Color;
import org.sunflow.system.ByteUtil;
import org.sunflow.system.UI;

public class OpenExrDisplay
implements Display {
    private static final byte HALF = 1;
    private static final byte FLOAT = 2;
    private static final int HALF_SIZE = 2;
    private static final int FLOAT_SIZE = 4;
    private static final int OE_MAGIC = 20000630;
    private static final int OE_EXR_VERSION = 2;
    private static final int OE_TILED_FLAG = 512;
    private static final int NO_COMPRESSION = 0;
    private static final int RLE_COMPRESSION = 1;
    private static final int ZIP_COMPRESSION = 3;
    private static final int RLE_MIN_RUN = 3;
    private static final int RLE_MAX_RUN = 127;
    private String filename;
    private RandomAccessFile file;
    private long[][] tileOffsets;
    private long tileOffsetsPosition;
    private int tilesX;
    private int tilesY;
    private int tileSize;
    private int compression;
    private byte channelType;
    private int channelSize;
    private byte[] tmpbuf;
    private byte[] comprbuf;

    public OpenExrDisplay(String string, String string2, String string3) {
        String string4 = this.filename = string == null ? "output.exr" : string;
        if (string2 == null || string2.equals("none")) {
            this.compression = 0;
        } else if (string2.equals("rle")) {
            this.compression = 1;
        } else if (string2.equals("zip")) {
            this.compression = 3;
        } else {
            UI.printWarning(UI.Module.DISP, "EXR - Compression type was not recognized - defaulting to zip", new Object[0]);
            this.compression = 3;
        }
        if (string3 != null && string3.equals("float")) {
            this.channelType = (byte)2;
            this.channelSize = 4;
        } else if (string3 != null && string3.equals("half")) {
            this.channelType = 1;
            this.channelSize = 2;
        } else {
            UI.printWarning(UI.Module.DISP, "EXR - Channel type was not recognized - defaulting to float", new Object[0]);
            this.channelType = (byte)2;
            this.channelSize = 4;
        }
    }

    public void setGamma(float f) {
        UI.printWarning(UI.Module.DISP, "EXR - Gamma correction unsupported - ignoring", new Object[0]);
    }

    public void imageBegin(int n, int n2, int n3) {
        try {
            this.file = new RandomAccessFile(this.filename, "rw");
            this.file.setLength(0L);
            if (n3 <= 0) {
                throw new Exception("Can't use OpenEXR display without buckets.");
            }
            this.writeRGBHeader(n, n2, n3);
        }
        catch (Exception exception) {
            UI.printError(UI.Module.DISP, "EXR - %s", exception.getMessage());
            exception.printStackTrace();
        }
    }

    public void imagePrepare(int n, int n2, int n3, int n4, int n5) {
    }

    public synchronized void imageUpdate(int n, int n2, int n3, int n4, Color[] colorArray) {
        try {
            int n5 = n / this.tileSize;
            int n6 = n2 / this.tileSize;
            this.writeTile(n5, n6, n3, n4, colorArray);
        }
        catch (IOException iOException) {
            UI.printError(UI.Module.DISP, "EXR - %s", iOException.getMessage());
            iOException.printStackTrace();
        }
    }

    public void imageFill(int n, int n2, int n3, int n4, Color color) {
    }

    public void imageEnd() {
        try {
            this.writeTileOffsets();
            this.file.close();
        }
        catch (IOException iOException) {
            UI.printError(UI.Module.DISP, "EXR - %s", iOException.getMessage());
            iOException.printStackTrace();
        }
    }

    public void writeRGBHeader(int n, int n2, int n3) throws Exception {
        byte[] byArray = new byte[]{0, this.channelType, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0};
        this.file.write(ByteUtil.get4Bytes(20000630));
        this.file.write(ByteUtil.get4Bytes(514));
        this.file.write("channels".getBytes());
        this.file.write(0);
        this.file.write("chlist".getBytes());
        this.file.write(0);
        this.file.write(ByteUtil.get4Bytes(55));
        this.file.write("R".getBytes());
        this.file.write(byArray);
        this.file.write("G".getBytes());
        this.file.write(byArray);
        this.file.write("B".getBytes());
        this.file.write(byArray);
        this.file.write(0);
        this.file.write("compression".getBytes());
        this.file.write(0);
        this.file.write("compression".getBytes());
        this.file.write(0);
        this.file.write(1);
        this.file.write(ByteUtil.get4BytesInv(this.compression));
        this.file.write("dataWindow".getBytes());
        this.file.write(0);
        this.file.write("box2i".getBytes());
        this.file.write(0);
        this.file.write(ByteUtil.get4Bytes(16));
        this.file.write(ByteUtil.get4Bytes(0));
        this.file.write(ByteUtil.get4Bytes(0));
        this.file.write(ByteUtil.get4Bytes(n - 1));
        this.file.write(ByteUtil.get4Bytes(n2 - 1));
        this.file.write("displayWindow".getBytes());
        this.file.write(0);
        this.file.write("box2i".getBytes());
        this.file.write(0);
        this.file.write(ByteUtil.get4Bytes(16));
        this.file.write(ByteUtil.get4Bytes(0));
        this.file.write(ByteUtil.get4Bytes(0));
        this.file.write(ByteUtil.get4Bytes(n - 1));
        this.file.write(ByteUtil.get4Bytes(n2 - 1));
        this.file.write("lineOrder".getBytes());
        this.file.write(0);
        this.file.write("lineOrder".getBytes());
        this.file.write(0);
        this.file.write(1);
        this.file.write(ByteUtil.get4BytesInv(2));
        this.file.write("pixelAspectRatio".getBytes());
        this.file.write(0);
        this.file.write("float".getBytes());
        this.file.write(0);
        this.file.write(ByteUtil.get4Bytes(4));
        this.file.write(ByteUtil.get4Bytes(Float.floatToIntBits(1.0f)));
        this.file.write("screenWindowCenter".getBytes());
        this.file.write(0);
        this.file.write("v2f".getBytes());
        this.file.write(0);
        this.file.write(ByteUtil.get4Bytes(8));
        this.file.write(ByteUtil.get4Bytes(Float.floatToIntBits(0.0f)));
        this.file.write(ByteUtil.get4Bytes(Float.floatToIntBits(0.0f)));
        this.file.write("screenWindowWidth".getBytes());
        this.file.write(0);
        this.file.write("float".getBytes());
        this.file.write(0);
        this.file.write(ByteUtil.get4Bytes(4));
        this.file.write(ByteUtil.get4Bytes(Float.floatToIntBits(1.0f)));
        this.tileSize = n3;
        this.tilesX = (n + n3 - 1) / n3;
        this.tilesY = (n2 + n3 - 1) / n3;
        this.tmpbuf = new byte[n3 * n3 * this.channelSize * 3];
        this.comprbuf = new byte[n3 * n3 * this.channelSize * 3 * 2];
        this.tileOffsets = new long[this.tilesX][this.tilesY];
        this.file.write("tiles".getBytes());
        this.file.write(0);
        this.file.write("tiledesc".getBytes());
        this.file.write(0);
        this.file.write(ByteUtil.get4Bytes(9));
        this.file.write(ByteUtil.get4Bytes(n3));
        this.file.write(ByteUtil.get4Bytes(n3));
        this.file.write(0);
        this.file.write(0);
        this.tileOffsetsPosition = this.file.getFilePointer();
        this.writeTileOffsets();
    }

    public void writeTileOffsets() throws IOException {
        this.file.seek(this.tileOffsetsPosition);
        for (int i = 0; i < this.tilesY; ++i) {
            for (int j = 0; j < this.tilesX; ++j) {
                this.file.write(ByteUtil.get8Bytes(this.tileOffsets[j][i]));
            }
        }
    }

    private void writeTile(int n, int n2, int n3, int n4, Color[] colorArray) throws IOException {
        byte[] byArray = new byte[4];
        int n5 = 0;
        int n6 = 0;
        int n7 = Integer.MAX_VALUE;
        int n8 = this.tileSize < n3 ? this.tileSize : n3;
        int n9 = this.tileSize < n4 ? this.tileSize : n4;
        int n10 = n8 * this.channelSize;
        if (this.tileSize != n8 && n == 0) {
            System.out.print(" bad X alignment ");
        }
        if (this.tileSize != n9 && n2 == 0) {
            System.out.print(" bad Y alignment ");
        }
        this.tileOffsets[n][n2] = this.file.getFilePointer();
        this.file.write(ByteUtil.get4Bytes(n));
        this.file.write(ByteUtil.get4Bytes(n2));
        this.file.write(ByteUtil.get4Bytes(0));
        this.file.write(ByteUtil.get4Bytes(0));
        Arrays.fill(this.tmpbuf, (byte)0);
        for (int i = 0; i < n9; ++i) {
            for (int j = 0; j < n8; ++j) {
                float[] fArray = colorArray[j + i * n8].getRGB();
                for (int k = 0; k < 3; ++k) {
                    if (this.channelType == 2) {
                        byArray = ByteUtil.get4Bytes(Float.floatToRawIntBits(fArray[2 - k]));
                        this.tmpbuf[n10 * k + n5 + 0] = byArray[0];
                        this.tmpbuf[n10 * k + n5 + 1] = byArray[1];
                        this.tmpbuf[n10 * k + n5 + 2] = byArray[2];
                        this.tmpbuf[n10 * k + n5 + 3] = byArray[3];
                        continue;
                    }
                    if (this.channelType != 1) continue;
                    byArray = ByteUtil.get2Bytes(ByteUtil.floatToHalf(fArray[2 - k]));
                    this.tmpbuf[n10 * k + n5 + 0] = byArray[0];
                    this.tmpbuf[n10 * k + n5 + 1] = byArray[1];
                }
                n5 += this.channelSize;
            }
            n5 += n8 * this.channelSize * 2;
        }
        n6 = n8 * n9 * this.channelSize * 3;
        if (this.compression != 0) {
            n7 = OpenExrDisplay.compress(this.compression, this.tmpbuf, n6, this.comprbuf);
        }
        if (n7 < n6) {
            this.file.write(ByteUtil.get4Bytes(n7));
            this.file.write(this.comprbuf, 0, n7);
        } else {
            this.file.write(ByteUtil.get4Bytes(n6));
            this.file.write(this.tmpbuf, 0, n6);
        }
    }

    private static final int compress(int n, byte[] byArray, int n2, byte[] byArray2) {
        if (n2 == 0) {
            return 0;
        }
        int n3 = 0;
        int n4 = (n2 + 1) / 2;
        int n5 = 0;
        byte[] byArray3 = new byte[n2];
        if (n == 3 || n == 1) {
            while (n5 < n2) {
                byArray3[n3++] = byArray[n5++];
                if (n5 >= n2) break;
                byArray3[n4++] = byArray[n5++];
            }
            byte by = byArray3[n3 - 1];
            for (n3 = 1; n3 < n2; ++n3) {
                int n6 = byArray3[n3] - by + 384;
                by = byArray3[n3];
                byArray3[n3] = (byte)n6;
            }
        }
        switch (n) {
            case 3: {
                Deflater deflater = new Deflater(-1, false);
                deflater.setInput(byArray3, 0, n2);
                deflater.finish();
                int n7 = deflater.deflate(byArray2);
                return n7;
            }
            case 1: {
                return OpenExrDisplay.rleCompress(byArray3, n2, byArray2);
            }
        }
        return -1;
    }

    private static final int rleCompress(byte[] byArray, int n, byte[] byArray2) {
        int n2 = 0;
        int n3 = 1;
        int n4 = 0;
        while (n2 < n) {
            while (n3 < n && byArray[n2] == byArray[n3] && n3 - n2 - 1 < 127) {
                ++n3;
            }
            if (n3 - n2 >= 3) {
                byArray2[n4++] = (byte)(n3 - n2 - 1);
                byArray2[n4++] = byArray[n2];
                n2 = n3;
            } else {
                while (n3 < n && (n3 + 1 >= n || byArray[n3] != byArray[n3 + 1] || n3 + 2 >= n || byArray[n3 + 1] != byArray[n3 + 2]) && n3 - n2 < 127) {
                    ++n3;
                }
                byArray2[n4++] = (byte)(n2 - n3);
                while (n2 < n3) {
                    byArray2[n4++] = byArray[n2++];
                }
            }
            ++n3;
        }
        return n4;
    }
}

