/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core.display;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.sunflow.core.Display;
import org.sunflow.image.Color;
import org.sunflow.system.Timer;

public class FastDisplay
extends JPanel
implements Display {
    private JFrame frame = null;
    private BufferedImage image = null;
    private int[] pixels;
    private Timer t = new Timer();
    private float seconds = 0.0f;
    private int frames = 0;

    public synchronized void imageBegin(int n, int n2, int n3) {
        if (this.frame == null || this.image == null || n != this.image.getWidth() || n2 != this.image.getHeight()) {
            this.pixels = new int[n * n2];
            this.image = new BufferedImage(n, n2, 2);
            if (this.frame == null) {
                this.setPreferredSize(new Dimension(n, n2));
                this.frame = new JFrame("Sunflow v0.07.2");
                this.frame.setDefaultCloseOperation(3);
                this.frame.addKeyListener(new KeyAdapter(){

                    public void keyPressed(KeyEvent keyEvent) {
                        if (keyEvent.getKeyCode() == 27) {
                            System.exit(0);
                        }
                    }
                });
                this.frame.setContentPane(this);
                this.frame.pack();
                this.frame.setLocationRelativeTo(null);
                this.frame.setVisible(true);
            }
        }
        this.t.start();
    }

    public void imagePrepare(int n, int n2, int n3, int n4, int n5) {
    }

    public void imageUpdate(int n, int n2, int n3, int n4, Color[] colorArray) {
        int n5 = this.image.getWidth();
        int n6 = n + n5 * n2;
        n5 -= n3;
        int n7 = 0;
        int n8 = 0;
        while (n7 < n4) {
            int n9 = 0;
            while (n9 < n3) {
                this.pixels[n6] = 0xFF000000 | colorArray[n8].toRGB();
                ++n9;
                ++n8;
                ++n6;
            }
            ++n7;
            n6 += n5;
        }
    }

    public void imageFill(int n, int n2, int n3, int n4, Color color) {
        int n5 = this.image.getWidth();
        int n6 = n + n5 * n2;
        n5 -= n3;
        int n7 = 0xFF000000 | color.toRGB();
        int n8 = 0;
        int n9 = 0;
        while (n8 < n4) {
            int n10 = 0;
            while (n10 < n3) {
                this.pixels[n6] = n7;
                ++n10;
                ++n9;
                ++n6;
            }
            ++n8;
            n6 += n5;
        }
    }

    public synchronized void imageEnd() {
        this.image.setRGB(0, 0, this.image.getWidth(), this.image.getHeight(), this.pixels, 0, this.image.getWidth());
        this.repaint();
        this.t.end();
        this.seconds = (float)((double)this.seconds + this.t.seconds());
        ++this.frames;
        if (this.seconds > 1.0f) {
            this.frame.setTitle(String.format("Sunflow v%s - %.2f fps", "0.07.2", Float.valueOf((float)this.frames / this.seconds)));
            this.frames = 0;
            this.seconds = 0.0f;
        }
    }

    public synchronized void paint(Graphics graphics) {
        if (this.image == null) {
            return;
        }
        graphics.drawImage(this.image, 0, 0, null);
    }
}

