/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core.camera;

import org.sunflow.SunflowAPI;
import org.sunflow.core.CameraLens;
import org.sunflow.core.ParameterList;
import org.sunflow.core.Ray;

public class PinholeLens
implements CameraLens {
    private float au;
    private float av;
    private float aspect = 1.0f;
    private float fov = 90.0f;

    public PinholeLens() {
        this.update();
    }

    public boolean update(ParameterList parameterList, SunflowAPI sunflowAPI) {
        this.fov = parameterList.getFloat("fov", this.fov);
        this.aspect = parameterList.getFloat("aspect", this.aspect);
        this.update();
        return true;
    }

    private void update() {
        this.au = (float)Math.tan(Math.toRadians(this.fov * 0.5f));
        this.av = this.au / this.aspect;
    }

    public Ray getRay(float f, float f2, int n, int n2, double d, double d2, double d3) {
        float f3 = -this.au + 2.0f * this.au * f / ((float)n - 1.0f);
        float f4 = -this.av + 2.0f * this.av * f2 / ((float)n2 - 1.0f);
        return new Ray(0.0f, 0.0f, 0.0f, f3, f4, -1.0f);
    }
}

