/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core.bucket;

import org.sunflow.core.BucketOrder;
import org.sunflow.core.bucket.ColumnBucketOrder;
import org.sunflow.core.bucket.DiagonalBucketOrder;
import org.sunflow.core.bucket.HilbertBucketOrder;
import org.sunflow.core.bucket.InvertedBucketOrder;
import org.sunflow.core.bucket.RandomBucketOrder;
import org.sunflow.core.bucket.RowBucketOrder;
import org.sunflow.core.bucket.SpiralBucketOrder;
import org.sunflow.system.UI;

public class BucketOrderFactory {
    public static BucketOrder create(String string) {
        Object object;
        boolean bl = false;
        if ((string.startsWith("inverse") || string.startsWith("invert") || string.startsWith("reverse")) && ((String[])(object = string.split("\\s+"))).length == 2) {
            string = object[1];
            bl = true;
        }
        object = null;
        if (string.equals("row")) {
            object = new RowBucketOrder();
        } else if (string.equals("column")) {
            object = new ColumnBucketOrder();
        } else if (string.equals("diagonal")) {
            object = new DiagonalBucketOrder();
        } else if (string.equals("spiral")) {
            object = new SpiralBucketOrder();
        } else if (string.equals("hilbert")) {
            object = new HilbertBucketOrder();
        } else if (string.equals("random")) {
            object = new RandomBucketOrder();
        }
        if (object == null) {
            UI.printWarning(UI.Module.BCKT, "Unrecognized bucket ordering: \"%s\" - using hilbert", string);
            return new HilbertBucketOrder();
        }
        if (bl) {
            object = new InvertedBucketOrder((BucketOrder)object);
        }
        return object;
    }
}

