/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core.accel;

import java.io.FileWriter;
import java.io.IOException;
import org.sunflow.core.AccelerationStructure;
import org.sunflow.core.IntersectionState;
import org.sunflow.core.PrimitiveList;
import org.sunflow.core.Ray;
import org.sunflow.image.Color;
import org.sunflow.math.BoundingBox;
import org.sunflow.math.Point3;
import org.sunflow.system.Memory;
import org.sunflow.system.Timer;
import org.sunflow.system.UI;
import org.sunflow.util.IntArray;

public class KDTree
implements AccelerationStructure {
    private int[] tree;
    private int[] primitives;
    private PrimitiveList primitiveList;
    private BoundingBox bounds;
    private int maxPrims;
    private static final float INTERSECT_COST = 0.5f;
    private static final float TRAVERSAL_COST = 1.0f;
    private static final float EMPTY_BONUS = 0.2f;
    private static final int MAX_DEPTH = 64;
    private static boolean dump = false;
    private static String dumpPrefix = "kdtree";
    private static final long CLOSED = 0L;
    private static final long PLANAR = 0x40000000L;
    private static final long OPENED = 0x80000000L;
    private static final long TYPE_MASK = 0xC0000000L;

    public KDTree() {
        this(0);
    }

    public KDTree(int n) {
        this.maxPrims = n;
    }

    public static void setDumpMode(boolean bl, String string) {
        dump = bl;
        dumpPrefix = string;
    }

    public void build(PrimitiveList primitiveList) {
        UI.printDetailed(UI.Module.ACCEL, "KDTree settings", new Object[0]);
        UI.printDetailed(UI.Module.ACCEL, "  * Max Leaf Size:  %d", this.maxPrims);
        UI.printDetailed(UI.Module.ACCEL, "  * Max Depth:      %d", 64);
        UI.printDetailed(UI.Module.ACCEL, "  * Traversal cost: %.2f", Float.valueOf(1.0f));
        UI.printDetailed(UI.Module.ACCEL, "  * Intersect cost: %.2f", Float.valueOf(0.5f));
        UI.printDetailed(UI.Module.ACCEL, "  * Empty bonus:    %.2f", Float.valueOf(0.2f));
        UI.printDetailed(UI.Module.ACCEL, "  * Dump leaves:    %s", dump ? "enabled" : "disabled");
        Timer timer = new Timer();
        timer.start();
        this.primitiveList = primitiveList;
        this.bounds = primitiveList.getWorldBounds(null);
        int n = this.primitiveList.getNumPrimitives();
        int n2 = 0;
        BuildTask buildTask = new BuildTask(n);
        Timer timer2 = new Timer();
        timer2.start();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < 3; ++j) {
                float f;
                float f2 = this.primitiveList.getPrimitiveBound(i, 2 * j + 0);
                if (f2 == (f = this.primitiveList.getPrimitiveBound(i, 2 * j + 1))) {
                    buildTask.splits[n2] = KDTree.pack(f2, 0x40000000L, j, i);
                    ++n2;
                    continue;
                }
                buildTask.splits[n2 + 0] = KDTree.pack(f2, 0x80000000L, j, i);
                buildTask.splits[n2 + 1] = KDTree.pack(f, 0L, j, i);
                n2 += 2;
            }
        }
        buildTask.n = n2;
        timer2.end();
        Timer timer3 = new Timer();
        IntArray intArray = new IntArray();
        IntArray intArray2 = new IntArray();
        intArray.add(0);
        intArray.add(1);
        timer3.start();
        Timer timer4 = new Timer();
        timer4.start();
        KDTree.radix12(buildTask.splits, buildTask.n);
        timer4.end();
        BuildStats buildStats = new BuildStats();
        this.buildTree(this.bounds.getMinimum().x, this.bounds.getMaximum().x, this.bounds.getMinimum().y, this.bounds.getMaximum().y, this.bounds.getMinimum().z, this.bounds.getMaximum().z, buildTask, 1, intArray, 0, intArray2, buildStats);
        timer3.end();
        buildTask = null;
        this.tree = intArray.trim();
        intArray = null;
        this.primitives = intArray2.trim();
        intArray2 = null;
        timer.end();
        buildStats.printStats();
        UI.printDetailed(UI.Module.ACCEL, "  * Node memory:    %s", Memory.sizeof(this.tree));
        UI.printDetailed(UI.Module.ACCEL, "  * Object memory:  %s", Memory.sizeof(this.primitives));
        UI.printDetailed(UI.Module.ACCEL, "  * Prepare time:   %s", timer2);
        UI.printDetailed(UI.Module.ACCEL, "  * Sorting time:   %s", timer4);
        UI.printDetailed(UI.Module.ACCEL, "  * Tree creation:  %s", timer3);
        UI.printDetailed(UI.Module.ACCEL, "  * Build time:     %s", timer);
        if (dump) {
            try {
                UI.printInfo(UI.Module.ACCEL, "Dumping mtls to %s.mtl ...", dumpPrefix);
                FileWriter fileWriter = new FileWriter(dumpPrefix + ".mtl");
                int n3 = buildStats.maxObjects;
                for (int i = 0; i <= n3; ++i) {
                    float f = (float)i / (float)n3;
                    Color color = (double)f < 0.25 ? Color.blend(Color.BLUE, Color.GREEN, f / 0.25f) : ((double)f < 0.5 ? Color.blend(Color.GREEN, Color.YELLOW, (f - 0.25f) / 0.25f) : ((double)f < 0.75 ? Color.blend(Color.YELLOW, Color.RED, (f - 0.5f) / 0.25f) : Color.MAGENTA));
                    fileWriter.write(String.format("newmtl mtl%d\n", i));
                    float[] fArray = color.getRGB();
                    fileWriter.write("Ka 0.1 0.1 0.1\n");
                    fileWriter.write(String.format("Kd %.12g %.12g %.12g\n", Float.valueOf(fArray[0]), Float.valueOf(fArray[1]), Float.valueOf(fArray[2])));
                    fileWriter.write("illum 1\n\n");
                }
                FileWriter fileWriter2 = new FileWriter(dumpPrefix + ".obj");
                UI.printInfo(UI.Module.ACCEL, "Dumping tree to %s.obj ...", dumpPrefix);
                this.dumpObj(0, 0, n3, new BoundingBox(this.bounds), fileWriter2, fileWriter);
                fileWriter2.close();
                fileWriter.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private int dumpObj(int n, int n2, int n3, BoundingBox boundingBox, FileWriter fileWriter, FileWriter fileWriter2) throws IOException {
        int n4;
        int n5;
        if (n == 0) {
            fileWriter.write(String.format("mtllib %s.mtl\n", dumpPrefix));
        }
        if (((n5 = this.tree[n]) & 0xC0000000) == -1073741824) {
            int n6 = this.tree[n + 1];
            if (n6 > 0) {
                Point3 point3 = boundingBox.getMinimum();
                Point3 point32 = boundingBox.getMaximum();
                fileWriter.write(String.format("o node%d\n", n));
                fileWriter.write(String.format("v %g %g %g\n", Float.valueOf(point32.x), Float.valueOf(point32.y), Float.valueOf(point3.z)));
                fileWriter.write(String.format("v %g %g %g\n", Float.valueOf(point32.x), Float.valueOf(point3.y), Float.valueOf(point3.z)));
                fileWriter.write(String.format("v %g %g %g\n", Float.valueOf(point3.x), Float.valueOf(point3.y), Float.valueOf(point3.z)));
                fileWriter.write(String.format("v %g %g %g\n", Float.valueOf(point3.x), Float.valueOf(point32.y), Float.valueOf(point3.z)));
                fileWriter.write(String.format("v %g %g %g\n", Float.valueOf(point32.x), Float.valueOf(point32.y), Float.valueOf(point32.z)));
                fileWriter.write(String.format("v %g %g %g\n", Float.valueOf(point32.x), Float.valueOf(point3.y), Float.valueOf(point32.z)));
                fileWriter.write(String.format("v %g %g %g\n", Float.valueOf(point3.x), Float.valueOf(point3.y), Float.valueOf(point32.z)));
                fileWriter.write(String.format("v %g %g %g\n", Float.valueOf(point3.x), Float.valueOf(point32.y), Float.valueOf(point32.z)));
                int n7 = n2;
                fileWriter.write(String.format("usemtl mtl%d\n", n6));
                fileWriter.write("s off\n");
                fileWriter.write(String.format("f %d %d %d %d\n", n7 + 1, n7 + 2, n7 + 3, n7 + 4));
                fileWriter.write(String.format("f %d %d %d %d\n", n7 + 5, n7 + 8, n7 + 7, n7 + 6));
                fileWriter.write(String.format("f %d %d %d %d\n", n7 + 1, n7 + 5, n7 + 6, n7 + 2));
                fileWriter.write(String.format("f %d %d %d %d\n", n7 + 2, n7 + 6, n7 + 7, n7 + 3));
                fileWriter.write(String.format("f %d %d %d %d\n", n7 + 3, n7 + 7, n7 + 8, n7 + 4));
                fileWriter.write(String.format("f %d %d %d %d\n", n7 + 5, n7 + 1, n7 + 4, n7 + 8));
                n2 += 8;
            }
            return n2;
        }
        int n8 = n5 & 0xC0000000;
        float f = Float.intBitsToFloat(this.tree[n + 1]);
        n5 &= 0x3FFFFFFF;
        switch (n8) {
            case 0: {
                float f2 = boundingBox.getMaximum().x;
                boundingBox.getMaximum().x = f;
                n4 = this.dumpObj(n5, n2, n3, boundingBox, fileWriter, fileWriter2);
                boundingBox.getMaximum().x = f2;
                float f3 = boundingBox.getMinimum().x;
                boundingBox.getMinimum().x = f;
                n4 = this.dumpObj(n5 + 2, n4, n3, boundingBox, fileWriter, fileWriter2);
                boundingBox.getMinimum().x = f3;
                break;
            }
            case 0x40000000: {
                float f4 = boundingBox.getMaximum().y;
                boundingBox.getMaximum().y = f;
                n4 = this.dumpObj(n5, n2, n3, boundingBox, fileWriter, fileWriter2);
                boundingBox.getMaximum().y = f4;
                float f5 = boundingBox.getMinimum().y;
                boundingBox.getMinimum().y = f;
                n4 = this.dumpObj(n5 + 2, n4, n3, boundingBox, fileWriter, fileWriter2);
                boundingBox.getMinimum().y = f5;
                break;
            }
            case -2147483648: {
                float f6 = boundingBox.getMaximum().z;
                boundingBox.getMaximum().z = f;
                n4 = this.dumpObj(n5, n2, n3, boundingBox, fileWriter, fileWriter2);
                boundingBox.getMaximum().z = f6;
                float f7 = boundingBox.getMinimum().z;
                boundingBox.getMinimum().z = f;
                n4 = this.dumpObj(n5 + 2, n4, n3, boundingBox, fileWriter, fileWriter2);
                boundingBox.getMinimum().z = f7;
                break;
            }
            default: {
                n4 = n2;
            }
        }
        return n4;
    }

    private static long pack(float f, long l, int n, int n2) {
        int n3 = Float.floatToRawIntBits(f);
        int n4 = n3 ^ (n3 >> 31 | Integer.MIN_VALUE);
        long l2 = ((long)n4 & 0xFFFFFFFFL) << 32;
        l2 |= l;
        l2 |= (long)n << 28;
        return l2 |= (long)n2 & 0xFFFFFFFL;
    }

    private static int unpackObject(long l) {
        return (int)(l & 0xFFFFFFFL);
    }

    private static int unpackAxis(long l) {
        return (int)(l >>> 28) & 3;
    }

    private static long unpackSplitType(long l) {
        return l & 0xC0000000L;
    }

    private static float unpackSplit(long l) {
        int n = (int)(l >>> 32 & 0xFFFFFFFFL);
        int n2 = (n >>> 31) - 1 | Integer.MIN_VALUE;
        return Float.intBitsToFloat(n ^ n2);
    }

    private static void radix12(long[] lArray, int n) {
        int n2;
        int[] nArray = new int[2048];
        long[] lArray2 = new long[n];
        for (n2 = 0; n2 < n; ++n2) {
            long l = lArray[n2];
            int n3 = 0 + ((int)(l >>> 28) & 0x1FF);
            nArray[n3] = nArray[n3] + 1;
            int n4 = 512 + ((int)(l >>> 37) & 0x1FF);
            nArray[n4] = nArray[n4] + 1;
            int n5 = 1024 + ((int)(l >>> 46) & 0x1FF);
            nArray[n5] = nArray[n5] + 1;
            int n6 = 1536 + (int)(l >>> 55);
            nArray[n6] = nArray[n6] + 1;
        }
        n2 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        for (int i = 0; i < 512; ++i) {
            int n10 = nArray[0 + i] + n2;
            nArray[0 + i] = n2 - 1;
            n2 = n10;
            n10 = nArray[512 + i] + n7;
            nArray[512 + i] = n7 - 1;
            n7 = n10;
            n10 = nArray[1024 + i] + n8;
            nArray[1024 + i] = n8 - 1;
            n8 = n10;
            n10 = nArray[1536 + i] + n9;
            nArray[1536 + i] = n9 - 1;
            n9 = n10;
        }
        for (n2 = 0; n2 < n; ++n2) {
            long l = lArray[n2];
            n9 = (int)(l >>> 28) & 0x1FF;
            int n11 = 0 + n9;
            int n12 = nArray[n11] + 1;
            nArray[n11] = n12;
            lArray2[n12] = l;
        }
        for (n2 = 0; n2 < n; ++n2) {
            long l = lArray2[n2];
            n9 = (int)(l >>> 37) & 0x1FF;
            int n13 = 512 + n9;
            int n14 = nArray[n13] + 1;
            nArray[n13] = n14;
            lArray[n14] = l;
        }
        for (n2 = 0; n2 < n; ++n2) {
            long l = lArray[n2];
            n9 = (int)(l >>> 46) & 0x1FF;
            int n15 = 1024 + n9;
            int n16 = nArray[n15] + 1;
            nArray[n15] = n16;
            lArray2[n16] = l;
        }
        for (n2 = 0; n2 < n; ++n2) {
            long l = lArray2[n2];
            n9 = (int)(l >>> 55);
            int n17 = 1536 + n9;
            int n18 = nArray[n17] + 1;
            nArray[n17] = n18;
            lArray[n18] = l;
        }
    }

    private void buildTree(float f, float f2, float f3, float f4, float f5, float f6, BuildTask buildTask, int n, IntArray intArray, int n2, IntArray intArray2, BuildStats buildStats) {
        if (buildTask.numObjects > this.maxPrims && n < 64) {
            int n3;
            long l;
            int n4;
            int n5;
            int n6;
            int n7;
            float f7 = f2 - f;
            float f8 = f4 - f3;
            float f9 = f6 - f5;
            float f10 = 0.5f * (float)buildTask.numObjects;
            int n8 = -1;
            int n9 = -1;
            int n10 = -1;
            float f11 = 0.0f;
            boolean bl = false;
            int n11 = 0;
            int n12 = 0;
            float f12 = f7 * f8 + f8 * f9 + f9 * f7;
            float f13 = 0.5f / f12;
            int[] nArray = new int[]{0, 0, 0};
            int[] nArray2 = new int[]{buildTask.numObjects, buildTask.numObjects, buildTask.numObjects};
            float[] fArray = new float[]{f8 * f9, f9 * f7, f7 * f8};
            float[] fArray2 = new float[]{f8 + f9, f9 + f7, f7 + f8};
            float[] fArray3 = new float[]{f, f3, f5};
            float[] fArray4 = new float[]{f2, f4, f6};
            int n13 = buildTask.n;
            long[] lArray = buildTask.splits;
            byte[] byArray = buildTask.leftRightTable;
            int n14 = 0;
            while (n14 < n13) {
                float f14;
                float f15;
                int n15;
                float f16;
                float f17;
                boolean bl2;
                int n16;
                float f18;
                float f19;
                int n17;
                long l2 = lArray[n14];
                float f20 = KDTree.unpackSplit(l2);
                n7 = KDTree.unpackAxis(l2);
                int n18 = n14;
                n6 = 0;
                n5 = 0;
                n4 = 0;
                l = l2 & 0xFFFFFFFF30000000L;
                long l3 = l | 0L;
                long l4 = l | 0x40000000L;
                long l5 = l | 0x80000000L;
                while (n14 < n13 && (lArray[n14] & 0xFFFFFFFFF0000000L) == l3) {
                    n17 = KDTree.unpackObject(lArray[n14]);
                    byArray[n17 >>> 2] = 0;
                    ++n6;
                    ++n14;
                }
                while (n14 < n13 && (lArray[n14] & 0xFFFFFFFFF0000000L) == l4) {
                    n17 = KDTree.unpackObject(lArray[n14]);
                    byArray[n17 >>> 2] = 0;
                    ++n5;
                    ++n14;
                }
                while (n14 < n13 && (lArray[n14] & 0xFFFFFFFFF0000000L) == l5) {
                    n17 = KDTree.unpackObject(lArray[n14]);
                    byArray[n17 >>> 2] = 0;
                    ++n4;
                    ++n14;
                }
                int n19 = n7;
                nArray2[n19] = nArray2[n19] - (n5 + n6);
                if (f20 >= fArray3[n7] && f20 <= fArray4[n7] && (f19 = 1.0f + f13 * (1.0f - (f18 = (n16 = nArray[n7] + ((bl2 = (f17 = f20 - fArray3[n7]) < (f16 = fArray4[n7] - f20)) ? n5 : 0)) == 0 && f17 > 0.0f || n15 == 0 && f16 > 0.0f ? 0.2f : 0.0f)) * ((f15 = fArray[n7] + f17 * fArray2[n7]) * (float)n16 + (f14 = fArray[n7] + f16 * fArray2[n7]) * (float)(n15 = nArray2[n7] + (bl2 ? 0 : n5)))) < f10) {
                    f10 = f19;
                    n8 = n7;
                    f11 = f20;
                    n9 = n18;
                    n10 = n14;
                    n11 = n16;
                    n12 = n15;
                    bl = bl2;
                }
                int n20 = n7;
                nArray[n20] = nArray[n20] + (n4 + n5);
            }
            for (n14 = 0; n14 < 3; ++n14) {
                int n21 = nArray[n14];
                n3 = nArray2[n14];
                if (n21 == buildTask.numObjects && n3 == 0) continue;
                UI.printError(UI.Module.ACCEL, "Didn't scan full range of objects @depth=%d. Left overs for axis %d: [L: %d] [R: %d]", n, n14, n21, n3);
            }
            if (n8 != -1) {
                BuildTask buildTask2 = new BuildTask(n11, buildTask);
                BuildTask buildTask3 = new BuildTask(n12, buildTask);
                n3 = 0;
                int n22 = 0;
                for (n7 = 0; n7 < n9; ++n7) {
                    long l6 = lArray[n7];
                    if (KDTree.unpackAxis(l6) != n8 || KDTree.unpackSplitType(l6) == 0L) continue;
                    n5 = KDTree.unpackObject(l6);
                    int n23 = n5 >>> 2;
                    byArray[n23] = (byte)(byArray[n23] | 1 << ((n5 & 3) << 1));
                    ++n3;
                }
                for (n7 = n9; n7 < n10; ++n7) {
                    long l7 = lArray[n7];
                    assert (KDTree.unpackAxis(l7) == n8);
                    if (KDTree.unpackSplitType(l7) != 0x40000000L) continue;
                    if (bl) {
                        n5 = KDTree.unpackObject(l7);
                        int n24 = n5 >>> 2;
                        byArray[n24] = (byte)(byArray[n24] | 1 << ((n5 & 3) << 1));
                        ++n3;
                        continue;
                    }
                    n5 = KDTree.unpackObject(l7);
                    int n25 = n5 >>> 2;
                    byArray[n25] = (byte)(byArray[n25] | 2 << ((n5 & 3) << 1));
                    ++n22;
                }
                for (n7 = n10; n7 < n13; ++n7) {
                    long l8 = lArray[n7];
                    if (KDTree.unpackAxis(l8) != n8 || KDTree.unpackSplitType(l8) == 0x80000000L) continue;
                    n5 = KDTree.unpackObject(l8);
                    int n26 = n5 >>> 2;
                    byArray[n26] = (byte)(byArray[n26] | 2 << ((n5 & 3) << 1));
                    ++n22;
                }
                long[] lArray2 = buildTask2.splits;
                long[] lArray3 = buildTask3.splits;
                n6 = 0;
                n5 = 0;
                for (n4 = 0; n4 < n13; ++n4) {
                    int n27;
                    l = lArray[n4];
                    int n28 = KDTree.unpackObject(l);
                    int n29 = n28 >>> 2;
                    if ((byArray[n29] & (n27 = 1 << ((n28 & 3) << 1))) != 0) {
                        lArray2[n6] = l;
                        ++n6;
                    }
                    if ((byArray[n29] & n27 << 1) == 0) continue;
                    lArray3[n5] = l;
                    ++n5;
                }
                buildTask2.n = n6;
                buildTask3.n = n5;
                lArray3 = null;
                lArray2 = null;
                lArray = null;
                buildTask.splits = null;
                buildTask = null;
                n4 = intArray.getSize();
                intArray.add(0);
                intArray.add(0);
                intArray.add(0);
                intArray.add(0);
                intArray.set(n2 + 0, n8 << 30 | n4);
                intArray.set(n2 + 1, Float.floatToRawIntBits(f11));
                buildStats.updateInner();
                switch (n8) {
                    case 0: {
                        this.buildTree(f, f11, f3, f4, f5, f6, buildTask2, n + 1, intArray, n4, intArray2, buildStats);
                        buildTask2 = null;
                        this.buildTree(f11, f2, f3, f4, f5, f6, buildTask3, n + 1, intArray, n4 + 2, intArray2, buildStats);
                        buildTask3 = null;
                        return;
                    }
                    case 1: {
                        this.buildTree(f, f2, f3, f11, f5, f6, buildTask2, n + 1, intArray, n4, intArray2, buildStats);
                        buildTask2 = null;
                        this.buildTree(f, f2, f11, f4, f5, f6, buildTask3, n + 1, intArray, n4 + 2, intArray2, buildStats);
                        buildTask3 = null;
                        return;
                    }
                    case 2: {
                        this.buildTree(f, f2, f3, f4, f5, f11, buildTask2, n + 1, intArray, n4, intArray2, buildStats);
                        buildTask2 = null;
                        this.buildTree(f, f2, f3, f4, f11, f6, buildTask3, n + 1, intArray, n4 + 2, intArray2, buildStats);
                        buildTask3 = null;
                        return;
                    }
                }
                assert (false);
            }
        }
        int n30 = intArray2.getSize();
        int n31 = 0;
        for (int i = 0; i < buildTask.n; ++i) {
            long l = buildTask.splits[i];
            if (KDTree.unpackAxis(l) != 0 || KDTree.unpackSplitType(l) == 0L) continue;
            intArray2.add(KDTree.unpackObject(l));
            ++n31;
        }
        buildStats.updateLeaf(n, n31);
        if (n31 != buildTask.numObjects) {
            UI.printError(UI.Module.ACCEL, "Error creating leaf node - expecting %d found %d", buildTask.numObjects, n31);
        }
        intArray.set(n2 + 0, 0xC0000000 | n30);
        intArray.set(n2 + 1, buildTask.numObjects);
        buildTask.splits = null;
    }

    public void intersect(Ray ray, IntersectionState intersectionState) {
        int n;
        float f = ray.getMin();
        float f2 = ray.getMax();
        float f3 = ray.ox;
        float f4 = ray.dx;
        float f5 = 1.0f / f4;
        float f6 = (this.bounds.getMinimum().x - f3) * f5;
        float f7 = (this.bounds.getMaximum().x - f3) * f5;
        if (f5 > 0.0f) {
            if (f6 > f) {
                f = f6;
            }
            if (f7 < f2) {
                f2 = f7;
            }
        } else {
            if (f7 > f) {
                f = f7;
            }
            if (f6 < f2) {
                f2 = f6;
            }
        }
        if (f > f2) {
            return;
        }
        float f8 = ray.oy;
        float f9 = ray.dy;
        float f10 = 1.0f / f9;
        f6 = (this.bounds.getMinimum().y - f8) * f10;
        f7 = (this.bounds.getMaximum().y - f8) * f10;
        if (f10 > 0.0f) {
            if (f6 > f) {
                f = f6;
            }
            if (f7 < f2) {
                f2 = f7;
            }
        } else {
            if (f7 > f) {
                f = f7;
            }
            if (f6 < f2) {
                f2 = f6;
            }
        }
        if (f > f2) {
            return;
        }
        float f11 = ray.oz;
        float f12 = ray.dz;
        float f13 = 1.0f / f12;
        f6 = (this.bounds.getMinimum().z - f11) * f13;
        f7 = (this.bounds.getMaximum().z - f11) * f13;
        if (f13 > 0.0f) {
            if (f6 > f) {
                f = f6;
            }
            if (f7 < f2) {
                f2 = f7;
            }
        } else {
            if (f7 > f) {
                f = f7;
            }
            if (f6 < f2) {
                f2 = f6;
            }
        }
        if (f > f2) {
            return;
        }
        int n2 = (Float.floatToRawIntBits(f4) & Integer.MIN_VALUE) >>> 30;
        int n3 = (Float.floatToRawIntBits(f9) & Integer.MIN_VALUE) >>> 30;
        int n4 = (Float.floatToRawIntBits(f12) & Integer.MIN_VALUE) >>> 30;
        int n5 = n2 ^ 2;
        int n6 = n3 ^ 2;
        int n7 = n4 ^ 2;
        IntersectionState.StackNode[] stackNodeArray = intersectionState.getStack();
        int n8 = n = intersectionState.getStackTop();
        int n9 = 0;
        block5: while (true) {
            int n10 = this.tree[n9];
            int n11 = n10 & 0xC0000000;
            int n12 = n10 & 0x3FFFFFFF;
            switch (n11) {
                case 0: {
                    int n13;
                    float f14 = (Float.intBitsToFloat(this.tree[n9 + 1]) - f3) * f5;
                    n9 = n13 = n12 + n5;
                    if (f14 < f) continue block5;
                    n9 = n12 + n2;
                    if (f14 > f2) continue block5;
                    stackNodeArray[n8].node = n13;
                    stackNodeArray[n8].near = f14 >= f ? f14 : f;
                    stackNodeArray[n8].far = f2;
                    ++n8;
                    f2 = f14 <= f2 ? f14 : f2;
                    continue block5;
                }
                case 0x40000000: {
                    int n13;
                    float f15 = (Float.intBitsToFloat(this.tree[n9 + 1]) - f8) * f10;
                    n9 = n13 = n12 + n6;
                    if (f15 < f) continue block5;
                    n9 = n12 + n3;
                    if (f15 > f2) continue block5;
                    stackNodeArray[n8].node = n13;
                    stackNodeArray[n8].near = f15 >= f ? f15 : f;
                    stackNodeArray[n8].far = f2;
                    ++n8;
                    f2 = f15 <= f2 ? f15 : f2;
                    continue block5;
                }
                case -2147483648: {
                    int n13;
                    float f16 = (Float.intBitsToFloat(this.tree[n9 + 1]) - f11) * f13;
                    n9 = n13 = n12 + n7;
                    if (f16 < f) continue block5;
                    n9 = n12 + n4;
                    if (f16 > f2) continue block5;
                    stackNodeArray[n8].node = n13;
                    stackNodeArray[n8].near = f16 >= f ? f16 : f;
                    stackNodeArray[n8].far = f2;
                    ++n8;
                    f2 = f16 <= f2 ? f16 : f2;
                    continue block5;
                }
            }
            int n14 = this.tree[n9 + 1];
            while (n14 > 0) {
                this.primitiveList.intersectPrimitive(ray, this.primitives[n12], intersectionState);
                --n14;
                ++n12;
            }
            if (ray.getMax() < f2) {
                return;
            }
            do {
                if (n8 == n) {
                    return;
                }
                f = stackNodeArray[--n8].near;
            } while (ray.getMax() < f);
            n9 = stackNodeArray[n8].node;
            f2 = stackNodeArray[n8].far;
        }
    }

    private static class BuildTask {
        long[] splits;
        int numObjects;
        int n;
        byte[] leftRightTable;

        BuildTask(int n) {
            this.splits = new long[6 * n];
            this.numObjects = n;
            this.n = 0;
            this.leftRightTable = new byte[(n + 3) / 4];
        }

        BuildTask(int n, BuildTask buildTask) {
            this.splits = new long[6 * n];
            this.numObjects = n;
            this.n = 0;
            this.leftRightTable = buildTask.leftRightTable;
        }
    }

    private static class BuildStats {
        private int numNodes = 0;
        private int numLeaves = 0;
        private int sumObjects = 0;
        private int minObjects = Integer.MAX_VALUE;
        private int maxObjects = Integer.MIN_VALUE;
        private int sumDepth = 0;
        private int minDepth = Integer.MAX_VALUE;
        private int maxDepth = Integer.MIN_VALUE;
        private int numLeaves0 = 0;
        private int numLeaves1 = 0;
        private int numLeaves2 = 0;
        private int numLeaves3 = 0;
        private int numLeaves4 = 0;
        private int numLeaves4p = 0;

        BuildStats() {
        }

        void updateInner() {
            ++this.numNodes;
        }

        void updateLeaf(int n, int n2) {
            ++this.numLeaves;
            this.minDepth = Math.min(n, this.minDepth);
            this.maxDepth = Math.max(n, this.maxDepth);
            this.sumDepth += n;
            this.minObjects = Math.min(n2, this.minObjects);
            this.maxObjects = Math.max(n2, this.maxObjects);
            this.sumObjects += n2;
            switch (n2) {
                case 0: {
                    ++this.numLeaves0;
                    break;
                }
                case 1: {
                    ++this.numLeaves1;
                    break;
                }
                case 2: {
                    ++this.numLeaves2;
                    break;
                }
                case 3: {
                    ++this.numLeaves3;
                    break;
                }
                case 4: {
                    ++this.numLeaves4;
                    break;
                }
                default: {
                    ++this.numLeaves4p;
                }
            }
        }

        void printStats() {
            UI.printDetailed(UI.Module.ACCEL, "KDTree stats:", new Object[0]);
            UI.printDetailed(UI.Module.ACCEL, "  * Nodes:          %d", this.numNodes);
            UI.printDetailed(UI.Module.ACCEL, "  * Leaves:         %d", this.numLeaves);
            UI.printDetailed(UI.Module.ACCEL, "  * Objects: min    %d", this.minObjects);
            UI.printDetailed(UI.Module.ACCEL, "             avg    %.2f", Float.valueOf((float)this.sumObjects / (float)this.numLeaves));
            UI.printDetailed(UI.Module.ACCEL, "           avg(n>0) %.2f", Float.valueOf((float)this.sumObjects / (float)(this.numLeaves - this.numLeaves0)));
            UI.printDetailed(UI.Module.ACCEL, "             max    %d", this.maxObjects);
            UI.printDetailed(UI.Module.ACCEL, "  * Depth:   min    %d", this.minDepth);
            UI.printDetailed(UI.Module.ACCEL, "             avg    %.2f", Float.valueOf((float)this.sumDepth / (float)this.numLeaves));
            UI.printDetailed(UI.Module.ACCEL, "             max    %d", this.maxDepth);
            UI.printDetailed(UI.Module.ACCEL, "  * Leaves w/: N=0  %3d%%", 100 * this.numLeaves0 / this.numLeaves);
            UI.printDetailed(UI.Module.ACCEL, "               N=1  %3d%%", 100 * this.numLeaves1 / this.numLeaves);
            UI.printDetailed(UI.Module.ACCEL, "               N=2  %3d%%", 100 * this.numLeaves2 / this.numLeaves);
            UI.printDetailed(UI.Module.ACCEL, "               N=3  %3d%%", 100 * this.numLeaves3 / this.numLeaves);
            UI.printDetailed(UI.Module.ACCEL, "               N=4  %3d%%", 100 * this.numLeaves4 / this.numLeaves);
            UI.printDetailed(UI.Module.ACCEL, "               N>4  %3d%%", 100 * this.numLeaves4p / this.numLeaves);
        }
    }
}

