/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core.accel;

import org.sunflow.core.AccelerationStructure;
import org.sunflow.core.IntersectionState;
import org.sunflow.core.PrimitiveList;
import org.sunflow.core.Ray;
import org.sunflow.math.BoundingBox;
import org.sunflow.system.Memory;
import org.sunflow.system.Timer;
import org.sunflow.system.UI;
import org.sunflow.util.IntArray;

public class BoundingIntervalHierarchy
implements AccelerationStructure {
    private int[] tree;
    private int[] objects;
    private PrimitiveList primitives;
    private BoundingBox bounds;
    private int maxPrims = 2;

    public void build(PrimitiveList primitiveList) {
        int n;
        this.primitives = primitiveList;
        int n2 = primitiveList.getNumPrimitives();
        UI.printDetailed(UI.Module.ACCEL, "Getting bounding box ...", new Object[0]);
        this.bounds = primitiveList.getWorldBounds(null);
        this.objects = new int[n2];
        for (n = 0; n < n2; ++n) {
            this.objects[n] = n;
        }
        UI.printDetailed(UI.Module.ACCEL, "Creating tree ...", new Object[0]);
        n = 3 * (12 * n2 + 1);
        IntArray intArray = new IntArray((n + 3) / 4);
        BuildStats buildStats = new BuildStats();
        Timer timer = new Timer();
        timer.start();
        this.buildHierarchy(intArray, this.objects, buildStats);
        timer.end();
        UI.printDetailed(UI.Module.ACCEL, "Trimming tree ...", new Object[0]);
        this.tree = intArray.trim();
        buildStats.printStats();
        UI.printDetailed(UI.Module.ACCEL, "  * Creation time:  %s", timer);
        UI.printDetailed(UI.Module.ACCEL, "  * Usage of init:  %3d%%", 100 * this.tree.length / n);
        UI.printDetailed(UI.Module.ACCEL, "  * Tree memory:    %s", Memory.sizeof(this.tree));
        UI.printDetailed(UI.Module.ACCEL, "  * Indices memory: %s", Memory.sizeof(this.objects));
    }

    private void buildHierarchy(IntArray intArray, int[] nArray, BuildStats buildStats) {
        intArray.add(-1073741824);
        intArray.add(0);
        intArray.add(0);
        if (this.objects.length == 0) {
            return;
        }
        float[] fArray = new float[]{this.bounds.getMinimum().x, this.bounds.getMaximum().x, this.bounds.getMinimum().y, this.bounds.getMaximum().y, this.bounds.getMinimum().z, this.bounds.getMaximum().z};
        float[] fArray2 = new float[]{this.bounds.getMinimum().x, this.bounds.getMaximum().x, this.bounds.getMinimum().y, this.bounds.getMaximum().y, this.bounds.getMinimum().z, this.bounds.getMaximum().z};
        this.subdivide(0, this.objects.length - 1, intArray, nArray, fArray, fArray2, 0, 1, buildStats);
    }

    private void createNode(IntArray intArray, int n, int n2, int n3) {
        intArray.set(n + 0, 0xC0000000 | n2);
        intArray.set(n + 1, n3 - n2 + 1);
    }

    private void subdivide(int n, int n2, IntArray intArray, int[] nArray, float[] fArray, float[] fArray2, int n3, int n4, BuildStats buildStats) {
        int n5;
        int n6;
        int n7;
        if (n2 - n + 1 <= this.maxPrims || n4 >= 64) {
            buildStats.updateLeaf(n4, n2 - n + 1);
            this.createNode(intArray, n3, n, n2);
            return;
        }
        int n8 = -1;
        float f = Float.NaN;
        float f2 = Float.NaN;
        float f3 = Float.NaN;
        float f4 = Float.NaN;
        boolean bl = true;
        while (true) {
            float f5;
            float f6;
            n7 = n8;
            float f7 = f4;
            float[] fArray3 = new float[]{fArray[1] - fArray[0], fArray[3] - fArray[2], fArray[5] - fArray[4]};
            if (fArray3[0] < 0.0f || fArray3[1] < 0.0f || fArray3[2] < 0.0f) {
                throw new IllegalStateException("negative node extents");
            }
            for (int i = 0; i < 3; ++i) {
                if (!(fArray2[2 * i + 1] < fArray[2 * i]) && !(fArray2[2 * i] > fArray[2 * i + 1])) continue;
                UI.printError(UI.Module.ACCEL, "Reached tree area in error - discarding node with: %d objects", n2 - n + 1);
                throw new IllegalStateException("invalid node overlap");
            }
            n8 = fArray3[0] > fArray3[1] && fArray3[0] > fArray3[2] ? 0 : (fArray3[1] > fArray3[2] ? 1 : 2);
            f4 = 0.5f * (fArray[2 * n8] + fArray[2 * n8 + 1]);
            f = Float.NEGATIVE_INFINITY;
            f2 = Float.POSITIVE_INFINITY;
            n6 = n2;
            float f8 = Float.POSITIVE_INFINITY;
            float f9 = Float.NEGATIVE_INFINITY;
            n5 = n;
            while (n5 <= n2) {
                float f10;
                int n9 = nArray[n5];
                float f11 = this.primitives.getPrimitiveBound(n9, 2 * n8 + 0);
                float f12 = (f11 + (f10 = this.primitives.getPrimitiveBound(n9, 2 * n8 + 1))) * 0.5f;
                if (f12 <= f4) {
                    ++n5;
                    if (f < f10) {
                        f = f10;
                    }
                } else {
                    int n10 = nArray[n5];
                    nArray[n5] = nArray[n2];
                    nArray[n2] = n10;
                    --n2;
                    if (f2 > f11) {
                        f2 = f11;
                    }
                }
                if (f8 > f11) {
                    f8 = f11;
                }
                if (!(f9 < f10)) continue;
                f9 = f10;
            }
            if (f8 > fArray2[2 * n8 + 0] && f9 < fArray2[2 * n8 + 1] && 1.3f * (f6 = f9 - f8) < (f5 = fArray2[2 * n8 + 1] - fArray2[2 * n8 + 0])) {
                buildStats.updateBVH2();
                int n11 = intArray.getSize();
                intArray.add(0);
                intArray.add(0);
                intArray.add(0);
                buildStats.updateInner();
                intArray.set(n3 + 0, n8 << 30 | 0x20000000 | n11);
                intArray.set(n3 + 1, Float.floatToRawIntBits(f8));
                intArray.set(n3 + 2, Float.floatToRawIntBits(f9));
                fArray2[2 * n8 + 0] = f8;
                fArray2[2 * n8 + 1] = f9;
                this.subdivide(n, n6, intArray, nArray, fArray, fArray2, n11, n4 + 1, buildStats);
                return;
            }
            if (n2 == n6) {
                if (f <= f4) {
                    fArray[2 * n8 + 1] = f4;
                    f3 = f;
                    bl = true;
                    continue;
                }
                if (n7 == n8 && f7 == f4) {
                    buildStats.updateLeaf(n4, n2 - n + 1);
                    this.createNode(intArray, n3, n, n2);
                    return;
                }
                fArray[2 * n8 + 1] = f4;
                f3 = Float.NaN;
                continue;
            }
            if (n <= n2) break;
            n2 = n6;
            if (f2 >= f4) {
                fArray[2 * n8 + 0] = f4;
                f3 = f2;
                bl = false;
                continue;
            }
            if (n7 == n8 && f7 == f4) {
                buildStats.updateLeaf(n4, n2 - n + 1);
                this.createNode(intArray, n3, n, n2);
                return;
            }
            fArray[2 * n8 + 0] = f4;
            f3 = Float.NaN;
        }
        if (n7 != -1 && !Float.isNaN(f3)) {
            n5 = intArray.getSize();
            intArray.add(0);
            intArray.add(0);
            intArray.add(0);
            if (bl) {
                buildStats.updateInner();
                intArray.set(n3 + 0, n7 << 30 | n5);
                intArray.set(n3 + 1, Float.floatToRawIntBits(f3));
                intArray.set(n3 + 2, Float.floatToRawIntBits(Float.POSITIVE_INFINITY));
            } else {
                buildStats.updateInner();
                intArray.set(n3 + 0, n7 << 30 | n5 - 3);
                intArray.set(n3 + 1, Float.floatToRawIntBits(Float.NEGATIVE_INFINITY));
                intArray.set(n3 + 2, Float.floatToRawIntBits(f3));
            }
            buildStats.updateLeaf(++n4, 0);
            n3 = n5;
        }
        int n12 = intArray.getSize();
        int n13 = n2 - n + 1;
        int n14 = n6 - (n2 + 1) + 1;
        if (n13 > 0) {
            intArray.add(0);
            intArray.add(0);
            intArray.add(0);
        } else {
            n12 -= 3;
        }
        if (n14 > 0) {
            intArray.add(0);
            intArray.add(0);
            intArray.add(0);
        }
        buildStats.updateInner();
        intArray.set(n3 + 0, n8 << 30 | n12);
        intArray.set(n3 + 1, Float.floatToRawIntBits(f));
        intArray.set(n3 + 2, Float.floatToRawIntBits(f2));
        float[] fArray4 = new float[6];
        float[] fArray5 = new float[6];
        float[] fArray6 = new float[6];
        float[] fArray7 = new float[6];
        for (int i = 0; i < 6; ++i) {
            fArray4[i] = fArray5[i] = fArray[i];
            fArray6[i] = fArray7[i] = fArray2[i];
        }
        float f13 = f4;
        fArray5[2 * n8] = f13;
        fArray4[2 * n8 + 1] = f13;
        fArray6[2 * n8 + 1] = f;
        fArray7[2 * n8 + 0] = f2;
        fArray2 = null;
        fArray = null;
        if (n13 > 0) {
            this.subdivide(n, n2, intArray, nArray, fArray4, fArray6, n12, n4 + 1, buildStats);
        } else {
            buildStats.updateLeaf(n4 + 1, 0);
        }
        if (n14 > 0) {
            this.subdivide(n2 + 1, n6, intArray, nArray, fArray5, fArray7, n12 + 3, n4 + 1, buildStats);
        } else {
            buildStats.updateLeaf(n4 + 1, 0);
        }
    }

    public void intersect(Ray ray, IntersectionState intersectionState) {
        int n;
        float f = ray.getMin();
        float f2 = ray.getMax();
        float f3 = ray.ox;
        float f4 = ray.dx;
        float f5 = 1.0f / f4;
        float f6 = (this.bounds.getMinimum().x - f3) * f5;
        float f7 = (this.bounds.getMaximum().x - f3) * f5;
        if (f5 > 0.0f) {
            if (f6 > f) {
                f = f6;
            }
            if (f7 < f2) {
                f2 = f7;
            }
        } else {
            if (f7 > f) {
                f = f7;
            }
            if (f6 < f2) {
                f2 = f6;
            }
        }
        if (f > f2) {
            return;
        }
        float f8 = ray.oy;
        float f9 = ray.dy;
        float f10 = 1.0f / f9;
        f6 = (this.bounds.getMinimum().y - f8) * f10;
        f7 = (this.bounds.getMaximum().y - f8) * f10;
        if (f10 > 0.0f) {
            if (f6 > f) {
                f = f6;
            }
            if (f7 < f2) {
                f2 = f7;
            }
        } else {
            if (f7 > f) {
                f = f7;
            }
            if (f6 < f2) {
                f2 = f6;
            }
        }
        if (f > f2) {
            return;
        }
        float f11 = ray.oz;
        float f12 = ray.dz;
        float f13 = 1.0f / f12;
        f6 = (this.bounds.getMinimum().z - f11) * f13;
        f7 = (this.bounds.getMaximum().z - f11) * f13;
        if (f13 > 0.0f) {
            if (f6 > f) {
                f = f6;
            }
            if (f7 < f2) {
                f2 = f7;
            }
        } else {
            if (f7 > f) {
                f = f7;
            }
            if (f6 < f2) {
                f2 = f6;
            }
        }
        if (f > f2) {
            return;
        }
        int n2 = Float.floatToRawIntBits(f4) >>> 31;
        int n3 = Float.floatToRawIntBits(f9) >>> 31;
        int n4 = Float.floatToRawIntBits(f12) >>> 31;
        int n5 = n2 ^ 1;
        int n6 = n3 ^ 1;
        int n7 = n4 ^ 1;
        int n8 = n2 * 3;
        int n9 = n3 * 3;
        int n10 = n4 * 3;
        int n11 = n5 * 3;
        int n12 = n6 * 3;
        int n13 = n7 * 3;
        ++n2;
        ++n3;
        ++n4;
        ++n5;
        ++n6;
        ++n7;
        IntersectionState.StackNode[] stackNodeArray = intersectionState.getStack();
        int n14 = n = intersectionState.getStackTop();
        int n15 = 0;
        block9: while (true) {
            int n16 = this.tree[n15];
            int n17 = n16 & 0xE0000000;
            int n18 = n16 & 0x1FFFFFFF;
            switch (n17) {
                case 0: {
                    int n19;
                    float f14 = (Float.intBitsToFloat(this.tree[n15 + n2]) - f3) * f5;
                    float f15 = (Float.intBitsToFloat(this.tree[n15 + n5]) - f3) * f5;
                    if (f14 < f && f15 > f2) break;
                    n15 = n19 = n18 + n11;
                    if (f14 < f) {
                        f = f15 >= f ? f15 : f;
                        continue block9;
                    }
                    n15 = n18 + n8;
                    if (f15 > f2) {
                        f2 = f14 <= f2 ? f14 : f2;
                        continue block9;
                    }
                    stackNodeArray[n14].node = n19;
                    stackNodeArray[n14].near = f15 >= f ? f15 : f;
                    stackNodeArray[n14].far = f2;
                    ++n14;
                    f2 = f14 <= f2 ? f14 : f2;
                    continue block9;
                }
                case 0x40000000: {
                    int n19;
                    float f16 = (Float.intBitsToFloat(this.tree[n15 + n3]) - f8) * f10;
                    float f15 = (Float.intBitsToFloat(this.tree[n15 + n6]) - f8) * f10;
                    if (f16 < f && f15 > f2) break;
                    n15 = n19 = n18 + n12;
                    if (f16 < f) {
                        f = f15 >= f ? f15 : f;
                        continue block9;
                    }
                    n15 = n18 + n9;
                    if (f15 > f2) {
                        f2 = f16 <= f2 ? f16 : f2;
                        continue block9;
                    }
                    stackNodeArray[n14].node = n19;
                    stackNodeArray[n14].near = f15 >= f ? f15 : f;
                    stackNodeArray[n14].far = f2;
                    ++n14;
                    f2 = f16 <= f2 ? f16 : f2;
                    continue block9;
                }
                case -2147483648: {
                    int n19;
                    float f17 = (Float.intBitsToFloat(this.tree[n15 + n4]) - f11) * f13;
                    float f15 = (Float.intBitsToFloat(this.tree[n15 + n7]) - f11) * f13;
                    if (f17 < f && f15 > f2) break;
                    n15 = n19 = n18 + n13;
                    if (f17 < f) {
                        f = f15 >= f ? f15 : f;
                        continue block9;
                    }
                    n15 = n18 + n10;
                    if (f15 > f2) {
                        f2 = f17 <= f2 ? f17 : f2;
                        continue block9;
                    }
                    stackNodeArray[n14].node = n19;
                    stackNodeArray[n14].near = f15 >= f ? f15 : f;
                    stackNodeArray[n14].far = f2;
                    ++n14;
                    f2 = f17 <= f2 ? f17 : f2;
                    continue block9;
                }
                case -1073741824: {
                    int n20 = this.tree[n15 + 1];
                    while (n20 > 0) {
                        this.primitives.intersectPrimitive(ray, this.objects[n18], intersectionState);
                        --n20;
                        ++n18;
                    }
                    break;
                }
                case 0x20000000: {
                    float f18 = (Float.intBitsToFloat(this.tree[n15 + n2]) - f3) * f5;
                    float f15 = (Float.intBitsToFloat(this.tree[n15 + n5]) - f3) * f5;
                    n15 = n18;
                    f = f18 >= f ? f18 : f;
                    float f19 = f15 <= f2 ? f15 : f2;
                    f2 = f19;
                    if (!(f > f2)) continue block9;
                    break;
                }
                case 0x60000000: {
                    float f20 = (Float.intBitsToFloat(this.tree[n15 + n3]) - f8) * f10;
                    float f15 = (Float.intBitsToFloat(this.tree[n15 + n6]) - f8) * f10;
                    n15 = n18;
                    f = f20 >= f ? f20 : f;
                    float f21 = f15 <= f2 ? f15 : f2;
                    f2 = f21;
                    if (!(f > f2)) continue block9;
                    break;
                }
                case -1610612736: {
                    float f22 = (Float.intBitsToFloat(this.tree[n15 + n4]) - f11) * f13;
                    float f15 = (Float.intBitsToFloat(this.tree[n15 + n7]) - f11) * f13;
                    n15 = n18;
                    f = f22 >= f ? f22 : f;
                    float f23 = f15 <= f2 ? f15 : f2;
                    f2 = f23;
                    if (!(f > f2)) continue block9;
                    break;
                }
                default: {
                    return;
                }
            }
            do {
                if (n14 == n) {
                    return;
                }
                f = stackNodeArray[--n14].near;
            } while (ray.getMax() < f);
            n15 = stackNodeArray[n14].node;
            f2 = stackNodeArray[n14].far;
        }
    }

    private static class BuildStats {
        private int numNodes = 0;
        private int numLeaves = 0;
        private int sumObjects = 0;
        private int minObjects = Integer.MAX_VALUE;
        private int maxObjects = Integer.MIN_VALUE;
        private int sumDepth = 0;
        private int minDepth = Integer.MAX_VALUE;
        private int maxDepth = Integer.MIN_VALUE;
        private int numLeaves0 = 0;
        private int numLeaves1 = 0;
        private int numLeaves2 = 0;
        private int numLeaves3 = 0;
        private int numLeaves4 = 0;
        private int numLeaves4p = 0;
        private int numBVH2 = 0;

        BuildStats() {
        }

        void updateInner() {
            ++this.numNodes;
        }

        void updateBVH2() {
            ++this.numBVH2;
        }

        void updateLeaf(int n, int n2) {
            ++this.numLeaves;
            this.minDepth = Math.min(n, this.minDepth);
            this.maxDepth = Math.max(n, this.maxDepth);
            this.sumDepth += n;
            this.minObjects = Math.min(n2, this.minObjects);
            this.maxObjects = Math.max(n2, this.maxObjects);
            this.sumObjects += n2;
            switch (n2) {
                case 0: {
                    ++this.numLeaves0;
                    break;
                }
                case 1: {
                    ++this.numLeaves1;
                    break;
                }
                case 2: {
                    ++this.numLeaves2;
                    break;
                }
                case 3: {
                    ++this.numLeaves3;
                    break;
                }
                case 4: {
                    ++this.numLeaves4;
                    break;
                }
                default: {
                    ++this.numLeaves4p;
                }
            }
        }

        void printStats() {
            UI.printDetailed(UI.Module.ACCEL, "Tree stats:", new Object[0]);
            UI.printDetailed(UI.Module.ACCEL, "  * Nodes:          %d", this.numNodes);
            UI.printDetailed(UI.Module.ACCEL, "  * Leaves:         %d", this.numLeaves);
            UI.printDetailed(UI.Module.ACCEL, "  * Objects: min    %d", this.minObjects);
            UI.printDetailed(UI.Module.ACCEL, "             avg    %.2f", Float.valueOf((float)this.sumObjects / (float)this.numLeaves));
            UI.printDetailed(UI.Module.ACCEL, "           avg(n>0) %.2f", Float.valueOf((float)this.sumObjects / (float)(this.numLeaves - this.numLeaves0)));
            UI.printDetailed(UI.Module.ACCEL, "             max    %d", this.maxObjects);
            UI.printDetailed(UI.Module.ACCEL, "  * Depth:   min    %d", this.minDepth);
            UI.printDetailed(UI.Module.ACCEL, "             avg    %.2f", Float.valueOf((float)this.sumDepth / (float)this.numLeaves));
            UI.printDetailed(UI.Module.ACCEL, "             max    %d", this.maxDepth);
            UI.printDetailed(UI.Module.ACCEL, "  * Leaves w/: N=0  %3d%%", 100 * this.numLeaves0 / this.numLeaves);
            UI.printDetailed(UI.Module.ACCEL, "               N=1  %3d%%", 100 * this.numLeaves1 / this.numLeaves);
            UI.printDetailed(UI.Module.ACCEL, "               N=2  %3d%%", 100 * this.numLeaves2 / this.numLeaves);
            UI.printDetailed(UI.Module.ACCEL, "               N=3  %3d%%", 100 * this.numLeaves3 / this.numLeaves);
            UI.printDetailed(UI.Module.ACCEL, "               N=4  %3d%%", 100 * this.numLeaves4 / this.numLeaves);
            UI.printDetailed(UI.Module.ACCEL, "               N>4  %3d%%", 100 * this.numLeaves4p / this.numLeaves);
            UI.printDetailed(UI.Module.ACCEL, "  * BVH2 nodes:     %d (%3d%%)", this.numBVH2, 100 * this.numBVH2 / (this.numNodes + this.numLeaves - 2 * this.numBVH2));
        }
    }
}

