/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core;

import java.io.IOException;
import org.sunflow.image.Bitmap;
import org.sunflow.image.Color;
import org.sunflow.math.OrthoNormalBasis;
import org.sunflow.math.Vector3;
import org.sunflow.system.UI;

public class Texture {
    private String filename;
    private boolean isLinear;
    private Bitmap bitmap;
    private int loaded;

    Texture(String string, boolean bl) {
        this.filename = string;
        this.isLinear = bl;
        this.loaded = 0;
    }

    private synchronized void load() {
        if (this.loaded != 0) {
            return;
        }
        try {
            UI.printInfo(UI.Module.TEX, "Reading texture bitmap from: \"%s\" ...", this.filename);
            this.bitmap = new Bitmap(this.filename, this.isLinear);
            if (this.bitmap.getWidth() == 0 || this.bitmap.getHeight() == 0) {
                this.bitmap = null;
            }
        }
        catch (IOException iOException) {
            UI.printError(UI.Module.TEX, "%s", iOException.getMessage());
        }
        this.loaded = 1;
    }

    public Bitmap getBitmap() {
        if (this.loaded == 0) {
            this.load();
        }
        return this.bitmap;
    }

    public Color getPixel(float f, float f2) {
        Bitmap bitmap = this.getBitmap();
        if (bitmap == null) {
            return Color.BLACK;
        }
        f -= (float)((int)f);
        f2 -= (float)((int)f2);
        if (f < 0.0f) {
            f += 1.0f;
        }
        if (f2 < 0.0f) {
            f2 += 1.0f;
        }
        float f3 = f * (float)(bitmap.getWidth() - 1);
        float f4 = f2 * (float)(bitmap.getHeight() - 1);
        int n = (int)f3;
        int n2 = (int)f4;
        int n3 = (n + 1) % bitmap.getWidth();
        int n4 = (n2 + 1) % bitmap.getHeight();
        float f5 = f3 - (float)n;
        float f6 = f4 - (float)n2;
        f5 = f5 * f5 * (3.0f - 2.0f * f5);
        f6 = f6 * f6 * (3.0f - 2.0f * f6);
        float f7 = (1.0f - f5) * (1.0f - f6);
        Color color = bitmap.getPixel(n, n2);
        float f8 = (1.0f - f5) * f6;
        Color color2 = bitmap.getPixel(n, n4);
        float f9 = f5 * (1.0f - f6);
        Color color3 = bitmap.getPixel(n3, n2);
        float f10 = f5 * f6;
        Color color4 = bitmap.getPixel(n3, n4);
        Color color5 = Color.mul(f7, color);
        color5.madd(f8, color2);
        color5.madd(f9, color3);
        color5.madd(f10, color4);
        return color5;
    }

    public Vector3 getNormal(float f, float f2, OrthoNormalBasis orthoNormalBasis) {
        float[] fArray = this.getPixel(f, f2).getRGB();
        return orthoNormalBasis.transform(new Vector3(2.0f * fArray[0] - 1.0f, 2.0f * fArray[1] - 1.0f, 2.0f * fArray[2] - 1.0f)).normalize();
    }

    public Vector3 getBump(float f, float f2, OrthoNormalBasis orthoNormalBasis, float f3) {
        Bitmap bitmap = this.getBitmap();
        if (bitmap == null) {
            return orthoNormalBasis.transform(new Vector3(0.0f, 0.0f, 1.0f));
        }
        float f4 = 1.0f / (float)(bitmap.getWidth() - 1);
        float f5 = 1.0f / (float)(bitmap.getHeight() - 1);
        float f6 = this.getPixel(f, f2).getLuminance();
        float f7 = this.getPixel(f + f4, f2).getLuminance();
        float f8 = this.getPixel(f, f2 + f5).getLuminance();
        return orthoNormalBasis.transform(new Vector3(f3 * (f7 - f6) / f4, f3 * (f8 - f6) / f5, 1.0f)).normalize();
    }
}

