/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core;

import org.sunflow.image.Color;
import org.sunflow.math.Matrix4;
import org.sunflow.math.Point2;
import org.sunflow.math.Point3;
import org.sunflow.math.Vector3;
import org.sunflow.system.UI;
import org.sunflow.util.FastHashMap;

public class ParameterList {
    protected final FastHashMap<String, Parameter> list = new FastHashMap();
    private int numVerts = 0;
    private int numFaces = 0;
    private int numFaceVerts = 0;

    public void clear(boolean bl) {
        if (bl) {
            for (FastHashMap.Entry<String, Parameter> entry : this.list) {
                if (entry.getValue().checked) continue;
                UI.printWarning(UI.Module.API, "Unused parameter: %s - %s", entry.getKey(), entry.getValue());
            }
        }
        this.list.clear();
        this.numFaceVerts = 0;
        this.numFaces = 0;
        this.numVerts = 0;
    }

    public void setFaceCount(int n) {
        this.numFaces = n;
    }

    public void setVertexCount(int n) {
        this.numVerts = n;
    }

    public void setFaceVertexCount(int n) {
        this.numFaceVerts = n;
    }

    public void addString(String string, String string2) {
        this.add(string, new Parameter(string2));
    }

    public void addInteger(String string, int n) {
        this.add(string, new Parameter(n));
    }

    public void addBoolean(String string, boolean bl) {
        this.add(string, new Parameter(bl));
    }

    public void addFloat(String string, float f) {
        this.add(string, new Parameter(f));
    }

    public void addColor(String string, Color color) {
        if (color == null) {
            throw new NullPointerException();
        }
        this.add(string, new Parameter(color));
    }

    public void addIntegerArray(String string, int[] nArray) {
        if (nArray == null) {
            throw new NullPointerException();
        }
        this.add(string, new Parameter(nArray));
    }

    public void addStringArray(String string, String[] stringArray) {
        if (stringArray == null) {
            throw new NullPointerException();
        }
        this.add(string, new Parameter(stringArray));
    }

    public void addFloats(String string, InterpolationType interpolationType, float[] fArray) {
        if (fArray == null) {
            UI.printError(UI.Module.API, "Cannot create float parameter %s -- invalid data length", string);
            return;
        }
        this.add(string, new Parameter(ParameterType.FLOAT, interpolationType, fArray));
    }

    public void addPoints(String string, InterpolationType interpolationType, float[] fArray) {
        if (fArray == null || fArray.length % 3 != 0) {
            UI.printError(UI.Module.API, "Cannot create point parameter %s -- invalid data length", string);
            return;
        }
        this.add(string, new Parameter(ParameterType.POINT, interpolationType, fArray));
    }

    public void addVectors(String string, InterpolationType interpolationType, float[] fArray) {
        if (fArray == null || fArray.length % 3 != 0) {
            UI.printError(UI.Module.API, "Cannot create vector parameter %s -- invalid data length", string);
            return;
        }
        this.add(string, new Parameter(ParameterType.VECTOR, interpolationType, fArray));
    }

    public void addTexCoords(String string, InterpolationType interpolationType, float[] fArray) {
        if (fArray == null || fArray.length % 2 != 0) {
            UI.printError(UI.Module.API, "Cannot create texcoord parameter %s -- invalid data length", string);
            return;
        }
        this.add(string, new Parameter(ParameterType.TEXCOORD, interpolationType, fArray));
    }

    public void addMatrices(String string, InterpolationType interpolationType, float[] fArray) {
        if (fArray == null || fArray.length % 16 != 0) {
            UI.printError(UI.Module.API, "Cannot create matrix parameter %s -- invalid data length", string);
            return;
        }
        this.add(string, new Parameter(ParameterType.MATRIX, interpolationType, fArray));
    }

    private void add(String string, Parameter parameter) {
        if (string == null) {
            UI.printError(UI.Module.API, "Cannot declare parameter with null name", new Object[0]);
        } else if (this.list.put(string, parameter) != null) {
            UI.printWarning(UI.Module.API, "Parameter %s was already defined -- overwriting", string);
        }
    }

    public String getString(String string, String string2) {
        Parameter parameter = this.list.get(string);
        if (this.isValidParameter(string, ParameterType.STRING, InterpolationType.NONE, 1, parameter)) {
            return parameter.getStringValue();
        }
        return string2;
    }

    public String[] getStringArray(String string, String[] stringArray) {
        Parameter parameter = this.list.get(string);
        if (this.isValidParameter(string, ParameterType.STRING, InterpolationType.NONE, -1, parameter)) {
            return parameter.getStrings();
        }
        return stringArray;
    }

    public int getInt(String string, int n) {
        Parameter parameter = this.list.get(string);
        if (this.isValidParameter(string, ParameterType.INT, InterpolationType.NONE, 1, parameter)) {
            return parameter.getIntValue();
        }
        return n;
    }

    public int[] getIntArray(String string) {
        Parameter parameter = this.list.get(string);
        if (this.isValidParameter(string, ParameterType.INT, InterpolationType.NONE, -1, parameter)) {
            return parameter.getInts();
        }
        return null;
    }

    public boolean getBoolean(String string, boolean bl) {
        Parameter parameter = this.list.get(string);
        if (this.isValidParameter(string, ParameterType.BOOL, InterpolationType.NONE, 1, parameter)) {
            return parameter.getBoolValue();
        }
        return bl;
    }

    public float getFloat(String string, float f) {
        Parameter parameter = this.list.get(string);
        if (this.isValidParameter(string, ParameterType.FLOAT, InterpolationType.NONE, 1, parameter)) {
            return parameter.getFloatValue();
        }
        return f;
    }

    public Color getColor(String string, Color color) {
        Parameter parameter = this.list.get(string);
        if (this.isValidParameter(string, ParameterType.COLOR, InterpolationType.NONE, 1, parameter)) {
            return parameter.getColor();
        }
        return color;
    }

    public Point3 getPoint(String string, Point3 point3) {
        Parameter parameter = this.list.get(string);
        if (this.isValidParameter(string, ParameterType.POINT, InterpolationType.NONE, 1, parameter)) {
            return parameter.getPoint();
        }
        return point3;
    }

    public Vector3 getVector(String string, Vector3 vector3) {
        Parameter parameter = this.list.get(string);
        if (this.isValidParameter(string, ParameterType.VECTOR, InterpolationType.NONE, 1, parameter)) {
            return parameter.getVector();
        }
        return vector3;
    }

    public Point2 getTexCoord(String string, Point2 point2) {
        Parameter parameter = this.list.get(string);
        if (this.isValidParameter(string, ParameterType.TEXCOORD, InterpolationType.NONE, 1, parameter)) {
            return parameter.getTexCoord();
        }
        return point2;
    }

    public Matrix4 getMatrix(String string, Matrix4 matrix4) {
        Parameter parameter = this.list.get(string);
        if (this.isValidParameter(string, ParameterType.MATRIX, InterpolationType.NONE, 1, parameter)) {
            return parameter.getMatrix();
        }
        return matrix4;
    }

    public FloatParameter getFloatArray(String string) {
        return this.getFloatParameter(string, ParameterType.FLOAT, this.list.get(string));
    }

    public FloatParameter getPointArray(String string) {
        return this.getFloatParameter(string, ParameterType.POINT, this.list.get(string));
    }

    public FloatParameter getVectorArray(String string) {
        return this.getFloatParameter(string, ParameterType.VECTOR, this.list.get(string));
    }

    public FloatParameter getTexCoordArray(String string) {
        return this.getFloatParameter(string, ParameterType.TEXCOORD, this.list.get(string));
    }

    public FloatParameter getMatrixArray(String string) {
        return this.getFloatParameter(string, ParameterType.MATRIX, this.list.get(string));
    }

    private boolean isValidParameter(String string, ParameterType parameterType, InterpolationType interpolationType, int n, Parameter parameter) {
        if (parameter == null) {
            return false;
        }
        if (parameter.type != parameterType) {
            UI.printWarning(UI.Module.API, "Parameter %s requested as a %s - declared as %s", string, parameterType.name().toLowerCase(), parameter.type.name().toLowerCase());
            return false;
        }
        if (parameter.interp != interpolationType) {
            UI.printWarning(UI.Module.API, "Parameter %s requested as a %s - declared as %s", string, interpolationType.name().toLowerCase(), parameter.interp.name().toLowerCase());
            return false;
        }
        if (n > 0 && parameter.size() != n) {
            UI.printWarning(UI.Module.API, "Parameter %s requires %d %s - declared with %d", string, n, n == 1 ? "value" : "values", parameter.size());
            return false;
        }
        parameter.checked = true;
        return true;
    }

    private FloatParameter getFloatParameter(String string, ParameterType parameterType, Parameter parameter) {
        if (parameter == null) {
            return null;
        }
        switch (parameter.interp) {
            case NONE: {
                if (this.isValidParameter(string, parameterType, parameter.interp, -1, parameter)) break;
                return null;
            }
            case VERTEX: {
                if (this.isValidParameter(string, parameterType, parameter.interp, this.numVerts, parameter)) break;
                return null;
            }
            case FACE: {
                if (this.isValidParameter(string, parameterType, parameter.interp, this.numFaces, parameter)) break;
                return null;
            }
            case FACEVARYING: {
                if (this.isValidParameter(string, parameterType, parameter.interp, this.numFaceVerts, parameter)) break;
                return null;
            }
            default: {
                return null;
            }
        }
        return parameter.getFloats();
    }

    protected static final class Parameter {
        private ParameterType type;
        private InterpolationType interp;
        private Object obj;
        private boolean checked;

        private Parameter(String string) {
            this.type = ParameterType.STRING;
            this.interp = InterpolationType.NONE;
            this.obj = new String[]{string};
            this.checked = false;
        }

        private Parameter(int n) {
            this.type = ParameterType.INT;
            this.interp = InterpolationType.NONE;
            this.obj = new int[]{n};
            this.checked = false;
        }

        private Parameter(boolean bl) {
            this.type = ParameterType.BOOL;
            this.interp = InterpolationType.NONE;
            this.obj = bl;
            this.checked = false;
        }

        private Parameter(float f) {
            this.type = ParameterType.FLOAT;
            this.interp = InterpolationType.NONE;
            this.obj = new float[]{f};
            this.checked = false;
        }

        private Parameter(int[] nArray) {
            this.type = ParameterType.INT;
            this.interp = InterpolationType.NONE;
            this.obj = nArray;
            this.checked = false;
        }

        private Parameter(String[] stringArray) {
            this.type = ParameterType.STRING;
            this.interp = InterpolationType.NONE;
            this.obj = stringArray;
            this.checked = false;
        }

        private Parameter(Color color) {
            this.type = ParameterType.COLOR;
            this.interp = InterpolationType.NONE;
            this.obj = color;
            this.checked = false;
        }

        private Parameter(ParameterType parameterType, InterpolationType interpolationType, float[] fArray) {
            this.type = parameterType;
            this.interp = interpolationType;
            this.obj = fArray;
            this.checked = false;
        }

        private int size() {
            switch (this.type) {
                case STRING: {
                    return ((String[])this.obj).length;
                }
                case INT: {
                    return ((int[])this.obj).length;
                }
                case BOOL: {
                    return 1;
                }
                case FLOAT: {
                    return ((float[])this.obj).length;
                }
                case POINT: {
                    return ((float[])this.obj).length / 3;
                }
                case VECTOR: {
                    return ((float[])this.obj).length / 3;
                }
                case TEXCOORD: {
                    return ((float[])this.obj).length / 2;
                }
                case MATRIX: {
                    return ((float[])this.obj).length / 16;
                }
                case COLOR: {
                    return 1;
                }
            }
            return -1;
        }

        protected void check() {
            this.checked = true;
        }

        public String toString() {
            return String.format("%s%s[%d]", this.interp == InterpolationType.NONE ? "" : this.interp.name().toLowerCase() + " ", this.type.name().toLowerCase(), this.size());
        }

        private String getStringValue() {
            return ((String[])this.obj)[0];
        }

        private boolean getBoolValue() {
            return (Boolean)this.obj;
        }

        private int getIntValue() {
            return ((int[])this.obj)[0];
        }

        private int[] getInts() {
            return (int[])this.obj;
        }

        private String[] getStrings() {
            return (String[])this.obj;
        }

        private float getFloatValue() {
            return ((float[])this.obj)[0];
        }

        private FloatParameter getFloats() {
            return new FloatParameter(this.interp, (float[])this.obj);
        }

        private Point3 getPoint() {
            float[] fArray = (float[])this.obj;
            return new Point3(fArray[0], fArray[1], fArray[2]);
        }

        private Vector3 getVector() {
            float[] fArray = (float[])this.obj;
            return new Vector3(fArray[0], fArray[1], fArray[2]);
        }

        private Point2 getTexCoord() {
            float[] fArray = (float[])this.obj;
            return new Point2(fArray[0], fArray[1]);
        }

        private Matrix4 getMatrix() {
            float[] fArray = (float[])this.obj;
            return new Matrix4(fArray, true);
        }

        private Color getColor() {
            return (Color)this.obj;
        }
    }

    public static final class FloatParameter {
        public final InterpolationType interp;
        public final float[] data;

        public FloatParameter() {
            this(InterpolationType.NONE, null);
        }

        public FloatParameter(float f) {
            this(InterpolationType.NONE, new float[]{f});
        }

        private FloatParameter(InterpolationType interpolationType, float[] fArray) {
            this.interp = interpolationType;
            this.data = fArray;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InterpolationType {
        NONE,
        FACE,
        VERTEX,
        FACEVARYING;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ParameterType {
        STRING,
        INT,
        BOOL,
        FLOAT,
        POINT,
        VECTOR,
        TEXCOORD,
        MATRIX,
        COLOR;

    }
}

